/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.Application;

import IceGridGUI.Application.Editable;
import IceGridGUI.Application.Editor;
import IceGridGUI.Application.TreeNode;
import IceGridGUI.Application.UpdateFailedException;
import IceGridGUI.XMLWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.tree.DefaultTreeModel;

abstract class ListTreeNode
extends TreeNode {
    protected final LinkedList _children = new LinkedList();
    protected Editable _editable;
    private static Editor _editor;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Enumeration children() {
        return new Enumeration(){
            private Iterator _p;
            {
                this._p = ListTreeNode.this._children.iterator();
            }

            public boolean hasMoreElements() {
                return this._p.hasNext();
            }

            public Object nextElement() {
                return this._p.next();
            }
        };
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public javax.swing.tree.TreeNode getChildAt(int childIndex) {
        if (childIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(childIndex);
        }
        if (childIndex < this._children.size()) {
            return (javax.swing.tree.TreeNode)this._children.get(childIndex);
        }
        throw new ArrayIndexOutOfBoundsException(childIndex);
    }

    public int getChildCount() {
        return this._children.size();
    }

    public int getIndex(javax.swing.tree.TreeNode node) {
        return this._children.indexOf(node);
    }

    public boolean isLeaf() {
        return this._children.isEmpty();
    }

    public Editor getEditor() {
        if (_editor == null) {
            _editor = new Editor();
        }
        return _editor;
    }

    protected Editor createEditor() {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    protected ListTreeNode(boolean brandNew, TreeNode parent, String id) {
        super(parent, id);
        this._editable = new Editable(brandNew);
    }

    void write(XMLWriter writer) throws IOException {
        Iterator p = this._children.iterator();
        while (p.hasNext()) {
            TreeNode node = (TreeNode)p.next();
            node.write(writer);
        }
    }

    void insertChild(TreeNode child, boolean fireEvent) throws UpdateFailedException {
        DefaultTreeModel treeModel;
        DefaultTreeModel defaultTreeModel = treeModel = fireEvent ? this.getRoot().getTreeModel() : null;
        if (!this.insertSortedChild(child, this._children, treeModel)) {
            throw new UpdateFailedException(this, child.getId());
        }
    }

    void insertChildren(List newChildren, boolean fireEvent) throws UpdateFailedException {
        DefaultTreeModel treeModel = fireEvent ? this.getRoot().getTreeModel() : null;
        String badChildId = this.insertSortedChildren(newChildren, this._children, treeModel);
        if (badChildId != null) {
            throw new UpdateFailedException(this, badChildId);
        }
    }

    int removeChild(TreeNode child) {
        int index = this.getIndex(child);
        this._children.remove(child);
        this.getRoot().getTreeModel().nodesWereRemoved(this, new int[]{index}, new Object[]{child});
        return index;
    }

    void removeChildren(String[] childIds) {
        this.removeSortedChildren(childIds, this._children, this.getRoot().getTreeModel());
    }

    void childrenChanged(List children) {
        this.childrenChanged(children, this.getRoot().getTreeModel());
    }

    Editable getEditable() {
        return this._editable;
    }

    javax.swing.ComboBoxModel createComboBoxModel() {
        return new ComboBoxModel();
    }

    javax.swing.ComboBoxModel createComboBoxModel(Object item) {
        return new ComboBoxModel(item);
    }

    static {
        $assertionsDisabled = !ListTreeNode.class.desiredAssertionStatus();
    }

    class ComboBoxModel
    extends AbstractListModel
    implements javax.swing.ComboBoxModel {
        private final Object _firstItem;
        private Object _selectedItem;

        public Object getElementAt(int index) {
            if (this._firstItem != null) {
                if (index == 0) {
                    return this._firstItem;
                }
                return ListTreeNode.this.getChildAt(index - 1);
            }
            return ListTreeNode.this.getChildAt(index);
        }

        public int getSize() {
            if (this._firstItem != null) {
                return ListTreeNode.this.getChildCount() + 1;
            }
            return ListTreeNode.this.getChildCount();
        }

        public Object getSelectedItem() {
            return this._selectedItem;
        }

        public void setSelectedItem(Object obj) {
            if (obj != this._selectedItem) {
                this._selectedItem = obj;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        ComboBoxModel(Object firstItem) {
            this._firstItem = firstItem;
        }

        ComboBoxModel() {
            this._firstItem = null;
        }
    }
}

