/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.Application;

import IceGrid.CommunicatorDescriptor;
import IceGridGUI.Application.Editor;
import IceGridGUI.Application.ListTextField;
import IceGridGUI.Application.PropertiesField;
import IceGridGUI.Utils;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import java.awt.Component;
import java.util.Arrays;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class CommunicatorSubEditor {
    protected Editor _mainEditor;
    private JTextArea _description = new JTextArea(3, 20);
    private ListTextField _propertySets = new ListTextField(20);
    private PropertiesField _properties;

    CommunicatorSubEditor(Editor mainEditor) {
        this._mainEditor = mainEditor;
        this._description.getDocument().addDocumentListener(this._mainEditor.getUpdateListener());
        this._description.setToolTipText("An optional description");
        this._propertySets.getDocument().addDocumentListener(this._mainEditor.getUpdateListener());
        this._properties = new PropertiesField(mainEditor);
        this._description.setToolTipText("Property Set References");
    }

    void appendProperties(DefaultFormBuilder builder) {
        builder.append("Description");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-2);
        CellConstraints cc = new CellConstraints();
        JScrollPane scrollPane = new JScrollPane(this._description);
        builder.add(scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 3));
        builder.nextRow(2);
        builder.nextLine();
        builder.append("Property Sets");
        builder.append((Component)this._propertySets, 3);
        builder.nextLine();
        builder.append("Properties");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-6);
        scrollPane = new JScrollPane(this._properties);
        builder.add(scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 7));
        builder.nextRow(6);
        builder.nextLine();
    }

    void writeDescriptor(CommunicatorDescriptor descriptor) {
        descriptor.propertySet.references = this._propertySets.getList().toArray(new String[0]);
        descriptor.propertySet.properties = this._properties.getProperties();
        descriptor.description = this._description.getText();
    }

    void show(CommunicatorDescriptor descriptor, boolean isEditable) {
        Utils.Resolver detailResolver = this._mainEditor.getDetailResolver();
        isEditable = isEditable && detailResolver == null;
        this._propertySets.setList(Arrays.asList(descriptor.propertySet.references), detailResolver);
        this._propertySets.setEditable(isEditable);
        this._properties.setProperties(descriptor.propertySet.properties, descriptor.adapters, detailResolver, isEditable);
        this._description.setText(Utils.substitute(descriptor.description, detailResolver));
        this._description.setEditable(isEditable);
        this._description.setOpaque(isEditable);
    }
}

