;;; This is an abstraction elimination tool for the Unlambda
;;; programming language.
;;; Version 1.92.1 of 1999/10/30
;;; $Id: unlambdaify.scm,v 1.5 1999/11/03 21:01:13 madore Exp $

;;; Copyright (C) 1999 by David A. Madore <david.madore@ens.fr>

;;; This program is free software; you can redistribute it and/or
;;; modify it under the terms of the GNU General Public License
;;; as published by the Free Software Foundation; either version
;;; 2 of the License, or (at your option) any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty
;;; of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See
;;; the GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

;; Bail out with an error.
(define (error str)
  (display str)
  (newline)
; (quit) ; There is no standard quit operation in Scheme!!!
  (disappear-in-the-pit-of-hell) ; Force an error
  )

;; Parse the input file and return the representation of it.
(define (parse input-port)
  (define (gobble-comment)
    (if (not (let ((ch (read-char input-port)))
	       (or (eof-object? ch)
		   (eqv? ch #\newline))))
	(gobble-comment)))
  (case (let ((ch (read-char input-port)))
	  (if (eof-object? ch)
	      (error "Unexpected end of file")
	      ch))
    ((#\`) (let* ((op (parse input-port)) 
		  (arg (parse input-port)))
	     `(,op . ,arg)))
;   ((#\space #\ht #\cr #\newline) (parse input-port))
    ((#\space #\newline) (parse input-port)) ; #\ht and #\cr are not standard, shit!
    ((#\#) (gobble-comment) (parse input-port))
    ((#\k #\K) '(k)) ; (lambda (x) (lambda (y) x))
    ((#\s #\S) '(s)) ; (lambda (x) (lambda (y) (lambda (z) ((x z) (y z)))))
    ((#\i #\I) '(i)) ; identity (same as ``skk)
    ((#\v #\V) '(v)) ; return v
    ((#\c #\C) '(c)) ; call/cc
    ((#\d #\D) '(d)) ; delay (special form, force at next call)
    ((#\e #\E) '(e)) ; exit immediately
;; The p function has been replaced by the more general . function
;   ((#\p #\P) '(pr #\*)) ; print an asterisk (same as .*)
    ((#\r #\R) '(pr #\newline)) ; print newline
    ((#\.) `(pr ,(let ((ch (read-char input-port)))
		   (if (eof-object? ch)
		       (error "Unexpected end of file")
		       ch)))) ; print given char
    ((#\@) '(rd)) ; read next input char
    ((#\?) `(rc ,(let ((ch (read-char input-port)))
		   (if (eof-object? ch)
		       (error "Unexpected end of file")
		       ch)))) ; compare character under reading head
    ((#\|) '(pc)) ; call arg with dot function for current char
    ((#\^) (let* ((var (let ((ch (read-char input-port)))
			 (if (eof-object? ch)
			     (error "Unexpected end of file")
			     ch)))
		  (body (parse input-port)))
		  `(lambda ,var ,body)))
    ((#\$) `(,(let ((ch (read-char input-port)))
		(if (eof-object? ch)
		    (error "Unexpected end of file")
		    ch))))
    (else (error "Character not understood"))))

;; Unparse (display) an object.
(define (unparse exp)
  (cond
   ((pair? (car exp))
    (write-char #\`) (unparse (car exp)) (unparse (cdr exp)))
   (else (case (car exp)
	   ((k) (write-char #\k))
	   ((k1) (write-char #\`) (write-char #\k) (unparse (cadr exp)))
	   ((s) (write-char #\s))
	   ((s1) (write-char #\`) (write-char #\s) (unparse (cadr exp)))
	   ((s2) (write-char #\`) (write-char #\`) (write-char #\s)
	    (unparse (cadr exp)) (unparse (caddr exp)))
	   ((i) (write-char #\i))
	   ((v) (write-char #\v))
	   ((c) (write-char #\c))
	   ((c1) (display "<continuation>"))
	   ((d) (write-char #\d))
	   ((d1) (write-char #\`) (write-char #\d) (unparse (cadr exp)))
	   ((e) (write-char #\e))
	   ((pr) (if (eqv? (cadr exp) #\newline) (write-char #\r)
		     (begin (write-char #\.) (write-char (cadr exp)))))
	   ((rd) (write-char #\@))
	   ((rc) (begin (write-char #\?) (write-char (cadr exp))))
	   ((pc) (write-char #\|))
	   ((lambda) (write-char #\^) (write-char (cadr exp))
	    (unparse (caddr exp)))
	   (else
	    (if (char? (car exp))
		(begin (write-char #\$) (write-char (car exp)))
		(error "Internal error: unexpected type to unparse!")))))))

;; Unlambdaify
(define remove-lambdas
  (letrec ((remove-variable
	    (lambda (var exp)
	      (cond ((pair? (car exp))
		     `(((s) . ,(remove-variable var (car exp)))
		       . ,(remove-variable var (cdr exp))))
		    ((eqv? (car exp) var)
		     `(i))
		    (else
		     `((k) . ,exp))))))
    (lambda (exp)
      (if (pair? (car exp))
	  `(,(remove-lambdas (car exp)) . ,(remove-lambdas (cdr exp)))
	  (if (eqv? (car exp) 'lambda)
	      (remove-variable (cadr exp) (remove-lambdas (caddr exp)))
	      exp)))))

;; ``Main'' function
(define (main . junk)
  (unparse (remove-lambdas (parse (current-input-port))))
  (newline))
