# {%= name %} {%= badge("fury") %}

> {%= description %}

Use [isobject](https://github.com/jonschlinkert/isobject) if you only want to check if the value is an object and not an array or null.

## Install
{%= include("install-npm", {save: true}) %}

## Usage

```js
var isPlainObject = require('{%= name %}');
```

**true** when created by the `Object` constructor.

```js
isPlainObject(Object.create({}));
//=> true
isPlainObject(Object.create(Object.prototype));
//=> true
isPlainObject({foo: 'bar'});
//=> true
isPlainObject({});
//=> true
```

**false** when not created by the `Object` constructor.

```js
isPlainObject(1);
//=> false
isPlainObject(['foo', 'bar']);
//=> false
isPlainObject([]);
//=> false
isPlainObject(new Foo);
//=> false
isPlainObject(null);
//=> false
isPlainObject(Object.create(null));
//=> false
```

## Related projects
{%= related(['is-plain-object', 'kind-of', 'for-own', 'extend-shallow', 'isobject', 'for-in', 'assign-deep', 'merge-deep']) %}

## Running tests
{%= include("tests") %}

## Author
{%= include("author") %}

## License
{%= copyright() %}
{%= license() %}

***

{%= include("footer") %}
