/***************************************************************************
 *
 * This file is covered by a dual licence. You can choose whether you
 * want to use it according to the terms of the GNU GPL version 2, or
 * under the terms of Zorp Professional Firewall System EULA located
 * on the Zorp installation CD.
 *
 * $Id: streambuf.h,v 1.7 2003/06/04 09:34:06 bazsi Exp $
 *
 ***************************************************************************/

#ifndef ZORP_STREAMBUF_H_INCLUDED
#define ZORP_STREAMBUF_H_INCLUDED

#include <zorp/stream.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef void (*ZStreamBufWritableFunc)(ZStream *stream, gpointer user_data);
typedef gboolean (*ZStreamBufErrorFunc)(ZStream *stream, GIOStatus  status, gpointer  user_data);

ZStream *z_stream_buf_new(ZStream                *stream,
                          guint                  min_threshold,
                          guint                  max_threshold,
                          ZStreamBufWritableFunc writeable_callback,
                          ZStreamBufErrorFunc    error_callback);

GIOStatus z_stream_write_buf(ZStream *stream,
                             gchar *buf,
                             guint  buflen,
                             gboolean  must_copy,
                             gboolean  urgent);

#ifdef __cplusplus
}
#endif

#endif
