.\" Converted with mdoc2man 0.2
.\" from NiH: zip_add.mdoc,v 1.9 2005/06/09 21:14:54 wiz Exp 
.\" $NiH: zip_add.mdoc,v 1.9 2005/06/09 21:14:54 wiz Exp $
.\"
.\" zip_add.mdoc \-- add files to zip archive
.\" Copyright (C) 2004, 2005, 2006 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP archives.
.\" The authors can be contacted at <nih@giga.or.at>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH ZIP_ADD 3 "April 9, 2006" NiH
.SH "NAME"
zip_add , \- .Nm zip_replace
add file to zip archive or replace file in zip archive
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
#include <zip.h>
.PP
int
zip_add(struct zip *archive, const char *name); \
"struct zip_source *source"
.PP
int
zip_replace(struct zip *archive, int index); \
"struct zip_source *source"
.SH "DESCRIPTION"
The function
zip_add
adds a file to a zip archive, while
zip_replace
replaces an existing file in a zip archive.
The argument
\fBarchive\fR
specifies the zip archive to which the file should be added.
\fBname\fR
is the file's name in the zip archive (for
zip_add ),
while
\fBindex\fR
specifies which file should be replaced (for
zip_replace ).
The data is obtained from the
\fBsource\fR
argument.
See the
zip_source_*
functions cited in
SEE ALSO.
.SH "RETURN VALUES"
Upon successful completion, the index of the new file in the archive
is returned.
Otherwise, \-1 is returned and the error code in
\fBarchive\fR
is set to indicate the error.
.SH "EXAMPLES"
.Bd \-literal \-offset indent
struct zip_source *s;

if ((s=zip_source_buffer(archive, buffer, len)) == NULL ||
    zip_add(archive, name, s) \*[Lt] 0) {
    zip_source_free(s);
    printf("error adding file: %s\n", zip_strerror(archive));
}
.Ed
.SH "ERRORS"
zip_add
and
zip_replace
fail if:
.RS
.TP 4
[ZIP_ER_EXISTS]
There is already a file called
\fBname\fR
in the archive.
(Only applies to
zip_add ).
.TP 4
[ZIP_ER_INVAL]
\fBsource\fR
or
\fBname\fR
are
\fBNULL,\fR
or
\fBindex\fR
is invalid.
.TP 4
[ZIP_ER_MEMORY]
Required memory could not be allocated.
.RE
.SH "SEE ALSO"
libzip(3),
zip_source_file(3),
zip_source_filep(3),
zip_source_function(3),
zip_source_zip(3)
.SH "AUTHORS"

Dieter Baron <dillo@giga.or.at>
and
Thomas Klausner <tk@giga.or.at>
