/***************************************************************************
                     libxbox-misc.c - Misc functions for libxbox
                             -------------------
    begin                : Thu Dec 09 23:02:12 BST 2004
    copyright            : (C) 2004 by David Pye
    email                : dmp@davidmpye.dyndns.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdbool.h>
#include <sys/mman.h>
#include <sys/io.h>
#include <errno.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <string.h>

#include "libxbox.h"

bool xbox_mcpx_version(long *version) {
	if (iopl(3)) {
		printf("Unable to set iopl: %s\n",strerror(errno));
		return false;
	}
	outl(0x80000808, 0x0CF8);
	*version = inl(0x0CFC);
	iopl(0);
	return true;
}

bool xbox_nv2a_version(long *version) {
        long *ptr;
	int fd = open("/dev/mem", O_RDONLY);
	if (fd < 0) {
		printf("Unable to open /dev/mem: %s\n",strerror(errno));
		return false;						        
	}
	ptr = mmap(0,4,PROT_READ,MAP_SHARED, fd, 0xFD000000);
	if (ptr == (void *)-1) {
		printf("mmap failed: %s\n",strerror(errno));
		close(fd);
		return false;
	}
	memcpy(version, ptr, 0x04);
	munmap(ptr,4);
	close(fd);
	return true;
}

bool xbox_machine_is_xbox() {
	bool result=false;
	if (iopl(3)) {
		printf("Unable to set iopl: %s\n",strerror(errno));
		return false;
	}
	outl(0x80000000, 0x0CF8);
	if (inl(0x0CFC) == 0x02a510de) {
		result = true;
	}
	iopl(0);
	return result;
}


void xbox_tv_encoder_name(XBOX_TV_ENCODER encoder, char *name) {
	switch (encoder) {
		case ENCODER_CONEXANT:
			strcpy(name,"Conexant");
			break;
		case ENCODER_FOCUS:
			strcpy(name,"Focus");
			break;
		case ENCODER_XCALIBUR:
			strcpy(name,"Xcalibur");
			break;
		default:
			strcpy(name,"Unknown");
	}
}

void xbox_av_cable_name(XBOX_AVIP_CABLE cable, char *name) {
	switch (cable) {
		case CABLE_COMPOSITE:
			strcpy(name,"Composite");
			break;
		case CABLE_SVIDEO:
			strcpy(name,"S-Video");
			break;
		case CABLE_RGB_SCART:
			strcpy(name,"RGB-SCART");
			break;
		case CABLE_HDTV:
			strcpy(name,"HDTV");
			break;
		case CABLE_VGA:
			strcpy(name,"VGA");
			break;
		case CABLE_VGA_SOG:
			strcpy(name, "VGA (Sync on green)");
			break;
		default:
			strcpy(name, "Unknown");
	}
}

void xbox_video_std_name(XBOX_VIDEO_STD std, char *name) {
	switch (std) {
		case VIDEO_PAL:
			strcpy(name, "PAL");
			break;
		case VIDEO_NTSC:
			strcpy(name, "NTSC");
			break;
		case VIDEO_NTSC_J:
			strcpy(name, "NTSC-Japan");
			break;
		default:
			strcpy(name, "Unknown");
			break;
	}
}

void xbox_xbe_region_name(XBOX_XBE_REGION region, char *name) {
	switch (region) {
		case NORTH_AMERICA:
			strcpy(name, "North America");
			break;
		case JAPAN:
			strcpy(name, "Japan");
			break;
		case EURO_AUSTRALIA:
			strcpy(name, "Europe/Australia");
			break;
		case INVALID:
			strcpy(name, "Invalid");
			break;
	}
}
