#!/bin/sh

set -e

VERSION=$(dpkg-parsechangelog | sed -ne 's,^Version: \(.*\)-.*,\1,p')
SOURCE=$(dpkg-parsechangelog | sed -ne 's,Source: \(.*\),\1,p')

DIR=xapool-${VERSION}-src

# clean up the upstream tarball
tar -x -z -f $3
tar -c -z -f $3 --exclude '*.ppt' --exclude '*.jar' --exclude '*/CVS*' $DIR
rm -rf $DIR

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $3 $origDir
  echo "moved $3 to $origDir"
fi

