/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.DTDLocation;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XMLCatalog
extends DataType
implements Cloneable,
EntityResolver,
URIResolver {
    private FileUtils fileUtils = FileUtils.newFileUtils();
    private Vector elements = new Vector();
    private Path classpath;

    public XMLCatalog() {
        this.checked = false;
    }

    private Vector getElements() {
        return this.elements;
    }

    private Path getClasspath() {
        return this.classpath;
    }

    private void setElements(Vector aVector) {
        this.elements = aVector;
    }

    public Path createClasspath() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        this.checked = false;
        return this.classpath.createPath();
    }

    public void setClasspath(Path classpath) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (this.classpath == null) {
            this.classpath = classpath;
        } else {
            this.classpath.append(classpath);
        }
        this.checked = false;
    }

    public void setClasspathRef(Reference r) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.createClasspath().setRefid(r);
        this.checked = false;
    }

    public void addDTD(DTDLocation dtd) throws BuildException {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.getElements().addElement(dtd);
        this.checked = false;
    }

    public void addEntity(DTDLocation dtd) throws BuildException {
        this.addDTD(dtd);
    }

    public void addConfiguredXMLCatalog(XMLCatalog catalog) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        Vector newElements = catalog.getElements();
        Vector ourElements = this.getElements();
        Enumeration enumeration = newElements.elements();
        while (enumeration.hasMoreElements()) {
            ourElements.addElement(enumeration.nextElement());
        }
        Path nestedClasspath = catalog.getClasspath();
        this.createClasspath().append(nestedClasspath);
        this.checked = false;
    }

    public void setRefid(Reference r) throws BuildException {
        if (!this.elements.isEmpty()) {
            throw this.tooManyAttributes();
        }
        Object o = r.getReferencedObject(this.getProject());
        if (!(o instanceof XMLCatalog)) {
            String msg = r.getRefId() + " does not refer to an XMLCatalog";
            throw new BuildException(msg);
        }
        XMLCatalog catalog = (XMLCatalog)o;
        this.setElements(catalog.getElements());
        super.setRefid(r);
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (!this.checked) {
            Stack<XMLCatalog> stk = new Stack<XMLCatalog>();
            stk.push(this);
            this.dieOnCircularReference(stk, this.getProject());
        }
        this.log("resolveEntity: '" + publicId + "': '" + systemId + "'", 4);
        InputSource inputSource = this.resolveEntityImpl(publicId, systemId);
        if (inputSource == null) {
            this.log("No matching catalog entry found, parser will use: '" + systemId + "'", 4);
        }
        return inputSource;
    }

    public Source resolve(String href, String base) throws TransformerException {
        if (!this.checked) {
            Stack<XMLCatalog> stk = new Stack<XMLCatalog>();
            stk.push(this);
            this.dieOnCircularReference(stk, this.getProject());
        }
        SAXSource source = null;
        String uri = this.removeFragment(href);
        this.log("resolve: '" + uri + "' with base: '" + base + "'", 4);
        source = this.resolveImpl(uri, base);
        if (source == null) {
            this.log("No matching catalog entry found, parser will use: '" + href + "'", 4);
            source = new SAXSource();
            try {
                URL baseURL = new URL(base);
                URL url = uri.length() == 0 ? baseURL : new URL(baseURL, uri);
                source.setInputSource(new InputSource(url.toString()));
            }
            catch (MalformedURLException ex) {
                source.setInputSource(new InputSource(uri));
            }
        }
        this.setEntityResolver(source);
        return source;
    }

    private DTDLocation findMatchingEntry(String publicId) {
        Enumeration elements = this.getElements().elements();
        DTDLocation element = null;
        while (elements.hasMoreElements()) {
            element = (DTDLocation)elements.nextElement();
            if (!element.getPublicId().equals(publicId)) continue;
            return element;
        }
        return null;
    }

    private void setEntityResolver(SAXSource source) throws TransformerException {
        XMLReader reader = source.getXMLReader();
        if (reader == null) {
            SAXParserFactory spFactory = SAXParserFactory.newInstance();
            spFactory.setNamespaceAware(true);
            try {
                reader = spFactory.newSAXParser().getXMLReader();
            }
            catch (ParserConfigurationException ex) {
                throw new TransformerException(ex);
            }
            catch (SAXException ex) {
                throw new TransformerException(ex);
            }
        }
        reader.setEntityResolver(this);
        source.setXMLReader(reader);
    }

    private String removeFragment(String uri) {
        String result = uri;
        String fragment = null;
        int hashPos = uri.indexOf("#");
        if (hashPos >= 0) {
            result = uri.substring(0, hashPos);
            fragment = uri.substring(hashPos + 1);
        }
        return result;
    }

    private InputSource filesystemLookup(DTDLocation matchingEntry) {
        String uri = matchingEntry.getLocation();
        File resFile = this.project.resolveFile(uri);
        InputSource source = null;
        if (resFile.exists() && resFile.canRead()) {
            try {
                source = new InputSource(new FileInputStream(resFile));
                URL resFileURL = this.fileUtils.getFileURL(resFile);
                String sysid = resFileURL.toExternalForm();
                source.setSystemId(sysid);
                this.log("catalog entry matched a readable file: '" + sysid + "'", 4);
            }
            catch (FileNotFoundException ex) {
            }
            catch (MalformedURLException ex) {
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return source;
    }

    private InputSource classpathLookup(DTDLocation matchingEntry) {
        InputSource source = null;
        AntClassLoader loader = null;
        loader = this.classpath != null ? new AntClassLoader(this.project, this.classpath) : new AntClassLoader(this.project, Path.systemClasspath);
        InputStream is = loader.getResourceAsStream(matchingEntry.getLocation());
        if (is != null) {
            source = new InputSource(is);
            URL entryURL = loader.getResource(matchingEntry.getLocation());
            String sysid = entryURL.toExternalForm();
            source.setSystemId(sysid);
            this.log("catalog entry matched a resource in the classpath: '" + sysid + "'", 4);
        }
        return source;
    }

    private InputSource urlLookup(String uri, String base) {
        InputSource source = null;
        URL url = null;
        try {
            if (base == null) {
                url = new URL(uri);
            } else {
                URL baseURL = new URL(base);
                url = uri.length() == 0 ? baseURL : new URL(baseURL, uri);
            }
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
        if (url != null) {
            try {
                InputStream is = url.openStream();
                if (is != null) {
                    source = new InputSource(is);
                    String sysid = url.toExternalForm();
                    source.setSystemId(sysid);
                    this.log("catalog entry matched as a URL: '" + sysid + "'", 4);
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return source;
    }

    private InputSource resolveEntityImpl(String publicId, String systemId) {
        InputSource result = null;
        DTDLocation matchingEntry = this.findMatchingEntry(publicId);
        if (matchingEntry != null) {
            this.log("Matching catalog entry found for publicId: '" + matchingEntry.getPublicId() + "' location: '" + matchingEntry.getLocation() + "'", 4);
            result = this.filesystemLookup(matchingEntry);
            if (result == null) {
                result = this.classpathLookup(matchingEntry);
            }
            if (result == null) {
                result = this.urlLookup(matchingEntry.getLocation(), null);
            }
        }
        return result;
    }

    private SAXSource resolveImpl(String href, String base) throws TransformerException {
        SAXSource result = null;
        InputSource source = null;
        DTDLocation matchingEntry = this.findMatchingEntry(href);
        if (matchingEntry != null) {
            this.log("Matching catalog entry found for uri: '" + matchingEntry.getPublicId() + "' location: '" + matchingEntry.getLocation() + "'", 4);
            source = this.filesystemLookup(matchingEntry);
            if (source == null) {
                source = this.classpathLookup(matchingEntry);
            }
            if (source == null) {
                source = this.urlLookup(matchingEntry.getLocation(), base);
            }
            if (source != null) {
                result = new SAXSource(source);
            }
        }
        return result;
    }
}

