/* 
-------------------------------------------------------------- 
Copyright 2007-2008 Max Cavallo ixamit@gmail.com - All Rights Reserved

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, Inc., 675 Mass Ave, Cambridge MA 02139,USA; either version 2 of the License, or (at your option) any later version; incorporated herein by reference.
-------------------------------------------------------------- 
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <mysql/mysql.h>

struct SqlConInfo
{
	char *host;
	char *user;
	char *dbase;
	int ShowErrors;
}SqlConInfo;

int MySqlError (MYSQL *mysql, char *info)
{
	char Error[256];
	unsigned int CodErr=mysql_errno(mysql);

	if (SqlConInfo.ShowErrors==0) return (0);

	if (CodErr==1045)
	{
		sprintf (Error,
			"Accesso negato per %s@%s\n",
			SqlConInfo.user,
			SqlConInfo.host);
	}
	else if (CodErr==1049)
	{
		sprintf (Error,
			"Database '%s' sconosciuto\n",
			SqlConInfo.dbase);
	}
	else if (CodErr==2002)
	{ 
		sprintf (Error,
			"Non connesso al MySql server %s\n",
			SqlConInfo.host);
	}
	else if (CodErr==2005)
	{ 
		sprintf (Error,
			"Host server MySql '%s' sconosciuto\n",
			SqlConInfo.host);
	}
	else	
	{
		sprintf (Error,"%s\n",mysql_error(mysql));
	}

	//sprintf(Error,"[%u] %s\n ",CodErr,Error);
	printf ("[%u] %s\n",CodErr,Error);

	printf ("%s\n",Error);
	if (info) printf ("%s\n",info);
	
	exit (CodErr);
}

unsigned int MySqlNumFields (MYSQL_RES *result)
{
	unsigned int num=0;
	num=mysql_num_fields(result);
	return (num);
}

MYSQL_ROW MySqlFetchRow (MYSQL_RES *result, MYSQL_ROW row)
{
	//MYSQL_ROW row;

	mysql_field_seek (result, 0);
	row = mysql_fetch_row (result);

	return (row);
}

int MySqlNumRows (MYSQL *mysql, MYSQL_RES *result)
{
	int num_rows;

	num_rows = mysql_num_rows (result);

	return (num_rows);
}

MYSQL_RES *MySqlStoreResult (MYSQL *mysql, MYSQL_RES *result)
{

	result = mysql_store_result (mysql);
	if (!result)
	{
		MySqlError (mysql,NULL);
	}
	return (result);
}

int MySqlQuery (MYSQL *mysql, MYSQL_RES *result, char *query)
{
	int err=0;
	err=mysql_query (mysql, query);
	if (err)
	{
		MySqlError (mysql, query);
	}
	return (err);
}

int MySqlSelectDb (MYSQL *mysql, char *database)
{
	int err=0;

	SqlConInfo.dbase=database;

	err=mysql_select_db (mysql, database);
        if (err) 
	{
		MySqlError (mysql, NULL);
        }
	return (err);
}

MYSQL *MySqlRealConnect (MYSQL *mysql, char *host, char *user, char *pass)
{
	MYSQL *mysql_ret;

	SqlConInfo.host=host;
	SqlConInfo.user=user;
	SqlConInfo.dbase=NULL;
	SqlConInfo.ShowErrors=1;

        mysql_ret=mysql_real_connect (mysql, host, user, pass, "" , 0, NULL, 0);
	if (!mysql_ret)
	{
		MySqlError (mysql, NULL);
	}
	return (mysql_ret);
}

MYSQL *MySqlInit (MYSQL *mysql)
{
	MYSQL *mysql_ret;

        mysql_ret=mysql_init (mysql);
	if (!mysql_ret)
	{
                MySqlError (mysql, NULL);
        }
	return (mysql_ret);
}
/*
int main (int argc,char **argv)
{
	
	MYSQL *mysql=NULL;
	MYSQL_RES *result=NULL;
	MYSQL_ROW row;
	int numero_rows;
	int x;

	mysql=MySqlInit(mysql);
	MySqlRealConnect(mysql,"localhost","max","siena");
	MySqlSelectDb (mysql,"test");
	MySqlQuery (mysql, result, "SELECT cip FROM tam000;");
	result=MySqlStoreResult (mysql,result);
	numero_rows=MySqlNumRows (mysql, result);
	printf ("%d\n",numero_rows);
	row=MySqlFetchRow (result, row);
	
	for (x=0;x<MySqlNumFields (result);x++)
		printf ("%d...%s\n",x+1,row[x]);
}
*/

