/* 
-------------------------------------------------------------- 
Copyright 2007-2008 Max Cavallo ixamit@gmail.com - All Rights Reserved

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, Inc., 675 Mass Ave, Cambridge MA 02139,USA; either version 2 of the License, or (at your option) any later version; incorporated herein by reference.
-------------------------------------------------------------- 
*/
/*
	NOTE VERY IMPORTANT !!!
	Menu uses same ListCmdInfo struct as ListBox & ComboBox
	CALL WX11_MENU BEFORE ANY OTHER COSTRUCTING LISTCMDINFO
*/

#include "finestre.h"
int WX11_SPACE_BETWEEN_BORDERS;

ListCmdInfo *WX11_MenuFirst (int mode,ListCmdInfo *menu)
{
	static ListCmdInfo *current=NULL;
	if (mode) current=menu;
	return (current);
}

ListCmdInfo *WX11_MenuLast (int mode,ListCmdInfo *menu)
{
	static ListCmdInfo *current=NULL;
	if (mode) current=menu;
	return (current);
}

ListCmdInfo *WX11_MenuCurrent (int mode,ListCmdInfo *menu)
{
	static ListCmdInfo *current=NULL;
	if (mode) current=menu;
	return (current);
}

void WX11_Menu_free ()
{
	ListCmdInfo *menu,*next_menu;
	ListCmdItemInfo *item,*next_item;

	menu=WX11_MenuLast (0,NULL);
	while (menu)
	{
		next_menu=menu->Prev;


		item=menu->UltimoItem;
		while (item)
		{
			next_item=item->Prev;
			WX11_ListCmdFreeItem (menu, item);
			item=next_item;
		}
		// Warning !!!
		// Dont use WX11_ListCmdFree... just free
		free (menu);
		menu=next_menu;
	}
}

int WX11_MenuHotKey (ListCmdInfo *menu,ListCmdItemInfo *menu_item,char *hotkey)
{
	if (!menu || !menu_item || !menu_item->extra)
	{
		printf ("WX11_MenuHotKey: CallBack not defined?!\n");
		return (0);
	}
		

	if (menu->MaxLenItem < strlen(menu_item->Buff)+strlen(hotkey)+1)
		menu->MaxLenItem =  strlen(menu_item->Buff)+strlen(hotkey)+1;

	(menu_item->extra)->hotkey=hotkey;
	return (0);
}

int WX11_MenuCallBack (ListCmdItemInfo *menu_item,int (*CallBack)(),void *data)
{
	ListCmdItemExtraInfo *extra;
	extra = (ListCmdItemExtraInfo *) malloc (sizeof(ListCmdItemExtraInfo));
	if (extra==NULL)
	{
		printf ("Non posso allocare ListCmdItemExtraInfo\n");
		exit (1);
	}
	extra->CallBack=CallBack;
	extra->data=data;
	extra->hotkey=NULL;
	
	menu_item->extra=extra;
	return (0);
}

int WX11_MenuExec (CmdInfo *cmd,int EventType,ListCmdInfo *menu)
{
	ListCmdItemInfo *menu_item;
	int (*CallBack)()=NULL;
	void *data=NULL;
	int ret=0;

	if (EventType==EnterNotify)
	{
		menu_item=CercaListCmdItemInfo (menu, cmd->win);
		menu->CorrenteItem=menu_item;
	}
	if (EventType==LeaveNotify)
	{
		menu_item=NULL;
		menu->CorrenteItem=menu_item;
	}
	if (EventType==Button1Release)
	{
		if (menu->CorrenteItem->select)//!=-1)
		{
			*menu->CorrenteItem->select=!*(menu->CorrenteItem->select);
		}

		if (menu->CorrenteItem->extra)
		{
			CallBack=menu->CorrenteItem->extra->CallBack;
			data=menu->CorrenteItem->extra->data;
		}
		UltimoComandoSelezionato(1,NULL);
		WX11_MenuOpen (menu->CmdOpen,Button1Press,menu);
		if (CallBack)
			ret=(CallBack)(data);
	}
	return (ret);
}

int WX11_MenuOpen (CmdInfo *cmd,int EventType,ListCmdInfo *menu)
{
	ListCmdInfo *menu_old=WX11_MenuCurrent(0,NULL);

	ListCmdItemInfo *menuitem=menu->PrimoItem;
	CmdInfo *area,*cmd_item,*CmdParent=CercaComando(cmd->parent);
	int AltezzaComando=WX11_FontHeight()+4;
 	int Width =40+(menu->MaxLenItem)*WX11_FontWidth ();
	int Height=AltezzaComando*menu->NumeroItem;
	int x=cmd->x;
	int y=(cmd->y)+(cmd->Height);
	unsigned int colorbg=WX11_ColorGet(MENUBG);
	unsigned int colorfg=WX11_ColorGet(MENUFG);
	int Bordo=2;
	char NewBuf[64];

	Width+=WX11_SPACE_BETWEEN_BORDERS*2;

	if (menu_old)
	{
		if ((EventType==Button1Press) || (EventType==EnterNotify && menu_old != menu))
		{

			menu_old->CorrenteItem=NULL;

			menu_old->CmdOpen->Focus=0;
			WX11_PrintFlush (menu_old->CmdOpen);

			xFreeCmd(menu_old->CmdPar);
			
			if (EventType==Button1Press)
			{
				menu_old=NULL;
				WX11_MenuCurrent (1,NULL);
				return (0);
			}
		}
	}
	
	if ((EventType==Button1Press && menu_old==NULL) || (EventType==EnterNotify && menu_old && menu_old != menu))
	{
		cmd->Focus=1;
		WX11_PrintFlush (cmd);

		area=ApreArea (CmdParent,x+1,y+3,Width+1, Height+1, colorbg,colorfg,Bordo);
		//area=WX11_CmdOpen (MENU,CmdParent,x+1,y+3,Width+1, Height+1, colorbg,colorfg,Bordo," "); area->BUpDn=1;
		menu->CmdPar=area;
		menu->CorrenteItem=NULL;

		for (x=0;x < menu->NumeroItem;x++)
		{

			if (menuitem->extra && menuitem->extra->hotkey)
				sprintf (NewBuf,"%s %s",menuitem->Buff,menuitem->extra->hotkey);
			else
				strcpy (NewBuf,menuitem->Buff);

			cmd_item=WX11_CheckBoxOpen (MENU_ITEM, area, 0, 0+(AltezzaComando * x),
				Width , AltezzaComando, colorbg , colorfg, 0, NewBuf, menuitem->select);

			menuitem->Cmd=cmd_item;

			WX11_SetSignalCallBack (cmd_item,Button1Release,WX11_MenuExec,menu);
			WX11_SetSignalCallBack (cmd_item,EnterNotify,WX11_MenuExec,menu);
			WX11_SetSignalCallBack (cmd_item,LeaveNotify,WX11_MenuExec,menu);

			menuitem=menuitem->Next;
		}
		menu_old=menu;
		WX11_MenuCurrent (1,menu);
	}
	
	return (0);
}

void WX11_Menu (CmdInfo *parent,ListCmdInfo *menu[],int nmenu)
{
	CmdInfo *cmd;
	unsigned int colorbg=WX11_ColorGet(MENUBG);
	unsigned int colorfg=WX11_ColorGet(MENUFG);
	int Width,Height;
	int pos,x,gap;
	//
	//
	Height=WX11_FontHeight()+5;
	gap=15;
	pos=5;
	for (x=0;x<nmenu;x++)
	{
		Width=XTextWidth(WX11_FontCurrent(),menu[x]->Name,strlen(menu[x]->Name));
		Width+=WX11_SPACE_BETWEEN_BORDERS*2;
		cmd=WX11_CmdOpen (MENU,parent,pos,5,Width,Height,colorbg,colorfg,0,menu[x]->Name);
		menu[x]->CmdOpen=cmd;
		pos+=Width+gap;
		
		WX11_SetSignalCallBack (cmd,Button1Press,WX11_MenuOpen,menu[x]);
		WX11_SetSignalCallBack (cmd,EnterNotify, WX11_MenuOpen,menu[x]);

	}

	//WX11_MenuFirst (1,menu[0]);
	//WX11_MenuLast  (1,menu[nmenu-1]);
	//
	WX11_MenuFirst (1,WX11_ListCmdFirst (0, NULL));
	WX11_MenuLast  (1,WX11_ListCmdLast  (0, NULL));
	//
	WX11_ListCmdFirst (1, NULL);
	WX11_ListCmdLast (1, NULL);
	
}

