/*
  assignment problem by simulated annealing.
*/

#include "wnlib.h"
#include "wnswap.h"
#include "wnabs.h"

#include "wnmat.h"


#define SIZE 200
/*
#define SIZE 50
*/


local int *permutation;
local double objective,**matrix;


main()
{
  wn_gpmake("no_free");

  initialize();

  printf("size = %d\n",SIZE);
  printf("start objective = %f\n",objective);

  solve();

  printf("end objective = %f\n",objective);

  wn_gpfree();
}



local initialize()
{
  extern double wn_flat_distribution();
  int i,j;

  wn_make_raw_matrix(&matrix,SIZE,SIZE);
  permutation = (int *)wn_zalloc(SIZE*wn_sizeof(int));

  wn_random_permutation(permutation,SIZE);

  for(i=0;i<SIZE;++i)
  {
    for(j=0;j<SIZE;++j)
    {
      matrix[i][j] = wn_flat_distribution();
    }
  }

  objective = 0;

  for(i=0;i<SIZE;++i)
  {
    objective += matrix[i][permutation[i]];
  }
}


/*
#define TIME 20000000000.0    
#define TIME 10000000000.0    
#define TIME 1800000000.0    
#define TIME 360000000.0    
#define TIME 1000000.0
*/
#define TIME 10000000000.0

local solve()
{
  double delta_of_mutation(),temperature_function();
  void accept_mutation();
  double temperature;

  printf("time = %f\n",(float)TIME);
  wn_measure_anneal_temperature(&temperature,(delta_of_mutation),10000.0);
  printf("temperature = %f\n",(float)temperature);

  wn_anneal(
	    (delta_of_mutation),(accept_mutation),
	    (temperature_function),
	    TIME);

  wn_measure_anneal_temperature(&temperature,(delta_of_mutation),10000.0);
  printf("temperature = %f\n",(float)temperature);
}



local double temperature_function(time)

double time;

{
  /*
  return(1.00*wn_anneal_time*time);
  return(0.20*wn_anneal_time*time);
  return(0.20*wn_anneal_time*time + 0.05);
  return(0.05);
  */
  return(0.20*time*time);
}



local int index1,index2;
local double delta_score;



local double delta_of_mutation()
{
  double eval_num_at_index();

  index1 = wn_random_mod_int(SIZE);
  index2 = wn_random_mod_int(SIZE);

  compute_delta(&delta_score);
		
  return(delta_score);
}



local compute_delta(pdelta_score)

double *pdelta_score;

{
  *pdelta_score = matrix[index1][permutation[index2]] +
		  matrix[index2][permutation[index1]] -
		  matrix[index1][permutation[index1]] -
		  matrix[index2][permutation[index2]];
}



local accept_mutation()
{
  wn_swap(permutation[index1],permutation[index2],int);

  objective += delta_score;
}




