/****************************************************************************

COPYRIGHT NOTICE:

  The source code in this file is provided free of charge
  to the author's consulting clients.  It is in the
  public domain and therefore may be used by anybody for
  any purpose.

AUTHOR:

  Will Naylor

****************************************************************************/

#include <math.h>

#include "wnlib.h"
#include "wnasrt.h"
#include "wnmem.h"
#include "wnfft.h"



#define SIZE  (1<<15)


local void print_vect(wn_cplx vect[],int size)
{
  int i;

  printf("[");

  for(i=0;i<size;++i)
  {
    printf(" ");
    wn_cplx_print(vect[i]);
  }

  printf("]\n");
}


void main(void)
{
  wn_cplx *vect;

  wn_cplx_make_vect(&vect,SIZE);

  vect[0]->real = 1.0;
  vect[1]->real = 1.0;
  vect[2]->real = 1.0;

  /*
  print_vect(vect,SIZE);
  */
  print_vect(vect,20);

  wn_fft_vect(vect,SIZE);

  print_vect(vect,20);
  /*
  */

  wn_inverse_fft_vect(vect,SIZE);

  print_vect(vect,20);
  /*
  */
}


