= webapp - easy-to-use CGI/FastCGI/mod_ruby/WEBrick interface

== Features

* very easy-to-use API
* works under CGI, FastCGI and mod_ruby without modification
* works under WEBrick
  (WEBrick based server must require "webapp/webrick-servlet", though.)
* works as a standalone http server without modification
* works as usual command (CLI) for debugging and static content generation.
    xxx.cgi [options] [/path_info] [?query_string]
* path_info aware relative URI generation
* HTML form parameter validation by HTML form (sample/query.cgi)
* automatic Content-Type generation
* a web application can be used as a web site with WEBrick
  (URL will be http://host/path_info?query.
  No path component to specify a web application.)
* a response is gzipped automatically if the browser accepts.
* Last-Modified: and If-Modified-Since: support for usual files.

== Home Page

((<URL:http://cvs.m17n.org/~akr/webapp/>))

== Download

* ((<URL:http://cvs.m17n.org/viewcvs/ruby/webapp.tar.gz>))

== How to Install

  % ruby install.rb

To see the list of files to install: ruby install.rb -n

== Reference Manual

((<URL:doc/index.html>))

== Example

=== Hello World

The script follows works under CGI, FastCGI and mod_ruby without modification.
(Although it depends on web server configuration, the filename of the script
should be "hello.cgi", "hello.fcgi" or "hello.rbx".)

  #!/usr/bin/env ruby
  require 'webapp'
  WebApp {|webapp|
    webapp.puts "Hello World."
  }

The script also works under WEBrick based server such as follows.
In this case, the script filename should be "hello.webrick".

  require 'webapp/webrick-servlet'
  httpd = WEBrick::HTTPServer.new(:DocumentRoot => Dir.getwd, :Port => 10080)
  trap(:INT){ httpd.shutdown }
  httpd.start 

The script also works as usual command.
It can be used for debugging and static content generation.

  % ./hello.cgi 
  Status: 200 OK
  Content-Type: text/plain
  Content-Length: 13

  Hello World.

The script also works as a standalone http server.

  % ./hello.cgi server
  http://serein:38846/
  [2005-02-19 10:29:26] INFO  WEBrick 1.3.1
  [2005-02-19 10:29:26] INFO  ruby 1.9.0 (2005-02-17) [i686-linux]
  [2005-02-19 10:29:26] INFO  WEBrick::HTTPServer#start: pid=9280 port=38846
  ...

== TODO

* file upload (multipart/form-data) support
* session support
* customizable cookie support

== Requirements

* Ruby 1.8.2
* htree 0.2
* fcgi 0.8.4 (if you use FastCGI)
* mod_ruby 1.2.2 (if you use mod_ruby)

== License

The modified BSD license

== Author
Tanaka Akira <akr@m17n.org>
