/* libtinymail-1.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Tny", lower_case_cprefix = "tny_")]
namespace Tny {
	[CCode (cheader_filename = "tny.h")]
	public class CachedFile : GLib.Object {
		[CCode (has_construct_function = false)]
		public CachedFile (Tny.FsStreamCache stream_cache, string id, int64 expected_size, Tny.Stream stream);
		public virtual int64 get_expected_size ();
		public virtual unowned string get_id ();
		public virtual unowned Tny.Stream get_stream ();
		public virtual ulong get_timestamp ();
		public virtual bool is_active ();
		public virtual bool is_finished ();
		public virtual void remove ();
		public virtual void unregister_stream (Tny.CachedFileStream stream);
		public virtual int64 wait_fetchable (int64 offset);
	}
	[CCode (cheader_filename = "tny.h")]
	public class CachedFileStream : Tny.FsStream, Tny.Stream, Tny.Seekable {
		[CCode (type = "TnyStream*", has_construct_function = false)]
		public CachedFileStream (Tny.CachedFile cached_file, int fd);
	}
	[CCode (cheader_filename = "tny.h")]
	public class CombinedAccount : GLib.Object, Tny.Account, Tny.StoreAccount, Tny.FolderStore, Tny.TransportAccount {
		[CCode (type = "TnyAccount*", has_construct_function = false)]
		public CombinedAccount (Tny.TransportAccount ta, Tny.StoreAccount sa);
		public unowned Tny.StoreAccount get_store_account ();
		public unowned Tny.TransportAccount get_transport_account ();
	}
	[CCode (cheader_filename = "tny.h")]
	public class FolderChange : GLib.Object {
		[CCode (has_construct_function = false)]
		public FolderChange (Tny.Folder folder);
		public void add_added_header (Tny.Header header);
		public void add_expunged_header (Tny.Header header);
		public void get_added_headers (Tny.List headers);
		public Tny.FolderChangeChanged get_changed ();
		public bool get_check_duplicates ();
		public void get_expunged_headers (Tny.List headers);
		public unowned Tny.Folder get_folder ();
		public uint get_new_all_count ();
		public uint get_new_unread_count ();
		public unowned Tny.Msg get_received_msg ();
		public unowned string get_rename (string oldname);
		public void reset ();
		public void set_check_duplicates (bool check_duplicates);
		public void set_new_all_count (uint new_all_count);
		public void set_new_unread_count (uint new_unread_count);
		public void set_received_msg (Tny.Msg msg);
		public void set_rename (string newname);
	}
	[CCode (cheader_filename = "tny.h")]
	public class FolderMonitor : GLib.Object, Tny.FolderObserver {
		[CCode (type = "TnyFolderObserver*", has_construct_function = false)]
		public FolderMonitor (Tny.Folder folder);
		public virtual void add_list (Tny.List list);
		public virtual void poke_status ();
		public virtual void remove_list (Tny.List list);
		public virtual void start ();
		public virtual void stop ();
	}
	[CCode (cheader_filename = "tny.h")]
	public class FolderStats : GLib.Object {
		[CCode (has_construct_function = false)]
		public FolderStats (Tny.Folder folder);
		public uint get_all_count ();
		public unowned Tny.Folder get_folder ();
		public size_t get_local_size ();
		public uint get_unread_count ();
		public void set_local_size (size_t local_size);
	}
	[CCode (cheader_filename = "tny.h")]
	public class FolderStoreChange : GLib.Object {
		[CCode (has_construct_function = false)]
		public FolderStoreChange (Tny.FolderStore folderstore);
		public void add_created_folder (Tny.Folder folder);
		public void add_removed_folder (Tny.Folder folder);
		public Tny.FolderStoreChangeChanged get_changed ();
		public void get_created_folders (Tny.List folders);
		public unowned Tny.FolderStore get_folder_store ();
		public void get_removed_folders (Tny.List folders);
		public void reset ();
	}
	[CCode (cheader_filename = "tny.h")]
	public class FolderStoreQuery : GLib.Object {
		public weak Tny.List items;
		[CCode (has_construct_function = false)]
		public FolderStoreQuery ();
		public void add_item (string pattern, Tny.FolderStoreQueryOption options);
		public unowned Tny.List get_items ();
	}
	[CCode (cheader_filename = "tny.h")]
	public class FolderStoreQueryItem : GLib.Object {
		public Tny.FolderStoreQueryOption options;
		public weak string pattern;
		public void* regex;
		public Tny.FolderStoreQueryOption get_options ();
		public unowned string get_pattern ();
		public void* get_regex ();
	}
	[CCode (cheader_filename = "tny.h")]
	public class FsStream : GLib.Object, Tny.Stream, Tny.Seekable {
		[CCode (type = "TnyStream*", has_construct_function = false)]
		public FsStream (int fd);
		public void set_fd (int fd);
	}
	[CCode (cheader_filename = "tny.h")]
	public class FsStreamCache : GLib.Object, Tny.StreamCache {
		[CCode (type = "TnyStreamCache*", has_construct_function = false)]
		public FsStreamCache (string path, uint64 max_size);
		public unowned string get_path ();
	}
	[CCode (cheader_filename = "tny.h")]
	public class MergeFolder : GLib.Object, Tny.Folder, Tny.FolderObserver {
		[CCode (type = "TnyFolder*", has_construct_function = false)]
		public MergeFolder (string folder_name);
		public void add_folder (Tny.Folder folder);
		public void get_folders (Tny.List list);
		public void remove_folder (Tny.Folder folder);
		public void set_folder_type (Tny.FolderType folder_type);
		public void set_ui_locker (Tny.Lockable ui_locker);
		[CCode (type = "TnyFolder*", has_construct_function = false)]
		public MergeFolder.with_ui_locker (string folder_name, Tny.Lockable ui_locker);
	}
	[CCode (cheader_filename = "tny.h")]
	public class MergeFolderStore : GLib.Object, Tny.FolderStore, Tny.FolderStoreObserver {
		[CCode (has_construct_function = false)]
		public MergeFolderStore (Tny.Lockable ui_locker);
		public virtual void add_store (Tny.FolderStore store);
		[NoWrapper]
		public virtual void add_store_observer (Tny.FolderStoreObserver observer);
		[NoWrapper]
		public virtual unowned Tny.Folder create_folder (string name) throws GLib.Error;
		[NoWrapper]
		public virtual void create_folder_async (string name, Tny.CreateFolderCallback callback, Tny.StatusCallback status_callback);
		[NoWrapper]
		public virtual unowned Tny.FolderStore get_folder_store ();
		[NoWrapper]
		public virtual void get_folders (Tny.List list, Tny.FolderStoreQuery query, bool refresh) throws GLib.Error;
		[NoWrapper]
		public virtual void get_folders_async (Tny.List list, Tny.FolderStoreQuery query, bool refresh, Tny.GetFoldersCallback callback, Tny.StatusCallback status_callback);
		[NoWrapper]
		public virtual void refresh_async (Tny.FolderStoreCallback callback, Tny.StatusCallback status_callback);
		[NoWrapper]
		public virtual void remove_folder (Tny.Folder folder) throws GLib.Error;
		public virtual void remove_store (Tny.FolderStore store);
		[NoWrapper]
		public virtual void remove_store_observer (Tny.FolderStoreObserver observer);
	}
	[CCode (cheader_filename = "tny.h")]
	public class NoopLockable : GLib.Object, Tny.Lockable {
		[CCode (type = "TnyLockable*", has_construct_function = false)]
		public NoopLockable ();
	}
	[CCode (cheader_filename = "tny.h")]
	public class Pair : GLib.Object {
		[CCode (has_construct_function = false)]
		public Pair (string name, string value);
		public unowned string get_name ();
		public unowned string get_value ();
		public void set_name (string name);
		public void set_value (string value);
	}
	[CCode (cheader_filename = "tny.h")]
	public class SimpleList : GLib.Object, Tny.List {
		[CCode (type = "TnyList*", has_construct_function = false)]
		public SimpleList ();
	}
	[Compact]
	[CCode (copy_function = "tny_status_copy", cheader_filename = "tny.h")]
	public class Status {
		public int code;
		public GLib.Quark domain;
		public weak string message;
		public uint of_total;
		public uint position;
		[CCode (has_construct_function = false)]
		public Status (GLib.Quark domain, int code, uint position, uint of_total, string format);
		public unowned Tny.Status copy ();
		public double get_fraction ();
		[CCode (has_construct_function = false)]
		public Status.literal (GLib.Quark domain, int code, uint position, uint of_total, string message);
		public bool matches (GLib.Quark domain, int code);
		public void set_fraction (double fraction);
	}
	[Compact]
	[CCode (cheader_filename = "tny.h")]
	public class TError {
	}
	[CCode (cheader_filename = "tny.h")]
	public interface Account : GLib.Object {
		public abstract void cancel ();
		public abstract Tny.AccountType get_account_type ();
		public abstract unowned Tny.ConnectionPolicy get_connection_policy ();
		public abstract Tny.ConnectionStatus get_connection_status ();
		public abstract unowned Tny.ForgetPassFunc get_forget_pass_func ();
		public abstract unowned string get_hostname ();
		public abstract unowned string get_id ();
		public abstract unowned string get_name ();
		public abstract unowned Tny.GetPassFunc get_pass_func ();
		public abstract uint get_port ();
		public abstract unowned string get_proto ();
		public abstract unowned string get_secure_auth_mech ();
		public abstract unowned string get_url_string ();
		public abstract unowned string get_user ();
		public abstract bool is_ready ();
		public abstract bool matches_url_string (string url_string);
		public abstract void set_connection_policy (Tny.ConnectionPolicy policy);
		public abstract void set_forget_pass_func (Tny.ForgetPassFunc forget_pass_func);
		public abstract void set_hostname (string host);
		public abstract void set_id (string id);
		public abstract void set_name (string name);
		public abstract void set_pass_func (Tny.GetPassFunc get_pass_func);
		public abstract void set_port (uint port);
		public abstract void set_proto (string proto);
		public abstract void set_secure_auth_mech (string mech);
		public abstract void set_url_string (string url_string);
		public abstract void set_user (string user);
		public abstract void start_operation (Tny.StatusDomain domain, Tny.StatusCode code, Tny.StatusCallback status_callback, void* status_user_data);
		public abstract void stop_operation (bool cancelled);
		public signal void changed ();
		public signal void connection_status_changed (Tny.ConnectionStatus status);
	}
	[CCode (cheader_filename = "tny.h")]
	public interface AccountStore : GLib.Object {
		public abstract bool alert (Tny.Account account, Tny.AlertType type, bool question, GLib.Error error);
		public abstract Tny.Account? find_account (string url_string);
		public abstract void get_accounts (Tny.List list, Tny.GetAccountsRequestType types);
		public abstract unowned string get_cache_dir ();
		public abstract Tny.Device get_device ();
		public signal void connecting_started ();
	}
	[CCode (cheader_filename = "tny.h")]
	public interface ConnectionPolicy {
		public abstract void on_connect (Tny.Account account);
		public abstract void on_connection_broken (Tny.Account account);
		public abstract void on_disconnect (Tny.Account account);
		public abstract void set_current (Tny.Account account, Tny.Folder folder);
	}
	[CCode (cheader_filename = "tny.h")]
	public interface Device : GLib.Object {
		public abstract void force_offline ();
		public abstract void force_online ();
		public abstract bool is_forced ();
		public abstract bool is_online ();
		public abstract void reset ();
		public signal void connection_changed (bool online);
	}
	[CCode (cheader_filename = "tny.h")]
	public interface Folder : GLib.Object {
		public abstract void add_msg (Tny.Msg msg) throws GLib.Error;
		public abstract void add_msg_async (Tny.Msg msg, Tny.FolderCallback callback, Tny.StatusCallback status_callback);
		public abstract void add_observer (Tny.FolderObserver observer);
		public abstract unowned Tny.Folder copy (Tny.FolderStore into, string new_name, bool del) throws GLib.Error;
		public abstract void copy_async (Tny.FolderStore into, string new_name, bool del, Tny.CopyFolderCallback callback, Tny.StatusCallback status_callback);
		public abstract unowned Tny.Msg find_msg (string url_string) throws GLib.Error;
		public abstract void find_msg_async (string url_string, Tny.GetMsgCallback callback, Tny.StatusCallback status_callback);
		public abstract unowned Tny.Account get_account ();
		public abstract uint get_all_count ();
		public abstract Tny.FolderCaps get_caps ();
		public abstract unowned Tny.FolderStore get_folder_store ();
		public abstract Tny.FolderType get_folder_type ();
		public abstract void get_headers (Tny.List headers, bool refresh) throws GLib.Error;
		public abstract void get_headers_async (Tny.List headers, bool refresh, Tny.GetHeadersCallback callback, Tny.StatusCallback status_callback);
		public abstract unowned string get_id ();
		public abstract uint get_local_size ();
		public abstract unowned Tny.Msg get_msg (Tny.Header header) throws GLib.Error;
		public abstract void get_msg_async (Tny.Header header, Tny.GetMsgCallback callback, Tny.StatusCallback status_callback);
		public abstract unowned Tny.MsgReceiveStrategy get_msg_receive_strategy ();
		public abstract unowned Tny.MsgRemoveStrategy get_msg_remove_strategy ();
		public abstract unowned string get_name ();
		public abstract unowned Tny.FolderStats get_stats ();
		public abstract uint get_unread_count ();
		public abstract unowned string get_url_string ();
		public abstract bool is_subscribed ();
		public abstract void poke_status ();
		public abstract void refresh () throws GLib.Error;
		public abstract void refresh_async ([CCode (delegate_target_pos = 2.1)] Tny.FolderCallback callback, Tny.StatusCallback status_callback);
		public abstract void remove_msg (Tny.Header header) throws GLib.Error;
		public abstract void remove_msgs (Tny.List headers) throws GLib.Error;
		public abstract void remove_msgs_async (Tny.List headers, Tny.FolderCallback callback, Tny.StatusCallback status_callback);
		public abstract void remove_observer (Tny.FolderObserver observer);
		public abstract void set_msg_receive_strategy (Tny.MsgReceiveStrategy st);
		public abstract void set_msg_remove_strategy (Tny.MsgRemoveStrategy st);
		public abstract void sync (bool expunge) throws GLib.Error;
		public abstract void sync_async (bool expunge, Tny.FolderCallback callback, Tny.StatusCallback status_callback);
		public abstract void transfer_msgs (Tny.List header_list, Tny.Folder folder_dst, bool delete_originals) throws GLib.Error;
		public abstract void transfer_msgs_async (Tny.List header_list, Tny.Folder folder_dst, bool delete_originals, Tny.TransferMsgsCallback callback, Tny.StatusCallback status_callback);
	}
	[CCode (cheader_filename = "tny.h")]
	public interface FolderObserver {
		public abstract void update (Tny.FolderChange change);
	}
	[CCode (cheader_filename = "tny.h")]
	public interface FolderStore {
		public abstract void add_observer (Tny.FolderStoreObserver observer);
		public abstract unowned Tny.Folder create_folder (string name) throws GLib.Error;
		public abstract void create_folder_async (string name, Tny.CreateFolderCallback callback, Tny.StatusCallback status_callback);
		public abstract void get_folders (Tny.List list, Tny.FolderStoreQuery query, bool refresh) throws GLib.Error;
		public abstract void get_folders_async (Tny.List list, Tny.FolderStoreQuery query, bool refresh, Tny.GetFoldersCallback callback, Tny.StatusCallback status_callback);
		public abstract void refresh_async (Tny.FolderStoreCallback callback, Tny.StatusCallback status_callback);
		public abstract void remove_folder (Tny.Folder folder) throws GLib.Error;
		public abstract void remove_observer (Tny.FolderStoreObserver observer);
	}
	[CCode (cheader_filename = "tny.h")]
	public interface FolderStoreObserver {
		public abstract void update (Tny.FolderStoreChange change);
	}
	[CCode (cheader_filename = "tny.h")]
	public interface Header : GLib.Object {
		public abstract string dup_bcc ();
		public abstract string dup_cc ();
		public abstract string dup_from ();
		public abstract string dup_message_id ();
		public abstract string dup_replyto ();
		public abstract string dup_subject ();
		public abstract string dup_to ();
		public abstract string dup_uid ();
		public abstract ulong get_date_received ();
		public abstract ulong get_date_sent ();
		public abstract Tny.HeaderFlags get_flags ();
		public abstract unowned Tny.Folder get_folder ();
		public abstract uint get_message_size ();
		public Tny.HeaderFlags get_priority ();
		public abstract void set_bcc (string bcc);
		public abstract void set_cc (string cc);
		public abstract void set_flag (Tny.HeaderFlags mask);
		public abstract void set_from (string from);
		public void set_priority (Tny.HeaderFlags priority);
		public abstract void set_replyto (string to);
		public abstract void set_subject (string subject);
		public abstract void set_to (string to);
		public abstract void unset_flag (Tny.HeaderFlags mask);
	}
	[CCode (cheader_filename = "tny.h")]
	public interface Iterator {
		public abstract void first ();
		public abstract unowned GLib.Object get_current ();
		public abstract unowned Tny.List get_list ();
		public abstract bool is_done ();
		public abstract void next ();
		public abstract void nth (uint nth);
		public abstract void prev ();
	}
	[CCode (cheader_filename = "tny.h")]
	public interface List {
		public abstract void append (GLib.Object item);
		public abstract unowned Tny.List copy ();
		public abstract unowned Tny.Iterator create_iterator ();
		public abstract void @foreach (GLib.Func func);
		public abstract uint get_length ();
		public abstract void prepend (GLib.Object item);
		public abstract void remove (GLib.Object item);
		public abstract void remove_matches (Tny.ListMatcher matcher, void* match_data);
	}
	[CCode (cheader_filename = "tny.h")]
	public interface Lockable {
		public abstract void @lock ();
		public abstract void unlock ();
	}
	[CCode (cheader_filename = "tny.h")]
	public interface MimePart {
		public abstract int add_part (Tny.MimePart part);
		public abstract int @construct (Tny.Stream stream, string mime_type, string transfer_encoding);
		public abstract bool content_type_is (string type);
		public abstract ssize_t decode_to_stream (Tny.Stream stream) throws GLib.Error;
		public abstract void decode_to_stream_async (Tny.Stream stream, Tny.MimePartCallback callback, Tny.StatusCallback status_callback);
		public abstract void del_part (Tny.MimePart part);
		public abstract unowned string get_content_id ();
		public abstract unowned string get_content_location ();
		public abstract unowned string get_content_type ();
		public abstract unowned Tny.Stream get_decoded_stream ();
		public abstract unowned string get_description ();
		public abstract unowned string get_filename ();
		public abstract void get_header_pairs (Tny.List list);
		public abstract void get_parts (Tny.List list);
		public abstract unowned Tny.Stream get_stream ();
		public abstract unowned string get_transfer_encoding ();
		public abstract bool is_attachment ();
		public abstract bool is_purged ();
		public abstract void set_content_id (string content_id);
		public abstract void set_content_location (string content_location);
		public abstract void set_content_type (string contenttype);
		public abstract void set_description (string description);
		public abstract void set_filename (string filename);
		public abstract void set_header_pair (string name, string value);
		public abstract void set_purged ();
		public abstract void set_transfer_encoding (string transfer_encoding);
		public abstract ssize_t write_to_stream (Tny.Stream stream) throws GLib.Error;
	}
	[CCode (cheader_filename = "tny.h")]
	public interface Msg : Tny.MimePart, GLib.Object {
		public abstract bool get_allow_external_images ();
		public abstract unowned Tny.Folder get_folder ();
		public abstract unowned Tny.Header get_header ();
		public abstract unowned string get_url_string ();
		public abstract void rewrite_cache ();
		public abstract void set_allow_external_images (bool allow);
		public abstract void uncache_attachments ();
	}
	[CCode (cheader_filename = "tny.h")]
	public interface MsgReceiveStrategy {
		public abstract unowned Tny.Msg perform_get_msg (Tny.Folder folder, Tny.Header header) throws GLib.Error;
	}
	[CCode (cheader_filename = "tny.h")]
	public interface MsgRemoveStrategy {
		public abstract void perform_remove (Tny.Folder folder, Tny.Header header) throws GLib.Error;
	}
	[CCode (cheader_filename = "tny.h")]
	public interface PasswordGetter : GLib.Object {
		public abstract void forget_password (string aid);
		public abstract unowned string get_password (string aid, string prompt, bool cancel);
	}
	[CCode (cheader_filename = "tny.h")]
	public interface Seekable {
		public abstract int64 seek (int64 offset, int policy);
		public abstract int set_bounds (int64 start, int64 end);
		public abstract int64 tell ();
	}
	[CCode (cheader_filename = "tny.h")]
	public interface SendQueue : GLib.Object {
		public abstract void add (Tny.Msg msg) throws GLib.Error;
		public abstract void add_async (Tny.Msg msg, Tny.SendQueueAddCallback callback, Tny.StatusCallback status_callback);
		public abstract void cancel (Tny.SendQueueCancelAction cancel_action) throws GLib.Error;
		public abstract unowned Tny.Folder get_outbox ();
		public abstract unowned Tny.Folder get_sentbox ();
		public signal void error_happened (Tny.Header header, Tny.Msg msg, void* err);
		public signal void msg_sending (Tny.Header header, Tny.Msg msg, uint nth, uint total);
		public signal void msg_sent (Tny.Header header, Tny.Msg msg, uint nth, uint total);
		public signal void queue_start ();
		public signal void queue_stop ();
	}
	[CCode (cheader_filename = "tny.h")]
	public interface StoreAccount : Tny.Account, Tny.FolderStore, GLib.Object {
		public abstract void delete_cache ();
		public abstract unowned Tny.Folder find_folder (string url_string) throws GLib.Error;
		public abstract void subscribe (Tny.Folder folder);
		public abstract void unsubscribe (Tny.Folder folder);
		public signal void subscription_changed (Tny.Folder folder);
	}
	[CCode (cheader_filename = "tny.h")]
	public interface Stream {
		public abstract int close ();
		public abstract int flush ();
		public abstract bool is_eos ();
		public abstract ssize_t read (string buffer, size_t n);
		public abstract int reset ();
		public abstract ssize_t write (string buffer, size_t n);
		public abstract ssize_t write_to_stream (Tny.Stream output);
	}
	[CCode (cheader_filename = "tny.h")]
	public interface StreamCache {
		public abstract int64 get_max_size ();
		public abstract unowned Tny.Stream get_stream (string id, Tny.StreamCacheOpenStreamFetcher fetcher, void* userdata);
		public abstract void remove (Tny.StreamCacheRemoveFilter filter, void* userdata);
		public abstract void set_max_size (int64 max_size);
	}
	[CCode (cheader_filename = "tny.h")]
	public interface TransportAccount : Tny.Account, GLib.Object {
		public abstract void send (Tny.Msg msg) throws GLib.Error;
	}
	[CCode (cprefix = "TNY_ACCOUNT_", cheader_filename = "tny.h")]
	public enum AccountSignal {
		CONNECTION_STATUS_CHANGED,
		CHANGED,
		LAST_SIGNAL
	}
	[CCode (cprefix = "TNY_ACCOUNT_STORE_", has_type_id = "0", cheader_filename = "tny.h")]
	public enum AccountStoreSignal {
		CONNECTING_STARTED,
		LAST_SIGNAL
	}
	[CCode (cprefix = "TNY_ACCOUNT_TYPE_", cheader_filename = "tny.h")]
	public enum AccountType {
		STORE,
		TRANSPORT
	}
	[CCode (cprefix = "TNY_ALERT_TYPE_", cheader_filename = "tny.h")]
	public enum AlertType {
		INFO,
		WARNING,
		ERROR
	}
	[CCode (cprefix = "TNY_CONNECTION_STATUS_", cheader_filename = "tny.h")]
	public enum ConnectionStatus {
		DISCONNECTED,
		DISCONNECTED_BROKEN,
		CONNECTED_BROKEN,
		CONNECTED,
		RECONNECTING,
		INIT
	}
	[CCode (cprefix = "TNY_", has_type_id = "0", cheader_filename = "tny.h")]
	public enum Error {
		NO_ERROR,
		SYSTEM_ERROR_UNKNOWN,
		SYSTEM_ERROR_MEMORY,
		SYSTEM_ERROR_CANCEL,
		IO_ERROR_WRITE,
		IO_ERROR_READ,
		SERVICE_ERROR_UNKNOWN,
		SERVICE_ERROR_AUTHENTICATE,
		SERVICE_ERROR_CONNECT,
		SERVICE_ERROR_UNAVAILABLE,
		SERVICE_ERROR_LOST_CONNECTION,
		SERVICE_ERROR_CERTIFICATE,
		SERVICE_ERROR_FOLDER_CREATE,
		SERVICE_ERROR_FOLDER_REMOVE,
		SERVICE_ERROR_FOLDER_RENAME,
		SERVICE_ERROR_FOLDER_IS_UNKNOWN,
		SERVICE_ERROR_PROTOCOL,
		SERVICE_ERROR_UNSUPPORTED,
		SERVICE_ERROR_NO_SUCH_MESSAGE,
		SERVICE_ERROR_MESSAGE_NOT_AVAILABLE,
		SERVICE_ERROR_STATE,
		SERVICE_ERROR_ADD_MSG,
		SERVICE_ERROR_REMOVE_MSG,
		SERVICE_ERROR_GET_MSG,
		SERVICE_ERROR_SYNC,
		SERVICE_ERROR_REFRESH,
		SERVICE_ERROR_COPY,
		SERVICE_ERROR_TRANSFER,
		SERVICE_ERROR_GET_FOLDERS,
		SERVICE_ERROR_SEND,
		MIME_ERROR_STATE,
		MIME_ERROR_MALFORMED
	}
	[CCode (cprefix = "TNY_FOLDER_CAPS_", cheader_filename = "tny.h")]
	[Flags]
	public enum FolderCaps {
		WRITABLE,
		PUSHEMAIL
	}
	[CCode (cprefix = "TNY_FOLDER_CHANGE_CHANGED_", cheader_filename = "tny.h")]
	[Flags]
	public enum FolderChangeChanged {
		ALL_COUNT,
		UNREAD_COUNT,
		ADDED_HEADERS,
		EXPUNGED_HEADERS,
		FOLDER_RENAME,
		MSG_RECEIVED
	}
	[CCode (cprefix = "TNY_FOLDER_", cheader_filename = "tny.h")]
	public enum FolderSignal {
		FOLDER_INSERTED,
		FOLDERS_RELOADED,
		LAST_SIGNAL
	}
	[CCode (cprefix = "TNY_FOLDER_STORE_CHANGE_CHANGED_", cheader_filename = "tny.h")]
	[Flags]
	public enum FolderStoreChangeChanged {
		CREATED_FOLDERS,
		REMOVED_FOLDERS
	}
	[CCode (cprefix = "TNY_FOLDER_STORE_QUERY_OPTION_", cheader_filename = "tny.h")]
	[Flags]
	public enum FolderStoreQueryOption {
		SUBSCRIBED,
		UNSUBSCRIBED,
		MATCH_ON_NAME,
		MATCH_ON_ID,
		PATTERN_IS_CASE_INSENSITIVE,
		PATTERN_IS_REGEX
	}
	[CCode (cprefix = "TNY_FOLDER_TYPE_", cheader_filename = "tny.h")]
	public enum FolderType {
		UNKNOWN,
		NORMAL,
		INBOX,
		OUTBOX,
		TRASH,
		JUNK,
		SENT,
		ROOT,
		NOTES,
		DRAFTS,
		CONTACTS,
		CALENDAR,
		ARCHIVE,
		MERGE
	}
	[CCode (cprefix = "TNY_ACCOUNT_STORE_", cheader_filename = "tny.h")]
	public enum GetAccountsRequestType {
		TRANSPORT_ACCOUNTS,
		STORE_ACCOUNTS,
		BOTH
	}
	[CCode (cprefix = "TNY_HEADER_FLAG_", cheader_filename = "tny.h")]
	[Flags]
	public enum HeaderFlags {
		ANSWERED,
		DELETED,
		DRAFT,
		FLAGGED,
		SEEN,
		ATTACHMENTS,
		CACHED,
		PARTIAL,
		EXPUNGED,
		HIGH_PRIORITY,
		NORMAL_PRIORITY,
		LOW_PRIORITY,
		SUSPENDED
	}
	[CCode (cprefix = "TNY_SEND_QUEUE_CANCEL_ACTION_", has_type_id = "0", cheader_filename = "tny.h")]
	public enum SendQueueCancelAction {
		SUSPEND,
		REMOVE
	}
	[CCode (cprefix = "TNY_", cheader_filename = "tny.h")]
	public enum StatusCode {
		FOLDER_STATUS_CODE_REFRESH,
		FOLDER_STATUS_CODE_GET_MSG,
		GET_MSG_QUEUE_STATUS_GET_MSG,
		FOLDER_STATUS_CODE_XFER_MSGS,
		FOLDER_STATUS_CODE_COPY_FOLDER,
		GET_SUPPORTED_SECURE_AUTH_STATUS_GET_SECURE_AUTH,
		FOLDER_STATUS_CODE_SYNC
	}
	[CCode (cprefix = "TNY_", cheader_filename = "tny.h")]
	public enum StatusDomain {
		FOLDER_STATUS,
		GET_MSG_QUEUE_STATUS,
		GET_SUPPORTED_SECURE_AUTH_STATUS
	}
	[CCode (cheader_filename = "tny.h")]
	public delegate void CopyFolderCallback (Tny.Folder _self, bool cancelled, Tny.FolderStore into, Tny.Folder new_folder, GLib.Error err);
	[CCode (cheader_filename = "tny.h")]
	public delegate void CreateFolderCallback (Tny.FolderStore _self, bool cancelled, Tny.Folder new_folder, GLib.Error err);
	[CCode (cheader_filename = "tny.h")]
	public delegate void FolderCallback (Tny.Folder _self, bool cancelled, GLib.Error err);
	[CCode (cheader_filename = "tny.h")]
	public delegate void FolderStoreCallback (Tny.FolderStore _self, bool cancelled, GLib.Error err);
	[CCode (cheader_filename = "tny.h", has_target = false)]
	public delegate void ForgetPassFunc (Tny.Account _self);
	[CCode (cheader_filename = "tny.h")]
	public delegate void GetFoldersCallback (Tny.FolderStore _self, bool cancelled, Tny.List list, GLib.Error err);
	[CCode (cheader_filename = "tny.h")]
	public delegate void GetHeadersCallback (Tny.Folder _self, bool cancelled, Tny.List headers, GLib.Error err);
	[CCode (cheader_filename = "tny.h")]
	public delegate void GetMsgCallback (Tny.Folder folder, bool cancelled, Tny.Msg msg, GLib.Error err);
	[CCode (cheader_filename = "tny.h", has_target = false)]
	public delegate unowned string GetPassFunc (Tny.Account _self, string prompt, bool cancel);
	[CCode (cheader_filename = "tny.h", has_target = false)]
	public delegate bool ListMatcher (Tny.List list, GLib.Object item, void* match_data);
	[CCode (cheader_filename = "tny.h")]
	public delegate void MimePartCallback (Tny.MimePart _self, bool cancelled, Tny.Stream stream, GLib.Error err);
	[CCode (cheader_filename = "tny.h")]
	public delegate void SendQueueAddCallback (Tny.SendQueue _self, bool cancelled, Tny.Msg msg, GLib.Error err);
	[CCode (cheader_filename = "tny.h")]
	public delegate void StatusCallback (GLib.Object _self, Tny.Status status);
	[CCode (cheader_filename = "tny.h", has_target = false)]
	public delegate unowned Tny.Stream StreamCacheOpenStreamFetcher (Tny.StreamCache _self, int64 expected_size, void* userdata);
	[CCode (cheader_filename = "tny.h", has_target = false)]
	public delegate bool StreamCacheRemoveFilter (Tny.StreamCache _self, string id, void* userdata);
	[CCode (cheader_filename = "tny.h")]
	public delegate void TransferMsgsCallback (Tny.Folder folder, bool cancelled, GLib.Error err);
	[CCode (cheader_filename = "tny.h")]
	public const int HEADER_FLAG_PRIORITY_MASK;
	[CCode (cheader_filename = "tny.h")]
	public const int PRIORITY_LOWER_THAN_GTK_REDRAWS;
	[CCode (cheader_filename = "tny.h")]
	public static void clear_status (out unowned Tny.Status status);
	[CCode (cheader_filename = "tny.h")]
	public static int error_get_code (GLib.Error err);
	[CCode (cheader_filename = "tny.h")]
	public static unowned string error_get_message (GLib.Error err);
	[CCode (cheader_filename = "tny.h")]
	public static GLib.Quark get_error_quark ();
	[CCode (cheader_filename = "tny.h")]
	public static void marshal_VOID__OBJECT_OBJECT_INT_INT (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "tny.h")]
	public static void marshal_VOID__OBJECT_OBJECT_POINTER (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "tny.h")]
	public static void set_status (out unowned Tny.Status status, GLib.Quark domain, int code, uint position, uint of_total, string format);
}
