/*  tilp - link program for TI calculators
 *  Copyright (C) 1999, 2000  Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
  This unit contains functions for managing TIGraphLink variable format
  and some other stuffs (saving).
  This unit is built as an overlayer of the ti_files.c unit.
*/

#include "hfiles.h"
#include "tiffep.h"

/* !!!General comment!!! */
/*
  Save the content of the specified variable in the type 'TYPE' 
  as specified by 'tiffep_save_var_content_as_TYPE'.
  - fi [in]: the TiffepFileInfo structure of a previously saveed file
  (by a call to tiffep_save_file_content).
  - v [out]: an internally allocated structure which contain an image
  of the variable to handle. Can be modified in order to be saved later.
  - int [out]: 0 if success, an error code otherwise.
*/

TIEXPORT
int tiffep_save_var_content_as_number(TiffepVarInfo *vi, VarNum *v)
{
  return 0;
}

TIEXPORT
int tiffep_save_var_content_as_expression(TiffepVarInfo *vi, VarExpr *v)
{
  return 0;
}

TIEXPORT
int tiffep_save_var_content_as_list(TiffepVarInfo *vi, VarList *v)
{
  return 0;
}

TIEXPORT
int tiffep_save_var_content_as_matrix(TiffepVarInfo *vi, VarMatrix *v)
{
  return 0;
}

TIEXPORT
int tiffep_save_var_content_as_data(TiffepVarInfo *vi, VarData *v)
{
  return 0;
}

/*
TIEXPORT
int tiffep_save_var_content_as_text(TiffepVarInfo *vi, VarText *v)
{
  return 0;
}
*/

TIEXPORT
int tiffep_save_var_content_as_string(TiffepVarInfo *vi, VarString *vs)
{
  byte *var_data2, *var_data = NULL;
  gint var_size = 0;
  gint j;
  /* vi = FI_VARINFO(fi) */

  var_data = (byte *)VI_CONTENT(vi);
  switch(vs->type)
    {
    case TYPE_STRING:
      fprintf(stdout, "Size of string: %i\n", strlen(vs->str));
      for(j=0; j<strlen(vs->str); j++)
	{
	  fprintf(stdout, "0x%02x ", vs->str[j]);
	}
      fprintf(stdout, "\n");

      switch(VI_CALCTYPE(vi))
	{ // HH LL 00 <..string..> (00) 2D
	case TYPE_TI92P:
	case TYPE_TI92:
	case TYPE_TI89:
	  VI_SIZE(vi) = strlen(vs->str)+5;
	  var_size = VI_SIZE(vi);
	  fprintf(stdout, "Var size: 0x%02x\n", var_size);
	  var_data=(byte *)g_realloc(var_data , var_size);
	  var_data[0] = MSB(var_size-2);
	  var_data[1] = LSB(var_size-2);
	  var_data[2] = 0x00;
	  var_data2 = var_data;
	  for(j=0; j<3; j++) var_data2++;
	  strcpy(var_data2, vs->str);
	  var_data[var_size-1] = 0x2D;

	  fprintf(stdout, "Formatting:\n");
	  for(j=0; j<var_size; j++)
	    {
	      fprintf(stdout, "0x%02x ", var_data[j]);
	    }
	  fprintf(stdout, "\n");
	  break;
	case TYPE_TI86:
	case TYPE_TI85:
	case TYPE_TI83P:
	case TYPE_TI83:
	case TYPE_TI82:
	  vs->str = g_strdup(var_data + 0x02); // ??
	  break;
	}
      break;
    case TYPE_TEXT:
      fprintf(stdout, "Size of string: %i\n", strlen(vs->str));
      for(j=0; j<strlen(vs->str); j++)
	{
	  fprintf(stdout, "0x%02x ", vs->str[j]);
	}
      fprintf(stdout, "\n");
      
      switch(VI_CALCTYPE(vi))
	{ // HH LL CH CL 20 <..text..> (00) 2D
	case TYPE_TI92P:
	case TYPE_TI92:
	case TYPE_TI89:
	  VI_SIZE(vi) = strlen(vs->str)+7;
	  var_size = VI_SIZE(vi);
	  fprintf(stdout, "Var size: 0x%02x\n", var_size);
	  var_data=(byte *)g_realloc(var_data , var_size);
	  var_data[0] = MSB(var_size-2);
	  var_data[1] = LSB(var_size-2);
	  var_data[2] = MSB(vs->curs_pos);
	  var_data[3] = LSB(vs->curs_pos);
	  var_data[4] = 0x20;
	  var_data2 = var_data;
	  for(j=0; j<5; j++) var_data2++;
	  strcpy(var_data2, vs->str);
	  var_data[var_size-1] = 0xE0;

	  fprintf(stdout, "Formatting:\n");
	  for(j=0; j<var_size; j++)
	    {
	      fprintf(stdout, "0x%02x ", var_data[j]);
	    }
	  fprintf(stdout, "\n");
	  break;
	case TYPE_TI86:
	case TYPE_TI85:
	case TYPE_TI83P:
	case TYPE_TI83:
	case TYPE_TI82:
	  vs->str = g_strdup(var_data + 0x03); // ??
	  break;
	}
      break;
    default:
       return ERR_INVALID_TYPE;
       break;
    }

  return 0;
}

TIEXPORT
int tiffep_save_var_content_as_gdb(TiffepVarInfo *vi, VarGdb *v)
{
  return 0;
}

TIEXPORT
int tiffep_save_var_content_as_figure(TiffepVarInfo *vi, VarFigure *v)
{
  return 0;
}

TIEXPORT
int tiffep_save_var_content_as_picture(TiffepVarInfo *vi, VarPict *v)
{
  return 0;
}

TIEXPORT
int tiffep_save_var_content_as_program(TiffepVarInfo *vi, VarPrgm *v)
{
  return 0;
}

TIEXPORT
int tiffep_save_var_content_as_function(TiffepVarInfo *vi, VarFnct *v)
{
  return 0;
}

TIEXPORT
int tiffep_save_var_content_as_macro(TiffepVarInfo *vi, VarMacro *v)
{
  return 0;
}

TIEXPORT
int tiffep_save_var_content_as_backup(TiffepVarInfo *vi, VarBackup *v)
{
  return 0;
}
