/*  tiffep - Ti File Format Engine & Proxy
 *  Copyright (C) 2000-2001  Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
  This unit is used to manage error codes and error messages.
*/

#include <stdio.h>
#include <string.h>

#include "intl.h"

#include "errcodes.h"
#include "hfiles.h"
#include "tiffep.h"


/* 
   This function put in err_msg the error message corresponding to the 
   error code.
   If the error code has been handled, the function returns 0 else it 
   propagates the error code by returning it.
   - err_num [in]: the error code
   - error_msg [out]: the corresponding error message 
   - int [out]: 0 if successful, the err_num value else
*/
TIEXPORT
int tiffep_get_error(int err_num, char *error_msg)
{
  switch(err_num)
    {
    case ERR_NONE:
      break;
    case ERR_IPC_KEY:
      strcpy(error_msg, _("Unable to get an IPC key (Linux)."));
      break;
    case ERR_SHM_GET:
      strcpy(error_msg, _("Unable to get a segment (Linux)."));
      break;
    case ERR_SHM_ATT:
      strcpy(error_msg, _("Unable to attach a segment (Linux)."));
      break;
    case ERR_SHM_DTCH:
      strcpy(error_msg, _("Unable to detach a segment (Linux)."));
      break;
    case ERR_SHM_RMID:
      strcpy(error_msg, _("Unable to remove a segment (Linux)."));
      break;
    case ERR_CREATE_FILEMAP:
      strcpy(error_msg, _("Unable to create a file-mapping (Win32)."));
      break;
    case ERR_MAP_FILE:
      strcpy(error_msg, _("Unable to map the file (Win32)."));
      break;
    case ERR_UNMAP_FILE:
      strcpy(error_msg, _("Unable to unmap the file (Win32)."));
      break;
    case ERR_SCK_SOCKET:
      strcpy(error_msg, _("Unable to create a socket."));
      break;
    case ERR_SCK_BIND:
      strcpy(error_msg, _("Unable to bind a socket."));
      break;
    case ERR_SCK_LISTEN:
      strcpy(error_msg, _("Unable to listen a socket."));
      break;
    case ERR_SCK_ACCEPT:
      strcpy(error_msg, _("Unable to accept the socket connection."));
      break;
    case ERR_SCK_CONNECT:
      strcpy(error_msg, _("Unable to connect on the socket."));
      break;
    case ERR_SCK_SEND:
      strcpy(error_msg, _("Unable to send data through socket."));
      break;
    case ERR_SCK_RECEIVE:
      strcpy(error_msg, _("Unable to receive data from socket."));
      break;
    case ERR_FILE_OPEN:
      strcpy(error_msg, _("Unable to open a file."));
      break;
    case ERR_INVALID_FILE:
      strcpy(error_msg, _("Invalid TI file."));
      break;
    case ERR_PARSE_FILE:
      strcpy(error_msg, _("Error in the registry file."));
      break;
    case ERR_NOT_FOUND:
      strcpy(error_msg, _("Plugin not found."));
      break;
    case ERR_CMD_INVALID:
      strcpy(error_msg, _("Invalid or unexpected command."));
      break;
    case ERR_INVALID_TYPE:
      strcpy(error_msg, _("Invalid type."));
      break;
    case ERR_PLG_NOT_FOUND:
      strcpy(error_msg, _("Unable to find a plugin in the registry."));
      break;

    default:
      strcpy(error_msg, "Error code not found in the list.\nThis is a bug. Please report it.\n");
      return err_num;
      break;
  }
  
  return 0;
}
