/*  tilp - link program for TI calculators
 *  Copyright (C) 1999, 2000  Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "hfiles.h"
#include "tiffep.h"
#include "calc_defs.h"


/******************************/
/* Common types (abstraction) */
/******************************/

gint TI89_TYPES_TO_COMMON_TYPES[TI89_MAXTYPES] =
{ 
  TYPE_EXPRESSION, TYPE_NONE, TYPE_NONE, TYPE_NONE, 
  TYPE_LIST, TYPE_NONE, TYPE_MATRIX, TYPE_NONE, 
  TYPE_NONE, TYPE_NONE, TYPE_DATA, TYPE_TEXT, 
  TYPE_STRING, TYPE_GDB, TYPE_FIGURE, TYPE_NONE,
  TYPE_PICTURE, TYPE_NONE, TYPE_PROGRAM, TYPE_FUNCTION, 
  TYPE_MACRO, TYPE_NONE, TYPE_NONE, TYPE_NONE,
  TYPE_NONE, TYPE_NONE, TYPE_NONE, TYPE_NONE, 
  TYPE_NONE, TYPE_BACKUP, TYPE_NONE, TYPE_DIRECTORY,
  TYPE_NONE, TYPE_ASM, TYPE_NONE, TYPE_NONE,
  TYPE_NONE, TYPE_NONE, TYPE_NONE, TYPE_NONE,
  TYPE_NONE, TYPE_NONE, TYPE_NONE, TYPE_NONE,
  TYPE_NONE, TYPE_NONE, TYPE_NONE, TYPE_NONE
};

gint COMMON_TYPES_TO_TI89_TYPES[COMMON_MAXTYPES] =
{
  TI89_EXPR, TI89_LIST, TI89_MAT, TI89_DATA,
  TI89_TEXT, TI89_STR, TI89_GDB, TI89_FIG,
  TI89_PIC, TI89_PRGM, TI89_FUNC, TI89_MAC, 
  TI89_BKUP, TI89_DIR, 0, 0,
  TI89_ASM, 0, 0, 0,
  0, 0, 0, 0,
  0, 0, 0, 0,
  0, 0, 0, 0,
  0, 0, 0, 0,
  0, 0, 0, 0,
  0, 0, 0, 0,
  0, 0, 0, 0
};

gint TI92_TYPES_TO_COMMON_TYPES[TI92_MAXTYPES] =
{ 
  TYPE_EXPRESSION, TYPE_NONE, TYPE_NONE, TYPE_NONE, 
  TYPE_LIST, TYPE_NONE, TYPE_MATRIX, TYPE_NONE, 
  TYPE_NONE, TYPE_NONE, TYPE_DATA, TYPE_TEXT, 
  TYPE_STRING, TYPE_GDB, TYPE_FIGURE, TYPE_NONE,
  TYPE_PICTURE, TYPE_NONE, TYPE_PROGRAM, TYPE_FUNCTION, 
  TYPE_MACRO, TYPE_NONE, TYPE_NONE, TYPE_NONE,
  TYPE_NONE, TYPE_NONE, TYPE_NONE, TYPE_NONE, 
  TYPE_NONE, TYPE_BACKUP, TYPE_NONE, TYPE_DIRECTORY,
  TYPE_NONE, TYPE_NONE, TYPE_NONE, TYPE_NONE,
  TYPE_NONE, TYPE_NONE, TYPE_NONE, TYPE_NONE,
  TYPE_NONE, TYPE_NONE, TYPE_NONE, TYPE_NONE,
  TYPE_NONE, TYPE_NONE, TYPE_NONE, TYPE_NONE
};

gint COMMON_TYPES_TO_TI92_TYPES[COMMON_MAXTYPES] =
{
  TI92_EXPR, TI92_LIST, TI92_MAT, TI92_DATA,
  TI92_TEXT, TI92_STR, TI92_GDB, TI92_FIG,
  TI92_PIC, TI92_PRGM, TI92_FUNC, TI92_MAC, 
  TI92_BKUP, TI92_DIR, 0, 0,
  0, 0, 0, 0,
  0, 0, 0, 0,
  0, 0, 0, 0,
  0, 0, 0, 0,
  0, 0, 0, 0,
  0, 0, 0, 0,
  0, 0, 0, 0,
  0, 0, 0, 0
};

gint TI92P_TYPES_TO_COMMON_TYPES[TI92P_MAXTYPES] =
{ 
  TYPE_EXPRESSION, TYPE_NONE, TYPE_NONE, TYPE_NONE, 
  TYPE_LIST, TYPE_NONE, TYPE_MATRIX, TYPE_NONE, 
  TYPE_NONE, TYPE_NONE, TYPE_DATA, TYPE_TEXT, 
  TYPE_STRING, TYPE_GDB, TYPE_FIGURE, TYPE_NONE,
  TYPE_PICTURE, TYPE_NONE, TYPE_PROGRAM, TYPE_FUNCTION, 
  TYPE_MACRO, TYPE_NONE, TYPE_NONE, TYPE_NONE,
  TYPE_NONE, TYPE_NONE, TYPE_NONE, TYPE_NONE, 
  TYPE_NONE, TYPE_BACKUP, TYPE_NONE, TYPE_DIRECTORY,
  TYPE_NONE, TYPE_ASM, TYPE_NONE, TYPE_NONE,
  TYPE_NONE, TYPE_NONE, TYPE_NONE, TYPE_NONE,
  TYPE_NONE, TYPE_NONE, TYPE_NONE, TYPE_NONE,
  TYPE_NONE, TYPE_NONE, TYPE_NONE, TYPE_NONE
};

gint COMMON_TYPES_TO_TI92P_TYPES[COMMON_MAXTYPES] =
{
  TI92p_EXPR, TI92p_LIST, TI92p_MAT, TI92p_DATA,
  TI92p_TEXT, TI92p_STR, TI92p_GDB, TI92p_FIG,
  TI92p_PIC, TI92p_PRGM, TI92p_FUNC, TI92p_MAC, 
  TI92p_BKUP, TI92p_DIR, 0, 0,
  TI92p_ASM, 0, 0, 0,
  0, 0, 0, 0,
  0, 0, 0, 0,
  0, 0, 0, 0,
  0, 0, 0, 0,
  0, 0, 0, 0,
  0, 0, 0, 0,
  0, 0, 0, 0
};

gint TI82_TYPES_TO_COMMON_TYPES[TI82_MAXTYPES] =
{ 
  TYPE_EXPRESSION, TYPE_LIST, TYPE_MATRIX, TYPE_EXPRESSION, 
  TYPE_NONE, TYPE_PROGRAM, TYPE_PROGRAM, TYPE_PICTURE, 
  TYPE_GDB , TYPE_NONE, TYPE_NONE, TYPE_NONE, 
  TYPE_NONE, TYPE_NONE, TYPE_NONE, TYPE_BACKUP,
  TYPE_NONE, TYPE_NONE, TYPE_NONE, TYPE_NONE, 
  TYPE_NONE, TYPE_NONE, TYPE_NONE, TYPE_NONE,
  TYPE_NONE, TYPE_NONE, TYPE_NONE, TYPE_NONE, 
  TYPE_NONE, TYPE_NONE, TYPE_NONE, TYPE_NONE,
  TYPE_NONE, TYPE_NONE, TYPE_NONE, TYPE_NONE,
  TYPE_NONE, TYPE_NONE, TYPE_NONE, TYPE_NONE,
  TYPE_NONE, TYPE_NONE, TYPE_NONE, TYPE_NONE,
  TYPE_NONE, TYPE_NONE, TYPE_NONE, TYPE_NONE
};

gint COMMON_TYPES_TO_TI82_TYPES[COMMON_MAXTYPES] =
{
  TI82_REAL, TI92_LIST, TI92_MAT, TI92_DATA,
  TI92_TEXT, TI92_STR, TI92_GDB, TI92_FIG,
  TI92_PIC, TI92_PRGM, TI92_FUNC, TI92_MAC, 
  TI92_BKUP, 0, 0, 0,
  0, 0, 0, 0,
  0, 0, 0, 0,
  0, 0, 0, 0,
  0, 0, 0, 0,
  0, 0, 0, 0,
  0, 0, 0, 0,
  0, 0, 0, 0,
  0, 0, 0, 0
};


gint TIxx_TYPES_TO_COMMON_TYPES(gint type, gint calc_type)
{
  switch(calc_type)
    {
    case TYPE_TI82: return TI82_TYPES_TO_COMMON_TYPES[type]; break;
    case TYPE_TI89: return TI89_TYPES_TO_COMMON_TYPES[type]; break;
    case TYPE_TI92: return TI92_TYPES_TO_COMMON_TYPES[type]; break;
    case TYPE_TI92P: return TI92P_TYPES_TO_COMMON_TYPES[type]; break;
    default: return -1;
    }

  return -1;
}

gint COMMON_TYPES_TO_TIxx_TYPES(gint type, gint calc_type)
{
  switch(calc_type)
    {
    case TYPE_TI82: return COMMON_TYPES_TO_TI82_TYPES[type]; break;
    case TYPE_TI89: return COMMON_TYPES_TO_TI89_TYPES[type]; break;
    case TYPE_TI92: return COMMON_TYPES_TO_TI92_TYPES[type]; break;
    case TYPE_TI92P: return COMMON_TYPES_TO_TI92P_TYPES[type]; break;
    default: return -1;
    }

  return -1;
}

/****************/
/* Global types */
/****************/

const char GROUP_FILE_EXT[CALC_MAX][4]=
{  
  "XxX", "9Xg", "92g", "89g", "86g", "85g", "8xg", "83g", "82g", "73g"
};

const char BACKUP_FILE_EXT[CALC_MAX][4]=
{ 
  "XxX", "9xg", "92b", "89g", "86b", "85b", "8xb", "83b", "82b", "73b" 
};

const char FLASH_APP_FILE_EXT[CALC_MAX][4]=
{
  "XxX", "9xk", "???", "89k", "???", "???", "8xk", "???", "???", "???" 
};

const char FLASH_OS_FILE_EXT[CALC_MAX][4]=
{
  "XxX", "9xu", "???", "89u", "???", "???", "8xu", "???", "???", "???" 
};


/********************/
/* Calculator types */
/********************/

//#define TI82_MAXTYPES 16
const char *TI82_TYPES[TI82_MAXTYPES]=
{
  "REAL", "LIST", "MAT", "EQU", "??", "PRGM", "PPGM", "PIC",
  "GDB", "??", "??", "WDW", "ZSTO", "TAB", "LCD", "BACKUP",
  "??", "??", "??", "??", "??", "??", "??", "??",
  "??", "??", "??", "??", "??", "??", "??", "??",
  "??", "??", "??", "??", "??", "??", "??", "??",
  "??", "??", "??", "??", "??", "??", "??", "??"
};
const char *TI82_EXT[TI82_MAXTYPES]=
{
  "82n", "82l", "82m", "82y", "82?", "82p", "82p", "82i",
  "82d", "82?", "82?", "82w", "82z", "82t", "82?", "82b",
  "82?", "82?", "82?", "82?", "82?", "82?", "82?", "82?",
  "82?", "82?", "82?", "82?", "82?", "82?", "82?", "82?",
  "82?", "82?", "82?", "82?", "82?", "82?", "82?", "82?",
  "82?", "82?", "82?", "82?", "82?", "82?", "82?", "82?",
};

//#define TI83_MAXTYPES 16
const char *TI83_TYPES[TI83_MAXTYPES]=
{
  "REAL", "LIST", "MATRX", "EQU", "STRNG", "PRGM", "ASM", "PIC",
  "GDB", "??", "??", "??", "CPLX", "??", "??", "??",
  "??", "??", "??", "??", "??", "??", "??", "??",
  "??", "??", "??", "??", "??", "??", "??", "??",
  "??", "??", "??", "??", "??", "??", "??", "??",
  "??", "??", "??", "??", "??", "??", "??", "??"
};
const char *TI83_EXT[TI83_MAXTYPES]=
{
  "83n", "83l", "83m", "83y", "83s", "83p", "83p", "83i",
  "83d", "83?", "83?", "83?", "83c", "83?", "83?", "83?",
  "83?", "83?", "83?", "83?", "83?", "83?", "83?", "83?",
  "83?", "83?", "83?", "83?", "83?", "83?", "83?", "83?",
  "83?", "83?", "83?", "83?", "83?", "83?", "83?", "83?",
  "83?", "83?", "83?", "83?", "83?", "83?", "83?", "83?",
};


const char *TI83p_TYPES[TI83P_MAXTYPES]=
{
  "REAL", "LIST", "MATRX", "EQU", "STRNG", "PRGM", "APRGM", "PIC",
  "GDB", "??", "??", "??", "CPLX", "??", "??", "??",
  "??", "??", "??", "??", "??", "??", "??", "??",
  "??", "??", "??", "??", "??", "??", "??", "??",
  "??", "??", "??", "??", "APPL", "??", "??", "??",
  "??", "??", "??", "??", "??", "??", "??", "??"
};
const char *TI83p_EXT[TI83P_MAXTYPES]=
{
  "8xn", "8xl", "8xm", "8xy", "8xs", "8xp", "8xp", "8xi",
  "8xd", "8x?", "8x?", "8x?", "8xc", "8x?", "8x?", "8x?",
  "8x?", "8x?", "8x?", "8x?", "8x?", "8x?", "8x?", "8x?",
  "8x?", "8x?", "8x?", "8x?", "8x?", "8x?", "8x?", "8x?",
  "8x?", "8x?", "8x?", "8x?", "app", "8x?", "8x?", "8x?",
  "8x?", "8x?", "8x?", "8x?", "8x?", "8x?", "8x?", "8x?"
};


const char *TI85_TYPES[TI85_MAXTYPES]=
{
  "REAL", "CPLX", "VECTR", "CVECT", "LIST", "CLIST", "MATRX", "??",
  "CONS", "CCONS", "EQU", "??", "STRNG", "GDB", "GDB", "GDB",
  "GDB", "PIC", "PRGM", "RANGE", "SCRN", "DIR", "??", "WIND",
  "POLAR", "PARAM", "DIFEQ", "ZRCL", "??", "BACKUP", "??", "??",
  "??", "??", "??", "??", "??", "??", "??", "??",
  "??", "??", "EQU", "??", "??", "??", "??", "??"
};
const char *TI85_EXT[TI85_MAXTYPES]=
{
  "85n", "85c", "85v", "85v", "85l", "85l", "85m", "85?",
  "85k", "85k", "85e", "85?", "85s", "85d", "85d", "85d",
  "85d", "85i", "85p", "85r", "85?", "85g", "85?", "85w",
  "85r", "85r", "85r", "85?", "85?", "85b", "85?", "85?"
  "85?", "85?", "85?", "85?", "85?", "85?", "85?", "85?",
  "85?", "85?", "85e", "85?", "85?", "85?", "85?", "85?"
};


const char *TI86_TYPES[TI86_MAXTYPES]=
{
  "REAL", "CPLX", "VECTR", "CVECT", "LIST", "CLIST", "MATRX", "??",
  "CONS", "CCONS", "EQU", "??", "STRNG", "GDB", "GDB", "GDB",
  "GDB", "PIC", "PRGM", "RANGE", "SCRN", "DIR", "??", "WIND",
  "POLAR", "PARAM", "DIFEQ", "ZRCL", "??", "BACKUP", "??", "??",
  "??", "??", "??", "??", "??", "??", "??", "??",
  "??", "??", "EQU", "??", "??", "??", "??", "??"
};
const char *TI86_EXT[TI86_MAXTYPES]=
{
  "86n", "86c", "86v", "86v", "86l", "86l", "86m", "86?",
  "86k", "86k", "86e", "86?", "86s", "86d", "86d", "86d",
  "86d", "86i", "86p", "86r", "86?", "86g", "86?", "86w",
  "86r", "86r", "86r", "86?", "86?", "86b", "86?", "86?"
  "86?", "86?", "86?", "86?", "86?", "86?", "86?", "86?",
  "86?", "86?", "86e", "86?", "86?", "86?", "86?", "86?"
};


const char *TI89_TYPES[TI89_MAXTYPES]=
{
  "EXPR", "??", "??", "??", "LIST", "??", "MAT", "??",
  "UNKNOW", "??", "DATA", "TEXT", "STR", "GDB", "FIG", "??",
  "PIC", "??", "PRGM", "FUNC", "MAC", "??", "??", "??",
  "??", "??", "??", "??", "ZIP", "BACKUP", "??", "DIR",
  "??", "ASM", "IDLIST", "??", "FLASH", "??", "LOCKED", "ARCHIVED",
  "??", "??", "??", "??", "??", "??", "??", "??"
};
const char *TI89_EXT[TI89_MAXTYPES]=
{
  "89e", "89?", "89?", "89?", "89l", "89?", "89m", "89?",
  "89?", "89?", "89c", "89t", "89s", "89d", "89a", "89?",
  "89i", "89?", "89p", "89f", "89x", "89?", "89?", "89?",
  "89?", "89?", "89?", "89?", "89?", "89b", "89?", "89?",
  "89?", "89z", "89?", "89?", "89k", "89?", "89?", "89?",
  "89?", "89?", "89?", "89?", "89?", "89?", "89?", "89?"
};

//#define TI92_MAXTYPES 32
const char *TI92_TYPES[TI92_MAXTYPES]=
{
  "EXPR", "??", "??", "??", "LIST", "??", "MAT", "??",
  "UNKNOW", "??", "DATA", "TEXT", "STR", "GDB", "FIG", "??",
  "PIC", "??", "PRGM", "FUNC", "MAC", "??", "??", "??",
  "??", "??", "??", "??", "??", "BACKUP", "??", "DIR",
  "??", "??", "??", "??", "??", "??", "??", "??",
  "??", "??", "??", "??", "??", "??", "??", "??"
};
const char *TI92_EXT[TI92_MAXTYPES]=
{
  "92e", "92?", "92?", "92?", "92l", "92?", "92m", "92?",
  "92?", "92?", "92c", "92t", "92s", "92d", "92a", "92?",
  "92i", "92?", "92p", "92f", "92x", "92?", "92?", "92?",
  "92?", "92?", "92?", "92?", "92?", "92b", "92?", "92?",
  "92?", "92?", "92?", "92?", "92?", "92?", "92?", "92?",
  "92?", "92?", "92?", "92?", "92?", "92?", "92?", "92?"
};


const char *TI92p_TYPES[TI92P_MAXTYPES]=
{
  "EXPR", "??", "??", "??", "LIST", "??", "MAT", "??",
  "UNKNOW", "??", "DATA", "TEXT", "STR", "GDB", "FIG", "??",
  "PIC", "??", "PRGM", "FUNC", "MAC", "??", "??", "??",
  "??", "??", "??", "??", "ZIP", "BACKUP", "??", "DIR",
  "ASM", "??", "??", "??", "FLASH", "??", "LOCKED", "ARCHIVED",
  "??", "??", "??", "??", "??", "??", "??", "??"
};
const char *TI92p_EXT[TI92P_MAXTYPES]=
{
  "9xe", "9x?", "9x?", "9x?", "9xl", "9x?", "9xm", "9x?",
  "9x?", "9x?", "9xc", "9xt", "9xs", "9xd", "9xa", "9x?",
  "9xi", "9x?", "9xp", "9xf", "9xx", "9x?", "9x?", "9x?",
  "9x?", "9x?", "9x?", "9x?", "9x?", "9xb", "9x?", "9x?",
  "9xz", "9x?", "9x?", "9x?", "9xk", "9x?", "9x?", "9x?",
  "9x?", "9x?", "9x?", "9x?", "9x?", "9x?", "9x?", "9xy?"
};




