/*  tilp - link program for TI calculators
 *  Copyright (C) 1999, 2000  Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __TIFFEP_CALCDEFS__
#define __TIFFEP_CALCDEFS__

#include "tiffep.h"

/* 
   The different calculator types or file type
*/
#define TYPE_NONE  0
#define TYPE_TI92P 1
#define TYPE_TI92  2
#define TYPE_TI89  3
#define TYPE_TI86  4
#define TYPE_TI85  5
#define TYPE_TI83P 6
#define TYPE_TI83  7
#define TYPE_TI82  8
#define TYPE_TI73  9
/* Obsolete, for compatability */
/*
#define CALC_NONE TYPE_NONE
#define CALC_TI92P TYPE_TI92P
#define CALC_TI92  TYPE_TI92
#define CALC_TI89  TYPE_TI89
#define CALC_TI86  TYPE_TI86
#define CALC_TI85  TYPE_TI85
#define CALC_TI83P TYPE_TI83P
#define CALC_TI83  TYPE_TI83
#define CALC_TI82  TYPE_TI82
#define CALC_TI73  TYPE_TI73
*/

#define CALC_MAX 10
#define CALC_NUM (CALC_MAX - 1)
#define NCALCS   (CALC_MAX - 1)

/*
  Variable attributes
*/
#define ATTRB_NONE      0
#define ATTRB_LOCK      1
#define ATTRB_ARCHIVE   2
#define ATTRB_PROTECTED 3

/*
  Folder or variable: obsolete !
*/
#define IS_FOLDER   1
#define IS_VARIABLE 0

/*
  File type
*/
#define FILE_SINGLE 1
#define FILE_GROUP  2
#define FILE_FLASH  3
#define FILE_BACKUP 4

/*
  Common types
*/
#define TYPE_EXPRESSION 256
#define TYPE_LIST       257
#define TYPE_MATRIX     258
#define TYPE_DATA       259
#define TYPE_TEXT       260
#define TYPE_STRING     261
#define TYPE_GDB        262
#define TYPE_FIGURE     263
#define TYPE_PICTURE    264
#define TYPE_PROGRAM    265
#define TYPE_FUNCTION   266
#define TYPE_MACRO      267
#define TYPE_BACKUP     268
#define TYPE_DIRECTORY  269
#define TYPE_GROUP      270
#define TYPE_FLASH      271
#define TYPE_ASM        272

#endif




