/************************************************************************************
TerraLib - a library for developing GIS applications.
Copyright  2001-2004 INPE and Tecgraf/PUC-Rio.

This code is part of the TerraLib library.
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

You should have received a copy of the GNU Lesser General Public
License along with this library.

The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular purpose.
The library provided hereunder is on an "as is" basis, and the authors have no
obligation to provide maintenance, support, updates, enhancements, or modifications.
In no event shall INPE and Tecgraf / PUC-Rio be held liable to any party for direct,
indirect, special, incidental, or consequential damages arising out of the use
of this library and its documentation.
*************************************************************************************/

#ifndef  __TERRALIB_INTERNAL_QUERIER_DB_H
#define  __TERRALIB_INTERNAL_QUERIER_DB_H

#include "TeQuerierImpl.h"

class TeDatabasePortal;
class TeTimeInterval;
class TeTSEntry;


//! auxiliary functions to add geometries in the sto 
bool addGeometry(TeDatabasePortal* portal, TeGeomRep geomRep, TeSTInstance& sto, const string& geomTable = ""); 
bool addGeometry(TeDatabasePortal* portal, TeGeomRep geomRep, TeSTInstance& sto, const string& geomTable, 
					TeTimeInterval time, const string& initalTimeName, const string& finalTimeName);  


//! An abstract class to build STOs (Spatial Temporal Objects) from a TerraLib database 
class TeQuerierDB : public TeQuerierImpl
{
	protected:

		vector<TeDatabasePortal*>	portals_;		//! a portal to each geometry representation
		vector<TeRepresentation>	geomRepr_;		//! keep the geometry representation of each portal 
		TeTable						attrTable_;		//! internal information used to fill the stos
		bool						flagPortal_;	//! flag to control the portal 
				
		//! clear internal vectors
		void clearVectors(); 

		//! Return a where clause in SQL that represent the querier restrictions
		string sqlWhereRestrictions(TeRepresentation* rep=0);

		//! Build the sql from clause
		string sqlFrom(string geomTable="");
		
	public:
		
		//! Constructor
		TeQuerierDB(TeQuerierParams& params): TeQuerierImpl(params), flagPortal_(false) 
		{}
		
		//! Destructor 
		virtual ~TeQuerierDB();  
		
		//! Returns the pointer to the theme 
		TeTheme* theme() {	return params_.theme();	}

		//! Returns the pointer to the layer 
		TeLayer* layer() {	return  params_.theme()->layer(); }

		//! Returns the geometry representation of the theme
		TeGeomRep geometryRep() 
		{  return TeGeomRep(params_.theme()->layer()->geomRep()); }

		//! Loads the STOs
		virtual bool loadInstances(TeTSEntry* ent=0) = 0;  
		
		//! Returns each loaded STO
		virtual bool fetchInstance(TeSTInstance& stoi)= 0; 

		//! Empties querier instances
		void clear(); 

		
};


#endif
