//***********************************************************************
//      TerraLib is a GIS Classes and Functions Library that 
//      strongly explores Spatial Database Technologies 
//
//      Copyright  2002 INPE and Tecgraf/PUC-Rio. 
//
//      This library is free software; you can redistribute it 
//      and/or modify it under the terms of the GNU Lesser General 
//      Public License as published by the Free Software Foundation
//      version 2.1.(http://www.opensource.org/licenses/lgpl-license.php)
//
//      
//
//      Send questions or suggestions about the TerraLib Project 
//      to terralib@dpi.inpe.br .
//**************************************************************************//
/*! \file TeAssertions.h
    This file contains definitions for require and ensure macros.

	 The require and ensure macros implement
	 the pre-conditions and post-conditions
	 for each module.

	 The "invariant" macro verifies is an
	 invariant condition is true.

*/
#ifndef TeAssertions_H
#define TeAssertions_H
#include <assert.h>

#define require(statement)    assert(statement)
#define ensure(statement)     assert(statement)

#endif

