/************************************************************************************
TerraLib - a library for developing GIS applications.
Copyright  2001-2004 INPE and Tecgraf/PUC-Rio.

This code is part of the TerraLib library.
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

You should have received a copy of the GNU Lesser General Public
License along with this library.

The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular purpose.
The library provided hereunder is on an "as is" basis, and the authors have no
obligation to provide maintenance, support, updates, enhancements, or modifications.
In no event shall INPE and Tecgraf / PUC-Rio be held liable to any party for direct,
indirect, special, incidental, or consequential damages arising out of the use
of this library and its documentation.
*************************************************************************************/
#include "TeTheme.h"
#include "TeDatabase.h"


bool TeCreateThemeFromTheme(TeTheme* inTheme, const string& newThemeName, int selObj, TeTheme* newTheme)
{
	// if no source theme or not a name for the new theme
	if (!inTheme || newThemeName.empty())
		return false;

	// if there no pointer theme was passed create a new instance
	if (!newTheme)
		newTheme = new TeTheme();

	// builds a valid theme name
	TeDatabase* curDb = inTheme->layer()->database();
	string validThemeName = newThemeName;
	int i=1;
	while (curDb->themeExist(validThemeName))
	{
		validThemeName = newThemeName + "_" + Te2String(i);
		i++;
	}

	// create new theme with the same definitions of the input theme
	newTheme->id(0);
	newTheme->name(validThemeName);
	newTheme->layer(inTheme->layer());
	newTheme->setAttTables(inTheme->attrTables());
	curDb->viewMap()[inTheme->view()]->add(newTheme);
	newTheme->visibleRep(inTheme->visibleRep());

	// save its definition in the database
	if (!newTheme->save())
	{
		delete newTheme;
		newTheme = 0;
	}

	// this is a patch around TeTheme::save(). Auxiliary collection table is created
	// with field "unique_id" of type auto-number. It has to be string.
	TeAttribute at;
	at.rep_.name_ = "unique_id";
	at.rep_.type_ = TeSTRING;
	at.rep_.numChar_ = 100;
	at.rep_.isAutoNumber_ = false;
	at.rep_.isPrimaryKey_ = true;
	if (!curDb->alterTable(newTheme->collectionAuxTable(), at.rep_))
	{
		curDb->deleteTheme(newTheme->id());
		delete newTheme;
		return 0;
	}

	// if its a theme of raster data there's nothing else to be done
	if (inTheme->layer()->hasGeometry(TeRASTER))
		return false;

	// this SQL selects instances of objects according to input, so it uses te_collection_aux
	string inputInst;

	// this SQL selects objects according to input, so it uses te_collection
	string inputObj; 
	if(selObj == TeSelectedByPointing) // queried
	{
		inputObj = "(" + inTheme->collectionTable() + ".c_object_status = 2";
		inputObj += " OR " + inTheme->collectionTable() + ".c_object_status = 3)";
		inputInst = "(" + inTheme->collectionAuxTable() + ".grid_status = 2";
		inputInst += " OR " + inTheme->collectionAuxTable() + ".grid_status = 3)";
	}
	else if(selObj == 2) // pointed
	{
		inputObj = "(" + inTheme->collectionTable() + ".c_object_status = 1";
		inputObj += " OR " + inTheme->collectionTable() + ".c_object_status = 3)";
		inputInst = "(" + inTheme->collectionAuxTable() + ".grid_status = 1";
		inputInst += " OR " + inTheme->collectionAuxTable() + ".grid_status = 3)";
	}
	else if(selObj == 3) // not queried
	{
		inputObj = "(" + inTheme->collectionTable() + ".c_object_status <> 2";
		inputObj += " AND " + inTheme->collectionTable() + ".c_object_status <> 3)";
		inputInst = "(" + inTheme->collectionAuxTable() + ".grid_status <> 2";
		inputInst += " AND " + inTheme->collectionAuxTable() + ".grid_status <> 3)";
	}
	else if(selObj == 4) // not pointed
	{
		inputObj = "(" + inTheme->collectionTable() + ".c_object_status <> 1";
		inputObj += " AND " + inTheme->collectionTable() + ".c_object_status <> 3)";
		inputInst = "(" + inTheme->collectionAuxTable() + ".grid_status <> 1";
		inputInst += " AND " + inTheme->collectionAuxTable() + ".grid_status <> 3)";
	}
	else if(selObj == 5) // pointed and queried
	{
		inputObj = "(" + inTheme->collectionTable() + ".c_object_status = 3)";
		inputInst = "(" + inTheme->collectionAuxTable() + ".grid_status = 3)";
	}
	else if(selObj == 6) // pointed or queried
	{
		inputObj = "(" + inTheme->collectionTable() + ".c_object_status = 2";
		inputObj += " OR " + inTheme->collectionTable() + ".c_object_status = 1";
		inputObj += " OR " + inTheme->collectionTable() + ".c_object_status = 3)";
		inputInst = "(" + inTheme->collectionAuxTable() + ".grid_status = 2";
		inputInst += " OR " + inTheme->collectionAuxTable() + ".grid_status = 1";
		inputInst += " OR " + inTheme->collectionAuxTable() + ".grid_status = 3)";
	}

	// fills collection table from the selection requested
	string sql = "INSERT INTO " + newTheme->collectionTable() + " ( ";
	sql += " c_object_id, c_legend_id, label_x, label_y, c_legend_own, c_object_status ) ";
	sql += " SELECT * FROM " + inTheme->collectionTable() + " WHERE " + inputObj;
	if (!curDb->execute(sql))
	{
		curDb->deleteTheme(newTheme->id());
		return false;
	}
	// sets theme objects settings to default
	sql = "UPDATE " + newTheme->collectionTable() + " SET c_legend_id = 0";
	if (!curDb->execute(sql))
	{
		curDb->deleteTheme(newTheme->id());
		return false;
	}
	sql = "UPDATE " + newTheme->collectionTable() + " SET c_object_status = 0";
	if (!curDb->execute(sql))
	{
		curDb->deleteTheme(newTheme->id());
		return false;
	}

	// fills auxiliary collection table from the selection requested
	sql = "INSERT INTO " + newTheme->collectionAuxTable() + " ( ";
	sql += " object_id, unique_id, grid_status ) ";
	sql += " SELECT * FROM " + inTheme->collectionAuxTable() + " WHERE " + inputInst;
	if (!curDb->execute(sql))
	{
		curDb->deleteTheme(newTheme->id());
		return false;
	}
	sql = "UPDATE " + newTheme->collectionAuxTable() + " SET grid_status = 0";
	if (!curDb->execute(sql))
	{
		curDb->deleteTheme(newTheme->id());
		return false;
	}
	return true;
}


