/************************************************************************************
TerraLib - a library for developing GIS applications.
Copyright  2001-2004 INPE and Tecgraf/PUC-Rio.

This code is part of the TerraLib library.
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

You should have received a copy of the GNU Lesser General Public
License along with this library.

The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular purpose.
The library provided hereunder is on an "as is" basis, and the authors have no
obligation to provide maintenance, support, updates, enhancements, or modifications.
In no event shall INPE and Tecgraf / PUC-Rio be held liable to any party for direct,
indirect, special, incidental, or consequential damages arising out of the use
of this library and its documentation.
*************************************************************************************/
#include "TeColorUtils.h"

bool getColors(TeDatabase* db, vector<string>& ramps, int nc, bool asc, vector<TeColor> &colors)
{
	if (!db)
		return false;

	TeDatabasePortal* portal = db->getPortal();
	if (!portal)
		return false;

	if (ramps.empty())
		ramps.push_back("RED");

	vector<TeColor> allColors;

	unsigned int i;
	for (i=0; i<ramps.size(); i++)
	{
		string	query = "SELECT red, green, blue FROM te_color_scheme";
		if (asc)
			query = query + " WHERE ramp_name = '" + ramps[i] + "' ORDER BY color_order ASC";
		else
			query = query + " WHERE ramp_name = '" + ramps[i] + "' ORDER BY color_order DESC";
	
		TeColor color;
		if (portal->query(query))
		{
			while(portal->fetchRow())
			{
				color.name_ = ramps[i];
				color.red_ = portal->getInt(0);
				color.green_ = portal->getInt(1);
				color.blue_ = portal->getInt(2);
				allColors.push_back(color);
			}
		}
		portal->freeResult();
	}
	delete portal;

	double step = 0.;
	if (nc > 1)
		step = (double)(allColors.size()) / (double)(nc-1);
	for (int j=0; j<nc; j++)
	{
		int ind = (int)(step * (double)j + .5);
		if(ind > (int)(allColors.size() - 1))
			ind = allColors.size() - 1;
		colors.push_back(allColors[ind]);
	}
	allColors.clear();
	return true;
}

bool getColors(vector<string>& ramps, int nc, vector<TeColor> &colors)
{
	if (ramps.empty())
		ramps.push_back("RED");

	TeColor	RGB;
	map<string, TeColor> mapcor;

	RGB.name_ = "RED";
	RGB.red_ = 240;
	RGB.green_ = 0;
	RGB.blue_ = 0;
	mapcor["RED"] = RGB;

	RGB.name_ = "GREEN";
	RGB.red_ = 0;
	RGB.green_ = 240;
	RGB.blue_ = 0;
	mapcor["GREEN"] = RGB;

	RGB.name_ = "BLUE";
	RGB.red_ = 0;
	RGB.green_ = 0;
	RGB.blue_ = 240;
	mapcor["BLUE"] = RGB;

	RGB.name_ = "YELLOW";
	RGB.red_ = 255;
	RGB.green_ = 255;
	RGB.blue_ = 100;
	mapcor["YELLOW"] = RGB;

	RGB.name_ = "CYAN";
	RGB.red_ = 100;
	RGB.green_ = 255;
	RGB.blue_ = 255;
	mapcor["CYAN"] = RGB;

	RGB.name_ = "MAGENTA";
	RGB.red_ = 255;
	RGB.green_ = 100;
	RGB.blue_ = 255;
	mapcor["MAGENTA"] = RGB;

	RGB.name_ = "ORANGE";
	RGB.red_ = 255;
	RGB.green_ = 140;
	RGB.blue_ = 0;
	mapcor["ORANGE"] = RGB;

	RGB.name_ = "GRAY";
	RGB.red_ = 240;
	RGB.green_ = 240;
	RGB.blue_ = 240;
	mapcor["GRAY"] = RGB;

	RGB.name_ = "BLACK";
	RGB.red_ = 0;
	RGB.green_ = 0;
	RGB.blue_ = 0;
	mapcor["BLACK"] = RGB;

	int	ii, jj;
	int n = 200;
	
	TeColor cfrom = mapcor[ramps[0]];
	TeColor	cto, cor;

	vector<TeColor> allColors;
	if (ramps.size() == 1)
	{
		cto.red_ = cfrom.red_ / 5;
		cto.green_ = cfrom.green_ / 5;
		cto.blue_ = cfrom.blue_ / 5;
		double dr = (double)(cto.red_ - cfrom.red_) / (double)n;
		double dg = (double)(cto.green_ - cfrom.green_) / (double)n;
		double db = (double)(cto.blue_ - cfrom.blue_) / (double)n;

		for(jj=0; jj<n; jj++)
		{
			cor.red_ = cfrom.red_ + (int)(dr * (double)jj);
			cor.green_ = cfrom.green_ + (int)(dg * (double)jj);
			cor.blue_ = cfrom.blue_ + (int)(db * (double)jj);
			allColors.push_back(cor);
		}
	}
	else
	{
		ii = 1;
		while(ii < (int)ramps.size())
		{
			cto = mapcor[ramps[ii]];

			double dr = (double)(cto.red_ - cfrom.red_) / (double)n;
			double dg = (double)(cto.green_ - cfrom.green_) / (double)n;
			double db = (double)(cto.blue_ - cfrom.blue_) / (double)n;

			for(jj=0; jj<n; jj++)
			{
				cor.red_ = cfrom.red_ + (int)(dr * (double)jj);
				cor.green_ = cfrom.green_ + (int)(dg * (double)jj);
				cor.blue_ = cfrom.blue_ + (int)(db * (double)jj);
				allColors.push_back(cor);
			}
			cfrom = cto;
			ii++;
		}
	}
	double step = 0.;
	if (nc > 1)
		step = (double)(allColors.size()) / (double)(nc-1);
	for (int i=0; i<nc; i++)
	{
		int ind = (int)(step * (double)i + .5);
		if (ind > (int)(allColors.size() - 1))
			ind = allColors.size() - 1;
		colors.push_back(allColors[ind]);
	}
	allColors.clear();
	return true;
}
