/************************************************************************************
TerraView - visualization and exploration of geographical databases
using TerraLib.
Copyright  2001-2004 INPE and Tecgraf/PUC-Rio.
This file is part of TerraView. TerraView is free software; you can redistribute it 
and/or modify it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

You should have received a copy of the GNU General Public License
along with TerraView.
The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular purpose.
The software provided hereunder is on an "as is" basis, and the authors have no
obligation to provide maintenance, support, updates, enhancements, or modifications.
In no event shall INPE and Tecgraf / PUC-Rio be held liable to any party for direct,
indirect, special, incidental, or consequential damages arising out of the use of
this program and its documentation.
*************************************************************************************/


#include "TeSTElementSet.h"
#include "TeQtMethods.h"
#include "TeSkaterFunctions.h"
#include "TeQtTerraStat.h"
#include "TeQtGrid.h"
#include "TeSTEFunctionsDB.h"
#include <qobject.h>
#include <qapplication.h>

/////////////////////////////////////////////////////////////////////////////////////


bool TeSkaterMethod::apply(vector<double>& het) {



  if (this->hasPop_) {
    this->attrVector_.push_back(this->attrPop_);
  }

  TeSTElementSet stoSet(regTheme_);

  if (!TeSTOSetBuildDB(&stoSet, true, false, attrVector_)) {
    QMessageBox::critical(NULL, tr("Error"), 
		tr("Unexpected: Regions and attributes could not be loaded!"));
    return false;
  }

  if (!TeSkaterFunction(this->hasPop_, this->type_, this->nClusters_, this->minPop_,
    stoSet, this->resName_, het) ) {
    QMessageBox::critical(NULL, tr("Error"), 
		tr("Choose a connected graph!"));
    return false;
  }

  double h;
  for(unsigned int i = 0; i < het.size(); i++) {
    h = het[i];
  }

  
  if (!insertPropertyColumn(stoSet, tableName_, resName_) ) 
  {
    QMessageBox::critical(NULL, tr("Error"), 
		tr("Error storing results. Check result column name!"));
    return false;
  }

  // ---------------------------------------------- load updated table from database 
	// Update all the themes that uses this table
	TeViewMap& viewMap = regTheme_->layer()->database()->viewMap();
	TeViewMap::iterator it;
	set<TeLayer*> layerSet;
	for (it = viewMap.begin(); it != viewMap.end(); ++it)
	{
		TeView *view = it->second;
		vector<TeViewNode*>& themesVector = view->themes();
		for (unsigned int i = 0; i < themesVector.size(); ++i)
		{
			TeTheme *theme = (TeThemeApplication*)themesVector[i];
			if (theme->isThemeTable(tableName_) == true)
			{
				theme->loadThemeTables();
				layerSet.insert(theme->layer());
			}
		}
	}

	// Update the layer tables affected
	set<TeLayer*>::iterator setIt;
	for (setIt = layerSet.begin(); setIt != layerSet.end(); ++setIt)
		(*setIt)->loadLayerTables();

  return true;
}

