#!/usr/bin/perl --  ========================================== -*-perl-*-
#
# t/10-output.t
#
# Test the Latex plugin's ability to generate output files.
#
# Written by Andy Wardley <abw@wardley.org>
#
# This is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.
#
#========================================================================

use strict;
use warnings;
use FindBin qw($Bin);
use Cwd qw(abs_path);
use lib ( abs_path("$Bin/../lib"), "$Bin/lib" );
use Carp;
use Template;
use Template::Test;
use Template::Plugin::Latex;
use File::Spec;

my $out = 'output';
my $dir = -d 't' ? File::Spec->catfile('t', $out) : $out;

my $files = {
    pdf => 'test1.pdf',
    ps  => 'test1.ps',
    dvi => 'test1.dvi',
};
clean_file($_) for values %$files;
    
my $ttcfg = {
    OUTPUT_PATH => $dir,
    VARIABLES => {
        dir   => $dir,
        file  => $files,
        check => \&check_file,
    },
};

test_expect(\*DATA, $ttcfg);

sub clean_file {
    my $file = shift;
    my $path = File::Spec->catfile($dir, $file);
    if (-f $path) {
	unlink($path) or carp "cannot unlink $file ($!)";
    }
}

sub check_file {
    my $file = shift;
    my $path = File::Spec->catfile($dir, $file);
    return -f $path ? "PASS - $file exists" : "FAIL - $file does not exist";
}

__END__

-- test --
[% USE Latex;
   FILTER latex(file.pdf)
-%]
\documentclass{article}
\begin{document}
This is a PDF document generated by 
Latex and the Template Toolkit.
\end{document}
[% END -%]
[% check(file.pdf) %]
-- expect --
-- process --
PASS - [% file.pdf %] exists

-- test --
[% USE Latex;
   FILTER latex(output=file.ps)
-%]
\documentclass{article}
\begin{document}
This is a PostScript document generated by 
Latex and the Template Toolkit.
\end{document}
[% END -%]
[% check(file.ps) %]
-- expect --
-- process --
PASS - [% file.ps %] exists

-- test --
[% USE Latex;
   FILTER latex(file.dvi)
-%]
\documentclass{article}
\begin{document}
This is a DVI document generated by 
Latex and the Template Toolkit.
\end{document}
[% END -%]
[% check(file.dvi) %]
-- expect --
-- process --
PASS - [% file.dvi %] exists

