/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; version 
 * 2.1 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */
 
#include "support.h"

char *olddir = NULL;

char *setup_testbed(char *fkt_name)
{
	char *testbed = NULL;
	setuid(65534);
	
	if (!g_thread_supported ()) g_thread_init (NULL);
	
	if (fkt_name) {
		testbed = g_strdup_printf("%s/testbed.XXXXXX", g_get_tmp_dir());
		mkdtemp(testbed);
		
		char *command = NULL;
		if (fkt_name) {
			command = g_strdup_printf("cp -R %s%sdata/%s/* %s", g_getenv("srcdir") ? g_getenv("srcdir") : "", g_getenv("srcdir") ? "/" : "", fkt_name, testbed);
			if (system(command))
				abort();
			g_free(command);
		}
		
		olddir = g_get_current_dir();
		if (chdir(testbed))
			abort();
		
		smlTrace(TRACE_INTERNAL, "Seting up %s at %s", fkt_name, testbed);
	}
	printf(".");
	fflush(NULL);
	return testbed;
}

void destroy_testbed(char *path)
{
	char *command = g_strdup_printf("rm -rf %s", path);
	if (olddir)
		chdir(olddir);
	system(command);
	g_free(command);
	smlTrace(TRACE_INTERNAL, "Tearing down %s", path);
	g_free(path);
}

void create_case(Suite *s, const char *name, void (*function)(void))
{
	TCase *tc_new = tcase_create(name);
	tcase_set_timeout(tc_new, 0);
	suite_add_tcase (s, tc_new);
	tcase_add_test(tc_new, function);
}

SmlParser *start_parser(const char *data)
{
	setup_testbed(NULL);
	
	SmlError *error = NULL;
	SmlParser *parser = smlParserNew(SML_MIMETYPE_XML, 0, &error);
	fail_unless(parser != NULL, NULL);
	fail_unless(error == NULL, NULL);
	
	if (!smlParserStart(parser, data, strlen(data), &error)) {
		fail_unless(error != NULL, NULL);
		smlErrorDeref(&error);
		smlParserFree(parser);
		
		return NULL;
	}
	
	return parser;
}
