/*
 * libsyncml - A syncml protocol implementation
 * Copyright (C) 2005  Armin Bauer <armin.bauer@opensync.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; version 
 * 2.1 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

#ifndef _SML_DEVINF_H_
#define _SML_DEVINF_H_

SmlDevInfDevTyp smlDevInfDevTypeFromString(const char *name, SmlError **error);
const char *smlDevInfDevTypeToString(SmlDevInfDevTyp type, SmlError **error);

SmlDevInf *smlDevInfNew(const char *devid, SmlDevInfDevTyp devtyp, SmlError **error);
void smlDevInfRef(SmlDevInf *devinf);
void smlDevInfUnref(SmlDevInf *devinf);

const char *smlDevInfGetManufacturer(SmlDevInf *devinf);
void smlDevInfSetManufacturer(SmlDevInf *devinf, const char *man);
const char *smlDevInfGetModel(SmlDevInf *devinf);
void smlDevInfSetModel(SmlDevInf *devinf, const char *model);
const char *smlDevInfGetOEM(SmlDevInf *devinf);
void smlDevInfSetOEM(SmlDevInf *devinf, const char *oem);
const char *smlDevInfGetFirmwareVersion(SmlDevInf *devinf);
void smlDevInfSetFirmwareVersion(SmlDevInf *devinf, const char *firmwareVersion);
const char *smlDevInfGetSoftwareVersion(SmlDevInf *devinf);
void smlDevInfSetSoftwareVersion(SmlDevInf *devinf, const char *softwareVersion);
const char *smlDevInfGetHardwareVersion(SmlDevInf *devinf);
void smlDevInfSetHardwareVersion(SmlDevInf *devinf, const char *hardwareVersion);
const char *smlDevInfGetDeviceID(SmlDevInf *devinf);
void smlDevInfSetDeviceID(SmlDevInf *devinf, const char *devid);
SmlDevInfDevTyp smlDevInfGetDeviceType(SmlDevInf *devinf);
void smlDevInfSetDeviceType(SmlDevInf *devinf, SmlDevInfDevTyp devtyp);
SmlBool smlDevInfSupportsUTC(SmlDevInf *devinf);
void smlDevInfSetSupportsUTC(SmlDevInf *devinf, SmlBool supports);
SmlBool smlDevInfSupportsLargeObjs(SmlDevInf *devinf);
void smlDevInfSetSupportsLargeObjs(SmlDevInf *devinf, SmlBool supports);
SmlBool smlDevInfSupportsNumberOfChanges(SmlDevInf *devinf);
void smlDevInfSetSupportsNumberOfChanges(SmlDevInf *devinf, SmlBool supports);

void smlDevInfAddDataStore(SmlDevInf *devinf, SmlDevInfDataStore *datastore);
unsigned int smlDevInfNumDataStores(SmlDevInf *devinf);
SmlDevInfDataStore *smlDevInfGetNthDataStore(SmlDevInf *devinf, unsigned int nth);

SmlDevInfDataStore *smlDevInfDataStoreNew(const char *sourceRef, SmlError **error);
void smlDevInfDataStoreRef(SmlDevInfDataStore *datastore);
void smlDevInfDataStoreUnref(SmlDevInfDataStore *datastore);

const char *smlDevInfDataStoreGetSourceRef(SmlDevInfDataStore *datastore);
void smlDevInfDataStoreSetSourceRef(SmlDevInfDataStore *datastore, const char *sourceref);
const char *smlDevInfDataStoreGetDisplayName(SmlDevInfDataStore *datastore);
void smlDevInfDataStoreSetDisplayName(SmlDevInfDataStore *datastore, const char *displayName);
unsigned int smlDevInfGetMaxGUIDSize(SmlDevInfDataStore *datastore);
void smlDevInfSetMaxGUIDSize(SmlDevInfDataStore *datastore, unsigned int max);
void smlDevInfDataStoreSetRxPref(SmlDevInfDataStore *datastore, const char *contenttype, const char *version);
SmlBool smlDevInfDataStoreGetRxPref(SmlDevInfDataStore *datastore, char **contenttype, char **version);
void smlDevInfDataStoreSetRx(SmlDevInfDataStore *datastore, const char *contenttype, const char *version);
SmlBool smlDevInfDataStoreGetRx(SmlDevInfDataStore *datastore, char **contenttype, char **version);
void smlDevInfDataStoreSetTxPref(SmlDevInfDataStore *datastore, const char *contenttype, const char *version);
SmlBool smlDevInfDataStoreGetTxPref(SmlDevInfDataStore *datastore, char **contenttype, char **version);
void smlDevInfDataStoreSetTx(SmlDevInfDataStore *datastore, const char *contenttype, const char *version);
SmlBool smlDevInfDataStoreGetTx(SmlDevInfDataStore *datastore, char **contenttype, char **version);
void smlDevInfDataStoreSetMemory(SmlDevInfDataStore *datastore, SmlBool shared, unsigned int maxid, unsigned int maxmem);
void smlDevInfDataStoreGetMemory(SmlDevInfDataStore *datastore, SmlBool *shared, unsigned int *maxid, unsigned int *maxmem);
void smlDevInfDataStoreSetSyncCap(SmlDevInfDataStore *datastore, SmlDevInfSyncCap cap, SmlBool supported);
SmlBool smlDevInfDataStoreGetSyncCap(SmlDevInfDataStore *datastore, SmlDevInfSyncCap cap);

SmlBool smlDevInfAssemble(SmlDevInf *devinf, char **data, unsigned int *size, SmlError **error);
SmlCommand *smlDevInfNewResult(SmlCommand *cmd, SmlDevInf *devinf, SmlDevInfVersion version, SmlError **error);
SmlCommand *smlDevInfNewPut(SmlDevInf *devinf, SmlDevInfVersion version, SmlError **error);
SmlCommand *smlDevInfNewGet(SmlDevInfVersion version, SmlError **error);

void smlDevInfConfigureSession(SmlDevInf *devinf, SmlSession *session);

SmlDevInf *smlDevInfParse(const char *data, unsigned int length, SmlError **error);
SmlDevInf *smlDevInfFromResult(SmlCommand *result, SmlError **error);

#endif //_SML_DEVINF_H_
