/* ExtensionFileFilter.java
 * =========================================================================
 * This file is part of the SWIRL Library - http://swirl-lib.sourceforge.net
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 * 
 */

package be.ugent.caagt.swirl.actions;

import java.io.File;

import javax.swing.filechooser.FileFilter;

/**
 * Implements a Swing file filter that filters files on extensions.
 */
public class ExtensionFileFilter extends FileFilter {
    
    //
    private final String extension;
    
    //
    private final String description;
    
    /**
     * Creates a file filter which only allows files with the given extension.
     * (Case is ignored when doing the comparison.)
     * @param extension Extension which is to be allowed
     * @param description Description for this filter
     */
    public ExtensionFileFilter(String extension, String description) {
        if (extension.length() != 0 && extension.charAt(0) == '.')
            this.extension = extension.toLowerCase();
        else
            this.extension = "." + extension.toLowerCase();
        this.description = description;
    }
    
    //
    public boolean accept(File file) {
        return file.isDirectory() || file.getPath().toLowerCase().endsWith(extension);
    }
    
    //
    public String getDescription() {
        return description;
    }
    
    /**
     * Returns the given file with the extension of this filter added,
     * if the file has no extension. 
     */
    public File ensureExtension (File original) {
      if (original.getName().lastIndexOf('.') >= 1)
          return original;
      else 
          return new File (original.getParentFile(),
                  original.getName() + extension);
    }
}
