/* DefaultGenericSelectionModel.java
 * =========================================================================
 * This file is part of the SWIRL Library - http://swirl-lib.sourceforge.net
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 * 
 */

package be.ugent.caagt.swirl;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

/**
 * A default implementation of {@link GenericSelectionModel}. Uses {@code equals}
 * to check whether the model has been changed whenever a new selection is set.
 */
public class DefaultGenericSelectionModel<E> implements GenericSelectionModel<E> {

    // the current selection
    private E element;
    
    /**
     * The list of listeners currently registered
     */
    protected EventListenerList listenerList;
    
    // fixed event
    private final ChangeEvent changeEvent;

    public DefaultGenericSelectionModel() {
        this.element = null; // NOPMD
        this.listenerList = new EventListenerList();
        this.changeEvent = new ChangeEvent(this);
    }

    public E getSelection() {
        return element;
    }

    public void setSelection(E element) {
        if ((this.element == null && element != null) ||
            ! this.element.equals(element)) {
            this.element = element;
            fireStateChanged();
        }
    }

    public void clearSelection() {
        setSelection(null);
    }

    public boolean isSelected() {
        return element != null;
    }

    public void addChangeListener(ChangeListener listener) {
	listenerList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
	listenerList.remove(ChangeListener.class, listener);
    }
    
    /**
     * Notifies all listeners of a state change.
     */
    protected void fireStateChanged() {
	Object[] listeners = listenerList.getListenerList();
	for (int i = listeners.length-2; i>=0; i-=2) {
	    if (listeners[i]==ChangeListener.class) {
		((ChangeListener)listeners[i+1]).stateChanged(changeEvent);
	    }	       
	}
    }	
}
