/*
 * This C file has been generated by smidump 0.4.3.
 * It is intended to be used with the NET-SNMP library.
 *
 * This C file is derived from the MAU-MIB module.
 *
 * $Id: mau-mib-mgr-stub.c 1672 2004-08-09 14:56:17Z strauss $
 */

#include <stdlib.h>

#include <ucd-snmp/asn1.h>
#include <ucd-snmp/snmp.h>
#include <ucd-snmp/snmp_api.h>
#include <ucd-snmp/snmp_client.h>

#include "mau-mib.h"

static oid rpMauGroupIndex[] = {1, 3, 6, 1, 2, 1, 26, 1, 1, 1, 1};
static oid rpMauPortIndex[] = {1, 3, 6, 1, 2, 1, 26, 1, 1, 1, 2};
static oid rpMauIndex[] = {1, 3, 6, 1, 2, 1, 26, 1, 1, 1, 3};
static oid rpMauType[] = {1, 3, 6, 1, 2, 1, 26, 1, 1, 1, 4};
static oid rpMauStatus[] = {1, 3, 6, 1, 2, 1, 26, 1, 1, 1, 5};
static oid rpMauMediaAvailable[] = {1, 3, 6, 1, 2, 1, 26, 1, 1, 1, 6};
static oid rpMauMediaAvailableStateExits[] = {1, 3, 6, 1, 2, 1, 26, 1, 1, 1, 7};
static oid rpMauJabberState[] = {1, 3, 6, 1, 2, 1, 26, 1, 1, 1, 8};
static oid rpMauJabberingStateEnters[] = {1, 3, 6, 1, 2, 1, 26, 1, 1, 1, 9};
static oid rpMauFalseCarriers[] = {1, 3, 6, 1, 2, 1, 26, 1, 1, 1, 10};
static oid rpJackIndex[] = {1, 3, 6, 1, 2, 1, 26, 1, 2, 1, 1};
static oid rpJackType[] = {1, 3, 6, 1, 2, 1, 26, 1, 2, 1, 2};
static oid ifMauIfIndex[] = {1, 3, 6, 1, 2, 1, 26, 2, 1, 1, 1};
static oid ifMauIndex[] = {1, 3, 6, 1, 2, 1, 26, 2, 1, 1, 2};
static oid ifMauType[] = {1, 3, 6, 1, 2, 1, 26, 2, 1, 1, 3};
static oid ifMauStatus[] = {1, 3, 6, 1, 2, 1, 26, 2, 1, 1, 4};
static oid ifMauMediaAvailable[] = {1, 3, 6, 1, 2, 1, 26, 2, 1, 1, 5};
static oid ifMauMediaAvailableStateExits[] = {1, 3, 6, 1, 2, 1, 26, 2, 1, 1, 6};
static oid ifMauJabberState[] = {1, 3, 6, 1, 2, 1, 26, 2, 1, 1, 7};
static oid ifMauJabberingStateEnters[] = {1, 3, 6, 1, 2, 1, 26, 2, 1, 1, 8};
static oid ifMauFalseCarriers[] = {1, 3, 6, 1, 2, 1, 26, 2, 1, 1, 9};
static oid ifMauTypeList[] = {1, 3, 6, 1, 2, 1, 26, 2, 1, 1, 10};
static oid ifMauDefaultType[] = {1, 3, 6, 1, 2, 1, 26, 2, 1, 1, 11};
static oid ifMauAutoNegSupported[] = {1, 3, 6, 1, 2, 1, 26, 2, 1, 1, 12};
static oid ifMauTypeListBits[] = {1, 3, 6, 1, 2, 1, 26, 2, 1, 1, 13};
static oid ifMauHCFalseCarriers[] = {1, 3, 6, 1, 2, 1, 26, 2, 1, 1, 14};
static oid ifJackIndex[] = {1, 3, 6, 1, 2, 1, 26, 2, 2, 1, 1};
static oid ifJackType[] = {1, 3, 6, 1, 2, 1, 26, 2, 2, 1, 2};
static oid broadMauIfIndex[] = {1, 3, 6, 1, 2, 1, 26, 3, 1, 1, 1};
static oid broadMauIndex[] = {1, 3, 6, 1, 2, 1, 26, 3, 1, 1, 2};
static oid broadMauXmtRcvSplitType[] = {1, 3, 6, 1, 2, 1, 26, 3, 1, 1, 3};
static oid broadMauXmtCarrierFreq[] = {1, 3, 6, 1, 2, 1, 26, 3, 1, 1, 4};
static oid broadMauTranslationFreq[] = {1, 3, 6, 1, 2, 1, 26, 3, 1, 1, 5};
static oid ifMauAutoNegAdminStatus[] = {1, 3, 6, 1, 2, 1, 26, 5, 1, 1, 1};
static oid ifMauAutoNegRemoteSignaling[] = {1, 3, 6, 1, 2, 1, 26, 5, 1, 1, 2};
static oid ifMauAutoNegConfig[] = {1, 3, 6, 1, 2, 1, 26, 5, 1, 1, 4};
static oid ifMauAutoNegCapability[] = {1, 3, 6, 1, 2, 1, 26, 5, 1, 1, 5};
static oid ifMauAutoNegCapAdvertised[] = {1, 3, 6, 1, 2, 1, 26, 5, 1, 1, 6};
static oid ifMauAutoNegCapReceived[] = {1, 3, 6, 1, 2, 1, 26, 5, 1, 1, 7};
static oid ifMauAutoNegRestart[] = {1, 3, 6, 1, 2, 1, 26, 5, 1, 1, 8};
static oid ifMauAutoNegCapabilityBits[] = {1, 3, 6, 1, 2, 1, 26, 5, 1, 1, 9};
static oid ifMauAutoNegCapAdvertisedBits[] = {1, 3, 6, 1, 2, 1, 26, 5, 1, 1, 10};
static oid ifMauAutoNegCapReceivedBits[] = {1, 3, 6, 1, 2, 1, 26, 5, 1, 1, 11};
static oid ifMauAutoNegRemoteFaultAdvertised[] = {1, 3, 6, 1, 2, 1, 26, 5, 1, 1, 12};
static oid ifMauAutoNegRemoteFaultReceived[] = {1, 3, 6, 1, 2, 1, 26, 5, 1, 1, 13};

int mau_mib_mgr_get_rpMauEntry(struct snmp_session *s, rpMauEntry_t **rpMauEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, rpMauGroupIndex, sizeof(rpMauGroupIndex)/sizeof(oid));
    snmp_add_null_var(request, rpMauPortIndex, sizeof(rpMauPortIndex)/sizeof(oid));
    snmp_add_null_var(request, rpMauIndex, sizeof(rpMauIndex)/sizeof(oid));
    snmp_add_null_var(request, rpMauType, sizeof(rpMauType)/sizeof(oid));
    snmp_add_null_var(request, rpMauStatus, sizeof(rpMauStatus)/sizeof(oid));
    snmp_add_null_var(request, rpMauMediaAvailable, sizeof(rpMauMediaAvailable)/sizeof(oid));
    snmp_add_null_var(request, rpMauMediaAvailableStateExits, sizeof(rpMauMediaAvailableStateExits)/sizeof(oid));
    snmp_add_null_var(request, rpMauJabberState, sizeof(rpMauJabberState)/sizeof(oid));
    snmp_add_null_var(request, rpMauJabberingStateEnters, sizeof(rpMauJabberingStateEnters)/sizeof(oid));
    snmp_add_null_var(request, rpMauFalseCarriers, sizeof(rpMauFalseCarriers)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -2;
    }

    *rpMauEntry = (rpMauEntry_t *) malloc(sizeof(rpMauEntry_t));
    if (! *rpMauEntry) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(rpMauGroupIndex)/sizeof(oid)
            && memcmp(vars->name, rpMauGroupIndex, sizeof(rpMauGroupIndex)) == 0) {
            (*rpMauEntry)->__rpMauGroupIndex = *vars->val.integer;
            (*rpMauEntry)->rpMauGroupIndex = &((*rpMauEntry)->__rpMauGroupIndex);
        }
        if (vars->name_length > sizeof(rpMauPortIndex)/sizeof(oid)
            && memcmp(vars->name, rpMauPortIndex, sizeof(rpMauPortIndex)) == 0) {
            (*rpMauEntry)->__rpMauPortIndex = *vars->val.integer;
            (*rpMauEntry)->rpMauPortIndex = &((*rpMauEntry)->__rpMauPortIndex);
        }
        if (vars->name_length > sizeof(rpMauIndex)/sizeof(oid)
            && memcmp(vars->name, rpMauIndex, sizeof(rpMauIndex)) == 0) {
            (*rpMauEntry)->__rpMauIndex = *vars->val.integer;
            (*rpMauEntry)->rpMauIndex = &((*rpMauEntry)->__rpMauIndex);
        }
        if (vars->name_length > sizeof(rpMauType)/sizeof(oid)
            && memcmp(vars->name, rpMauType, sizeof(rpMauType)) == 0) {
        }
        if (vars->name_length > sizeof(rpMauStatus)/sizeof(oid)
            && memcmp(vars->name, rpMauStatus, sizeof(rpMauStatus)) == 0) {
            (*rpMauEntry)->__rpMauStatus = *vars->val.integer;
            (*rpMauEntry)->rpMauStatus = &((*rpMauEntry)->__rpMauStatus);
        }
        if (vars->name_length > sizeof(rpMauMediaAvailable)/sizeof(oid)
            && memcmp(vars->name, rpMauMediaAvailable, sizeof(rpMauMediaAvailable)) == 0) {
            (*rpMauEntry)->__rpMauMediaAvailable = *vars->val.integer;
            (*rpMauEntry)->rpMauMediaAvailable = &((*rpMauEntry)->__rpMauMediaAvailable);
        }
        if (vars->name_length > sizeof(rpMauMediaAvailableStateExits)/sizeof(oid)
            && memcmp(vars->name, rpMauMediaAvailableStateExits, sizeof(rpMauMediaAvailableStateExits)) == 0) {
            (*rpMauEntry)->__rpMauMediaAvailableStateExits = *vars->val.integer;
            (*rpMauEntry)->rpMauMediaAvailableStateExits = &((*rpMauEntry)->__rpMauMediaAvailableStateExits);
        }
        if (vars->name_length > sizeof(rpMauJabberState)/sizeof(oid)
            && memcmp(vars->name, rpMauJabberState, sizeof(rpMauJabberState)) == 0) {
            (*rpMauEntry)->__rpMauJabberState = *vars->val.integer;
            (*rpMauEntry)->rpMauJabberState = &((*rpMauEntry)->__rpMauJabberState);
        }
        if (vars->name_length > sizeof(rpMauJabberingStateEnters)/sizeof(oid)
            && memcmp(vars->name, rpMauJabberingStateEnters, sizeof(rpMauJabberingStateEnters)) == 0) {
            (*rpMauEntry)->__rpMauJabberingStateEnters = *vars->val.integer;
            (*rpMauEntry)->rpMauJabberingStateEnters = &((*rpMauEntry)->__rpMauJabberingStateEnters);
        }
        if (vars->name_length > sizeof(rpMauFalseCarriers)/sizeof(oid)
            && memcmp(vars->name, rpMauFalseCarriers, sizeof(rpMauFalseCarriers)) == 0) {
            (*rpMauEntry)->__rpMauFalseCarriers = *vars->val.integer;
            (*rpMauEntry)->rpMauFalseCarriers = &((*rpMauEntry)->__rpMauFalseCarriers);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int mau_mib_mgr_get_rpJackEntry(struct snmp_session *s, rpJackEntry_t **rpJackEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, rpJackType, sizeof(rpJackType)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -2;
    }

    *rpJackEntry = (rpJackEntry_t *) malloc(sizeof(rpJackEntry_t));
    if (! *rpJackEntry) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(rpJackType)/sizeof(oid)
            && memcmp(vars->name, rpJackType, sizeof(rpJackType)) == 0) {
            (*rpJackEntry)->__rpJackType = *vars->val.integer;
            (*rpJackEntry)->rpJackType = &((*rpJackEntry)->__rpJackType);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int mau_mib_mgr_get_ifMauEntry(struct snmp_session *s, ifMauEntry_t **ifMauEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, ifMauIfIndex, sizeof(ifMauIfIndex)/sizeof(oid));
    snmp_add_null_var(request, ifMauIndex, sizeof(ifMauIndex)/sizeof(oid));
    snmp_add_null_var(request, ifMauType, sizeof(ifMauType)/sizeof(oid));
    snmp_add_null_var(request, ifMauStatus, sizeof(ifMauStatus)/sizeof(oid));
    snmp_add_null_var(request, ifMauMediaAvailable, sizeof(ifMauMediaAvailable)/sizeof(oid));
    snmp_add_null_var(request, ifMauMediaAvailableStateExits, sizeof(ifMauMediaAvailableStateExits)/sizeof(oid));
    snmp_add_null_var(request, ifMauJabberState, sizeof(ifMauJabberState)/sizeof(oid));
    snmp_add_null_var(request, ifMauJabberingStateEnters, sizeof(ifMauJabberingStateEnters)/sizeof(oid));
    snmp_add_null_var(request, ifMauFalseCarriers, sizeof(ifMauFalseCarriers)/sizeof(oid));
    snmp_add_null_var(request, ifMauTypeList, sizeof(ifMauTypeList)/sizeof(oid));
    snmp_add_null_var(request, ifMauDefaultType, sizeof(ifMauDefaultType)/sizeof(oid));
    snmp_add_null_var(request, ifMauAutoNegSupported, sizeof(ifMauAutoNegSupported)/sizeof(oid));
    snmp_add_null_var(request, ifMauTypeListBits, sizeof(ifMauTypeListBits)/sizeof(oid));
    snmp_add_null_var(request, ifMauHCFalseCarriers, sizeof(ifMauHCFalseCarriers)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -2;
    }

    *ifMauEntry = (ifMauEntry_t *) malloc(sizeof(ifMauEntry_t));
    if (! *ifMauEntry) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(ifMauIfIndex)/sizeof(oid)
            && memcmp(vars->name, ifMauIfIndex, sizeof(ifMauIfIndex)) == 0) {
            (*ifMauEntry)->__ifMauIfIndex = *vars->val.integer;
            (*ifMauEntry)->ifMauIfIndex = &((*ifMauEntry)->__ifMauIfIndex);
        }
        if (vars->name_length > sizeof(ifMauIndex)/sizeof(oid)
            && memcmp(vars->name, ifMauIndex, sizeof(ifMauIndex)) == 0) {
            (*ifMauEntry)->__ifMauIndex = *vars->val.integer;
            (*ifMauEntry)->ifMauIndex = &((*ifMauEntry)->__ifMauIndex);
        }
        if (vars->name_length > sizeof(ifMauType)/sizeof(oid)
            && memcmp(vars->name, ifMauType, sizeof(ifMauType)) == 0) {
        }
        if (vars->name_length > sizeof(ifMauStatus)/sizeof(oid)
            && memcmp(vars->name, ifMauStatus, sizeof(ifMauStatus)) == 0) {
            (*ifMauEntry)->__ifMauStatus = *vars->val.integer;
            (*ifMauEntry)->ifMauStatus = &((*ifMauEntry)->__ifMauStatus);
        }
        if (vars->name_length > sizeof(ifMauMediaAvailable)/sizeof(oid)
            && memcmp(vars->name, ifMauMediaAvailable, sizeof(ifMauMediaAvailable)) == 0) {
            (*ifMauEntry)->__ifMauMediaAvailable = *vars->val.integer;
            (*ifMauEntry)->ifMauMediaAvailable = &((*ifMauEntry)->__ifMauMediaAvailable);
        }
        if (vars->name_length > sizeof(ifMauMediaAvailableStateExits)/sizeof(oid)
            && memcmp(vars->name, ifMauMediaAvailableStateExits, sizeof(ifMauMediaAvailableStateExits)) == 0) {
            (*ifMauEntry)->__ifMauMediaAvailableStateExits = *vars->val.integer;
            (*ifMauEntry)->ifMauMediaAvailableStateExits = &((*ifMauEntry)->__ifMauMediaAvailableStateExits);
        }
        if (vars->name_length > sizeof(ifMauJabberState)/sizeof(oid)
            && memcmp(vars->name, ifMauJabberState, sizeof(ifMauJabberState)) == 0) {
            (*ifMauEntry)->__ifMauJabberState = *vars->val.integer;
            (*ifMauEntry)->ifMauJabberState = &((*ifMauEntry)->__ifMauJabberState);
        }
        if (vars->name_length > sizeof(ifMauJabberingStateEnters)/sizeof(oid)
            && memcmp(vars->name, ifMauJabberingStateEnters, sizeof(ifMauJabberingStateEnters)) == 0) {
            (*ifMauEntry)->__ifMauJabberingStateEnters = *vars->val.integer;
            (*ifMauEntry)->ifMauJabberingStateEnters = &((*ifMauEntry)->__ifMauJabberingStateEnters);
        }
        if (vars->name_length > sizeof(ifMauFalseCarriers)/sizeof(oid)
            && memcmp(vars->name, ifMauFalseCarriers, sizeof(ifMauFalseCarriers)) == 0) {
            (*ifMauEntry)->__ifMauFalseCarriers = *vars->val.integer;
            (*ifMauEntry)->ifMauFalseCarriers = &((*ifMauEntry)->__ifMauFalseCarriers);
        }
        if (vars->name_length > sizeof(ifMauTypeList)/sizeof(oid)
            && memcmp(vars->name, ifMauTypeList, sizeof(ifMauTypeList)) == 0) {
            (*ifMauEntry)->__ifMauTypeList = *vars->val.integer;
            (*ifMauEntry)->ifMauTypeList = &((*ifMauEntry)->__ifMauTypeList);
        }
        if (vars->name_length > sizeof(ifMauDefaultType)/sizeof(oid)
            && memcmp(vars->name, ifMauDefaultType, sizeof(ifMauDefaultType)) == 0) {
        }
        if (vars->name_length > sizeof(ifMauAutoNegSupported)/sizeof(oid)
            && memcmp(vars->name, ifMauAutoNegSupported, sizeof(ifMauAutoNegSupported)) == 0) {
            (*ifMauEntry)->__ifMauAutoNegSupported = *vars->val.integer;
            (*ifMauEntry)->ifMauAutoNegSupported = &((*ifMauEntry)->__ifMauAutoNegSupported);
        }
        if (vars->name_length > sizeof(ifMauTypeListBits)/sizeof(oid)
            && memcmp(vars->name, ifMauTypeListBits, sizeof(ifMauTypeListBits)) == 0) {
            memcpy((*ifMauEntry)->__ifMauTypeListBits, vars->val.string, vars->val_len);
            (*ifMauEntry)->_ifMauTypeListBitsLength = vars->val_len;
            (*ifMauEntry)->ifMauTypeListBits = (*ifMauEntry)->__ifMauTypeListBits;
        }
        if (vars->name_length > sizeof(ifMauHCFalseCarriers)/sizeof(oid)
            && memcmp(vars->name, ifMauHCFalseCarriers, sizeof(ifMauHCFalseCarriers)) == 0) {
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int mau_mib_mgr_get_ifJackEntry(struct snmp_session *s, ifJackEntry_t **ifJackEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, ifJackType, sizeof(ifJackType)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -2;
    }

    *ifJackEntry = (ifJackEntry_t *) malloc(sizeof(ifJackEntry_t));
    if (! *ifJackEntry) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(ifJackType)/sizeof(oid)
            && memcmp(vars->name, ifJackType, sizeof(ifJackType)) == 0) {
            (*ifJackEntry)->__ifJackType = *vars->val.integer;
            (*ifJackEntry)->ifJackType = &((*ifJackEntry)->__ifJackType);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int mau_mib_mgr_get_broadMauBasicEntry(struct snmp_session *s, broadMauBasicEntry_t **broadMauBasicEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, broadMauIfIndex, sizeof(broadMauIfIndex)/sizeof(oid));
    snmp_add_null_var(request, broadMauIndex, sizeof(broadMauIndex)/sizeof(oid));
    snmp_add_null_var(request, broadMauXmtRcvSplitType, sizeof(broadMauXmtRcvSplitType)/sizeof(oid));
    snmp_add_null_var(request, broadMauXmtCarrierFreq, sizeof(broadMauXmtCarrierFreq)/sizeof(oid));
    snmp_add_null_var(request, broadMauTranslationFreq, sizeof(broadMauTranslationFreq)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -2;
    }

    *broadMauBasicEntry = (broadMauBasicEntry_t *) malloc(sizeof(broadMauBasicEntry_t));
    if (! *broadMauBasicEntry) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(broadMauIfIndex)/sizeof(oid)
            && memcmp(vars->name, broadMauIfIndex, sizeof(broadMauIfIndex)) == 0) {
            (*broadMauBasicEntry)->__broadMauIfIndex = *vars->val.integer;
            (*broadMauBasicEntry)->broadMauIfIndex = &((*broadMauBasicEntry)->__broadMauIfIndex);
        }
        if (vars->name_length > sizeof(broadMauIndex)/sizeof(oid)
            && memcmp(vars->name, broadMauIndex, sizeof(broadMauIndex)) == 0) {
            (*broadMauBasicEntry)->__broadMauIndex = *vars->val.integer;
            (*broadMauBasicEntry)->broadMauIndex = &((*broadMauBasicEntry)->__broadMauIndex);
        }
        if (vars->name_length > sizeof(broadMauXmtRcvSplitType)/sizeof(oid)
            && memcmp(vars->name, broadMauXmtRcvSplitType, sizeof(broadMauXmtRcvSplitType)) == 0) {
            (*broadMauBasicEntry)->__broadMauXmtRcvSplitType = *vars->val.integer;
            (*broadMauBasicEntry)->broadMauXmtRcvSplitType = &((*broadMauBasicEntry)->__broadMauXmtRcvSplitType);
        }
        if (vars->name_length > sizeof(broadMauXmtCarrierFreq)/sizeof(oid)
            && memcmp(vars->name, broadMauXmtCarrierFreq, sizeof(broadMauXmtCarrierFreq)) == 0) {
            (*broadMauBasicEntry)->__broadMauXmtCarrierFreq = *vars->val.integer;
            (*broadMauBasicEntry)->broadMauXmtCarrierFreq = &((*broadMauBasicEntry)->__broadMauXmtCarrierFreq);
        }
        if (vars->name_length > sizeof(broadMauTranslationFreq)/sizeof(oid)
            && memcmp(vars->name, broadMauTranslationFreq, sizeof(broadMauTranslationFreq)) == 0) {
            (*broadMauBasicEntry)->__broadMauTranslationFreq = *vars->val.integer;
            (*broadMauBasicEntry)->broadMauTranslationFreq = &((*broadMauBasicEntry)->__broadMauTranslationFreq);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int mau_mib_mgr_get_ifMauAutoNegEntry(struct snmp_session *s, ifMauAutoNegEntry_t **ifMauAutoNegEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, ifMauAutoNegAdminStatus, sizeof(ifMauAutoNegAdminStatus)/sizeof(oid));
    snmp_add_null_var(request, ifMauAutoNegRemoteSignaling, sizeof(ifMauAutoNegRemoteSignaling)/sizeof(oid));
    snmp_add_null_var(request, ifMauAutoNegConfig, sizeof(ifMauAutoNegConfig)/sizeof(oid));
    snmp_add_null_var(request, ifMauAutoNegCapability, sizeof(ifMauAutoNegCapability)/sizeof(oid));
    snmp_add_null_var(request, ifMauAutoNegCapAdvertised, sizeof(ifMauAutoNegCapAdvertised)/sizeof(oid));
    snmp_add_null_var(request, ifMauAutoNegCapReceived, sizeof(ifMauAutoNegCapReceived)/sizeof(oid));
    snmp_add_null_var(request, ifMauAutoNegRestart, sizeof(ifMauAutoNegRestart)/sizeof(oid));
    snmp_add_null_var(request, ifMauAutoNegCapabilityBits, sizeof(ifMauAutoNegCapabilityBits)/sizeof(oid));
    snmp_add_null_var(request, ifMauAutoNegCapAdvertisedBits, sizeof(ifMauAutoNegCapAdvertisedBits)/sizeof(oid));
    snmp_add_null_var(request, ifMauAutoNegCapReceivedBits, sizeof(ifMauAutoNegCapReceivedBits)/sizeof(oid));
    snmp_add_null_var(request, ifMauAutoNegRemoteFaultAdvertised, sizeof(ifMauAutoNegRemoteFaultAdvertised)/sizeof(oid));
    snmp_add_null_var(request, ifMauAutoNegRemoteFaultReceived, sizeof(ifMauAutoNegRemoteFaultReceived)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -2;
    }

    *ifMauAutoNegEntry = (ifMauAutoNegEntry_t *) malloc(sizeof(ifMauAutoNegEntry_t));
    if (! *ifMauAutoNegEntry) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(ifMauAutoNegAdminStatus)/sizeof(oid)
            && memcmp(vars->name, ifMauAutoNegAdminStatus, sizeof(ifMauAutoNegAdminStatus)) == 0) {
            (*ifMauAutoNegEntry)->__ifMauAutoNegAdminStatus = *vars->val.integer;
            (*ifMauAutoNegEntry)->ifMauAutoNegAdminStatus = &((*ifMauAutoNegEntry)->__ifMauAutoNegAdminStatus);
        }
        if (vars->name_length > sizeof(ifMauAutoNegRemoteSignaling)/sizeof(oid)
            && memcmp(vars->name, ifMauAutoNegRemoteSignaling, sizeof(ifMauAutoNegRemoteSignaling)) == 0) {
            (*ifMauAutoNegEntry)->__ifMauAutoNegRemoteSignaling = *vars->val.integer;
            (*ifMauAutoNegEntry)->ifMauAutoNegRemoteSignaling = &((*ifMauAutoNegEntry)->__ifMauAutoNegRemoteSignaling);
        }
        if (vars->name_length > sizeof(ifMauAutoNegConfig)/sizeof(oid)
            && memcmp(vars->name, ifMauAutoNegConfig, sizeof(ifMauAutoNegConfig)) == 0) {
            (*ifMauAutoNegEntry)->__ifMauAutoNegConfig = *vars->val.integer;
            (*ifMauAutoNegEntry)->ifMauAutoNegConfig = &((*ifMauAutoNegEntry)->__ifMauAutoNegConfig);
        }
        if (vars->name_length > sizeof(ifMauAutoNegCapability)/sizeof(oid)
            && memcmp(vars->name, ifMauAutoNegCapability, sizeof(ifMauAutoNegCapability)) == 0) {
            (*ifMauAutoNegEntry)->__ifMauAutoNegCapability = *vars->val.integer;
            (*ifMauAutoNegEntry)->ifMauAutoNegCapability = &((*ifMauAutoNegEntry)->__ifMauAutoNegCapability);
        }
        if (vars->name_length > sizeof(ifMauAutoNegCapAdvertised)/sizeof(oid)
            && memcmp(vars->name, ifMauAutoNegCapAdvertised, sizeof(ifMauAutoNegCapAdvertised)) == 0) {
            (*ifMauAutoNegEntry)->__ifMauAutoNegCapAdvertised = *vars->val.integer;
            (*ifMauAutoNegEntry)->ifMauAutoNegCapAdvertised = &((*ifMauAutoNegEntry)->__ifMauAutoNegCapAdvertised);
        }
        if (vars->name_length > sizeof(ifMauAutoNegCapReceived)/sizeof(oid)
            && memcmp(vars->name, ifMauAutoNegCapReceived, sizeof(ifMauAutoNegCapReceived)) == 0) {
            (*ifMauAutoNegEntry)->__ifMauAutoNegCapReceived = *vars->val.integer;
            (*ifMauAutoNegEntry)->ifMauAutoNegCapReceived = &((*ifMauAutoNegEntry)->__ifMauAutoNegCapReceived);
        }
        if (vars->name_length > sizeof(ifMauAutoNegRestart)/sizeof(oid)
            && memcmp(vars->name, ifMauAutoNegRestart, sizeof(ifMauAutoNegRestart)) == 0) {
            (*ifMauAutoNegEntry)->__ifMauAutoNegRestart = *vars->val.integer;
            (*ifMauAutoNegEntry)->ifMauAutoNegRestart = &((*ifMauAutoNegEntry)->__ifMauAutoNegRestart);
        }
        if (vars->name_length > sizeof(ifMauAutoNegCapabilityBits)/sizeof(oid)
            && memcmp(vars->name, ifMauAutoNegCapabilityBits, sizeof(ifMauAutoNegCapabilityBits)) == 0) {
            memcpy((*ifMauAutoNegEntry)->__ifMauAutoNegCapabilityBits, vars->val.string, vars->val_len);
            (*ifMauAutoNegEntry)->_ifMauAutoNegCapabilityBitsLength = vars->val_len;
            (*ifMauAutoNegEntry)->ifMauAutoNegCapabilityBits = (*ifMauAutoNegEntry)->__ifMauAutoNegCapabilityBits;
        }
        if (vars->name_length > sizeof(ifMauAutoNegCapAdvertisedBits)/sizeof(oid)
            && memcmp(vars->name, ifMauAutoNegCapAdvertisedBits, sizeof(ifMauAutoNegCapAdvertisedBits)) == 0) {
            memcpy((*ifMauAutoNegEntry)->__ifMauAutoNegCapAdvertisedBits, vars->val.string, vars->val_len);
            (*ifMauAutoNegEntry)->_ifMauAutoNegCapAdvertisedBitsLength = vars->val_len;
            (*ifMauAutoNegEntry)->ifMauAutoNegCapAdvertisedBits = (*ifMauAutoNegEntry)->__ifMauAutoNegCapAdvertisedBits;
        }
        if (vars->name_length > sizeof(ifMauAutoNegCapReceivedBits)/sizeof(oid)
            && memcmp(vars->name, ifMauAutoNegCapReceivedBits, sizeof(ifMauAutoNegCapReceivedBits)) == 0) {
            memcpy((*ifMauAutoNegEntry)->__ifMauAutoNegCapReceivedBits, vars->val.string, vars->val_len);
            (*ifMauAutoNegEntry)->_ifMauAutoNegCapReceivedBitsLength = vars->val_len;
            (*ifMauAutoNegEntry)->ifMauAutoNegCapReceivedBits = (*ifMauAutoNegEntry)->__ifMauAutoNegCapReceivedBits;
        }
        if (vars->name_length > sizeof(ifMauAutoNegRemoteFaultAdvertised)/sizeof(oid)
            && memcmp(vars->name, ifMauAutoNegRemoteFaultAdvertised, sizeof(ifMauAutoNegRemoteFaultAdvertised)) == 0) {
            (*ifMauAutoNegEntry)->__ifMauAutoNegRemoteFaultAdvertised = *vars->val.integer;
            (*ifMauAutoNegEntry)->ifMauAutoNegRemoteFaultAdvertised = &((*ifMauAutoNegEntry)->__ifMauAutoNegRemoteFaultAdvertised);
        }
        if (vars->name_length > sizeof(ifMauAutoNegRemoteFaultReceived)/sizeof(oid)
            && memcmp(vars->name, ifMauAutoNegRemoteFaultReceived, sizeof(ifMauAutoNegRemoteFaultReceived)) == 0) {
            (*ifMauAutoNegEntry)->__ifMauAutoNegRemoteFaultReceived = *vars->val.integer;
            (*ifMauAutoNegEntry)->ifMauAutoNegRemoteFaultReceived = &((*ifMauAutoNegEntry)->__ifMauAutoNegRemoteFaultReceived);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}


