/*
 * This C file has been generated by smidump 0.2.17.
 * It is intended to be used with the NET-SNMP library.
 *
 * This C file is derived from the RMON2-MIB module.
 *
 * $Id: rmon2-mib-mgr-stub.c,v 1.4 2001/08/24 10:11:17 strauss Exp $
 */

#include <stdlib.h>

#include <ucd-snmp/asn1.h>
#include <ucd-snmp/snmp.h>
#include <ucd-snmp/snmp_api.h>
#include <ucd-snmp/snmp_client.h>

#include "rmon2-mib.h"

static oid etherStatsDroppedFrames[] = {1, 3, 6, 1, 2, 1, 16, 1, 4, 1, 1};
static oid etherStatsCreateTime[] = {1, 3, 6, 1, 2, 1, 16, 1, 4, 1, 2};
static oid tokenRingMLStatsDroppedFrames[] = {1, 3, 6, 1, 2, 1, 16, 1, 5, 1, 1};
static oid tokenRingMLStatsCreateTime[] = {1, 3, 6, 1, 2, 1, 16, 1, 5, 1, 2};
static oid tokenRingPStatsDroppedFrames[] = {1, 3, 6, 1, 2, 1, 16, 1, 6, 1, 1};
static oid tokenRingPStatsCreateTime[] = {1, 3, 6, 1, 2, 1, 16, 1, 6, 1, 2};
static oid historyControlDroppedFrames[] = {1, 3, 6, 1, 2, 1, 16, 2, 5, 1, 1};
static oid hostControlDroppedFrames[] = {1, 3, 6, 1, 2, 1, 16, 4, 4, 1, 1};
static oid hostControlCreateTime[] = {1, 3, 6, 1, 2, 1, 16, 4, 4, 1, 2};
static oid matrixControlDroppedFrames[] = {1, 3, 6, 1, 2, 1, 16, 6, 4, 1, 1};
static oid matrixControlCreateTime[] = {1, 3, 6, 1, 2, 1, 16, 6, 4, 1, 2};
static oid channelDroppedFrames[] = {1, 3, 6, 1, 2, 1, 16, 7, 3, 1, 1};
static oid channelCreateTime[] = {1, 3, 6, 1, 2, 1, 16, 7, 3, 1, 2};
static oid filterProtocolDirDataLocalIndex[] = {1, 3, 6, 1, 2, 1, 16, 7, 4, 1, 1};
static oid filterProtocolDirLocalIndex[] = {1, 3, 6, 1, 2, 1, 16, 7, 4, 1, 2};
static oid ringStationControlDroppedFrames[] = {1, 3, 6, 1, 2, 1, 16, 10, 7, 1, 1};
static oid ringStationControlCreateTime[] = {1, 3, 6, 1, 2, 1, 16, 10, 7, 1, 2};
static oid sourceRoutingStatsDroppedFrames[] = {1, 3, 6, 1, 2, 1, 16, 10, 8, 1, 1};
static oid sourceRoutingStatsCreateTime[] = {1, 3, 6, 1, 2, 1, 16, 10, 8, 1, 2};
static oid protocolDirLastChange[] = {1, 3, 6, 1, 2, 1, 16, 11, 1};
static oid protocolDirID[] = {1, 3, 6, 1, 2, 1, 16, 11, 2, 1, 1};
static oid protocolDirParameters[] = {1, 3, 6, 1, 2, 1, 16, 11, 2, 1, 2};
static oid protocolDirLocalIndex[] = {1, 3, 6, 1, 2, 1, 16, 11, 2, 1, 3};
static oid protocolDirDescr[] = {1, 3, 6, 1, 2, 1, 16, 11, 2, 1, 4};
static oid protocolDirType[] = {1, 3, 6, 1, 2, 1, 16, 11, 2, 1, 5};
static oid protocolDirAddressMapConfig[] = {1, 3, 6, 1, 2, 1, 16, 11, 2, 1, 6};
static oid protocolDirHostConfig[] = {1, 3, 6, 1, 2, 1, 16, 11, 2, 1, 7};
static oid protocolDirMatrixConfig[] = {1, 3, 6, 1, 2, 1, 16, 11, 2, 1, 8};
static oid protocolDirOwner[] = {1, 3, 6, 1, 2, 1, 16, 11, 2, 1, 9};
static oid protocolDirStatus[] = {1, 3, 6, 1, 2, 1, 16, 11, 2, 1, 10};
static oid protocolDistControlIndex[] = {1, 3, 6, 1, 2, 1, 16, 12, 1, 1, 1};
static oid protocolDistControlDataSource[] = {1, 3, 6, 1, 2, 1, 16, 12, 1, 1, 2};
static oid protocolDistControlDroppedFrames[] = {1, 3, 6, 1, 2, 1, 16, 12, 1, 1, 3};
static oid protocolDistControlCreateTime[] = {1, 3, 6, 1, 2, 1, 16, 12, 1, 1, 4};
static oid protocolDistControlOwner[] = {1, 3, 6, 1, 2, 1, 16, 12, 1, 1, 5};
static oid protocolDistControlStatus[] = {1, 3, 6, 1, 2, 1, 16, 12, 1, 1, 6};
static oid protocolDistStatsPkts[] = {1, 3, 6, 1, 2, 1, 16, 12, 2, 1, 1};
static oid protocolDistStatsOctets[] = {1, 3, 6, 1, 2, 1, 16, 12, 2, 1, 2};
static oid addressMapInserts[] = {1, 3, 6, 1, 2, 1, 16, 13, 1};
static oid addressMapDeletes[] = {1, 3, 6, 1, 2, 1, 16, 13, 2};
static oid addressMapMaxDesiredEntries[] = {1, 3, 6, 1, 2, 1, 16, 13, 3};
static oid addressMapControlIndex[] = {1, 3, 6, 1, 2, 1, 16, 13, 4, 1, 1};
static oid addressMapControlDataSource[] = {1, 3, 6, 1, 2, 1, 16, 13, 4, 1, 2};
static oid addressMapControlDroppedFrames[] = {1, 3, 6, 1, 2, 1, 16, 13, 4, 1, 3};
static oid addressMapControlOwner[] = {1, 3, 6, 1, 2, 1, 16, 13, 4, 1, 4};
static oid addressMapControlStatus[] = {1, 3, 6, 1, 2, 1, 16, 13, 4, 1, 5};
static oid addressMapTimeMark[] = {1, 3, 6, 1, 2, 1, 16, 13, 5, 1, 1};
static oid addressMapNetworkAddress[] = {1, 3, 6, 1, 2, 1, 16, 13, 5, 1, 2};
static oid addressMapSource[] = {1, 3, 6, 1, 2, 1, 16, 13, 5, 1, 3};
static oid addressMapPhysicalAddress[] = {1, 3, 6, 1, 2, 1, 16, 13, 5, 1, 4};
static oid addressMapLastChange[] = {1, 3, 6, 1, 2, 1, 16, 13, 5, 1, 5};
static oid hlHostControlIndex[] = {1, 3, 6, 1, 2, 1, 16, 14, 1, 1, 1};
static oid hlHostControlDataSource[] = {1, 3, 6, 1, 2, 1, 16, 14, 1, 1, 2};
static oid hlHostControlNlDroppedFrames[] = {1, 3, 6, 1, 2, 1, 16, 14, 1, 1, 3};
static oid hlHostControlNlInserts[] = {1, 3, 6, 1, 2, 1, 16, 14, 1, 1, 4};
static oid hlHostControlNlDeletes[] = {1, 3, 6, 1, 2, 1, 16, 14, 1, 1, 5};
static oid hlHostControlNlMaxDesiredEntries[] = {1, 3, 6, 1, 2, 1, 16, 14, 1, 1, 6};
static oid hlHostControlAlDroppedFrames[] = {1, 3, 6, 1, 2, 1, 16, 14, 1, 1, 7};
static oid hlHostControlAlInserts[] = {1, 3, 6, 1, 2, 1, 16, 14, 1, 1, 8};
static oid hlHostControlAlDeletes[] = {1, 3, 6, 1, 2, 1, 16, 14, 1, 1, 9};
static oid hlHostControlAlMaxDesiredEntries[] = {1, 3, 6, 1, 2, 1, 16, 14, 1, 1, 10};
static oid hlHostControlOwner[] = {1, 3, 6, 1, 2, 1, 16, 14, 1, 1, 11};
static oid hlHostControlStatus[] = {1, 3, 6, 1, 2, 1, 16, 14, 1, 1, 12};
static oid nlHostTimeMark[] = {1, 3, 6, 1, 2, 1, 16, 14, 2, 1, 1};
static oid nlHostAddress[] = {1, 3, 6, 1, 2, 1, 16, 14, 2, 1, 2};
static oid nlHostInPkts[] = {1, 3, 6, 1, 2, 1, 16, 14, 2, 1, 3};
static oid nlHostOutPkts[] = {1, 3, 6, 1, 2, 1, 16, 14, 2, 1, 4};
static oid nlHostInOctets[] = {1, 3, 6, 1, 2, 1, 16, 14, 2, 1, 5};
static oid nlHostOutOctets[] = {1, 3, 6, 1, 2, 1, 16, 14, 2, 1, 6};
static oid nlHostOutMacNonUnicastPkts[] = {1, 3, 6, 1, 2, 1, 16, 14, 2, 1, 7};
static oid nlHostCreateTime[] = {1, 3, 6, 1, 2, 1, 16, 14, 2, 1, 8};
static oid hlMatrixControlIndex[] = {1, 3, 6, 1, 2, 1, 16, 15, 1, 1, 1};
static oid hlMatrixControlDataSource[] = {1, 3, 6, 1, 2, 1, 16, 15, 1, 1, 2};
static oid hlMatrixControlNlDroppedFrames[] = {1, 3, 6, 1, 2, 1, 16, 15, 1, 1, 3};
static oid hlMatrixControlNlInserts[] = {1, 3, 6, 1, 2, 1, 16, 15, 1, 1, 4};
static oid hlMatrixControlNlDeletes[] = {1, 3, 6, 1, 2, 1, 16, 15, 1, 1, 5};
static oid hlMatrixControlNlMaxDesiredEntries[] = {1, 3, 6, 1, 2, 1, 16, 15, 1, 1, 6};
static oid hlMatrixControlAlDroppedFrames[] = {1, 3, 6, 1, 2, 1, 16, 15, 1, 1, 7};
static oid hlMatrixControlAlInserts[] = {1, 3, 6, 1, 2, 1, 16, 15, 1, 1, 8};
static oid hlMatrixControlAlDeletes[] = {1, 3, 6, 1, 2, 1, 16, 15, 1, 1, 9};
static oid hlMatrixControlAlMaxDesiredEntries[] = {1, 3, 6, 1, 2, 1, 16, 15, 1, 1, 10};
static oid hlMatrixControlOwner[] = {1, 3, 6, 1, 2, 1, 16, 15, 1, 1, 11};
static oid hlMatrixControlStatus[] = {1, 3, 6, 1, 2, 1, 16, 15, 1, 1, 12};
static oid nlMatrixSDTimeMark[] = {1, 3, 6, 1, 2, 1, 16, 15, 2, 1, 1};
static oid nlMatrixSDSourceAddress[] = {1, 3, 6, 1, 2, 1, 16, 15, 2, 1, 2};
static oid nlMatrixSDDestAddress[] = {1, 3, 6, 1, 2, 1, 16, 15, 2, 1, 3};
static oid nlMatrixSDPkts[] = {1, 3, 6, 1, 2, 1, 16, 15, 2, 1, 4};
static oid nlMatrixSDOctets[] = {1, 3, 6, 1, 2, 1, 16, 15, 2, 1, 5};
static oid nlMatrixSDCreateTime[] = {1, 3, 6, 1, 2, 1, 16, 15, 2, 1, 6};
static oid nlMatrixDSTimeMark[] = {1, 3, 6, 1, 2, 1, 16, 15, 3, 1, 1};
static oid nlMatrixDSSourceAddress[] = {1, 3, 6, 1, 2, 1, 16, 15, 3, 1, 2};
static oid nlMatrixDSDestAddress[] = {1, 3, 6, 1, 2, 1, 16, 15, 3, 1, 3};
static oid nlMatrixDSPkts[] = {1, 3, 6, 1, 2, 1, 16, 15, 3, 1, 4};
static oid nlMatrixDSOctets[] = {1, 3, 6, 1, 2, 1, 16, 15, 3, 1, 5};
static oid nlMatrixDSCreateTime[] = {1, 3, 6, 1, 2, 1, 16, 15, 3, 1, 6};
static oid nlMatrixTopNControlIndex[] = {1, 3, 6, 1, 2, 1, 16, 15, 4, 1, 1};
static oid nlMatrixTopNControlMatrixIndex[] = {1, 3, 6, 1, 2, 1, 16, 15, 4, 1, 2};
static oid nlMatrixTopNControlRateBase[] = {1, 3, 6, 1, 2, 1, 16, 15, 4, 1, 3};
static oid nlMatrixTopNControlTimeRemaining[] = {1, 3, 6, 1, 2, 1, 16, 15, 4, 1, 4};
static oid nlMatrixTopNControlGeneratedReports[] = {1, 3, 6, 1, 2, 1, 16, 15, 4, 1, 5};
static oid nlMatrixTopNControlDuration[] = {1, 3, 6, 1, 2, 1, 16, 15, 4, 1, 6};
static oid nlMatrixTopNControlRequestedSize[] = {1, 3, 6, 1, 2, 1, 16, 15, 4, 1, 7};
static oid nlMatrixTopNControlGrantedSize[] = {1, 3, 6, 1, 2, 1, 16, 15, 4, 1, 8};
static oid nlMatrixTopNControlStartTime[] = {1, 3, 6, 1, 2, 1, 16, 15, 4, 1, 9};
static oid nlMatrixTopNControlOwner[] = {1, 3, 6, 1, 2, 1, 16, 15, 4, 1, 10};
static oid nlMatrixTopNControlStatus[] = {1, 3, 6, 1, 2, 1, 16, 15, 4, 1, 11};
static oid nlMatrixTopNIndex[] = {1, 3, 6, 1, 2, 1, 16, 15, 5, 1, 1};
static oid nlMatrixTopNProtocolDirLocalIndex[] = {1, 3, 6, 1, 2, 1, 16, 15, 5, 1, 2};
static oid nlMatrixTopNSourceAddress[] = {1, 3, 6, 1, 2, 1, 16, 15, 5, 1, 3};
static oid nlMatrixTopNDestAddress[] = {1, 3, 6, 1, 2, 1, 16, 15, 5, 1, 4};
static oid nlMatrixTopNPktRate[] = {1, 3, 6, 1, 2, 1, 16, 15, 5, 1, 5};
static oid nlMatrixTopNReversePktRate[] = {1, 3, 6, 1, 2, 1, 16, 15, 5, 1, 6};
static oid nlMatrixTopNOctetRate[] = {1, 3, 6, 1, 2, 1, 16, 15, 5, 1, 7};
static oid nlMatrixTopNReverseOctetRate[] = {1, 3, 6, 1, 2, 1, 16, 15, 5, 1, 8};
static oid alHostTimeMark[] = {1, 3, 6, 1, 2, 1, 16, 16, 1, 1, 1};
static oid alHostInPkts[] = {1, 3, 6, 1, 2, 1, 16, 16, 1, 1, 2};
static oid alHostOutPkts[] = {1, 3, 6, 1, 2, 1, 16, 16, 1, 1, 3};
static oid alHostInOctets[] = {1, 3, 6, 1, 2, 1, 16, 16, 1, 1, 4};
static oid alHostOutOctets[] = {1, 3, 6, 1, 2, 1, 16, 16, 1, 1, 5};
static oid alHostCreateTime[] = {1, 3, 6, 1, 2, 1, 16, 16, 1, 1, 6};
static oid alMatrixSDTimeMark[] = {1, 3, 6, 1, 2, 1, 16, 17, 1, 1, 1};
static oid alMatrixSDPkts[] = {1, 3, 6, 1, 2, 1, 16, 17, 1, 1, 2};
static oid alMatrixSDOctets[] = {1, 3, 6, 1, 2, 1, 16, 17, 1, 1, 3};
static oid alMatrixSDCreateTime[] = {1, 3, 6, 1, 2, 1, 16, 17, 1, 1, 4};
static oid alMatrixDSTimeMark[] = {1, 3, 6, 1, 2, 1, 16, 17, 2, 1, 1};
static oid alMatrixDSPkts[] = {1, 3, 6, 1, 2, 1, 16, 17, 2, 1, 2};
static oid alMatrixDSOctets[] = {1, 3, 6, 1, 2, 1, 16, 17, 2, 1, 3};
static oid alMatrixDSCreateTime[] = {1, 3, 6, 1, 2, 1, 16, 17, 2, 1, 4};
static oid alMatrixTopNControlIndex[] = {1, 3, 6, 1, 2, 1, 16, 17, 3, 1, 1};
static oid alMatrixTopNControlMatrixIndex[] = {1, 3, 6, 1, 2, 1, 16, 17, 3, 1, 2};
static oid alMatrixTopNControlRateBase[] = {1, 3, 6, 1, 2, 1, 16, 17, 3, 1, 3};
static oid alMatrixTopNControlTimeRemaining[] = {1, 3, 6, 1, 2, 1, 16, 17, 3, 1, 4};
static oid alMatrixTopNControlGeneratedReports[] = {1, 3, 6, 1, 2, 1, 16, 17, 3, 1, 5};
static oid alMatrixTopNControlDuration[] = {1, 3, 6, 1, 2, 1, 16, 17, 3, 1, 6};
static oid alMatrixTopNControlRequestedSize[] = {1, 3, 6, 1, 2, 1, 16, 17, 3, 1, 7};
static oid alMatrixTopNControlGrantedSize[] = {1, 3, 6, 1, 2, 1, 16, 17, 3, 1, 8};
static oid alMatrixTopNControlStartTime[] = {1, 3, 6, 1, 2, 1, 16, 17, 3, 1, 9};
static oid alMatrixTopNControlOwner[] = {1, 3, 6, 1, 2, 1, 16, 17, 3, 1, 10};
static oid alMatrixTopNControlStatus[] = {1, 3, 6, 1, 2, 1, 16, 17, 3, 1, 11};
static oid alMatrixTopNIndex[] = {1, 3, 6, 1, 2, 1, 16, 17, 4, 1, 1};
static oid alMatrixTopNProtocolDirLocalIndex[] = {1, 3, 6, 1, 2, 1, 16, 17, 4, 1, 2};
static oid alMatrixTopNSourceAddress[] = {1, 3, 6, 1, 2, 1, 16, 17, 4, 1, 3};
static oid alMatrixTopNDestAddress[] = {1, 3, 6, 1, 2, 1, 16, 17, 4, 1, 4};
static oid alMatrixTopNAppProtocolDirLocalIndex[] = {1, 3, 6, 1, 2, 1, 16, 17, 4, 1, 5};
static oid alMatrixTopNPktRate[] = {1, 3, 6, 1, 2, 1, 16, 17, 4, 1, 6};
static oid alMatrixTopNReversePktRate[] = {1, 3, 6, 1, 2, 1, 16, 17, 4, 1, 7};
static oid alMatrixTopNOctetRate[] = {1, 3, 6, 1, 2, 1, 16, 17, 4, 1, 8};
static oid alMatrixTopNReverseOctetRate[] = {1, 3, 6, 1, 2, 1, 16, 17, 4, 1, 9};
static oid usrHistoryControlIndex[] = {1, 3, 6, 1, 2, 1, 16, 18, 1, 1, 1};
static oid usrHistoryControlObjects[] = {1, 3, 6, 1, 2, 1, 16, 18, 1, 1, 2};
static oid usrHistoryControlBucketsRequested[] = {1, 3, 6, 1, 2, 1, 16, 18, 1, 1, 3};
static oid usrHistoryControlBucketsGranted[] = {1, 3, 6, 1, 2, 1, 16, 18, 1, 1, 4};
static oid usrHistoryControlInterval[] = {1, 3, 6, 1, 2, 1, 16, 18, 1, 1, 5};
static oid usrHistoryControlOwner[] = {1, 3, 6, 1, 2, 1, 16, 18, 1, 1, 6};
static oid usrHistoryControlStatus[] = {1, 3, 6, 1, 2, 1, 16, 18, 1, 1, 7};
static oid usrHistoryObjectIndex[] = {1, 3, 6, 1, 2, 1, 16, 18, 2, 1, 1};
static oid usrHistoryObjectVariable[] = {1, 3, 6, 1, 2, 1, 16, 18, 2, 1, 2};
static oid usrHistoryObjectSampleType[] = {1, 3, 6, 1, 2, 1, 16, 18, 2, 1, 3};
static oid usrHistorySampleIndex[] = {1, 3, 6, 1, 2, 1, 16, 18, 3, 1, 1};
static oid usrHistoryIntervalStart[] = {1, 3, 6, 1, 2, 1, 16, 18, 3, 1, 2};
static oid usrHistoryIntervalEnd[] = {1, 3, 6, 1, 2, 1, 16, 18, 3, 1, 3};
static oid usrHistoryAbsValue[] = {1, 3, 6, 1, 2, 1, 16, 18, 3, 1, 4};
static oid usrHistoryValStatus[] = {1, 3, 6, 1, 2, 1, 16, 18, 3, 1, 5};
static oid probeCapabilities[] = {1, 3, 6, 1, 2, 1, 16, 19, 1};
static oid probeSoftwareRev[] = {1, 3, 6, 1, 2, 1, 16, 19, 2};
static oid probeHardwareRev[] = {1, 3, 6, 1, 2, 1, 16, 19, 3};
static oid probeDateTime[] = {1, 3, 6, 1, 2, 1, 16, 19, 4};
static oid probeResetControl[] = {1, 3, 6, 1, 2, 1, 16, 19, 5};
static oid probeDownloadFile[] = {1, 3, 6, 1, 2, 1, 16, 19, 6};
static oid probeDownloadTFTPServer[] = {1, 3, 6, 1, 2, 1, 16, 19, 7};
static oid probeDownloadAction[] = {1, 3, 6, 1, 2, 1, 16, 19, 8};
static oid probeDownloadStatus[] = {1, 3, 6, 1, 2, 1, 16, 19, 9};
static oid serialMode[] = {1, 3, 6, 1, 2, 1, 16, 19, 10, 1, 1};
static oid serialProtocol[] = {1, 3, 6, 1, 2, 1, 16, 19, 10, 1, 2};
static oid serialTimeout[] = {1, 3, 6, 1, 2, 1, 16, 19, 10, 1, 3};
static oid serialModemInitString[] = {1, 3, 6, 1, 2, 1, 16, 19, 10, 1, 4};
static oid serialModemHangUpString[] = {1, 3, 6, 1, 2, 1, 16, 19, 10, 1, 5};
static oid serialModemConnectResp[] = {1, 3, 6, 1, 2, 1, 16, 19, 10, 1, 6};
static oid serialModemNoConnectResp[] = {1, 3, 6, 1, 2, 1, 16, 19, 10, 1, 7};
static oid serialDialoutTimeout[] = {1, 3, 6, 1, 2, 1, 16, 19, 10, 1, 8};
static oid serialStatus[] = {1, 3, 6, 1, 2, 1, 16, 19, 10, 1, 9};
static oid netConfigIPAddress[] = {1, 3, 6, 1, 2, 1, 16, 19, 11, 1, 1};
static oid netConfigSubnetMask[] = {1, 3, 6, 1, 2, 1, 16, 19, 11, 1, 2};
static oid netConfigStatus[] = {1, 3, 6, 1, 2, 1, 16, 19, 11, 1, 3};
static oid netDefaultGateway[] = {1, 3, 6, 1, 2, 1, 16, 19, 12};
static oid trapDestIndex[] = {1, 3, 6, 1, 2, 1, 16, 19, 13, 1, 1};
static oid trapDestCommunity[] = {1, 3, 6, 1, 2, 1, 16, 19, 13, 1, 2};
static oid trapDestProtocol[] = {1, 3, 6, 1, 2, 1, 16, 19, 13, 1, 3};
static oid trapDestAddress[] = {1, 3, 6, 1, 2, 1, 16, 19, 13, 1, 4};
static oid trapDestOwner[] = {1, 3, 6, 1, 2, 1, 16, 19, 13, 1, 5};
static oid trapDestStatus[] = {1, 3, 6, 1, 2, 1, 16, 19, 13, 1, 6};
static oid serialConnectIndex[] = {1, 3, 6, 1, 2, 1, 16, 19, 14, 1, 1};
static oid serialConnectDestIpAddress[] = {1, 3, 6, 1, 2, 1, 16, 19, 14, 1, 2};
static oid serialConnectType[] = {1, 3, 6, 1, 2, 1, 16, 19, 14, 1, 3};
static oid serialConnectDialString[] = {1, 3, 6, 1, 2, 1, 16, 19, 14, 1, 4};
static oid serialConnectSwitchConnectSeq[] = {1, 3, 6, 1, 2, 1, 16, 19, 14, 1, 5};
static oid serialConnectSwitchDisconnectSeq[] = {1, 3, 6, 1, 2, 1, 16, 19, 14, 1, 6};
static oid serialConnectSwitchResetSeq[] = {1, 3, 6, 1, 2, 1, 16, 19, 14, 1, 7};
static oid serialConnectOwner[] = {1, 3, 6, 1, 2, 1, 16, 19, 14, 1, 8};
static oid serialConnectStatus[] = {1, 3, 6, 1, 2, 1, 16, 19, 14, 1, 9};

int rmon2_mib_mgr_get_etherStats2Entry(struct snmp_session *s, etherStats2Entry_t **etherStats2Entry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, etherStatsDroppedFrames, sizeof(etherStatsDroppedFrames)/sizeof(oid));
    snmp_add_null_var(request, etherStatsCreateTime, sizeof(etherStatsCreateTime)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        return -2;
    }

    *etherStats2Entry = (etherStats2Entry_t *) malloc(sizeof(etherStats2Entry_t));
    if (! *etherStats2Entry) {
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(etherStatsDroppedFrames)/sizeof(oid)
            && memcmp(vars->name, etherStatsDroppedFrames, sizeof(etherStatsDroppedFrames)) == 0) {
            (*etherStats2Entry)->__etherStatsDroppedFrames = *vars->val.integer;
            (*etherStats2Entry)->etherStatsDroppedFrames = &((*etherStats2Entry)->__etherStatsDroppedFrames);
        }
        if (vars->name_length > sizeof(etherStatsCreateTime)/sizeof(oid)
            && memcmp(vars->name, etherStatsCreateTime, sizeof(etherStatsCreateTime)) == 0) {
            (*etherStats2Entry)->__etherStatsCreateTime = *vars->val.integer;
            (*etherStats2Entry)->etherStatsCreateTime = &((*etherStats2Entry)->__etherStatsCreateTime);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int rmon2_mib_mgr_get_tokenRingMLStats2Entry(struct snmp_session *s, tokenRingMLStats2Entry_t **tokenRingMLStats2Entry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, tokenRingMLStatsDroppedFrames, sizeof(tokenRingMLStatsDroppedFrames)/sizeof(oid));
    snmp_add_null_var(request, tokenRingMLStatsCreateTime, sizeof(tokenRingMLStatsCreateTime)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        return -2;
    }

    *tokenRingMLStats2Entry = (tokenRingMLStats2Entry_t *) malloc(sizeof(tokenRingMLStats2Entry_t));
    if (! *tokenRingMLStats2Entry) {
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(tokenRingMLStatsDroppedFrames)/sizeof(oid)
            && memcmp(vars->name, tokenRingMLStatsDroppedFrames, sizeof(tokenRingMLStatsDroppedFrames)) == 0) {
            (*tokenRingMLStats2Entry)->__tokenRingMLStatsDroppedFrames = *vars->val.integer;
            (*tokenRingMLStats2Entry)->tokenRingMLStatsDroppedFrames = &((*tokenRingMLStats2Entry)->__tokenRingMLStatsDroppedFrames);
        }
        if (vars->name_length > sizeof(tokenRingMLStatsCreateTime)/sizeof(oid)
            && memcmp(vars->name, tokenRingMLStatsCreateTime, sizeof(tokenRingMLStatsCreateTime)) == 0) {
            (*tokenRingMLStats2Entry)->__tokenRingMLStatsCreateTime = *vars->val.integer;
            (*tokenRingMLStats2Entry)->tokenRingMLStatsCreateTime = &((*tokenRingMLStats2Entry)->__tokenRingMLStatsCreateTime);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int rmon2_mib_mgr_get_tokenRingPStats2Entry(struct snmp_session *s, tokenRingPStats2Entry_t **tokenRingPStats2Entry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, tokenRingPStatsDroppedFrames, sizeof(tokenRingPStatsDroppedFrames)/sizeof(oid));
    snmp_add_null_var(request, tokenRingPStatsCreateTime, sizeof(tokenRingPStatsCreateTime)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        return -2;
    }

    *tokenRingPStats2Entry = (tokenRingPStats2Entry_t *) malloc(sizeof(tokenRingPStats2Entry_t));
    if (! *tokenRingPStats2Entry) {
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(tokenRingPStatsDroppedFrames)/sizeof(oid)
            && memcmp(vars->name, tokenRingPStatsDroppedFrames, sizeof(tokenRingPStatsDroppedFrames)) == 0) {
            (*tokenRingPStats2Entry)->__tokenRingPStatsDroppedFrames = *vars->val.integer;
            (*tokenRingPStats2Entry)->tokenRingPStatsDroppedFrames = &((*tokenRingPStats2Entry)->__tokenRingPStatsDroppedFrames);
        }
        if (vars->name_length > sizeof(tokenRingPStatsCreateTime)/sizeof(oid)
            && memcmp(vars->name, tokenRingPStatsCreateTime, sizeof(tokenRingPStatsCreateTime)) == 0) {
            (*tokenRingPStats2Entry)->__tokenRingPStatsCreateTime = *vars->val.integer;
            (*tokenRingPStats2Entry)->tokenRingPStatsCreateTime = &((*tokenRingPStats2Entry)->__tokenRingPStatsCreateTime);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int rmon2_mib_mgr_get_historyControl2Entry(struct snmp_session *s, historyControl2Entry_t **historyControl2Entry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, historyControlDroppedFrames, sizeof(historyControlDroppedFrames)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        return -2;
    }

    *historyControl2Entry = (historyControl2Entry_t *) malloc(sizeof(historyControl2Entry_t));
    if (! *historyControl2Entry) {
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(historyControlDroppedFrames)/sizeof(oid)
            && memcmp(vars->name, historyControlDroppedFrames, sizeof(historyControlDroppedFrames)) == 0) {
            (*historyControl2Entry)->__historyControlDroppedFrames = *vars->val.integer;
            (*historyControl2Entry)->historyControlDroppedFrames = &((*historyControl2Entry)->__historyControlDroppedFrames);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int rmon2_mib_mgr_get_hostControl2Entry(struct snmp_session *s, hostControl2Entry_t **hostControl2Entry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, hostControlDroppedFrames, sizeof(hostControlDroppedFrames)/sizeof(oid));
    snmp_add_null_var(request, hostControlCreateTime, sizeof(hostControlCreateTime)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        return -2;
    }

    *hostControl2Entry = (hostControl2Entry_t *) malloc(sizeof(hostControl2Entry_t));
    if (! *hostControl2Entry) {
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(hostControlDroppedFrames)/sizeof(oid)
            && memcmp(vars->name, hostControlDroppedFrames, sizeof(hostControlDroppedFrames)) == 0) {
            (*hostControl2Entry)->__hostControlDroppedFrames = *vars->val.integer;
            (*hostControl2Entry)->hostControlDroppedFrames = &((*hostControl2Entry)->__hostControlDroppedFrames);
        }
        if (vars->name_length > sizeof(hostControlCreateTime)/sizeof(oid)
            && memcmp(vars->name, hostControlCreateTime, sizeof(hostControlCreateTime)) == 0) {
            (*hostControl2Entry)->__hostControlCreateTime = *vars->val.integer;
            (*hostControl2Entry)->hostControlCreateTime = &((*hostControl2Entry)->__hostControlCreateTime);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int rmon2_mib_mgr_get_matrixControl2Entry(struct snmp_session *s, matrixControl2Entry_t **matrixControl2Entry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, matrixControlDroppedFrames, sizeof(matrixControlDroppedFrames)/sizeof(oid));
    snmp_add_null_var(request, matrixControlCreateTime, sizeof(matrixControlCreateTime)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        return -2;
    }

    *matrixControl2Entry = (matrixControl2Entry_t *) malloc(sizeof(matrixControl2Entry_t));
    if (! *matrixControl2Entry) {
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(matrixControlDroppedFrames)/sizeof(oid)
            && memcmp(vars->name, matrixControlDroppedFrames, sizeof(matrixControlDroppedFrames)) == 0) {
            (*matrixControl2Entry)->__matrixControlDroppedFrames = *vars->val.integer;
            (*matrixControl2Entry)->matrixControlDroppedFrames = &((*matrixControl2Entry)->__matrixControlDroppedFrames);
        }
        if (vars->name_length > sizeof(matrixControlCreateTime)/sizeof(oid)
            && memcmp(vars->name, matrixControlCreateTime, sizeof(matrixControlCreateTime)) == 0) {
            (*matrixControl2Entry)->__matrixControlCreateTime = *vars->val.integer;
            (*matrixControl2Entry)->matrixControlCreateTime = &((*matrixControl2Entry)->__matrixControlCreateTime);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int rmon2_mib_mgr_get_channel2Entry(struct snmp_session *s, channel2Entry_t **channel2Entry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, channelDroppedFrames, sizeof(channelDroppedFrames)/sizeof(oid));
    snmp_add_null_var(request, channelCreateTime, sizeof(channelCreateTime)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        return -2;
    }

    *channel2Entry = (channel2Entry_t *) malloc(sizeof(channel2Entry_t));
    if (! *channel2Entry) {
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(channelDroppedFrames)/sizeof(oid)
            && memcmp(vars->name, channelDroppedFrames, sizeof(channelDroppedFrames)) == 0) {
            (*channel2Entry)->__channelDroppedFrames = *vars->val.integer;
            (*channel2Entry)->channelDroppedFrames = &((*channel2Entry)->__channelDroppedFrames);
        }
        if (vars->name_length > sizeof(channelCreateTime)/sizeof(oid)
            && memcmp(vars->name, channelCreateTime, sizeof(channelCreateTime)) == 0) {
            (*channel2Entry)->__channelCreateTime = *vars->val.integer;
            (*channel2Entry)->channelCreateTime = &((*channel2Entry)->__channelCreateTime);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int rmon2_mib_mgr_get_filter2Entry(struct snmp_session *s, filter2Entry_t **filter2Entry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, filterProtocolDirDataLocalIndex, sizeof(filterProtocolDirDataLocalIndex)/sizeof(oid));
    snmp_add_null_var(request, filterProtocolDirLocalIndex, sizeof(filterProtocolDirLocalIndex)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        return -2;
    }

    *filter2Entry = (filter2Entry_t *) malloc(sizeof(filter2Entry_t));
    if (! *filter2Entry) {
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(filterProtocolDirDataLocalIndex)/sizeof(oid)
            && memcmp(vars->name, filterProtocolDirDataLocalIndex, sizeof(filterProtocolDirDataLocalIndex)) == 0) {
            (*filter2Entry)->__filterProtocolDirDataLocalIndex = *vars->val.integer;
            (*filter2Entry)->filterProtocolDirDataLocalIndex = &((*filter2Entry)->__filterProtocolDirDataLocalIndex);
        }
        if (vars->name_length > sizeof(filterProtocolDirLocalIndex)/sizeof(oid)
            && memcmp(vars->name, filterProtocolDirLocalIndex, sizeof(filterProtocolDirLocalIndex)) == 0) {
            (*filter2Entry)->__filterProtocolDirLocalIndex = *vars->val.integer;
            (*filter2Entry)->filterProtocolDirLocalIndex = &((*filter2Entry)->__filterProtocolDirLocalIndex);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int rmon2_mib_mgr_get_ringStationControl2Entry(struct snmp_session *s, ringStationControl2Entry_t **ringStationControl2Entry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, ringStationControlDroppedFrames, sizeof(ringStationControlDroppedFrames)/sizeof(oid));
    snmp_add_null_var(request, ringStationControlCreateTime, sizeof(ringStationControlCreateTime)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        return -2;
    }

    *ringStationControl2Entry = (ringStationControl2Entry_t *) malloc(sizeof(ringStationControl2Entry_t));
    if (! *ringStationControl2Entry) {
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(ringStationControlDroppedFrames)/sizeof(oid)
            && memcmp(vars->name, ringStationControlDroppedFrames, sizeof(ringStationControlDroppedFrames)) == 0) {
            (*ringStationControl2Entry)->__ringStationControlDroppedFrames = *vars->val.integer;
            (*ringStationControl2Entry)->ringStationControlDroppedFrames = &((*ringStationControl2Entry)->__ringStationControlDroppedFrames);
        }
        if (vars->name_length > sizeof(ringStationControlCreateTime)/sizeof(oid)
            && memcmp(vars->name, ringStationControlCreateTime, sizeof(ringStationControlCreateTime)) == 0) {
            (*ringStationControl2Entry)->__ringStationControlCreateTime = *vars->val.integer;
            (*ringStationControl2Entry)->ringStationControlCreateTime = &((*ringStationControl2Entry)->__ringStationControlCreateTime);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int rmon2_mib_mgr_get_sourceRoutingStats2Entry(struct snmp_session *s, sourceRoutingStats2Entry_t **sourceRoutingStats2Entry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, sourceRoutingStatsDroppedFrames, sizeof(sourceRoutingStatsDroppedFrames)/sizeof(oid));
    snmp_add_null_var(request, sourceRoutingStatsCreateTime, sizeof(sourceRoutingStatsCreateTime)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        return -2;
    }

    *sourceRoutingStats2Entry = (sourceRoutingStats2Entry_t *) malloc(sizeof(sourceRoutingStats2Entry_t));
    if (! *sourceRoutingStats2Entry) {
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(sourceRoutingStatsDroppedFrames)/sizeof(oid)
            && memcmp(vars->name, sourceRoutingStatsDroppedFrames, sizeof(sourceRoutingStatsDroppedFrames)) == 0) {
            (*sourceRoutingStats2Entry)->__sourceRoutingStatsDroppedFrames = *vars->val.integer;
            (*sourceRoutingStats2Entry)->sourceRoutingStatsDroppedFrames = &((*sourceRoutingStats2Entry)->__sourceRoutingStatsDroppedFrames);
        }
        if (vars->name_length > sizeof(sourceRoutingStatsCreateTime)/sizeof(oid)
            && memcmp(vars->name, sourceRoutingStatsCreateTime, sizeof(sourceRoutingStatsCreateTime)) == 0) {
            (*sourceRoutingStats2Entry)->__sourceRoutingStatsCreateTime = *vars->val.integer;
            (*sourceRoutingStats2Entry)->sourceRoutingStatsCreateTime = &((*sourceRoutingStats2Entry)->__sourceRoutingStatsCreateTime);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int rmon2_mib_mgr_get_protocolDir(struct snmp_session *s, protocolDir_t **protocolDir)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, protocolDirLastChange, sizeof(protocolDirLastChange)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        return -2;
    }

    *protocolDir = (protocolDir_t *) malloc(sizeof(protocolDir_t));
    if (! *protocolDir) {
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(protocolDirLastChange)/sizeof(oid)
            && memcmp(vars->name, protocolDirLastChange, sizeof(protocolDirLastChange)) == 0) {
            (*protocolDir)->__protocolDirLastChange = *vars->val.integer;
            (*protocolDir)->protocolDirLastChange = &((*protocolDir)->__protocolDirLastChange);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int rmon2_mib_mgr_get_protocolDirEntry(struct snmp_session *s, protocolDirEntry_t **protocolDirEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, protocolDirLocalIndex, sizeof(protocolDirLocalIndex)/sizeof(oid));
    snmp_add_null_var(request, protocolDirDescr, sizeof(protocolDirDescr)/sizeof(oid));
    snmp_add_null_var(request, protocolDirType, sizeof(protocolDirType)/sizeof(oid));
    snmp_add_null_var(request, protocolDirAddressMapConfig, sizeof(protocolDirAddressMapConfig)/sizeof(oid));
    snmp_add_null_var(request, protocolDirHostConfig, sizeof(protocolDirHostConfig)/sizeof(oid));
    snmp_add_null_var(request, protocolDirMatrixConfig, sizeof(protocolDirMatrixConfig)/sizeof(oid));
    snmp_add_null_var(request, protocolDirOwner, sizeof(protocolDirOwner)/sizeof(oid));
    snmp_add_null_var(request, protocolDirStatus, sizeof(protocolDirStatus)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        return -2;
    }

    *protocolDirEntry = (protocolDirEntry_t *) malloc(sizeof(protocolDirEntry_t));
    if (! *protocolDirEntry) {
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(protocolDirLocalIndex)/sizeof(oid)
            && memcmp(vars->name, protocolDirLocalIndex, sizeof(protocolDirLocalIndex)) == 0) {
            (*protocolDirEntry)->__protocolDirLocalIndex = *vars->val.integer;
            (*protocolDirEntry)->protocolDirLocalIndex = &((*protocolDirEntry)->__protocolDirLocalIndex);
        }
        if (vars->name_length > sizeof(protocolDirDescr)/sizeof(oid)
            && memcmp(vars->name, protocolDirDescr, sizeof(protocolDirDescr)) == 0) {
            memcpy((*protocolDirEntry)->__protocolDirDescr, vars->val.string, vars->val_len);
            (*protocolDirEntry)->_protocolDirDescrLength = vars->val_len;
            (*protocolDirEntry)->protocolDirDescr = (*protocolDirEntry)->__protocolDirDescr;
        }
        if (vars->name_length > sizeof(protocolDirType)/sizeof(oid)
            && memcmp(vars->name, protocolDirType, sizeof(protocolDirType)) == 0) {
            memcpy((*protocolDirEntry)->__protocolDirType, vars->val.string, vars->val_len);
            (*protocolDirEntry)->_protocolDirTypeLength = vars->val_len;
            (*protocolDirEntry)->protocolDirType = (*protocolDirEntry)->__protocolDirType;
        }
        if (vars->name_length > sizeof(protocolDirAddressMapConfig)/sizeof(oid)
            && memcmp(vars->name, protocolDirAddressMapConfig, sizeof(protocolDirAddressMapConfig)) == 0) {
            (*protocolDirEntry)->__protocolDirAddressMapConfig = *vars->val.integer;
            (*protocolDirEntry)->protocolDirAddressMapConfig = &((*protocolDirEntry)->__protocolDirAddressMapConfig);
        }
        if (vars->name_length > sizeof(protocolDirHostConfig)/sizeof(oid)
            && memcmp(vars->name, protocolDirHostConfig, sizeof(protocolDirHostConfig)) == 0) {
            (*protocolDirEntry)->__protocolDirHostConfig = *vars->val.integer;
            (*protocolDirEntry)->protocolDirHostConfig = &((*protocolDirEntry)->__protocolDirHostConfig);
        }
        if (vars->name_length > sizeof(protocolDirMatrixConfig)/sizeof(oid)
            && memcmp(vars->name, protocolDirMatrixConfig, sizeof(protocolDirMatrixConfig)) == 0) {
            (*protocolDirEntry)->__protocolDirMatrixConfig = *vars->val.integer;
            (*protocolDirEntry)->protocolDirMatrixConfig = &((*protocolDirEntry)->__protocolDirMatrixConfig);
        }
        if (vars->name_length > sizeof(protocolDirOwner)/sizeof(oid)
            && memcmp(vars->name, protocolDirOwner, sizeof(protocolDirOwner)) == 0) {
            memcpy((*protocolDirEntry)->__protocolDirOwner, vars->val.string, vars->val_len);
            (*protocolDirEntry)->_protocolDirOwnerLength = vars->val_len;
            (*protocolDirEntry)->protocolDirOwner = (*protocolDirEntry)->__protocolDirOwner;
        }
        if (vars->name_length > sizeof(protocolDirStatus)/sizeof(oid)
            && memcmp(vars->name, protocolDirStatus, sizeof(protocolDirStatus)) == 0) {
            (*protocolDirEntry)->__protocolDirStatus = *vars->val.integer;
            (*protocolDirEntry)->protocolDirStatus = &((*protocolDirEntry)->__protocolDirStatus);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int rmon2_mib_mgr_get_protocolDistControlEntry(struct snmp_session *s, protocolDistControlEntry_t **protocolDistControlEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, protocolDistControlDataSource, sizeof(protocolDistControlDataSource)/sizeof(oid));
    snmp_add_null_var(request, protocolDistControlDroppedFrames, sizeof(protocolDistControlDroppedFrames)/sizeof(oid));
    snmp_add_null_var(request, protocolDistControlCreateTime, sizeof(protocolDistControlCreateTime)/sizeof(oid));
    snmp_add_null_var(request, protocolDistControlOwner, sizeof(protocolDistControlOwner)/sizeof(oid));
    snmp_add_null_var(request, protocolDistControlStatus, sizeof(protocolDistControlStatus)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        return -2;
    }

    *protocolDistControlEntry = (protocolDistControlEntry_t *) malloc(sizeof(protocolDistControlEntry_t));
    if (! *protocolDistControlEntry) {
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(protocolDistControlDataSource)/sizeof(oid)
            && memcmp(vars->name, protocolDistControlDataSource, sizeof(protocolDistControlDataSource)) == 0) {
        }
        if (vars->name_length > sizeof(protocolDistControlDroppedFrames)/sizeof(oid)
            && memcmp(vars->name, protocolDistControlDroppedFrames, sizeof(protocolDistControlDroppedFrames)) == 0) {
            (*protocolDistControlEntry)->__protocolDistControlDroppedFrames = *vars->val.integer;
            (*protocolDistControlEntry)->protocolDistControlDroppedFrames = &((*protocolDistControlEntry)->__protocolDistControlDroppedFrames);
        }
        if (vars->name_length > sizeof(protocolDistControlCreateTime)/sizeof(oid)
            && memcmp(vars->name, protocolDistControlCreateTime, sizeof(protocolDistControlCreateTime)) == 0) {
            (*protocolDistControlEntry)->__protocolDistControlCreateTime = *vars->val.integer;
            (*protocolDistControlEntry)->protocolDistControlCreateTime = &((*protocolDistControlEntry)->__protocolDistControlCreateTime);
        }
        if (vars->name_length > sizeof(protocolDistControlOwner)/sizeof(oid)
            && memcmp(vars->name, protocolDistControlOwner, sizeof(protocolDistControlOwner)) == 0) {
            memcpy((*protocolDistControlEntry)->__protocolDistControlOwner, vars->val.string, vars->val_len);
            (*protocolDistControlEntry)->_protocolDistControlOwnerLength = vars->val_len;
            (*protocolDistControlEntry)->protocolDistControlOwner = (*protocolDistControlEntry)->__protocolDistControlOwner;
        }
        if (vars->name_length > sizeof(protocolDistControlStatus)/sizeof(oid)
            && memcmp(vars->name, protocolDistControlStatus, sizeof(protocolDistControlStatus)) == 0) {
            (*protocolDistControlEntry)->__protocolDistControlStatus = *vars->val.integer;
            (*protocolDistControlEntry)->protocolDistControlStatus = &((*protocolDistControlEntry)->__protocolDistControlStatus);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int rmon2_mib_mgr_get_protocolDistStatsEntry(struct snmp_session *s, protocolDistStatsEntry_t **protocolDistStatsEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, protocolDistStatsPkts, sizeof(protocolDistStatsPkts)/sizeof(oid));
    snmp_add_null_var(request, protocolDistStatsOctets, sizeof(protocolDistStatsOctets)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        return -2;
    }

    *protocolDistStatsEntry = (protocolDistStatsEntry_t *) malloc(sizeof(protocolDistStatsEntry_t));
    if (! *protocolDistStatsEntry) {
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(protocolDistStatsPkts)/sizeof(oid)
            && memcmp(vars->name, protocolDistStatsPkts, sizeof(protocolDistStatsPkts)) == 0) {
            (*protocolDistStatsEntry)->__protocolDistStatsPkts = *vars->val.integer;
            (*protocolDistStatsEntry)->protocolDistStatsPkts = &((*protocolDistStatsEntry)->__protocolDistStatsPkts);
        }
        if (vars->name_length > sizeof(protocolDistStatsOctets)/sizeof(oid)
            && memcmp(vars->name, protocolDistStatsOctets, sizeof(protocolDistStatsOctets)) == 0) {
            (*protocolDistStatsEntry)->__protocolDistStatsOctets = *vars->val.integer;
            (*protocolDistStatsEntry)->protocolDistStatsOctets = &((*protocolDistStatsEntry)->__protocolDistStatsOctets);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int rmon2_mib_mgr_get_addressMap(struct snmp_session *s, addressMap_t **addressMap)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, addressMapInserts, sizeof(addressMapInserts)/sizeof(oid));
    snmp_add_null_var(request, addressMapDeletes, sizeof(addressMapDeletes)/sizeof(oid));
    snmp_add_null_var(request, addressMapMaxDesiredEntries, sizeof(addressMapMaxDesiredEntries)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        return -2;
    }

    *addressMap = (addressMap_t *) malloc(sizeof(addressMap_t));
    if (! *addressMap) {
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(addressMapInserts)/sizeof(oid)
            && memcmp(vars->name, addressMapInserts, sizeof(addressMapInserts)) == 0) {
            (*addressMap)->__addressMapInserts = *vars->val.integer;
            (*addressMap)->addressMapInserts = &((*addressMap)->__addressMapInserts);
        }
        if (vars->name_length > sizeof(addressMapDeletes)/sizeof(oid)
            && memcmp(vars->name, addressMapDeletes, sizeof(addressMapDeletes)) == 0) {
            (*addressMap)->__addressMapDeletes = *vars->val.integer;
            (*addressMap)->addressMapDeletes = &((*addressMap)->__addressMapDeletes);
        }
        if (vars->name_length > sizeof(addressMapMaxDesiredEntries)/sizeof(oid)
            && memcmp(vars->name, addressMapMaxDesiredEntries, sizeof(addressMapMaxDesiredEntries)) == 0) {
            (*addressMap)->__addressMapMaxDesiredEntries = *vars->val.integer;
            (*addressMap)->addressMapMaxDesiredEntries = &((*addressMap)->__addressMapMaxDesiredEntries);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int rmon2_mib_mgr_get_addressMapControlEntry(struct snmp_session *s, addressMapControlEntry_t **addressMapControlEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, addressMapControlDataSource, sizeof(addressMapControlDataSource)/sizeof(oid));
    snmp_add_null_var(request, addressMapControlDroppedFrames, sizeof(addressMapControlDroppedFrames)/sizeof(oid));
    snmp_add_null_var(request, addressMapControlOwner, sizeof(addressMapControlOwner)/sizeof(oid));
    snmp_add_null_var(request, addressMapControlStatus, sizeof(addressMapControlStatus)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        return -2;
    }

    *addressMapControlEntry = (addressMapControlEntry_t *) malloc(sizeof(addressMapControlEntry_t));
    if (! *addressMapControlEntry) {
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(addressMapControlDataSource)/sizeof(oid)
            && memcmp(vars->name, addressMapControlDataSource, sizeof(addressMapControlDataSource)) == 0) {
        }
        if (vars->name_length > sizeof(addressMapControlDroppedFrames)/sizeof(oid)
            && memcmp(vars->name, addressMapControlDroppedFrames, sizeof(addressMapControlDroppedFrames)) == 0) {
            (*addressMapControlEntry)->__addressMapControlDroppedFrames = *vars->val.integer;
            (*addressMapControlEntry)->addressMapControlDroppedFrames = &((*addressMapControlEntry)->__addressMapControlDroppedFrames);
        }
        if (vars->name_length > sizeof(addressMapControlOwner)/sizeof(oid)
            && memcmp(vars->name, addressMapControlOwner, sizeof(addressMapControlOwner)) == 0) {
            memcpy((*addressMapControlEntry)->__addressMapControlOwner, vars->val.string, vars->val_len);
            (*addressMapControlEntry)->_addressMapControlOwnerLength = vars->val_len;
            (*addressMapControlEntry)->addressMapControlOwner = (*addressMapControlEntry)->__addressMapControlOwner;
        }
        if (vars->name_length > sizeof(addressMapControlStatus)/sizeof(oid)
            && memcmp(vars->name, addressMapControlStatus, sizeof(addressMapControlStatus)) == 0) {
            (*addressMapControlEntry)->__addressMapControlStatus = *vars->val.integer;
            (*addressMapControlEntry)->addressMapControlStatus = &((*addressMapControlEntry)->__addressMapControlStatus);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int rmon2_mib_mgr_get_addressMapEntry(struct snmp_session *s, addressMapEntry_t **addressMapEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, addressMapPhysicalAddress, sizeof(addressMapPhysicalAddress)/sizeof(oid));
    snmp_add_null_var(request, addressMapLastChange, sizeof(addressMapLastChange)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        return -2;
    }

    *addressMapEntry = (addressMapEntry_t *) malloc(sizeof(addressMapEntry_t));
    if (! *addressMapEntry) {
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(addressMapPhysicalAddress)/sizeof(oid)
            && memcmp(vars->name, addressMapPhysicalAddress, sizeof(addressMapPhysicalAddress)) == 0) {
            memcpy((*addressMapEntry)->__addressMapPhysicalAddress, vars->val.string, vars->val_len);
            (*addressMapEntry)->_addressMapPhysicalAddressLength = vars->val_len;
            (*addressMapEntry)->addressMapPhysicalAddress = (*addressMapEntry)->__addressMapPhysicalAddress;
        }
        if (vars->name_length > sizeof(addressMapLastChange)/sizeof(oid)
            && memcmp(vars->name, addressMapLastChange, sizeof(addressMapLastChange)) == 0) {
            (*addressMapEntry)->__addressMapLastChange = *vars->val.integer;
            (*addressMapEntry)->addressMapLastChange = &((*addressMapEntry)->__addressMapLastChange);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int rmon2_mib_mgr_get_hlHostControlEntry(struct snmp_session *s, hlHostControlEntry_t **hlHostControlEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, hlHostControlDataSource, sizeof(hlHostControlDataSource)/sizeof(oid));
    snmp_add_null_var(request, hlHostControlNlDroppedFrames, sizeof(hlHostControlNlDroppedFrames)/sizeof(oid));
    snmp_add_null_var(request, hlHostControlNlInserts, sizeof(hlHostControlNlInserts)/sizeof(oid));
    snmp_add_null_var(request, hlHostControlNlDeletes, sizeof(hlHostControlNlDeletes)/sizeof(oid));
    snmp_add_null_var(request, hlHostControlNlMaxDesiredEntries, sizeof(hlHostControlNlMaxDesiredEntries)/sizeof(oid));
    snmp_add_null_var(request, hlHostControlAlDroppedFrames, sizeof(hlHostControlAlDroppedFrames)/sizeof(oid));
    snmp_add_null_var(request, hlHostControlAlInserts, sizeof(hlHostControlAlInserts)/sizeof(oid));
    snmp_add_null_var(request, hlHostControlAlDeletes, sizeof(hlHostControlAlDeletes)/sizeof(oid));
    snmp_add_null_var(request, hlHostControlAlMaxDesiredEntries, sizeof(hlHostControlAlMaxDesiredEntries)/sizeof(oid));
    snmp_add_null_var(request, hlHostControlOwner, sizeof(hlHostControlOwner)/sizeof(oid));
    snmp_add_null_var(request, hlHostControlStatus, sizeof(hlHostControlStatus)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        return -2;
    }

    *hlHostControlEntry = (hlHostControlEntry_t *) malloc(sizeof(hlHostControlEntry_t));
    if (! *hlHostControlEntry) {
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(hlHostControlDataSource)/sizeof(oid)
            && memcmp(vars->name, hlHostControlDataSource, sizeof(hlHostControlDataSource)) == 0) {
        }
        if (vars->name_length > sizeof(hlHostControlNlDroppedFrames)/sizeof(oid)
            && memcmp(vars->name, hlHostControlNlDroppedFrames, sizeof(hlHostControlNlDroppedFrames)) == 0) {
            (*hlHostControlEntry)->__hlHostControlNlDroppedFrames = *vars->val.integer;
            (*hlHostControlEntry)->hlHostControlNlDroppedFrames = &((*hlHostControlEntry)->__hlHostControlNlDroppedFrames);
        }
        if (vars->name_length > sizeof(hlHostControlNlInserts)/sizeof(oid)
            && memcmp(vars->name, hlHostControlNlInserts, sizeof(hlHostControlNlInserts)) == 0) {
            (*hlHostControlEntry)->__hlHostControlNlInserts = *vars->val.integer;
            (*hlHostControlEntry)->hlHostControlNlInserts = &((*hlHostControlEntry)->__hlHostControlNlInserts);
        }
        if (vars->name_length > sizeof(hlHostControlNlDeletes)/sizeof(oid)
            && memcmp(vars->name, hlHostControlNlDeletes, sizeof(hlHostControlNlDeletes)) == 0) {
            (*hlHostControlEntry)->__hlHostControlNlDeletes = *vars->val.integer;
            (*hlHostControlEntry)->hlHostControlNlDeletes = &((*hlHostControlEntry)->__hlHostControlNlDeletes);
        }
        if (vars->name_length > sizeof(hlHostControlNlMaxDesiredEntries)/sizeof(oid)
            && memcmp(vars->name, hlHostControlNlMaxDesiredEntries, sizeof(hlHostControlNlMaxDesiredEntries)) == 0) {
            (*hlHostControlEntry)->__hlHostControlNlMaxDesiredEntries = *vars->val.integer;
            (*hlHostControlEntry)->hlHostControlNlMaxDesiredEntries = &((*hlHostControlEntry)->__hlHostControlNlMaxDesiredEntries);
        }
        if (vars->name_length > sizeof(hlHostControlAlDroppedFrames)/sizeof(oid)
            && memcmp(vars->name, hlHostControlAlDroppedFrames, sizeof(hlHostControlAlDroppedFrames)) == 0) {
            (*hlHostControlEntry)->__hlHostControlAlDroppedFrames = *vars->val.integer;
            (*hlHostControlEntry)->hlHostControlAlDroppedFrames = &((*hlHostControlEntry)->__hlHostControlAlDroppedFrames);
        }
        if (vars->name_length > sizeof(hlHostControlAlInserts)/sizeof(oid)
            && memcmp(vars->name, hlHostControlAlInserts, sizeof(hlHostControlAlInserts)) == 0) {
            (*hlHostControlEntry)->__hlHostControlAlInserts = *vars->val.integer;
            (*hlHostControlEntry)->hlHostControlAlInserts = &((*hlHostControlEntry)->__hlHostControlAlInserts);
        }
        if (vars->name_length > sizeof(hlHostControlAlDeletes)/sizeof(oid)
            && memcmp(vars->name, hlHostControlAlDeletes, sizeof(hlHostControlAlDeletes)) == 0) {
            (*hlHostControlEntry)->__hlHostControlAlDeletes = *vars->val.integer;
            (*hlHostControlEntry)->hlHostControlAlDeletes = &((*hlHostControlEntry)->__hlHostControlAlDeletes);
        }
        if (vars->name_length > sizeof(hlHostControlAlMaxDesiredEntries)/sizeof(oid)
            && memcmp(vars->name, hlHostControlAlMaxDesiredEntries, sizeof(hlHostControlAlMaxDesiredEntries)) == 0) {
            (*hlHostControlEntry)->__hlHostControlAlMaxDesiredEntries = *vars->val.integer;
            (*hlHostControlEntry)->hlHostControlAlMaxDesiredEntries = &((*hlHostControlEntry)->__hlHostControlAlMaxDesiredEntries);
        }
        if (vars->name_length > sizeof(hlHostControlOwner)/sizeof(oid)
            && memcmp(vars->name, hlHostControlOwner, sizeof(hlHostControlOwner)) == 0) {
            memcpy((*hlHostControlEntry)->__hlHostControlOwner, vars->val.string, vars->val_len);
            (*hlHostControlEntry)->_hlHostControlOwnerLength = vars->val_len;
            (*hlHostControlEntry)->hlHostControlOwner = (*hlHostControlEntry)->__hlHostControlOwner;
        }
        if (vars->name_length > sizeof(hlHostControlStatus)/sizeof(oid)
            && memcmp(vars->name, hlHostControlStatus, sizeof(hlHostControlStatus)) == 0) {
            (*hlHostControlEntry)->__hlHostControlStatus = *vars->val.integer;
            (*hlHostControlEntry)->hlHostControlStatus = &((*hlHostControlEntry)->__hlHostControlStatus);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int rmon2_mib_mgr_get_nlHostEntry(struct snmp_session *s, nlHostEntry_t **nlHostEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, nlHostInPkts, sizeof(nlHostInPkts)/sizeof(oid));
    snmp_add_null_var(request, nlHostOutPkts, sizeof(nlHostOutPkts)/sizeof(oid));
    snmp_add_null_var(request, nlHostInOctets, sizeof(nlHostInOctets)/sizeof(oid));
    snmp_add_null_var(request, nlHostOutOctets, sizeof(nlHostOutOctets)/sizeof(oid));
    snmp_add_null_var(request, nlHostOutMacNonUnicastPkts, sizeof(nlHostOutMacNonUnicastPkts)/sizeof(oid));
    snmp_add_null_var(request, nlHostCreateTime, sizeof(nlHostCreateTime)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        return -2;
    }

    *nlHostEntry = (nlHostEntry_t *) malloc(sizeof(nlHostEntry_t));
    if (! *nlHostEntry) {
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(nlHostInPkts)/sizeof(oid)
            && memcmp(vars->name, nlHostInPkts, sizeof(nlHostInPkts)) == 0) {
            (*nlHostEntry)->__nlHostInPkts = *vars->val.integer;
            (*nlHostEntry)->nlHostInPkts = &((*nlHostEntry)->__nlHostInPkts);
        }
        if (vars->name_length > sizeof(nlHostOutPkts)/sizeof(oid)
            && memcmp(vars->name, nlHostOutPkts, sizeof(nlHostOutPkts)) == 0) {
            (*nlHostEntry)->__nlHostOutPkts = *vars->val.integer;
            (*nlHostEntry)->nlHostOutPkts = &((*nlHostEntry)->__nlHostOutPkts);
        }
        if (vars->name_length > sizeof(nlHostInOctets)/sizeof(oid)
            && memcmp(vars->name, nlHostInOctets, sizeof(nlHostInOctets)) == 0) {
            (*nlHostEntry)->__nlHostInOctets = *vars->val.integer;
            (*nlHostEntry)->nlHostInOctets = &((*nlHostEntry)->__nlHostInOctets);
        }
        if (vars->name_length > sizeof(nlHostOutOctets)/sizeof(oid)
            && memcmp(vars->name, nlHostOutOctets, sizeof(nlHostOutOctets)) == 0) {
            (*nlHostEntry)->__nlHostOutOctets = *vars->val.integer;
            (*nlHostEntry)->nlHostOutOctets = &((*nlHostEntry)->__nlHostOutOctets);
        }
        if (vars->name_length > sizeof(nlHostOutMacNonUnicastPkts)/sizeof(oid)
            && memcmp(vars->name, nlHostOutMacNonUnicastPkts, sizeof(nlHostOutMacNonUnicastPkts)) == 0) {
            (*nlHostEntry)->__nlHostOutMacNonUnicastPkts = *vars->val.integer;
            (*nlHostEntry)->nlHostOutMacNonUnicastPkts = &((*nlHostEntry)->__nlHostOutMacNonUnicastPkts);
        }
        if (vars->name_length > sizeof(nlHostCreateTime)/sizeof(oid)
            && memcmp(vars->name, nlHostCreateTime, sizeof(nlHostCreateTime)) == 0) {
            (*nlHostEntry)->__nlHostCreateTime = *vars->val.integer;
            (*nlHostEntry)->nlHostCreateTime = &((*nlHostEntry)->__nlHostCreateTime);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int rmon2_mib_mgr_get_hlMatrixControlEntry(struct snmp_session *s, hlMatrixControlEntry_t **hlMatrixControlEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, hlMatrixControlDataSource, sizeof(hlMatrixControlDataSource)/sizeof(oid));
    snmp_add_null_var(request, hlMatrixControlNlDroppedFrames, sizeof(hlMatrixControlNlDroppedFrames)/sizeof(oid));
    snmp_add_null_var(request, hlMatrixControlNlInserts, sizeof(hlMatrixControlNlInserts)/sizeof(oid));
    snmp_add_null_var(request, hlMatrixControlNlDeletes, sizeof(hlMatrixControlNlDeletes)/sizeof(oid));
    snmp_add_null_var(request, hlMatrixControlNlMaxDesiredEntries, sizeof(hlMatrixControlNlMaxDesiredEntries)/sizeof(oid));
    snmp_add_null_var(request, hlMatrixControlAlDroppedFrames, sizeof(hlMatrixControlAlDroppedFrames)/sizeof(oid));
    snmp_add_null_var(request, hlMatrixControlAlInserts, sizeof(hlMatrixControlAlInserts)/sizeof(oid));
    snmp_add_null_var(request, hlMatrixControlAlDeletes, sizeof(hlMatrixControlAlDeletes)/sizeof(oid));
    snmp_add_null_var(request, hlMatrixControlAlMaxDesiredEntries, sizeof(hlMatrixControlAlMaxDesiredEntries)/sizeof(oid));
    snmp_add_null_var(request, hlMatrixControlOwner, sizeof(hlMatrixControlOwner)/sizeof(oid));
    snmp_add_null_var(request, hlMatrixControlStatus, sizeof(hlMatrixControlStatus)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        return -2;
    }

    *hlMatrixControlEntry = (hlMatrixControlEntry_t *) malloc(sizeof(hlMatrixControlEntry_t));
    if (! *hlMatrixControlEntry) {
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(hlMatrixControlDataSource)/sizeof(oid)
            && memcmp(vars->name, hlMatrixControlDataSource, sizeof(hlMatrixControlDataSource)) == 0) {
        }
        if (vars->name_length > sizeof(hlMatrixControlNlDroppedFrames)/sizeof(oid)
            && memcmp(vars->name, hlMatrixControlNlDroppedFrames, sizeof(hlMatrixControlNlDroppedFrames)) == 0) {
            (*hlMatrixControlEntry)->__hlMatrixControlNlDroppedFrames = *vars->val.integer;
            (*hlMatrixControlEntry)->hlMatrixControlNlDroppedFrames = &((*hlMatrixControlEntry)->__hlMatrixControlNlDroppedFrames);
        }
        if (vars->name_length > sizeof(hlMatrixControlNlInserts)/sizeof(oid)
            && memcmp(vars->name, hlMatrixControlNlInserts, sizeof(hlMatrixControlNlInserts)) == 0) {
            (*hlMatrixControlEntry)->__hlMatrixControlNlInserts = *vars->val.integer;
            (*hlMatrixControlEntry)->hlMatrixControlNlInserts = &((*hlMatrixControlEntry)->__hlMatrixControlNlInserts);
        }
        if (vars->name_length > sizeof(hlMatrixControlNlDeletes)/sizeof(oid)
            && memcmp(vars->name, hlMatrixControlNlDeletes, sizeof(hlMatrixControlNlDeletes)) == 0) {
            (*hlMatrixControlEntry)->__hlMatrixControlNlDeletes = *vars->val.integer;
            (*hlMatrixControlEntry)->hlMatrixControlNlDeletes = &((*hlMatrixControlEntry)->__hlMatrixControlNlDeletes);
        }
        if (vars->name_length > sizeof(hlMatrixControlNlMaxDesiredEntries)/sizeof(oid)
            && memcmp(vars->name, hlMatrixControlNlMaxDesiredEntries, sizeof(hlMatrixControlNlMaxDesiredEntries)) == 0) {
            (*hlMatrixControlEntry)->__hlMatrixControlNlMaxDesiredEntries = *vars->val.integer;
            (*hlMatrixControlEntry)->hlMatrixControlNlMaxDesiredEntries = &((*hlMatrixControlEntry)->__hlMatrixControlNlMaxDesiredEntries);
        }
        if (vars->name_length > sizeof(hlMatrixControlAlDroppedFrames)/sizeof(oid)
            && memcmp(vars->name, hlMatrixControlAlDroppedFrames, sizeof(hlMatrixControlAlDroppedFrames)) == 0) {
            (*hlMatrixControlEntry)->__hlMatrixControlAlDroppedFrames = *vars->val.integer;
            (*hlMatrixControlEntry)->hlMatrixControlAlDroppedFrames = &((*hlMatrixControlEntry)->__hlMatrixControlAlDroppedFrames);
        }
        if (vars->name_length > sizeof(hlMatrixControlAlInserts)/sizeof(oid)
            && memcmp(vars->name, hlMatrixControlAlInserts, sizeof(hlMatrixControlAlInserts)) == 0) {
            (*hlMatrixControlEntry)->__hlMatrixControlAlInserts = *vars->val.integer;
            (*hlMatrixControlEntry)->hlMatrixControlAlInserts = &((*hlMatrixControlEntry)->__hlMatrixControlAlInserts);
        }
        if (vars->name_length > sizeof(hlMatrixControlAlDeletes)/sizeof(oid)
            && memcmp(vars->name, hlMatrixControlAlDeletes, sizeof(hlMatrixControlAlDeletes)) == 0) {
            (*hlMatrixControlEntry)->__hlMatrixControlAlDeletes = *vars->val.integer;
            (*hlMatrixControlEntry)->hlMatrixControlAlDeletes = &((*hlMatrixControlEntry)->__hlMatrixControlAlDeletes);
        }
        if (vars->name_length > sizeof(hlMatrixControlAlMaxDesiredEntries)/sizeof(oid)
            && memcmp(vars->name, hlMatrixControlAlMaxDesiredEntries, sizeof(hlMatrixControlAlMaxDesiredEntries)) == 0) {
            (*hlMatrixControlEntry)->__hlMatrixControlAlMaxDesiredEntries = *vars->val.integer;
            (*hlMatrixControlEntry)->hlMatrixControlAlMaxDesiredEntries = &((*hlMatrixControlEntry)->__hlMatrixControlAlMaxDesiredEntries);
        }
        if (vars->name_length > sizeof(hlMatrixControlOwner)/sizeof(oid)
            && memcmp(vars->name, hlMatrixControlOwner, sizeof(hlMatrixControlOwner)) == 0) {
            memcpy((*hlMatrixControlEntry)->__hlMatrixControlOwner, vars->val.string, vars->val_len);
            (*hlMatrixControlEntry)->_hlMatrixControlOwnerLength = vars->val_len;
            (*hlMatrixControlEntry)->hlMatrixControlOwner = (*hlMatrixControlEntry)->__hlMatrixControlOwner;
        }
        if (vars->name_length > sizeof(hlMatrixControlStatus)/sizeof(oid)
            && memcmp(vars->name, hlMatrixControlStatus, sizeof(hlMatrixControlStatus)) == 0) {
            (*hlMatrixControlEntry)->__hlMatrixControlStatus = *vars->val.integer;
            (*hlMatrixControlEntry)->hlMatrixControlStatus = &((*hlMatrixControlEntry)->__hlMatrixControlStatus);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int rmon2_mib_mgr_get_nlMatrixSDEntry(struct snmp_session *s, nlMatrixSDEntry_t **nlMatrixSDEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, nlMatrixSDPkts, sizeof(nlMatrixSDPkts)/sizeof(oid));
    snmp_add_null_var(request, nlMatrixSDOctets, sizeof(nlMatrixSDOctets)/sizeof(oid));
    snmp_add_null_var(request, nlMatrixSDCreateTime, sizeof(nlMatrixSDCreateTime)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        return -2;
    }

    *nlMatrixSDEntry = (nlMatrixSDEntry_t *) malloc(sizeof(nlMatrixSDEntry_t));
    if (! *nlMatrixSDEntry) {
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(nlMatrixSDPkts)/sizeof(oid)
            && memcmp(vars->name, nlMatrixSDPkts, sizeof(nlMatrixSDPkts)) == 0) {
            (*nlMatrixSDEntry)->__nlMatrixSDPkts = *vars->val.integer;
            (*nlMatrixSDEntry)->nlMatrixSDPkts = &((*nlMatrixSDEntry)->__nlMatrixSDPkts);
        }
        if (vars->name_length > sizeof(nlMatrixSDOctets)/sizeof(oid)
            && memcmp(vars->name, nlMatrixSDOctets, sizeof(nlMatrixSDOctets)) == 0) {
            (*nlMatrixSDEntry)->__nlMatrixSDOctets = *vars->val.integer;
            (*nlMatrixSDEntry)->nlMatrixSDOctets = &((*nlMatrixSDEntry)->__nlMatrixSDOctets);
        }
        if (vars->name_length > sizeof(nlMatrixSDCreateTime)/sizeof(oid)
            && memcmp(vars->name, nlMatrixSDCreateTime, sizeof(nlMatrixSDCreateTime)) == 0) {
            (*nlMatrixSDEntry)->__nlMatrixSDCreateTime = *vars->val.integer;
            (*nlMatrixSDEntry)->nlMatrixSDCreateTime = &((*nlMatrixSDEntry)->__nlMatrixSDCreateTime);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int rmon2_mib_mgr_get_nlMatrixDSEntry(struct snmp_session *s, nlMatrixDSEntry_t **nlMatrixDSEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, nlMatrixDSPkts, sizeof(nlMatrixDSPkts)/sizeof(oid));
    snmp_add_null_var(request, nlMatrixDSOctets, sizeof(nlMatrixDSOctets)/sizeof(oid));
    snmp_add_null_var(request, nlMatrixDSCreateTime, sizeof(nlMatrixDSCreateTime)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        return -2;
    }

    *nlMatrixDSEntry = (nlMatrixDSEntry_t *) malloc(sizeof(nlMatrixDSEntry_t));
    if (! *nlMatrixDSEntry) {
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(nlMatrixDSPkts)/sizeof(oid)
            && memcmp(vars->name, nlMatrixDSPkts, sizeof(nlMatrixDSPkts)) == 0) {
            (*nlMatrixDSEntry)->__nlMatrixDSPkts = *vars->val.integer;
            (*nlMatrixDSEntry)->nlMatrixDSPkts = &((*nlMatrixDSEntry)->__nlMatrixDSPkts);
        }
        if (vars->name_length > sizeof(nlMatrixDSOctets)/sizeof(oid)
            && memcmp(vars->name, nlMatrixDSOctets, sizeof(nlMatrixDSOctets)) == 0) {
            (*nlMatrixDSEntry)->__nlMatrixDSOctets = *vars->val.integer;
            (*nlMatrixDSEntry)->nlMatrixDSOctets = &((*nlMatrixDSEntry)->__nlMatrixDSOctets);
        }
        if (vars->name_length > sizeof(nlMatrixDSCreateTime)/sizeof(oid)
            && memcmp(vars->name, nlMatrixDSCreateTime, sizeof(nlMatrixDSCreateTime)) == 0) {
            (*nlMatrixDSEntry)->__nlMatrixDSCreateTime = *vars->val.integer;
            (*nlMatrixDSEntry)->nlMatrixDSCreateTime = &((*nlMatrixDSEntry)->__nlMatrixDSCreateTime);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int rmon2_mib_mgr_get_nlMatrixTopNControlEntry(struct snmp_session *s, nlMatrixTopNControlEntry_t **nlMatrixTopNControlEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, nlMatrixTopNControlMatrixIndex, sizeof(nlMatrixTopNControlMatrixIndex)/sizeof(oid));
    snmp_add_null_var(request, nlMatrixTopNControlRateBase, sizeof(nlMatrixTopNControlRateBase)/sizeof(oid));
    snmp_add_null_var(request, nlMatrixTopNControlTimeRemaining, sizeof(nlMatrixTopNControlTimeRemaining)/sizeof(oid));
    snmp_add_null_var(request, nlMatrixTopNControlGeneratedReports, sizeof(nlMatrixTopNControlGeneratedReports)/sizeof(oid));
    snmp_add_null_var(request, nlMatrixTopNControlDuration, sizeof(nlMatrixTopNControlDuration)/sizeof(oid));
    snmp_add_null_var(request, nlMatrixTopNControlRequestedSize, sizeof(nlMatrixTopNControlRequestedSize)/sizeof(oid));
    snmp_add_null_var(request, nlMatrixTopNControlGrantedSize, sizeof(nlMatrixTopNControlGrantedSize)/sizeof(oid));
    snmp_add_null_var(request, nlMatrixTopNControlStartTime, sizeof(nlMatrixTopNControlStartTime)/sizeof(oid));
    snmp_add_null_var(request, nlMatrixTopNControlOwner, sizeof(nlMatrixTopNControlOwner)/sizeof(oid));
    snmp_add_null_var(request, nlMatrixTopNControlStatus, sizeof(nlMatrixTopNControlStatus)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        return -2;
    }

    *nlMatrixTopNControlEntry = (nlMatrixTopNControlEntry_t *) malloc(sizeof(nlMatrixTopNControlEntry_t));
    if (! *nlMatrixTopNControlEntry) {
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(nlMatrixTopNControlMatrixIndex)/sizeof(oid)
            && memcmp(vars->name, nlMatrixTopNControlMatrixIndex, sizeof(nlMatrixTopNControlMatrixIndex)) == 0) {
            (*nlMatrixTopNControlEntry)->__nlMatrixTopNControlMatrixIndex = *vars->val.integer;
            (*nlMatrixTopNControlEntry)->nlMatrixTopNControlMatrixIndex = &((*nlMatrixTopNControlEntry)->__nlMatrixTopNControlMatrixIndex);
        }
        if (vars->name_length > sizeof(nlMatrixTopNControlRateBase)/sizeof(oid)
            && memcmp(vars->name, nlMatrixTopNControlRateBase, sizeof(nlMatrixTopNControlRateBase)) == 0) {
            (*nlMatrixTopNControlEntry)->__nlMatrixTopNControlRateBase = *vars->val.integer;
            (*nlMatrixTopNControlEntry)->nlMatrixTopNControlRateBase = &((*nlMatrixTopNControlEntry)->__nlMatrixTopNControlRateBase);
        }
        if (vars->name_length > sizeof(nlMatrixTopNControlTimeRemaining)/sizeof(oid)
            && memcmp(vars->name, nlMatrixTopNControlTimeRemaining, sizeof(nlMatrixTopNControlTimeRemaining)) == 0) {
            (*nlMatrixTopNControlEntry)->__nlMatrixTopNControlTimeRemaining = *vars->val.integer;
            (*nlMatrixTopNControlEntry)->nlMatrixTopNControlTimeRemaining = &((*nlMatrixTopNControlEntry)->__nlMatrixTopNControlTimeRemaining);
        }
        if (vars->name_length > sizeof(nlMatrixTopNControlGeneratedReports)/sizeof(oid)
            && memcmp(vars->name, nlMatrixTopNControlGeneratedReports, sizeof(nlMatrixTopNControlGeneratedReports)) == 0) {
            (*nlMatrixTopNControlEntry)->__nlMatrixTopNControlGeneratedReports = *vars->val.integer;
            (*nlMatrixTopNControlEntry)->nlMatrixTopNControlGeneratedReports = &((*nlMatrixTopNControlEntry)->__nlMatrixTopNControlGeneratedReports);
        }
        if (vars->name_length > sizeof(nlMatrixTopNControlDuration)/sizeof(oid)
            && memcmp(vars->name, nlMatrixTopNControlDuration, sizeof(nlMatrixTopNControlDuration)) == 0) {
            (*nlMatrixTopNControlEntry)->__nlMatrixTopNControlDuration = *vars->val.integer;
            (*nlMatrixTopNControlEntry)->nlMatrixTopNControlDuration = &((*nlMatrixTopNControlEntry)->__nlMatrixTopNControlDuration);
        }
        if (vars->name_length > sizeof(nlMatrixTopNControlRequestedSize)/sizeof(oid)
            && memcmp(vars->name, nlMatrixTopNControlRequestedSize, sizeof(nlMatrixTopNControlRequestedSize)) == 0) {
            (*nlMatrixTopNControlEntry)->__nlMatrixTopNControlRequestedSize = *vars->val.integer;
            (*nlMatrixTopNControlEntry)->nlMatrixTopNControlRequestedSize = &((*nlMatrixTopNControlEntry)->__nlMatrixTopNControlRequestedSize);
        }
        if (vars->name_length > sizeof(nlMatrixTopNControlGrantedSize)/sizeof(oid)
            && memcmp(vars->name, nlMatrixTopNControlGrantedSize, sizeof(nlMatrixTopNControlGrantedSize)) == 0) {
            (*nlMatrixTopNControlEntry)->__nlMatrixTopNControlGrantedSize = *vars->val.integer;
            (*nlMatrixTopNControlEntry)->nlMatrixTopNControlGrantedSize = &((*nlMatrixTopNControlEntry)->__nlMatrixTopNControlGrantedSize);
        }
        if (vars->name_length > sizeof(nlMatrixTopNControlStartTime)/sizeof(oid)
            && memcmp(vars->name, nlMatrixTopNControlStartTime, sizeof(nlMatrixTopNControlStartTime)) == 0) {
            (*nlMatrixTopNControlEntry)->__nlMatrixTopNControlStartTime = *vars->val.integer;
            (*nlMatrixTopNControlEntry)->nlMatrixTopNControlStartTime = &((*nlMatrixTopNControlEntry)->__nlMatrixTopNControlStartTime);
        }
        if (vars->name_length > sizeof(nlMatrixTopNControlOwner)/sizeof(oid)
            && memcmp(vars->name, nlMatrixTopNControlOwner, sizeof(nlMatrixTopNControlOwner)) == 0) {
            memcpy((*nlMatrixTopNControlEntry)->__nlMatrixTopNControlOwner, vars->val.string, vars->val_len);
            (*nlMatrixTopNControlEntry)->_nlMatrixTopNControlOwnerLength = vars->val_len;
            (*nlMatrixTopNControlEntry)->nlMatrixTopNControlOwner = (*nlMatrixTopNControlEntry)->__nlMatrixTopNControlOwner;
        }
        if (vars->name_length > sizeof(nlMatrixTopNControlStatus)/sizeof(oid)
            && memcmp(vars->name, nlMatrixTopNControlStatus, sizeof(nlMatrixTopNControlStatus)) == 0) {
            (*nlMatrixTopNControlEntry)->__nlMatrixTopNControlStatus = *vars->val.integer;
            (*nlMatrixTopNControlEntry)->nlMatrixTopNControlStatus = &((*nlMatrixTopNControlEntry)->__nlMatrixTopNControlStatus);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int rmon2_mib_mgr_get_nlMatrixTopNEntry(struct snmp_session *s, nlMatrixTopNEntry_t **nlMatrixTopNEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, nlMatrixTopNProtocolDirLocalIndex, sizeof(nlMatrixTopNProtocolDirLocalIndex)/sizeof(oid));
    snmp_add_null_var(request, nlMatrixTopNSourceAddress, sizeof(nlMatrixTopNSourceAddress)/sizeof(oid));
    snmp_add_null_var(request, nlMatrixTopNDestAddress, sizeof(nlMatrixTopNDestAddress)/sizeof(oid));
    snmp_add_null_var(request, nlMatrixTopNPktRate, sizeof(nlMatrixTopNPktRate)/sizeof(oid));
    snmp_add_null_var(request, nlMatrixTopNReversePktRate, sizeof(nlMatrixTopNReversePktRate)/sizeof(oid));
    snmp_add_null_var(request, nlMatrixTopNOctetRate, sizeof(nlMatrixTopNOctetRate)/sizeof(oid));
    snmp_add_null_var(request, nlMatrixTopNReverseOctetRate, sizeof(nlMatrixTopNReverseOctetRate)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        return -2;
    }

    *nlMatrixTopNEntry = (nlMatrixTopNEntry_t *) malloc(sizeof(nlMatrixTopNEntry_t));
    if (! *nlMatrixTopNEntry) {
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(nlMatrixTopNProtocolDirLocalIndex)/sizeof(oid)
            && memcmp(vars->name, nlMatrixTopNProtocolDirLocalIndex, sizeof(nlMatrixTopNProtocolDirLocalIndex)) == 0) {
            (*nlMatrixTopNEntry)->__nlMatrixTopNProtocolDirLocalIndex = *vars->val.integer;
            (*nlMatrixTopNEntry)->nlMatrixTopNProtocolDirLocalIndex = &((*nlMatrixTopNEntry)->__nlMatrixTopNProtocolDirLocalIndex);
        }
        if (vars->name_length > sizeof(nlMatrixTopNSourceAddress)/sizeof(oid)
            && memcmp(vars->name, nlMatrixTopNSourceAddress, sizeof(nlMatrixTopNSourceAddress)) == 0) {
            memcpy((*nlMatrixTopNEntry)->__nlMatrixTopNSourceAddress, vars->val.string, vars->val_len);
            (*nlMatrixTopNEntry)->_nlMatrixTopNSourceAddressLength = vars->val_len;
            (*nlMatrixTopNEntry)->nlMatrixTopNSourceAddress = (*nlMatrixTopNEntry)->__nlMatrixTopNSourceAddress;
        }
        if (vars->name_length > sizeof(nlMatrixTopNDestAddress)/sizeof(oid)
            && memcmp(vars->name, nlMatrixTopNDestAddress, sizeof(nlMatrixTopNDestAddress)) == 0) {
            memcpy((*nlMatrixTopNEntry)->__nlMatrixTopNDestAddress, vars->val.string, vars->val_len);
            (*nlMatrixTopNEntry)->_nlMatrixTopNDestAddressLength = vars->val_len;
            (*nlMatrixTopNEntry)->nlMatrixTopNDestAddress = (*nlMatrixTopNEntry)->__nlMatrixTopNDestAddress;
        }
        if (vars->name_length > sizeof(nlMatrixTopNPktRate)/sizeof(oid)
            && memcmp(vars->name, nlMatrixTopNPktRate, sizeof(nlMatrixTopNPktRate)) == 0) {
            (*nlMatrixTopNEntry)->__nlMatrixTopNPktRate = *vars->val.integer;
            (*nlMatrixTopNEntry)->nlMatrixTopNPktRate = &((*nlMatrixTopNEntry)->__nlMatrixTopNPktRate);
        }
        if (vars->name_length > sizeof(nlMatrixTopNReversePktRate)/sizeof(oid)
            && memcmp(vars->name, nlMatrixTopNReversePktRate, sizeof(nlMatrixTopNReversePktRate)) == 0) {
            (*nlMatrixTopNEntry)->__nlMatrixTopNReversePktRate = *vars->val.integer;
            (*nlMatrixTopNEntry)->nlMatrixTopNReversePktRate = &((*nlMatrixTopNEntry)->__nlMatrixTopNReversePktRate);
        }
        if (vars->name_length > sizeof(nlMatrixTopNOctetRate)/sizeof(oid)
            && memcmp(vars->name, nlMatrixTopNOctetRate, sizeof(nlMatrixTopNOctetRate)) == 0) {
            (*nlMatrixTopNEntry)->__nlMatrixTopNOctetRate = *vars->val.integer;
            (*nlMatrixTopNEntry)->nlMatrixTopNOctetRate = &((*nlMatrixTopNEntry)->__nlMatrixTopNOctetRate);
        }
        if (vars->name_length > sizeof(nlMatrixTopNReverseOctetRate)/sizeof(oid)
            && memcmp(vars->name, nlMatrixTopNReverseOctetRate, sizeof(nlMatrixTopNReverseOctetRate)) == 0) {
            (*nlMatrixTopNEntry)->__nlMatrixTopNReverseOctetRate = *vars->val.integer;
            (*nlMatrixTopNEntry)->nlMatrixTopNReverseOctetRate = &((*nlMatrixTopNEntry)->__nlMatrixTopNReverseOctetRate);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int rmon2_mib_mgr_get_alHostEntry(struct snmp_session *s, alHostEntry_t **alHostEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, alHostInPkts, sizeof(alHostInPkts)/sizeof(oid));
    snmp_add_null_var(request, alHostOutPkts, sizeof(alHostOutPkts)/sizeof(oid));
    snmp_add_null_var(request, alHostInOctets, sizeof(alHostInOctets)/sizeof(oid));
    snmp_add_null_var(request, alHostOutOctets, sizeof(alHostOutOctets)/sizeof(oid));
    snmp_add_null_var(request, alHostCreateTime, sizeof(alHostCreateTime)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        return -2;
    }

    *alHostEntry = (alHostEntry_t *) malloc(sizeof(alHostEntry_t));
    if (! *alHostEntry) {
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(alHostInPkts)/sizeof(oid)
            && memcmp(vars->name, alHostInPkts, sizeof(alHostInPkts)) == 0) {
            (*alHostEntry)->__alHostInPkts = *vars->val.integer;
            (*alHostEntry)->alHostInPkts = &((*alHostEntry)->__alHostInPkts);
        }
        if (vars->name_length > sizeof(alHostOutPkts)/sizeof(oid)
            && memcmp(vars->name, alHostOutPkts, sizeof(alHostOutPkts)) == 0) {
            (*alHostEntry)->__alHostOutPkts = *vars->val.integer;
            (*alHostEntry)->alHostOutPkts = &((*alHostEntry)->__alHostOutPkts);
        }
        if (vars->name_length > sizeof(alHostInOctets)/sizeof(oid)
            && memcmp(vars->name, alHostInOctets, sizeof(alHostInOctets)) == 0) {
            (*alHostEntry)->__alHostInOctets = *vars->val.integer;
            (*alHostEntry)->alHostInOctets = &((*alHostEntry)->__alHostInOctets);
        }
        if (vars->name_length > sizeof(alHostOutOctets)/sizeof(oid)
            && memcmp(vars->name, alHostOutOctets, sizeof(alHostOutOctets)) == 0) {
            (*alHostEntry)->__alHostOutOctets = *vars->val.integer;
            (*alHostEntry)->alHostOutOctets = &((*alHostEntry)->__alHostOutOctets);
        }
        if (vars->name_length > sizeof(alHostCreateTime)/sizeof(oid)
            && memcmp(vars->name, alHostCreateTime, sizeof(alHostCreateTime)) == 0) {
            (*alHostEntry)->__alHostCreateTime = *vars->val.integer;
            (*alHostEntry)->alHostCreateTime = &((*alHostEntry)->__alHostCreateTime);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int rmon2_mib_mgr_get_alMatrixSDEntry(struct snmp_session *s, alMatrixSDEntry_t **alMatrixSDEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, alMatrixSDPkts, sizeof(alMatrixSDPkts)/sizeof(oid));
    snmp_add_null_var(request, alMatrixSDOctets, sizeof(alMatrixSDOctets)/sizeof(oid));
    snmp_add_null_var(request, alMatrixSDCreateTime, sizeof(alMatrixSDCreateTime)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        return -2;
    }

    *alMatrixSDEntry = (alMatrixSDEntry_t *) malloc(sizeof(alMatrixSDEntry_t));
    if (! *alMatrixSDEntry) {
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(alMatrixSDPkts)/sizeof(oid)
            && memcmp(vars->name, alMatrixSDPkts, sizeof(alMatrixSDPkts)) == 0) {
            (*alMatrixSDEntry)->__alMatrixSDPkts = *vars->val.integer;
            (*alMatrixSDEntry)->alMatrixSDPkts = &((*alMatrixSDEntry)->__alMatrixSDPkts);
        }
        if (vars->name_length > sizeof(alMatrixSDOctets)/sizeof(oid)
            && memcmp(vars->name, alMatrixSDOctets, sizeof(alMatrixSDOctets)) == 0) {
            (*alMatrixSDEntry)->__alMatrixSDOctets = *vars->val.integer;
            (*alMatrixSDEntry)->alMatrixSDOctets = &((*alMatrixSDEntry)->__alMatrixSDOctets);
        }
        if (vars->name_length > sizeof(alMatrixSDCreateTime)/sizeof(oid)
            && memcmp(vars->name, alMatrixSDCreateTime, sizeof(alMatrixSDCreateTime)) == 0) {
            (*alMatrixSDEntry)->__alMatrixSDCreateTime = *vars->val.integer;
            (*alMatrixSDEntry)->alMatrixSDCreateTime = &((*alMatrixSDEntry)->__alMatrixSDCreateTime);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int rmon2_mib_mgr_get_alMatrixDSEntry(struct snmp_session *s, alMatrixDSEntry_t **alMatrixDSEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, alMatrixDSPkts, sizeof(alMatrixDSPkts)/sizeof(oid));
    snmp_add_null_var(request, alMatrixDSOctets, sizeof(alMatrixDSOctets)/sizeof(oid));
    snmp_add_null_var(request, alMatrixDSCreateTime, sizeof(alMatrixDSCreateTime)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        return -2;
    }

    *alMatrixDSEntry = (alMatrixDSEntry_t *) malloc(sizeof(alMatrixDSEntry_t));
    if (! *alMatrixDSEntry) {
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(alMatrixDSPkts)/sizeof(oid)
            && memcmp(vars->name, alMatrixDSPkts, sizeof(alMatrixDSPkts)) == 0) {
            (*alMatrixDSEntry)->__alMatrixDSPkts = *vars->val.integer;
            (*alMatrixDSEntry)->alMatrixDSPkts = &((*alMatrixDSEntry)->__alMatrixDSPkts);
        }
        if (vars->name_length > sizeof(alMatrixDSOctets)/sizeof(oid)
            && memcmp(vars->name, alMatrixDSOctets, sizeof(alMatrixDSOctets)) == 0) {
            (*alMatrixDSEntry)->__alMatrixDSOctets = *vars->val.integer;
            (*alMatrixDSEntry)->alMatrixDSOctets = &((*alMatrixDSEntry)->__alMatrixDSOctets);
        }
        if (vars->name_length > sizeof(alMatrixDSCreateTime)/sizeof(oid)
            && memcmp(vars->name, alMatrixDSCreateTime, sizeof(alMatrixDSCreateTime)) == 0) {
            (*alMatrixDSEntry)->__alMatrixDSCreateTime = *vars->val.integer;
            (*alMatrixDSEntry)->alMatrixDSCreateTime = &((*alMatrixDSEntry)->__alMatrixDSCreateTime);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int rmon2_mib_mgr_get_alMatrixTopNControlEntry(struct snmp_session *s, alMatrixTopNControlEntry_t **alMatrixTopNControlEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, alMatrixTopNControlMatrixIndex, sizeof(alMatrixTopNControlMatrixIndex)/sizeof(oid));
    snmp_add_null_var(request, alMatrixTopNControlRateBase, sizeof(alMatrixTopNControlRateBase)/sizeof(oid));
    snmp_add_null_var(request, alMatrixTopNControlTimeRemaining, sizeof(alMatrixTopNControlTimeRemaining)/sizeof(oid));
    snmp_add_null_var(request, alMatrixTopNControlGeneratedReports, sizeof(alMatrixTopNControlGeneratedReports)/sizeof(oid));
    snmp_add_null_var(request, alMatrixTopNControlDuration, sizeof(alMatrixTopNControlDuration)/sizeof(oid));
    snmp_add_null_var(request, alMatrixTopNControlRequestedSize, sizeof(alMatrixTopNControlRequestedSize)/sizeof(oid));
    snmp_add_null_var(request, alMatrixTopNControlGrantedSize, sizeof(alMatrixTopNControlGrantedSize)/sizeof(oid));
    snmp_add_null_var(request, alMatrixTopNControlStartTime, sizeof(alMatrixTopNControlStartTime)/sizeof(oid));
    snmp_add_null_var(request, alMatrixTopNControlOwner, sizeof(alMatrixTopNControlOwner)/sizeof(oid));
    snmp_add_null_var(request, alMatrixTopNControlStatus, sizeof(alMatrixTopNControlStatus)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        return -2;
    }

    *alMatrixTopNControlEntry = (alMatrixTopNControlEntry_t *) malloc(sizeof(alMatrixTopNControlEntry_t));
    if (! *alMatrixTopNControlEntry) {
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(alMatrixTopNControlMatrixIndex)/sizeof(oid)
            && memcmp(vars->name, alMatrixTopNControlMatrixIndex, sizeof(alMatrixTopNControlMatrixIndex)) == 0) {
            (*alMatrixTopNControlEntry)->__alMatrixTopNControlMatrixIndex = *vars->val.integer;
            (*alMatrixTopNControlEntry)->alMatrixTopNControlMatrixIndex = &((*alMatrixTopNControlEntry)->__alMatrixTopNControlMatrixIndex);
        }
        if (vars->name_length > sizeof(alMatrixTopNControlRateBase)/sizeof(oid)
            && memcmp(vars->name, alMatrixTopNControlRateBase, sizeof(alMatrixTopNControlRateBase)) == 0) {
            (*alMatrixTopNControlEntry)->__alMatrixTopNControlRateBase = *vars->val.integer;
            (*alMatrixTopNControlEntry)->alMatrixTopNControlRateBase = &((*alMatrixTopNControlEntry)->__alMatrixTopNControlRateBase);
        }
        if (vars->name_length > sizeof(alMatrixTopNControlTimeRemaining)/sizeof(oid)
            && memcmp(vars->name, alMatrixTopNControlTimeRemaining, sizeof(alMatrixTopNControlTimeRemaining)) == 0) {
            (*alMatrixTopNControlEntry)->__alMatrixTopNControlTimeRemaining = *vars->val.integer;
            (*alMatrixTopNControlEntry)->alMatrixTopNControlTimeRemaining = &((*alMatrixTopNControlEntry)->__alMatrixTopNControlTimeRemaining);
        }
        if (vars->name_length > sizeof(alMatrixTopNControlGeneratedReports)/sizeof(oid)
            && memcmp(vars->name, alMatrixTopNControlGeneratedReports, sizeof(alMatrixTopNControlGeneratedReports)) == 0) {
            (*alMatrixTopNControlEntry)->__alMatrixTopNControlGeneratedReports = *vars->val.integer;
            (*alMatrixTopNControlEntry)->alMatrixTopNControlGeneratedReports = &((*alMatrixTopNControlEntry)->__alMatrixTopNControlGeneratedReports);
        }
        if (vars->name_length > sizeof(alMatrixTopNControlDuration)/sizeof(oid)
            && memcmp(vars->name, alMatrixTopNControlDuration, sizeof(alMatrixTopNControlDuration)) == 0) {
            (*alMatrixTopNControlEntry)->__alMatrixTopNControlDuration = *vars->val.integer;
            (*alMatrixTopNControlEntry)->alMatrixTopNControlDuration = &((*alMatrixTopNControlEntry)->__alMatrixTopNControlDuration);
        }
        if (vars->name_length > sizeof(alMatrixTopNControlRequestedSize)/sizeof(oid)
            && memcmp(vars->name, alMatrixTopNControlRequestedSize, sizeof(alMatrixTopNControlRequestedSize)) == 0) {
            (*alMatrixTopNControlEntry)->__alMatrixTopNControlRequestedSize = *vars->val.integer;
            (*alMatrixTopNControlEntry)->alMatrixTopNControlRequestedSize = &((*alMatrixTopNControlEntry)->__alMatrixTopNControlRequestedSize);
        }
        if (vars->name_length > sizeof(alMatrixTopNControlGrantedSize)/sizeof(oid)
            && memcmp(vars->name, alMatrixTopNControlGrantedSize, sizeof(alMatrixTopNControlGrantedSize)) == 0) {
            (*alMatrixTopNControlEntry)->__alMatrixTopNControlGrantedSize = *vars->val.integer;
            (*alMatrixTopNControlEntry)->alMatrixTopNControlGrantedSize = &((*alMatrixTopNControlEntry)->__alMatrixTopNControlGrantedSize);
        }
        if (vars->name_length > sizeof(alMatrixTopNControlStartTime)/sizeof(oid)
            && memcmp(vars->name, alMatrixTopNControlStartTime, sizeof(alMatrixTopNControlStartTime)) == 0) {
            (*alMatrixTopNControlEntry)->__alMatrixTopNControlStartTime = *vars->val.integer;
            (*alMatrixTopNControlEntry)->alMatrixTopNControlStartTime = &((*alMatrixTopNControlEntry)->__alMatrixTopNControlStartTime);
        }
        if (vars->name_length > sizeof(alMatrixTopNControlOwner)/sizeof(oid)
            && memcmp(vars->name, alMatrixTopNControlOwner, sizeof(alMatrixTopNControlOwner)) == 0) {
            memcpy((*alMatrixTopNControlEntry)->__alMatrixTopNControlOwner, vars->val.string, vars->val_len);
            (*alMatrixTopNControlEntry)->_alMatrixTopNControlOwnerLength = vars->val_len;
            (*alMatrixTopNControlEntry)->alMatrixTopNControlOwner = (*alMatrixTopNControlEntry)->__alMatrixTopNControlOwner;
        }
        if (vars->name_length > sizeof(alMatrixTopNControlStatus)/sizeof(oid)
            && memcmp(vars->name, alMatrixTopNControlStatus, sizeof(alMatrixTopNControlStatus)) == 0) {
            (*alMatrixTopNControlEntry)->__alMatrixTopNControlStatus = *vars->val.integer;
            (*alMatrixTopNControlEntry)->alMatrixTopNControlStatus = &((*alMatrixTopNControlEntry)->__alMatrixTopNControlStatus);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int rmon2_mib_mgr_get_alMatrixTopNEntry(struct snmp_session *s, alMatrixTopNEntry_t **alMatrixTopNEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, alMatrixTopNProtocolDirLocalIndex, sizeof(alMatrixTopNProtocolDirLocalIndex)/sizeof(oid));
    snmp_add_null_var(request, alMatrixTopNSourceAddress, sizeof(alMatrixTopNSourceAddress)/sizeof(oid));
    snmp_add_null_var(request, alMatrixTopNDestAddress, sizeof(alMatrixTopNDestAddress)/sizeof(oid));
    snmp_add_null_var(request, alMatrixTopNAppProtocolDirLocalIndex, sizeof(alMatrixTopNAppProtocolDirLocalIndex)/sizeof(oid));
    snmp_add_null_var(request, alMatrixTopNPktRate, sizeof(alMatrixTopNPktRate)/sizeof(oid));
    snmp_add_null_var(request, alMatrixTopNReversePktRate, sizeof(alMatrixTopNReversePktRate)/sizeof(oid));
    snmp_add_null_var(request, alMatrixTopNOctetRate, sizeof(alMatrixTopNOctetRate)/sizeof(oid));
    snmp_add_null_var(request, alMatrixTopNReverseOctetRate, sizeof(alMatrixTopNReverseOctetRate)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        return -2;
    }

    *alMatrixTopNEntry = (alMatrixTopNEntry_t *) malloc(sizeof(alMatrixTopNEntry_t));
    if (! *alMatrixTopNEntry) {
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(alMatrixTopNProtocolDirLocalIndex)/sizeof(oid)
            && memcmp(vars->name, alMatrixTopNProtocolDirLocalIndex, sizeof(alMatrixTopNProtocolDirLocalIndex)) == 0) {
            (*alMatrixTopNEntry)->__alMatrixTopNProtocolDirLocalIndex = *vars->val.integer;
            (*alMatrixTopNEntry)->alMatrixTopNProtocolDirLocalIndex = &((*alMatrixTopNEntry)->__alMatrixTopNProtocolDirLocalIndex);
        }
        if (vars->name_length > sizeof(alMatrixTopNSourceAddress)/sizeof(oid)
            && memcmp(vars->name, alMatrixTopNSourceAddress, sizeof(alMatrixTopNSourceAddress)) == 0) {
            memcpy((*alMatrixTopNEntry)->__alMatrixTopNSourceAddress, vars->val.string, vars->val_len);
            (*alMatrixTopNEntry)->_alMatrixTopNSourceAddressLength = vars->val_len;
            (*alMatrixTopNEntry)->alMatrixTopNSourceAddress = (*alMatrixTopNEntry)->__alMatrixTopNSourceAddress;
        }
        if (vars->name_length > sizeof(alMatrixTopNDestAddress)/sizeof(oid)
            && memcmp(vars->name, alMatrixTopNDestAddress, sizeof(alMatrixTopNDestAddress)) == 0) {
            memcpy((*alMatrixTopNEntry)->__alMatrixTopNDestAddress, vars->val.string, vars->val_len);
            (*alMatrixTopNEntry)->_alMatrixTopNDestAddressLength = vars->val_len;
            (*alMatrixTopNEntry)->alMatrixTopNDestAddress = (*alMatrixTopNEntry)->__alMatrixTopNDestAddress;
        }
        if (vars->name_length > sizeof(alMatrixTopNAppProtocolDirLocalIndex)/sizeof(oid)
            && memcmp(vars->name, alMatrixTopNAppProtocolDirLocalIndex, sizeof(alMatrixTopNAppProtocolDirLocalIndex)) == 0) {
            (*alMatrixTopNEntry)->__alMatrixTopNAppProtocolDirLocalIndex = *vars->val.integer;
            (*alMatrixTopNEntry)->alMatrixTopNAppProtocolDirLocalIndex = &((*alMatrixTopNEntry)->__alMatrixTopNAppProtocolDirLocalIndex);
        }
        if (vars->name_length > sizeof(alMatrixTopNPktRate)/sizeof(oid)
            && memcmp(vars->name, alMatrixTopNPktRate, sizeof(alMatrixTopNPktRate)) == 0) {
            (*alMatrixTopNEntry)->__alMatrixTopNPktRate = *vars->val.integer;
            (*alMatrixTopNEntry)->alMatrixTopNPktRate = &((*alMatrixTopNEntry)->__alMatrixTopNPktRate);
        }
        if (vars->name_length > sizeof(alMatrixTopNReversePktRate)/sizeof(oid)
            && memcmp(vars->name, alMatrixTopNReversePktRate, sizeof(alMatrixTopNReversePktRate)) == 0) {
            (*alMatrixTopNEntry)->__alMatrixTopNReversePktRate = *vars->val.integer;
            (*alMatrixTopNEntry)->alMatrixTopNReversePktRate = &((*alMatrixTopNEntry)->__alMatrixTopNReversePktRate);
        }
        if (vars->name_length > sizeof(alMatrixTopNOctetRate)/sizeof(oid)
            && memcmp(vars->name, alMatrixTopNOctetRate, sizeof(alMatrixTopNOctetRate)) == 0) {
            (*alMatrixTopNEntry)->__alMatrixTopNOctetRate = *vars->val.integer;
            (*alMatrixTopNEntry)->alMatrixTopNOctetRate = &((*alMatrixTopNEntry)->__alMatrixTopNOctetRate);
        }
        if (vars->name_length > sizeof(alMatrixTopNReverseOctetRate)/sizeof(oid)
            && memcmp(vars->name, alMatrixTopNReverseOctetRate, sizeof(alMatrixTopNReverseOctetRate)) == 0) {
            (*alMatrixTopNEntry)->__alMatrixTopNReverseOctetRate = *vars->val.integer;
            (*alMatrixTopNEntry)->alMatrixTopNReverseOctetRate = &((*alMatrixTopNEntry)->__alMatrixTopNReverseOctetRate);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int rmon2_mib_mgr_get_usrHistoryControlEntry(struct snmp_session *s, usrHistoryControlEntry_t **usrHistoryControlEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, usrHistoryControlObjects, sizeof(usrHistoryControlObjects)/sizeof(oid));
    snmp_add_null_var(request, usrHistoryControlBucketsRequested, sizeof(usrHistoryControlBucketsRequested)/sizeof(oid));
    snmp_add_null_var(request, usrHistoryControlBucketsGranted, sizeof(usrHistoryControlBucketsGranted)/sizeof(oid));
    snmp_add_null_var(request, usrHistoryControlInterval, sizeof(usrHistoryControlInterval)/sizeof(oid));
    snmp_add_null_var(request, usrHistoryControlOwner, sizeof(usrHistoryControlOwner)/sizeof(oid));
    snmp_add_null_var(request, usrHistoryControlStatus, sizeof(usrHistoryControlStatus)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        return -2;
    }

    *usrHistoryControlEntry = (usrHistoryControlEntry_t *) malloc(sizeof(usrHistoryControlEntry_t));
    if (! *usrHistoryControlEntry) {
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(usrHistoryControlObjects)/sizeof(oid)
            && memcmp(vars->name, usrHistoryControlObjects, sizeof(usrHistoryControlObjects)) == 0) {
            (*usrHistoryControlEntry)->__usrHistoryControlObjects = *vars->val.integer;
            (*usrHistoryControlEntry)->usrHistoryControlObjects = &((*usrHistoryControlEntry)->__usrHistoryControlObjects);
        }
        if (vars->name_length > sizeof(usrHistoryControlBucketsRequested)/sizeof(oid)
            && memcmp(vars->name, usrHistoryControlBucketsRequested, sizeof(usrHistoryControlBucketsRequested)) == 0) {
            (*usrHistoryControlEntry)->__usrHistoryControlBucketsRequested = *vars->val.integer;
            (*usrHistoryControlEntry)->usrHistoryControlBucketsRequested = &((*usrHistoryControlEntry)->__usrHistoryControlBucketsRequested);
        }
        if (vars->name_length > sizeof(usrHistoryControlBucketsGranted)/sizeof(oid)
            && memcmp(vars->name, usrHistoryControlBucketsGranted, sizeof(usrHistoryControlBucketsGranted)) == 0) {
            (*usrHistoryControlEntry)->__usrHistoryControlBucketsGranted = *vars->val.integer;
            (*usrHistoryControlEntry)->usrHistoryControlBucketsGranted = &((*usrHistoryControlEntry)->__usrHistoryControlBucketsGranted);
        }
        if (vars->name_length > sizeof(usrHistoryControlInterval)/sizeof(oid)
            && memcmp(vars->name, usrHistoryControlInterval, sizeof(usrHistoryControlInterval)) == 0) {
            (*usrHistoryControlEntry)->__usrHistoryControlInterval = *vars->val.integer;
            (*usrHistoryControlEntry)->usrHistoryControlInterval = &((*usrHistoryControlEntry)->__usrHistoryControlInterval);
        }
        if (vars->name_length > sizeof(usrHistoryControlOwner)/sizeof(oid)
            && memcmp(vars->name, usrHistoryControlOwner, sizeof(usrHistoryControlOwner)) == 0) {
            memcpy((*usrHistoryControlEntry)->__usrHistoryControlOwner, vars->val.string, vars->val_len);
            (*usrHistoryControlEntry)->_usrHistoryControlOwnerLength = vars->val_len;
            (*usrHistoryControlEntry)->usrHistoryControlOwner = (*usrHistoryControlEntry)->__usrHistoryControlOwner;
        }
        if (vars->name_length > sizeof(usrHistoryControlStatus)/sizeof(oid)
            && memcmp(vars->name, usrHistoryControlStatus, sizeof(usrHistoryControlStatus)) == 0) {
            (*usrHistoryControlEntry)->__usrHistoryControlStatus = *vars->val.integer;
            (*usrHistoryControlEntry)->usrHistoryControlStatus = &((*usrHistoryControlEntry)->__usrHistoryControlStatus);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int rmon2_mib_mgr_get_usrHistoryObjectEntry(struct snmp_session *s, usrHistoryObjectEntry_t **usrHistoryObjectEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, usrHistoryObjectVariable, sizeof(usrHistoryObjectVariable)/sizeof(oid));
    snmp_add_null_var(request, usrHistoryObjectSampleType, sizeof(usrHistoryObjectSampleType)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        return -2;
    }

    *usrHistoryObjectEntry = (usrHistoryObjectEntry_t *) malloc(sizeof(usrHistoryObjectEntry_t));
    if (! *usrHistoryObjectEntry) {
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(usrHistoryObjectVariable)/sizeof(oid)
            && memcmp(vars->name, usrHistoryObjectVariable, sizeof(usrHistoryObjectVariable)) == 0) {
        }
        if (vars->name_length > sizeof(usrHistoryObjectSampleType)/sizeof(oid)
            && memcmp(vars->name, usrHistoryObjectSampleType, sizeof(usrHistoryObjectSampleType)) == 0) {
            (*usrHistoryObjectEntry)->__usrHistoryObjectSampleType = *vars->val.integer;
            (*usrHistoryObjectEntry)->usrHistoryObjectSampleType = &((*usrHistoryObjectEntry)->__usrHistoryObjectSampleType);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int rmon2_mib_mgr_get_usrHistoryEntry(struct snmp_session *s, usrHistoryEntry_t **usrHistoryEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, usrHistoryIntervalStart, sizeof(usrHistoryIntervalStart)/sizeof(oid));
    snmp_add_null_var(request, usrHistoryIntervalEnd, sizeof(usrHistoryIntervalEnd)/sizeof(oid));
    snmp_add_null_var(request, usrHistoryAbsValue, sizeof(usrHistoryAbsValue)/sizeof(oid));
    snmp_add_null_var(request, usrHistoryValStatus, sizeof(usrHistoryValStatus)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        return -2;
    }

    *usrHistoryEntry = (usrHistoryEntry_t *) malloc(sizeof(usrHistoryEntry_t));
    if (! *usrHistoryEntry) {
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(usrHistoryIntervalStart)/sizeof(oid)
            && memcmp(vars->name, usrHistoryIntervalStart, sizeof(usrHistoryIntervalStart)) == 0) {
            (*usrHistoryEntry)->__usrHistoryIntervalStart = *vars->val.integer;
            (*usrHistoryEntry)->usrHistoryIntervalStart = &((*usrHistoryEntry)->__usrHistoryIntervalStart);
        }
        if (vars->name_length > sizeof(usrHistoryIntervalEnd)/sizeof(oid)
            && memcmp(vars->name, usrHistoryIntervalEnd, sizeof(usrHistoryIntervalEnd)) == 0) {
            (*usrHistoryEntry)->__usrHistoryIntervalEnd = *vars->val.integer;
            (*usrHistoryEntry)->usrHistoryIntervalEnd = &((*usrHistoryEntry)->__usrHistoryIntervalEnd);
        }
        if (vars->name_length > sizeof(usrHistoryAbsValue)/sizeof(oid)
            && memcmp(vars->name, usrHistoryAbsValue, sizeof(usrHistoryAbsValue)) == 0) {
            (*usrHistoryEntry)->__usrHistoryAbsValue = *vars->val.integer;
            (*usrHistoryEntry)->usrHistoryAbsValue = &((*usrHistoryEntry)->__usrHistoryAbsValue);
        }
        if (vars->name_length > sizeof(usrHistoryValStatus)/sizeof(oid)
            && memcmp(vars->name, usrHistoryValStatus, sizeof(usrHistoryValStatus)) == 0) {
            (*usrHistoryEntry)->__usrHistoryValStatus = *vars->val.integer;
            (*usrHistoryEntry)->usrHistoryValStatus = &((*usrHistoryEntry)->__usrHistoryValStatus);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int rmon2_mib_mgr_get_probeConfig(struct snmp_session *s, probeConfig_t **probeConfig)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, probeCapabilities, sizeof(probeCapabilities)/sizeof(oid));
    snmp_add_null_var(request, probeSoftwareRev, sizeof(probeSoftwareRev)/sizeof(oid));
    snmp_add_null_var(request, probeHardwareRev, sizeof(probeHardwareRev)/sizeof(oid));
    snmp_add_null_var(request, probeDateTime, sizeof(probeDateTime)/sizeof(oid));
    snmp_add_null_var(request, probeResetControl, sizeof(probeResetControl)/sizeof(oid));
    snmp_add_null_var(request, probeDownloadFile, sizeof(probeDownloadFile)/sizeof(oid));
    snmp_add_null_var(request, probeDownloadTFTPServer, sizeof(probeDownloadTFTPServer)/sizeof(oid));
    snmp_add_null_var(request, probeDownloadAction, sizeof(probeDownloadAction)/sizeof(oid));
    snmp_add_null_var(request, probeDownloadStatus, sizeof(probeDownloadStatus)/sizeof(oid));
    snmp_add_null_var(request, netDefaultGateway, sizeof(netDefaultGateway)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        return -2;
    }

    *probeConfig = (probeConfig_t *) malloc(sizeof(probeConfig_t));
    if (! *probeConfig) {
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(probeCapabilities)/sizeof(oid)
            && memcmp(vars->name, probeCapabilities, sizeof(probeCapabilities)) == 0) {
            memcpy((*probeConfig)->__probeCapabilities, vars->val.string, vars->val_len);
            (*probeConfig)->_probeCapabilitiesLength = vars->val_len;
            (*probeConfig)->probeCapabilities = (*probeConfig)->__probeCapabilities;
        }
        if (vars->name_length > sizeof(probeSoftwareRev)/sizeof(oid)
            && memcmp(vars->name, probeSoftwareRev, sizeof(probeSoftwareRev)) == 0) {
            memcpy((*probeConfig)->__probeSoftwareRev, vars->val.string, vars->val_len);
            (*probeConfig)->_probeSoftwareRevLength = vars->val_len;
            (*probeConfig)->probeSoftwareRev = (*probeConfig)->__probeSoftwareRev;
        }
        if (vars->name_length > sizeof(probeHardwareRev)/sizeof(oid)
            && memcmp(vars->name, probeHardwareRev, sizeof(probeHardwareRev)) == 0) {
            memcpy((*probeConfig)->__probeHardwareRev, vars->val.string, vars->val_len);
            (*probeConfig)->_probeHardwareRevLength = vars->val_len;
            (*probeConfig)->probeHardwareRev = (*probeConfig)->__probeHardwareRev;
        }
        if (vars->name_length > sizeof(probeDateTime)/sizeof(oid)
            && memcmp(vars->name, probeDateTime, sizeof(probeDateTime)) == 0) {
            memcpy((*probeConfig)->__probeDateTime, vars->val.string, vars->val_len);
            (*probeConfig)->_probeDateTimeLength = vars->val_len;
            (*probeConfig)->probeDateTime = (*probeConfig)->__probeDateTime;
        }
        if (vars->name_length > sizeof(probeResetControl)/sizeof(oid)
            && memcmp(vars->name, probeResetControl, sizeof(probeResetControl)) == 0) {
            (*probeConfig)->__probeResetControl = *vars->val.integer;
            (*probeConfig)->probeResetControl = &((*probeConfig)->__probeResetControl);
        }
        if (vars->name_length > sizeof(probeDownloadFile)/sizeof(oid)
            && memcmp(vars->name, probeDownloadFile, sizeof(probeDownloadFile)) == 0) {
            memcpy((*probeConfig)->__probeDownloadFile, vars->val.string, vars->val_len);
            (*probeConfig)->_probeDownloadFileLength = vars->val_len;
            (*probeConfig)->probeDownloadFile = (*probeConfig)->__probeDownloadFile;
        }
        if (vars->name_length > sizeof(probeDownloadTFTPServer)/sizeof(oid)
            && memcmp(vars->name, probeDownloadTFTPServer, sizeof(probeDownloadTFTPServer)) == 0) {
            memcpy((*probeConfig)->__probeDownloadTFTPServer, vars->val.string, vars->val_len);
            (*probeConfig)->probeDownloadTFTPServer = (*probeConfig)->__probeDownloadTFTPServer;
        }
        if (vars->name_length > sizeof(probeDownloadAction)/sizeof(oid)
            && memcmp(vars->name, probeDownloadAction, sizeof(probeDownloadAction)) == 0) {
            (*probeConfig)->__probeDownloadAction = *vars->val.integer;
            (*probeConfig)->probeDownloadAction = &((*probeConfig)->__probeDownloadAction);
        }
        if (vars->name_length > sizeof(probeDownloadStatus)/sizeof(oid)
            && memcmp(vars->name, probeDownloadStatus, sizeof(probeDownloadStatus)) == 0) {
            (*probeConfig)->__probeDownloadStatus = *vars->val.integer;
            (*probeConfig)->probeDownloadStatus = &((*probeConfig)->__probeDownloadStatus);
        }
        if (vars->name_length > sizeof(netDefaultGateway)/sizeof(oid)
            && memcmp(vars->name, netDefaultGateway, sizeof(netDefaultGateway)) == 0) {
            memcpy((*probeConfig)->__netDefaultGateway, vars->val.string, vars->val_len);
            (*probeConfig)->netDefaultGateway = (*probeConfig)->__netDefaultGateway;
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int rmon2_mib_mgr_get_serialConfigEntry(struct snmp_session *s, serialConfigEntry_t **serialConfigEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, serialMode, sizeof(serialMode)/sizeof(oid));
    snmp_add_null_var(request, serialProtocol, sizeof(serialProtocol)/sizeof(oid));
    snmp_add_null_var(request, serialTimeout, sizeof(serialTimeout)/sizeof(oid));
    snmp_add_null_var(request, serialModemInitString, sizeof(serialModemInitString)/sizeof(oid));
    snmp_add_null_var(request, serialModemHangUpString, sizeof(serialModemHangUpString)/sizeof(oid));
    snmp_add_null_var(request, serialModemConnectResp, sizeof(serialModemConnectResp)/sizeof(oid));
    snmp_add_null_var(request, serialModemNoConnectResp, sizeof(serialModemNoConnectResp)/sizeof(oid));
    snmp_add_null_var(request, serialDialoutTimeout, sizeof(serialDialoutTimeout)/sizeof(oid));
    snmp_add_null_var(request, serialStatus, sizeof(serialStatus)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        return -2;
    }

    *serialConfigEntry = (serialConfigEntry_t *) malloc(sizeof(serialConfigEntry_t));
    if (! *serialConfigEntry) {
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(serialMode)/sizeof(oid)
            && memcmp(vars->name, serialMode, sizeof(serialMode)) == 0) {
            (*serialConfigEntry)->__serialMode = *vars->val.integer;
            (*serialConfigEntry)->serialMode = &((*serialConfigEntry)->__serialMode);
        }
        if (vars->name_length > sizeof(serialProtocol)/sizeof(oid)
            && memcmp(vars->name, serialProtocol, sizeof(serialProtocol)) == 0) {
            (*serialConfigEntry)->__serialProtocol = *vars->val.integer;
            (*serialConfigEntry)->serialProtocol = &((*serialConfigEntry)->__serialProtocol);
        }
        if (vars->name_length > sizeof(serialTimeout)/sizeof(oid)
            && memcmp(vars->name, serialTimeout, sizeof(serialTimeout)) == 0) {
            (*serialConfigEntry)->__serialTimeout = *vars->val.integer;
            (*serialConfigEntry)->serialTimeout = &((*serialConfigEntry)->__serialTimeout);
        }
        if (vars->name_length > sizeof(serialModemInitString)/sizeof(oid)
            && memcmp(vars->name, serialModemInitString, sizeof(serialModemInitString)) == 0) {
            memcpy((*serialConfigEntry)->__serialModemInitString, vars->val.string, vars->val_len);
            (*serialConfigEntry)->_serialModemInitStringLength = vars->val_len;
            (*serialConfigEntry)->serialModemInitString = (*serialConfigEntry)->__serialModemInitString;
        }
        if (vars->name_length > sizeof(serialModemHangUpString)/sizeof(oid)
            && memcmp(vars->name, serialModemHangUpString, sizeof(serialModemHangUpString)) == 0) {
            memcpy((*serialConfigEntry)->__serialModemHangUpString, vars->val.string, vars->val_len);
            (*serialConfigEntry)->_serialModemHangUpStringLength = vars->val_len;
            (*serialConfigEntry)->serialModemHangUpString = (*serialConfigEntry)->__serialModemHangUpString;
        }
        if (vars->name_length > sizeof(serialModemConnectResp)/sizeof(oid)
            && memcmp(vars->name, serialModemConnectResp, sizeof(serialModemConnectResp)) == 0) {
            memcpy((*serialConfigEntry)->__serialModemConnectResp, vars->val.string, vars->val_len);
            (*serialConfigEntry)->_serialModemConnectRespLength = vars->val_len;
            (*serialConfigEntry)->serialModemConnectResp = (*serialConfigEntry)->__serialModemConnectResp;
        }
        if (vars->name_length > sizeof(serialModemNoConnectResp)/sizeof(oid)
            && memcmp(vars->name, serialModemNoConnectResp, sizeof(serialModemNoConnectResp)) == 0) {
            memcpy((*serialConfigEntry)->__serialModemNoConnectResp, vars->val.string, vars->val_len);
            (*serialConfigEntry)->_serialModemNoConnectRespLength = vars->val_len;
            (*serialConfigEntry)->serialModemNoConnectResp = (*serialConfigEntry)->__serialModemNoConnectResp;
        }
        if (vars->name_length > sizeof(serialDialoutTimeout)/sizeof(oid)
            && memcmp(vars->name, serialDialoutTimeout, sizeof(serialDialoutTimeout)) == 0) {
            (*serialConfigEntry)->__serialDialoutTimeout = *vars->val.integer;
            (*serialConfigEntry)->serialDialoutTimeout = &((*serialConfigEntry)->__serialDialoutTimeout);
        }
        if (vars->name_length > sizeof(serialStatus)/sizeof(oid)
            && memcmp(vars->name, serialStatus, sizeof(serialStatus)) == 0) {
            (*serialConfigEntry)->__serialStatus = *vars->val.integer;
            (*serialConfigEntry)->serialStatus = &((*serialConfigEntry)->__serialStatus);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int rmon2_mib_mgr_get_netConfigEntry(struct snmp_session *s, netConfigEntry_t **netConfigEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, netConfigIPAddress, sizeof(netConfigIPAddress)/sizeof(oid));
    snmp_add_null_var(request, netConfigSubnetMask, sizeof(netConfigSubnetMask)/sizeof(oid));
    snmp_add_null_var(request, netConfigStatus, sizeof(netConfigStatus)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        return -2;
    }

    *netConfigEntry = (netConfigEntry_t *) malloc(sizeof(netConfigEntry_t));
    if (! *netConfigEntry) {
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(netConfigIPAddress)/sizeof(oid)
            && memcmp(vars->name, netConfigIPAddress, sizeof(netConfigIPAddress)) == 0) {
            memcpy((*netConfigEntry)->__netConfigIPAddress, vars->val.string, vars->val_len);
            (*netConfigEntry)->netConfigIPAddress = (*netConfigEntry)->__netConfigIPAddress;
        }
        if (vars->name_length > sizeof(netConfigSubnetMask)/sizeof(oid)
            && memcmp(vars->name, netConfigSubnetMask, sizeof(netConfigSubnetMask)) == 0) {
            memcpy((*netConfigEntry)->__netConfigSubnetMask, vars->val.string, vars->val_len);
            (*netConfigEntry)->netConfigSubnetMask = (*netConfigEntry)->__netConfigSubnetMask;
        }
        if (vars->name_length > sizeof(netConfigStatus)/sizeof(oid)
            && memcmp(vars->name, netConfigStatus, sizeof(netConfigStatus)) == 0) {
            (*netConfigEntry)->__netConfigStatus = *vars->val.integer;
            (*netConfigEntry)->netConfigStatus = &((*netConfigEntry)->__netConfigStatus);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int rmon2_mib_mgr_get_trapDestEntry(struct snmp_session *s, trapDestEntry_t **trapDestEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, trapDestCommunity, sizeof(trapDestCommunity)/sizeof(oid));
    snmp_add_null_var(request, trapDestProtocol, sizeof(trapDestProtocol)/sizeof(oid));
    snmp_add_null_var(request, trapDestAddress, sizeof(trapDestAddress)/sizeof(oid));
    snmp_add_null_var(request, trapDestOwner, sizeof(trapDestOwner)/sizeof(oid));
    snmp_add_null_var(request, trapDestStatus, sizeof(trapDestStatus)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        return -2;
    }

    *trapDestEntry = (trapDestEntry_t *) malloc(sizeof(trapDestEntry_t));
    if (! *trapDestEntry) {
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(trapDestCommunity)/sizeof(oid)
            && memcmp(vars->name, trapDestCommunity, sizeof(trapDestCommunity)) == 0) {
            memcpy((*trapDestEntry)->__trapDestCommunity, vars->val.string, vars->val_len);
            (*trapDestEntry)->_trapDestCommunityLength = vars->val_len;
            (*trapDestEntry)->trapDestCommunity = (*trapDestEntry)->__trapDestCommunity;
        }
        if (vars->name_length > sizeof(trapDestProtocol)/sizeof(oid)
            && memcmp(vars->name, trapDestProtocol, sizeof(trapDestProtocol)) == 0) {
            (*trapDestEntry)->__trapDestProtocol = *vars->val.integer;
            (*trapDestEntry)->trapDestProtocol = &((*trapDestEntry)->__trapDestProtocol);
        }
        if (vars->name_length > sizeof(trapDestAddress)/sizeof(oid)
            && memcmp(vars->name, trapDestAddress, sizeof(trapDestAddress)) == 0) {
            memcpy((*trapDestEntry)->__trapDestAddress, vars->val.string, vars->val_len);
            (*trapDestEntry)->_trapDestAddressLength = vars->val_len;
            (*trapDestEntry)->trapDestAddress = (*trapDestEntry)->__trapDestAddress;
        }
        if (vars->name_length > sizeof(trapDestOwner)/sizeof(oid)
            && memcmp(vars->name, trapDestOwner, sizeof(trapDestOwner)) == 0) {
            memcpy((*trapDestEntry)->__trapDestOwner, vars->val.string, vars->val_len);
            (*trapDestEntry)->_trapDestOwnerLength = vars->val_len;
            (*trapDestEntry)->trapDestOwner = (*trapDestEntry)->__trapDestOwner;
        }
        if (vars->name_length > sizeof(trapDestStatus)/sizeof(oid)
            && memcmp(vars->name, trapDestStatus, sizeof(trapDestStatus)) == 0) {
            (*trapDestEntry)->__trapDestStatus = *vars->val.integer;
            (*trapDestEntry)->trapDestStatus = &((*trapDestEntry)->__trapDestStatus);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int rmon2_mib_mgr_get_serialConnectionEntry(struct snmp_session *s, serialConnectionEntry_t **serialConnectionEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, serialConnectDestIpAddress, sizeof(serialConnectDestIpAddress)/sizeof(oid));
    snmp_add_null_var(request, serialConnectType, sizeof(serialConnectType)/sizeof(oid));
    snmp_add_null_var(request, serialConnectDialString, sizeof(serialConnectDialString)/sizeof(oid));
    snmp_add_null_var(request, serialConnectSwitchConnectSeq, sizeof(serialConnectSwitchConnectSeq)/sizeof(oid));
    snmp_add_null_var(request, serialConnectSwitchDisconnectSeq, sizeof(serialConnectSwitchDisconnectSeq)/sizeof(oid));
    snmp_add_null_var(request, serialConnectSwitchResetSeq, sizeof(serialConnectSwitchResetSeq)/sizeof(oid));
    snmp_add_null_var(request, serialConnectOwner, sizeof(serialConnectOwner)/sizeof(oid));
    snmp_add_null_var(request, serialConnectStatus, sizeof(serialConnectStatus)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        return -2;
    }

    *serialConnectionEntry = (serialConnectionEntry_t *) malloc(sizeof(serialConnectionEntry_t));
    if (! *serialConnectionEntry) {
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(serialConnectDestIpAddress)/sizeof(oid)
            && memcmp(vars->name, serialConnectDestIpAddress, sizeof(serialConnectDestIpAddress)) == 0) {
            memcpy((*serialConnectionEntry)->__serialConnectDestIpAddress, vars->val.string, vars->val_len);
            (*serialConnectionEntry)->serialConnectDestIpAddress = (*serialConnectionEntry)->__serialConnectDestIpAddress;
        }
        if (vars->name_length > sizeof(serialConnectType)/sizeof(oid)
            && memcmp(vars->name, serialConnectType, sizeof(serialConnectType)) == 0) {
            (*serialConnectionEntry)->__serialConnectType = *vars->val.integer;
            (*serialConnectionEntry)->serialConnectType = &((*serialConnectionEntry)->__serialConnectType);
        }
        if (vars->name_length > sizeof(serialConnectDialString)/sizeof(oid)
            && memcmp(vars->name, serialConnectDialString, sizeof(serialConnectDialString)) == 0) {
            memcpy((*serialConnectionEntry)->__serialConnectDialString, vars->val.string, vars->val_len);
            (*serialConnectionEntry)->_serialConnectDialStringLength = vars->val_len;
            (*serialConnectionEntry)->serialConnectDialString = (*serialConnectionEntry)->__serialConnectDialString;
        }
        if (vars->name_length > sizeof(serialConnectSwitchConnectSeq)/sizeof(oid)
            && memcmp(vars->name, serialConnectSwitchConnectSeq, sizeof(serialConnectSwitchConnectSeq)) == 0) {
            memcpy((*serialConnectionEntry)->__serialConnectSwitchConnectSeq, vars->val.string, vars->val_len);
            (*serialConnectionEntry)->_serialConnectSwitchConnectSeqLength = vars->val_len;
            (*serialConnectionEntry)->serialConnectSwitchConnectSeq = (*serialConnectionEntry)->__serialConnectSwitchConnectSeq;
        }
        if (vars->name_length > sizeof(serialConnectSwitchDisconnectSeq)/sizeof(oid)
            && memcmp(vars->name, serialConnectSwitchDisconnectSeq, sizeof(serialConnectSwitchDisconnectSeq)) == 0) {
            memcpy((*serialConnectionEntry)->__serialConnectSwitchDisconnectSeq, vars->val.string, vars->val_len);
            (*serialConnectionEntry)->_serialConnectSwitchDisconnectSeqLength = vars->val_len;
            (*serialConnectionEntry)->serialConnectSwitchDisconnectSeq = (*serialConnectionEntry)->__serialConnectSwitchDisconnectSeq;
        }
        if (vars->name_length > sizeof(serialConnectSwitchResetSeq)/sizeof(oid)
            && memcmp(vars->name, serialConnectSwitchResetSeq, sizeof(serialConnectSwitchResetSeq)) == 0) {
            memcpy((*serialConnectionEntry)->__serialConnectSwitchResetSeq, vars->val.string, vars->val_len);
            (*serialConnectionEntry)->_serialConnectSwitchResetSeqLength = vars->val_len;
            (*serialConnectionEntry)->serialConnectSwitchResetSeq = (*serialConnectionEntry)->__serialConnectSwitchResetSeq;
        }
        if (vars->name_length > sizeof(serialConnectOwner)/sizeof(oid)
            && memcmp(vars->name, serialConnectOwner, sizeof(serialConnectOwner)) == 0) {
            memcpy((*serialConnectionEntry)->__serialConnectOwner, vars->val.string, vars->val_len);
            (*serialConnectionEntry)->_serialConnectOwnerLength = vars->val_len;
            (*serialConnectionEntry)->serialConnectOwner = (*serialConnectionEntry)->__serialConnectOwner;
        }
        if (vars->name_length > sizeof(serialConnectStatus)/sizeof(oid)
            && memcmp(vars->name, serialConnectStatus, sizeof(serialConnectStatus)) == 0) {
            (*serialConnectionEntry)->__serialConnectStatus = *vars->val.integer;
            (*serialConnectionEntry)->serialConnectStatus = &((*serialConnectionEntry)->__serialConnectStatus);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}


