
require 'sdl'

White = [255,255,255]

def print_joystick_info
  for i in 0..SDL::Joystick.num-1
    print i,":",SDL::Joystick.name(0),"\n"
  end
end

def display_button_state ( screen, joy )
  for i in 0..joy.numButtons-1
    if joy.button(i) then
      screen.fillRect( i*30+30, 50, 10, 10, [0,0,128] )
    else
      screen.fillRect( i*30+30, 50, 10, 10, White )
    end
  end
end

def display_hat_state ( screen, joy )
  # display the state of only first hat
  
end

def display_axis_state ( screen, joy )
  for i in 0..joy.numAxes-1
    screen.fillRect( i*30+130, joy.axis(i)*150/32768, 20, 20, White )
  end
end

SDL.init( SDL::INIT_VIDEO|SDL::INIT_JOYSTICK )
screen = SDL::setVideoMode(640, 480, 16, SDL::SWSURFACE)

if SDL::Joystick.num == 0 then
  print "No joystick available\n"
  exit
end

if ARGV.size == 0 then
  print_joystick_info
  exit
end

joynum = ARGV[0].to_i

if SDL::Joystick.num < joynum then
  print "Joystick No.#{joynum} is not available\n"
  exit
end

joy=SDL::Joystick.open(0)

event=SDL::Event.new

while true 
  if  event.poll != 0 then
    if event.type==SDL::Event::QUIT then
      break
    end
    if event.type==SDL::Event::KEYDOWN then
      exit
    end
  end
  SDL::Joystick.updateAll
  screen.fillRect(0,0,640,480,0)
  display_button_state screen, joy
  display_hat_state screen, joy
  display_axis_state screen, joy
  screen.updateRect(0, 0, 0, 0)
end
