#!/do/not/bash
# toc_run_description = Creates a rudimentary .qmake.cache.
# toc_begin_help =
# Creates a .qmake.cache file.
# If $1 is set to a file that file is at-filtered,
# otherwise a rudimentary file is created.
#
# = toc_end_help
trap 'test -f $CACHETMP && rm $CACHETMP' 0

test -d "$QTBINDIR" || {
    echo "QTBINDIR must be set before running this test! Try running the 'qt' test."
    return 1
}
outpath="$PWD"
CACHEFILE=.qmake.cache
CACHETMP="$CACHEFILE.tmp"

infile=$1
test x = "x$infile" && {
    cat <<EOF > "$CACHETMP"
QMAKE_BUILD_TREE = $outpath
QMAKE_QMAKE = $QTBINDIR/qmake
EOF
} || {
    cp "$infile" "$CACHETMP" || return $?
}

toc_atfilter_as_makefile $CACHETMP $CACHEFILE
return $?
