#ifndef PACKAGE_NAMESPACE_STRINGTOKENIZER_H
#define PACKAGE_NAMESPACE_STRINGTOKENIZER_H

namespace PACKAGE_NAMESPACE {


        /**
           string_tokenizer is a... well, a string tokenizer, modelled after
           Java's java.util.string_tokenizer class.

           This code used to be part of the KDE 1.x libraries: (named StringTokenizer)
           Copyright (C) 1997 Martin Jones (mjones@kde.org)
           (C) 1997 Torben Weis (weis@kde.org)
           (C) 1998 Waldo Bastian (bastian@kde.org)
           
           Then this code was part of the QUB project:
           Copyright (C) 2000-2003 stephan beal (stephan@s11n.net)
           and Rusty Ballinger (bozo@users.sourceforge.net)
           
           THIS code is part of the libessentials (a.k.a., elib):
           This copy is mainained by stephan@s11n.net
           i have explicit permission from the three original authors
           to release this code into the Public Domain, and this copy 
           falls under that "license."
        */

        class string_tokenizer
        {
        public:
                string_tokenizer();
                ~string_tokenizer();

                /**
                   Sets the token list and separator to be used by
                   subsequent next_token() calls.

                   It is important that the strings not be
                   destroyed/freed by the client before this object is
                   done with them. That is, do not call tokenize(),
                   then free the strings, then call has_tokens() or
                   next_token(). (In practice, this has never happened.)
                 */
                void tokenize( const char * sequence, const char * separator );

                /**
                   Returns the next token in the list. Results are
                   undefined if this method is called when
                   has_tokens() returns false.
                */
                const char* next_token();

                /**
                   Returns true if this object has another token to
                   return via next_token().
                 */
                bool has_tokens();

        private:
                char *pos;
                char *end;
                char *buffer;
                int  bufLen;
        };

}; // namespace PACKAGE_NAMESPACE
#endif // PACKAGE_NAMESPACE_STRINGTOKENIZER_H

