#ifndef S11N_NS_S11N_CORE_INCLUDED
#define S11N_NS_S11N_CORE_INCLUDED 1

////////////////////////////////////////////////////////////////////////
// s11n_core.h: some oh-so-core functions and includes
// for use by s11n code.
//
//    Author: stephan beal <stephan@s11n.net>
//    License: Public Domain
////////////////////////////////////////////////////////////////////////

#include <string>
#include <memory> // auto_ptr

#include <S11N_NS/cllite.h> // classloader "lite" interface
#include <S11N_NS/class_name.h> // used for getting/setting type names

namespace S11N_NS
{


        /**
           Returns BaseT's classloader.

           See cllite::classloader() for important info.
        */
        template <typename BaseT>
        class_loader<BaseT> &
        classloader()
        {
                return cllite::classloader<BaseT>();
        }

        /**
           See cllite::classload() for the docs.
        */
        template <typename BaseType>
        BaseType * classload( const std::string key )
        {
                return cllite::classload<BaseType>( key );
        }

        /**
           Registers SubType with BaseType's classloader, using
           a default object factory.

           SubType may be the same as BaseType. If BaseType is
           abstract it must first be registered as an abstract base,
           e.g., using
           S11N_NS_CLASSLOADER_ABSTRACT_BASE(BaseType), and in
           that case BaseType should not be registered directly with
           this function.

           Maintenance warning: see the notes in this func!
        */
        template <typename BaseType, typename SubType>
        void classloader_register( const std::string & classname )
        {
                classloader<BaseType>().register_factory( classname,
                                                          object_factory<BaseType,SubType>::new_instance
                                                          // ^^^ will break of classloader changes from using object_factory
                                                          // for it's default factory.
                                                          );

/**********************************************************************************
// WTF??? WTF??? WTF??? WTF??? WTF??? WTF??? WTF??? WTF??? WTF???
//                 typedef classloader_selector<BaseType> CLS;
//                 typedef typename CLS::classloader_type CL;
//                 CL::register_subtype<SubType>( classname );
// why no compilie?!?!?! (gcc 3.3.1)
//                 class_loader<BaseType> & cl = classloader<BaseType>();
//                 cl.register_subtype<SubType>( classname );
// classloader<BaseType>().register_subtype<SubType>( classname );
happens on register_subtype<>().
   s11n::classloader_register(const std::string&)':
../../include/s11n/s11n_core.h:110: error: parse error before `>' token
../../include/s11n/s11n_core.h:111: error: parse error before `)' token

Same construct compiles fine in:
./s11n/src/serializer_loader.cpp:                        this->register_subtype<compact_serializer>( "51191001" );
./s11n/src/serializer_loader.cpp:                        this->register_subtype<compact_serializer>( "51191011" );
./s11n/src/serializer_loader.cpp:                        this->register_subtype<funtxt_serializer>( "#SerialTree 1" );
./s11n/src/serializer_loader.cpp:                        this->register_subtype<funxml_serializer>( "<!DOCTYPE SerialTree>" );
./s11n/src/serializer_loader.cpp:                        this->register_subtype<hex_serializer>( "51190001" );
./s11n/src/serializer_loader.cpp:                        this->register_subtype<simplexml_serializer>( "<!DOCTYPE S11N_NS::simplexml>" );
./s11n/src/serializer_loader.cpp:                        this->register_subtype<paren_serializer>( "(S11N_NS::parens)" );

i often have trouble calling member template funcs from gcc 3.3.1: it allows them
in some contexts and not in others. AAARRRGGGG!!!!
************************************************************************/
        }

        template <typename BaseType>
        void classloader_register_base( const std::string & classname )
        {
                classloader<BaseType>().register_factory( classname,
                                                          object_factory<BaseType,BaseType>::new_instance
                                                          );
        }

        template <typename BaseType>
        void classloader_register_abstract( const std::string & classname )
        {
                classloader<BaseType>().register_factory( classname,
                                                          object_factory<BaseType,BaseType>::no_instance
                                                          );
        }

} // namespace


#endif // S11N_NS_S11N_CORE_INCLUDED
