////////////////////////////////////////////////////////////////////////
// "supermacro" registering "default serializable" types.
// It is compatible with all types which have serialization operators().
//
// License: Public Domain
// Author: stephan@s11n.net
//
// This file does not use a conventional BLAH_H_INCLUDED guard.
// Yes, that's on purpose.
//
// The s11n header files are expected to have been included by the
// time this file is ever included.
//
// Sample usage:
//
// #define S11N_TYPE MySubtype
// #define S11N_BASE_TYPE MyBase  // defaults to S11N_TYPE
// #define S11N_NAME "MySubtype"
// // optional:
// // #define S11N_SERIALIZE_FUNCTION member_func_name // default= operator()
// // #define S11N_DESERIALIZE_FUNCTION member_func_name // default= operator()
// #include [this file]
//
// Repeat for each type. If MyBase is abstract, also define this
// when registering MyBase:
//
// #define S11N_ABSTRACT_BASE
//
// That is ONLY necessary when registering MyBase, not when
// registering a subclass.
//
// After each include all of these macros are unset so that they may
// be immediately re-used for another registration.
//
////////////////////////////////////////////////////////////////////////
// General notes:
//
// By s11n convention S11N_NAME should contain no spaces, even for
// template types. Thus, please use:
//
//    "std::list<std::list<foo*>>"
//
// instead of:
//
//     "std::list<std::<list<foo *> >"
//
// C++ needs a space between "> >", but s11n does not.
// That said, s11n DOESN'T CARE what class names you use, as long
// as you're consistent.
//
////////////////////////////////////////////////////////////////////////

#define DEBUG_REG 0
#if DEBUG_REG
#  include <S11N_NS/debuggering_macros.h>
#endif


#ifndef S11N_TYPE
#    error "S11N_TYPE is not set. Set it to the type you want to proxy before including this file!"
#endif

#ifndef S11N_NAME
#    error "S11N_NAME must be set to the string form of S11N_TYPE"
#endif


#ifndef S11N_BASE_TYPE
#  define S11N_BASE_TYPE S11N_TYPE
// ARGUABLE!!!!!!
// #    error "S11N_BASE_TYPE is not set. Set it before including this file!"
#endif


#ifndef S11N_SERIALIZE_FUNCTION
#  define S11N_SERIALIZE_FUNCTION operator()
#endif

#ifndef S11N_DESERIALIZE_FUNCTION
#  define S11N_DESERIALIZE_FUNCTION operator()
#endif

////////////////////////////////////////////////////////////////////////
// set up the type name registry
#define NAME_TYPE S11N_TYPE
#define TYPE_NAME S11N_NAME
#include <S11N_NS/name_type.h>
////////////////////////////////////////////////////////////////////////


namespace { // anonymous namespace is important for complex linking reasons.



#ifndef S11N_NS_SERIALIZER_REG_CONTEXT_DEFINED
#define S11N_NS_SERIALIZER_REG_CONTEXT_DEFINED 1
        ///////////////////////////////////////////////////////////////
        // we must not include this more than once per compilation unit
        ///////////////////////////////////////////////////////////////
        // A unique (per Context/per compilation unit) space to assign
        // a bogus value for classloader registration purposes (see
        // the classloader docs for a full description of how this
        // works).
        template <typename Context>
        struct serializer_reg_context
        {
                typedef Context context;
                static bool placeholder;
                static void reg()
                {
                        CERR << "ACHTUNG: " << ::classname< serializer_reg_context<context> >()
                             << " is not specialized, which means that registration hasn't been done.\n"
                             << "For instructions see: " << __FILE__ << "\n";
                        abort();
                }

        };
        template <typename Context> bool serializer_reg_context<Context>::placeholder = false;
#endif //  !S11N_NS_SERIALIZER_REG_CONTEXT_DEFINED

        template <>
        struct serializer_reg_context< S11N_TYPE >
        {
                typedef S11N_TYPE context;
                static bool placeholder;
                static void reg()
                {
#if DEBUG_REG
                        CERR << "\nRegistering Serializable: " << S11N_NAME << "\n"
                             << "::classname<>() says: " << ::classname< S11N_TYPE >() << "\n"
                                ;
#endif // DEBUG_REG

#ifdef S11N_ABSTRACT_BASE
                        cllite::register_abstract_base< S11N_BASE_TYPE >( ::classname< context >() );
#  undef S11N_ABSTRACT_BASE
#else
                        cllite::register_factory< S11N_BASE_TYPE, S11N_TYPE >( ::classname< context >() );
                        cllite::register_factory< S11N_TYPE, S11N_TYPE >( ::classname< context >() );
#endif
                }
        };

        bool serializer_reg_context< S11N_TYPE >::placeholder = (
                                                              serializer_reg_context< S11N_TYPE >::reg()
                                                              ,
                                                              true
                                                              );
// serializer_reg_context 
////////////////////////////////////////////////////////////////////////////////

        ////////////////////////////////////////////////////////////////////////
        // Note that the code below is useless for abstract types, but:
        //
        // a) it's difficult to avoid with the macro (without adding
        // to the client interface)
        //
        // b) such types will never be instantiated, so this code
        // simply won't do anything. Not as if dead code is *good*,
        // but hey.
        ////////////////////////////////////////////////////////////////////////
        	
        ////////////////////////////////////////////////////////////////////////
        // give s11n de/serialize implementations for S11N_TYPE:
        ////////////////////////////////////////////////////////////////////////
	template <> struct s11n_api_marshaler< S11N_TYPE >
        {
                typedef S11N_TYPE serializable_type;
                template <typename NodeType>
                static bool serialize( NodeType &dest, const serializable_type & src )
                {
                        dest.impl_class( ::classname< S11N_TYPE >() ); // only good for monomorphs
                        //dest.impl_class( ::clname::classname( &src ) );
                        return src.S11N_SERIALIZE_FUNCTION( dest );
                }

                template <typename NodeType>
                static bool deserialize( const NodeType & src, serializable_type & dest ) 
                {
                        return dest.S11N_DESERIALIZE_FUNCTION( src );
                }

        }; // struct s11n_api_marshaler< S11N_TYPE >

} // anon namespace 

////////////////////////////////////////////////////////////////////////////////
// end proxy code for [S11N_TYPE]
////////////////////////////////////////////////////////////////////////////////
#undef S11N_TYPE
#undef S11N_BASE_TYPE
#undef S11N_NAME
#undef S11N_SERIALIZE_FUNCTION
#undef S11N_DESERIALIZE_FUNCTION
#undef DEBUG_REG

