Summary:	A library for manipulating QuickTime files
Name:		libquicktime
Version:	0.9.7
Release:	1
License:	GPL
Group:		Libraries
Group(de):	Libraries
Group(es):	Bibliotecas
Group(fr):	Librairies
Group(pl):	Biblioteki
Group(pt_BR):	Bibliotecas
Group(ru):	
Group(uk):	̦
Source0:	%{name}-%{version}.tar.gz
# Source0	http://heroinewarrior.com/%{name}-%{version}.tar.gz
URL:		http://http://libquicktime.sourceforge.net/
BuildRequires:	autoconf
BuildRequires:	automake
BuildRequires:	libpng-devel >=     1.0.8
BuildRequires:	libjpeg-devel >=    6b
BuildRequires:	libvorbis-devel >=  1.0
BuildRequires:	libdv-devel >=      0.102
BuildRequires:  gtk+-devel >=       2.4.0
BuildRequires:  lame-devel >=       3.93
BuildRequires:	libraw1394-devel >= 0.9.0
BuildRequires:	libavc1394-devel >= 0.3.1
BuildRequires:	ffmpeg-devel =      0.4.9-pre1

BuildRoot:	/tmp/libquicktime

%description
Libquicktime is a library for reading and writing QuickTime files
on UNIX systems. Video CODECs supported by this library are OpenDivX, MJPA,
JPEG Photo, PNG, RGB, YUV 4:2:2, and YUV 4:2:0 compression.  Supported
audio CODECs are Ogg Vorbis, IMA4, ulaw, and any linear PCM format.

Libquicktime is based on the quicktime4linux library.  Libquicktime add
features such as a GNU build tools-based build process and dynamically
loadable CODECs.

%package firewire
Summary:	Firewire Support for libquicktime
Group:		Applications/Graphics
Group(de):	Applikationen/Grafik
Group(pl):	Aplikacje/Grafika
Group(pt):	Aplicaes/Grficos
Requires:	%{name} = %{version}
Requires:	libraw1394 >= 0.9.0
Requires:	libavc1394 >= 0.3.1
Requires:       libdv >=      0.102

%description firewire
Firewire Support for libquicktime

%package firewire-devel
Summary:	Header files for libquicktime firewire support 
Group:		Applications/Graphics
Group(de):	Applikationen/Grafik
Group(pl):	Aplikacje/Grafika
Group(pt):	Aplicaes/Grficos
Requires:	%{name} = %{version}

%description firewire-devel
Header files for libquicktime firewire support

%package devel
Summary:	Header files and development documentation for libquicktime
Summary(pl):	Pliki nagwkowe i dokumentacja do libquicktime
Group:		Development/Libraries
Group(de):	Entwicklung/Libraries
Group(es):	Desarrollo/Bibliotecas
Group(fr):	Development/Librairies
Group(pl):	Programowanie/Biblioteki
Group(pt_BR):	Desenvolvimento/Bibliotecas
Group(ru):	/
Group(uk):	/̦
Requires:	%{name} = %{version}

%description devel
Header files and development documentation for libquicktime.

%description -l pl devel
Pliki nagwkowe i dokumentacja do biblioteki libquicktime.

%package progs
Summary:	Useful tools to operate at QuickTime files
Summary(pl):	Poyteczne narzdzia od operowania na plikach w formacie QuickTime
Group:		Applications/Graphics
Group(de):	Applikationen/Grafik
Group(pl):	Aplikacje/Grafika
Group(pt):	Aplicaes/Grficos
Requires:	%{name} = %{version}

%description progs
Useful tools to operate on QuickTime files.

%description -l pl progs
Poyteczne narzdzia od operowania na plikach w formacie QuickTime.

%package vorbis
Summary:	Libquicktime plugin supporting the Ogg Vorbis codec
Group:		Applications/Graphics
Requires:	%{name} = %{version}
Requires:       libvorbis >=  1.0 

%description vorbis
Libquicktime plugin supporting the Ogg Vorbis codec

%package opendivx
Summary:	Libquicktime plugin supporting the OpenDivX codec
Group:		Applications/Graphics
Requires:	%{name} = %{version}

%description opendivx
Libquicktime plugin supporting the OpenDivX codec

%package dv
Summary:	Libquicktime plugin supporting the DV codec
Group:		Applications/Graphics
Requires:	%{name} = %{version}
Requires:	libdv >= 0.102
Requires:	libraw1394

%description dv
Libquicktime plugin supporting the DV codec

%package jpeg
Summary:	Libquicktime plugin based on libjpeg
Group:		Applications/Graphics
Requires:	%{name} = %{version}
Requires:	libjpeg >= 6b

%description jpeg
Libquicktime plugin based on libjpeg

%package png
Summary:	PNG plugin for Libquicktime
Group:		Applications/Graphics
Requires:	%{name} = %{version}
Requires:	libpng >= 1.0.8

%description png
Libquicktime plugin based on libpng

%package lame
Summary:	Lame plugin for Libquicktime
Group:		Applications/Graphics
Requires:	%{name} = %{version}
Requires:	lame >= 3.93

%description lame
Lame plugin for Libquicktime

%package ffmpeg
Summary:	ffmpeg plugins for Libquicktime
Group:		Applications/Graphics
Requires:	%{name} = %{version}
Requires:	ffmpeg = 0.4.9-pre1


%description ffmpeg
ffmpeg plugins for Libquicktime

%package plugincfg
Summary:	Plugin configurator for Libquicktime
Group:		Applications/Graphics
Requires:	%{name} = %{version}
Requires:	gtk+ >= 2.4.0

%description plugincfg
Plugin configurator for Libquicktime

%package static
Summary:	Static libquicktime libraries
Summary(pl):	Biblioteki statyczne libquicktime
Group:		Development/Libraries
Group(de):	Entwicklung/Libraries
Group(es):	Desarrollo/Bibliotecas
Group(fr):	Development/Librairies
Group(pl):	Programowanie/Biblioteki
Group(pt_BR):	Desenvolvimento/Bibliotecas
Group(ru):	/
Group(uk):	/̦
Requires:	%{name}-devel = %{version}

%description static
Static libquicktime libraries.

%description -l pl static
Biblioteki statyczne libquicktime.

%prep
%setup -q

%build
rm -f missing
./autogen.sh
%configure

%{__make}

%install
rm -rf $RPM_BUILD_ROOT

%{__make} install DESTDIR=$RPM_BUILD_ROOT

gzip -9nf README

%clean
rm -rf $RPM_BUILD_ROOT

%post   -p /sbin/ldconfig
%postun -p /sbin/ldconfig

%files
%defattr(644,root,root,755)
%doc README.gz
%attr(755,root,root) %{_libdir}/libquicktime.so*
%attr(644,root,root) %{_libdir}/libquicktime.la
%attr(755,root,root) %{_libdir}/libquicktime/lqt_audiocodec.so
%attr(644,root,root) %{_libdir}/libquicktime/lqt_audiocodec.la
%attr(755,root,root) %{_libdir}/libquicktime/lqt_videocodec.so
%attr(644,root,root) %{_libdir}/libquicktime/lqt_videocodec.la
%attr(755,root,root) %{_libdir}/libquicktime/lqt_rtjpeg.so
%attr(644,root,root) %{_libdir}/libquicktime/lqt_rtjpeg.la

%files firewire
%attr(755,root,root) %{_libdir}/libquicktime1394.so*
%attr(644,root,root) %{_libdir}/libquicktime1394.la

%files firewire-devel
%attr(644,root,root) %{_includedir}/quicktime/libdv.h

%files devel
%doc doc/*.html
%attr(755,root,root) %{_libdir}/lib*.so
%attr(755,root,root) %{_includedir}/quicktime
%attr(755,root,root) %{_bindir}/lqt-config
%attr(755,root,root) %{_datadir}/aclocal/lqt.m4
%attr(644,root,root) %{_libdir}/pkgconfig/libquicktime.pc

%files plugincfg
%attr(755,root,root) %{_bindir}/libquicktime_config

%files progs
%defattr(644,root,root,755)
%attr(755,root,root) %{_bindir}/qt* 
%attr(755,root,root) %{_bindir}/lqt_transcode
%attr(755,root,root) %{_bindir}/lqtplay
%attr(755,root,root) %{_bindir}/lqtvrplay
%attr(644,root,root) %{_datadir}/man/man1/lqtplay.1.gz

%files jpeg
%attr(755,root,root) %{_libdir}/libquicktime/lqt_mjpeg.so
%attr(644,root,root) %{_libdir}/libquicktime/lqt_mjpeg.la

%files ffmpeg
%attr(755,root,root) %{_libdir}/libquicktime/lqt_ffmpeg.so
%attr(644,root,root) %{_libdir}/libquicktime/lqt_ffmpeg.la

%files png
%attr(755,root,root) %{_libdir}/libquicktime/lqt_png.so
%attr(644,root,root) %{_libdir}/libquicktime/lqt_png.la

%files vorbis
%defattr(644,root,root,755)
%attr(755,root,root) %{_libdir}/libquicktime/lqt_vorbis.so
%attr(644,root,root) %{_libdir}/libquicktime/lqt_vorbis.la

%files opendivx
%defattr(644,root,root,755)
%attr(755,root,root) %{_libdir}/libquicktime/lqt_opendivx.so
%attr(644,root,root) %{_libdir}/libquicktime/lqt_opendivx.la

%files dv
%attr(755,root,root) %{_libdir}/libquicktime/lqt_dv.so
%attr(644,root,root) %{_libdir}/libquicktime/lqt_dv.la

%files lame
%attr(755,root,root) %{_libdir}/libquicktime/lqt_lame.so
%attr(644,root,root) %{_libdir}/libquicktime/lqt_lame.la

%define date	%(echo `LC_ALL="C" date +"%a %b %d %Y"`)
%changelog
* Sat Feb 02 2002 W. Michael Petullo <libquicktime@flyn.org>
- Split vorbis, opendivx, and DV plugins into separate packages.
- First working release.
