package ru.novosoft.uml.gen;

import java.io.*;
import java.util.*;

/**
 * Generic generator writer
 * @author Constantine A. Plotnikov
 * @version 0.1.0
 */
public class IdentWriter extends PrintWriter
{
  /**
   * identation level
   */
  protected int identationLevel;

  /**
   * identation string
   */
  private java.lang.String identationString = "  ";

  /**
   * get identationString
   * @return a String
   */
  public java.lang.String getIdentationString()
  {
    return identationString;
  }

  /**
   * set identation string
   * @param a String
   */
  public void setIdentationString(java.lang.String arg)
  {
    identationString = arg;
  }

  /**
   * a constructor
   * @param g a Generator
   * @param out a java.io.PrintWriter
   */
  public IdentWriter(java.io.Writer out)
  {
    super(out);
  }

  /**
   * increase identation level
   */
  public void ident()
  {
    identationLevel++;
  }

  /**
   * decrease identation level
   */
  public void unident()
  {
    identationLevel--;
  }

  /**
   * print line with current identation level
   * @param ln line to print
   */
  public void line(java.lang.String ln)
  {
    sline(ln);
    println();
  }

  /**
   * ident then print line
   * @param line a String
   */
  public void iline(java.lang.String ln)
  {
    ident();
    line(ln);
  }

  /**
   * unident then print line
   * @param ln line to print
   */
  public void uline(java.lang.String ln)
  {
    unident();
    line(ln);
  }
  
  /**
   * ident then print line then unident
   * @param ln line to print
   */
  public void ilineu(java.lang.String ln)
  {
    iline(ln);
    unident();
  }

  /**
   * ident then print line then unident
   * @param ln line to print
   */
  public void ulinei(java.lang.String ln)
  {
    unident();
    line(ln);
    ident();
  }

  /**
   * start printing line, after this print 
   * and println methods should be called.
   * @param s a String
   */
  public void sline(java.lang.String s)
  {
    sline();
    print(s);
  }

  /**
   * start printing line. After this print 
   * and println methods should be called.
   * This method should be overloaded if
   * other identation policy is used.
   * @param s a String
   */
  public void sline()
  {
    for (int i=0; i<identationLevel; i++)
    {
      print(identationString);
    }
  }
}
