package ru.novosoft.uml.gen;

import java.util.*;
import java.io.*;

import com.wutka.dtd.*;

import ru.novosoft.uml.gen.mmm.*;

public class GenMMXMIWriter extends GenMMWriter
{
  public static String CLASSNAME = "XMIWriter";
  public static String PACKAGE= "ru.novosoft.uml.xmi";

  protected MPackage root = null;
  protected DTD dtd = null;
  
  GenMMXMIWriter(GenMM g, HashMap hmTypes) throws IOException
  {
    super(g, PACKAGE, CLASSNAME+".java");
    try
    {
      root = g.getRootPackage();

      dtd = new DTDParser(new InputStreamReader(getResourceAsStream("", "uml.1.3.dtd")), false).parse();

      prolog();

      sline("package "); print(PACKAGE); println(";");
      println();

      imports();

      println();
      sline("public class "); print(CLASSNAME); println(" extends PrintWriter");
      sblock();

      sline("public static final String EXPORTER_VERSION = \""); print(GenMM.VERSION_NUMBER); println("\";");
      appendResource(PACKAGE, CLASSNAME+".user");

      Iterator i = hmTypes.values().iterator();
      while (i.hasNext())
      {
        MClass c = (MClass)i.next();
        if ((c instanceof MElement || c instanceof MDataType) && (!c.getName().equals("Base")) && (!c.getName().equals("Extension")))
        {
          genClass(c);
        }
      }
      println();

      line("public void print(Object arg, boolean ref, String roleTypeXMIName) throws SAXException");
      sblock();

      line("ref = ref || isElementProcessed(arg);");
      println();

      sif("(arg != getModel()) && (arg instanceof MBase) && (null == ((MBase)arg).getModelElementContainer())");
        line("notContained.put(arg, arg);");
        //line("return;");
      eif();
      println();

      line("if (ref)");
      line("{"); ident();
  
      //sline("sline(\"<"); print(getFullXMITagName(p_cls)); println(" xmi.idref=\\\"\");  println(\"\\\"/>\");");
  
      line("al.addAttribute(\"xmi.idref\", CDATA_TYPE, getXMIID(arg));");
      line("dh.startElement(roleTypeXMIName, al); al.clear();");
      line("dh.endElement(roleTypeXMIName);");
      println();

      line("return;");      
      uline("}");
      println();

      HashSet hsProcessedClasses = new HashSet();
      HashSet hsLevel = new HashSet();

      i = hmTypes.values().iterator();
      while (i.hasNext())
      {
        MClass c = (MClass)i.next();
        Collection colSub = c.getSubClasses();
        if (null == colSub || 0 == colSub.size())
        {
          hsLevel.add(c);
        }
      }

      while(!hsLevel.isEmpty())
      {
        i = hsLevel.iterator();
        while(i.hasNext())
        {
          MClass c = (MClass)i.next();
          if (!hsProcessedClasses.contains(c))
          {
            hsProcessedClasses.add(c);
            if ((c instanceof MElement || c instanceof MDataType) && (!c.getName().equals("Base")) && (!c.getName().equals("Extension")))
            {
              genSelector(c);
            }
          }
        }

        HashSet hsNext = new HashSet();
        i = hsLevel.iterator();
        while (i.hasNext())
        {
          MClass c = (MClass)i.next();
          Collection colSuper = c.getSuperClasses();
          if (null != colSuper)
          {
            hsNext.addAll(colSuper);
          }
        }

        HashSet all = new HashSet();
        i = hsNext.iterator();
        while (i.hasNext())
        {
          MClass c = (MClass)i.next();
          getSuperclasses(c, all);
        }

        hsNext.removeAll(all);
        hsLevel = hsNext;
      }

      eblock();
      println();

      // Generate preprocessIDs

      line("public void preprocessIDs(MBase arg)");
      sblock();

      line("if (null == arg)");
      sblock();
      line("return;");
      eblock();
      println();

      hsProcessedClasses = new HashSet();
      hsLevel = new HashSet();

      i = hmTypes.values().iterator();
      while (i.hasNext())
      {
        MClass c = (MClass)i.next();
        Collection colSub = c.getSubClasses();
        if (null == colSub || 0 == colSub.size())
        {
          hsLevel.add(c);
        }
      }

      boolean bFirst = true;

      while(!hsLevel.isEmpty())
      {
        i = hsLevel.iterator();
        while(i.hasNext())
        {
          MClass c = (MClass)i.next();
          if (!hsProcessedClasses.contains(c))
          {
            hsProcessedClasses.add(c);
            if ((c instanceof MElement) && (!c.getName().equals("Base")) && (!c.getName().equals("Extension")))
            {
              if (bFirst)
              {
                sline();
                bFirst = false;
              }
              else
              {
                sline("else ");
              }
              genSelectorID(c);
            }
          }
        }

        HashSet hsNext = new HashSet();
        i = hsLevel.iterator();
        while (i.hasNext())
        {
          MClass c = (MClass)i.next();
          Collection colSuper = c.getSuperClasses();
          if (null != colSuper)
          {
            hsNext.addAll(colSuper);
          }
        }

        HashSet all = new HashSet();
        i = hsNext.iterator();
        while (i.hasNext())
        {
          MClass c = (MClass)i.next();
          getSuperclasses(c, all);
        }

        hsNext.removeAll(all);
        hsLevel = hsNext;
      }
      println();

      line("Iterator i = arg.getExtensions().iterator();");
      line("while(i.hasNext())");
      line("{"); ident();
      line("MExtension ext = (MExtension)i.next();");
      line("if (ext.getValue() instanceof Element)");
      sblock();
      line("preprocessJDOMElementID((Element)(ext.getValue()));");
      eblock();
      uline("}");

      eblock();

      eblock();
    }
    finally
    {
      close();
    }
  }

  protected void imports()
  {
    importCollections();
    sline("import "); print(getGenerator().getCollectionsPackage()); println(".HashMap;");
    sline("import "); print(getGenerator().getCollectionsPackage()); println(".Map;");
    println();

    line("import java.util.StringTokenizer;");
    println();
    
    line("import java.io.*;");
    println();    

    line("import org.jdom.*;");
    println();

    line("import ru.novosoft.uml.*;");
    line("import ru.novosoft.uml.foundation.core.*;");
    line("import ru.novosoft.uml.foundation.data_types.*;");
    line("import ru.novosoft.uml.foundation.extension_mechanisms.*;");
    line("import ru.novosoft.uml.behavior.*;");
    line("import ru.novosoft.uml.behavior.use_cases.*;");
    line("import ru.novosoft.uml.behavior.common_behavior.*;");
    line("import ru.novosoft.uml.behavior.state_machines.*;");
    line("import ru.novosoft.uml.behavior.collaborations.*;");
    line("import ru.novosoft.uml.behavior.activity_graphs.*;");
    line("import ru.novosoft.uml.model_management.*;");
    println();
    
    line("import org.xml.sax.*;");
    line("import org.xml.sax.helpers.*;");
    println();
  }

  protected void genSelectorID(MClass p_cls)
  {
    print("if (arg instanceof "); print(getUMLMName(p_cls)); println(")");
    line("{"); ident();

    sline(getUMLMName(p_cls)); print(" arg2 = ("); print(getUMLMName(p_cls));
      println(")arg;");

    genClassRolesID(p_cls);

    eblock();
  }

  protected void genClassRolesID(MClass p_cls)
  {
    HashSet allSuper = new HashSet();

    getSuperclasses(p_cls, allSuper);

    Iterator i = allSuper.iterator();
    while(i.hasNext())
    {
      MClass scls = (MClass)i.next();

      Iterator j = scls.getRoles().iterator();
      while(j.hasNext())
      {
        MRole role = (MRole)j.next();
        genClassRoleID(scls, oppositeRole(role));
      }
    }

    i = p_cls.getRoles().iterator();
    while(i.hasNext())
    {
      MRole role = (MRole)i.next();
      genClassRoleID(p_cls, oppositeRole(role));
    }
  }

  protected void genClassRoleID(MClass p_cls, MRole p_role)
  {
    if (!p_role.getName().equals(""))
    {
      MRole roleOp = oppositeRole(p_role);
      if (roleOp.isComposite() && !p_role.getName().substring(0, 1).equals("/") && !roleOp.getName().substring(0, 1).equals("/") && p_role.isNavigable())
      {
        MClass rt = (MClass)p_role.getType();
        if ((rt instanceof MElement) && (!rt.getName().equals("Base")) && (!rt.getName().equals("Extension")))
        {
          if (p_role.getKind().equals("bag") || p_role.getKind().equals("list"))
          {
            line("{"); ident();
            sline("Iterator i = arg2.get"); print(getJavaName(getPlural(p_role.getName()))); println("().iterator();");
            line("while(i.hasNext())");
            line("{"); ident();
            line("preprocessIDs((MBase)i.next());");
            uline("}");
            uline("}");
          }
          else
          {
            sline("preprocessIDs(arg2.get"); print(getJavaName(p_role.getName())); println("());");
          }
        }
      }
    }
  }



  protected void genSelector(MClass p_cls)
  {
    sline("if (arg instanceof "); print(getUMLMName(p_cls)); println(")");
    line("{"); ident();

    sline(); printPrintMainName(p_cls); print("(("); print(getUMLMName(p_cls)); println(")arg);");
    line("return;");

    uline("}");
    println();
  }

  protected void genClass(MClass p_cls)
  {
    sline("public void "); printPrintMainName(p_cls); print("("); print(getUMLMName(p_cls)); println(" arg) throws SAXException");
    sblock();
    line("if (null == arg)");
    sblock();
    line("return;");
    eblock();
    println();

    line("processElement(arg);");
    println();

    //sline("sline(\"<"); print(getFullXMITagName(p_cls)); print(" xmi.id=\\\"\"); print(getXMIID(arg)); ");
    //  println("print(\"\\\"\"); printXMIUUID(arg); println(\">\");");

    line("al.addAttribute(\"xmi.id\", CDATA_TYPE, getXMIID(arg));");
    line("addXMIUUID(arg, al);");
    sline("dh.startElement(\""); print(getFullXMITagName(p_cls)); println("\", al); al.clear();");

    //line("ident();");

    // Map for store dtd declarations 
    HashMap hmClass = new HashMap();

    // List for store order of element's nodes
    List liClass = new ArrayList();

    // Element declaration
    //ElementDecl ed = dtd.getElementDeclaration(getFullXMITagName(p_cls));

    DTDElement ed = (DTDElement)dtd.elements.get(getFullXMITagName(p_cls));

    if (null == ed)
    {
      throw new IllegalArgumentException("DTD: element declaration not found!!!");
    }

    //if (ed.content instanceof DTDSequence)
    //{
      elementDeclarationToString(ed.content, hmClass, liClass);
    //}
    //else
    //{
    //  throw new IllegalArgumentException("DTD: element declaration content type not supported!!!");
    //}

    genClassAttributes(p_cls, hmClass);
    if (!p_cls.getName().equals("MultiplicityRange"))
    {
      genClassRoles(p_cls, hmClass);
    }

    Iterator i = liClass.iterator();
    while (i.hasNext())
    {
      String key = (String)i.next();
      String value = (String)hmClass.get(key);
      if (null != value)
      {
        print(value);
      }
    }

    //line("unident();");

    //sline("line(\"</"); print(getFullXMITagName(p_cls)); println(">\");");

    sline("dh.endElement(\""); print(getFullXMITagName(p_cls)); println("\");");

    eblock();
    println();
  }

  protected void genClassAttributes(MClass p_cls, HashMap p_hmClass)
  {
    Iterator i = p_cls.getSuperClasses().iterator();
    while(i.hasNext())
    {
      MClass scls = (MClass)i.next();
      genClassAttributes(scls, p_hmClass);
    }

    i = p_cls.getAttributes().iterator();
    while(i.hasNext())
    {
      MAttribute attr = (MAttribute)i.next();
      p_hmClass.put(
        getFullXMITagName(p_cls)+"."+attr.getName(),
        genClassAttribute(p_cls, attr)
      );
    }
  }

  protected String genClassAttribute(MClass p_cls, MAttribute p_attr)
  {
    StringWriter sw = new StringWriter();
    IdentWriter iw = new IdentWriter(sw);

    iw.ident(); iw.ident();
    if (p_attr.getType().getName().equals("Name") || p_attr.getType().getName().equals("String") || p_attr.getType().getName().equals("Geometry"))
    {
      iw.sline("if (null != arg."); iw.print(getterUML(p_attr.getType(), p_attr.getName())); iw.println("())");
      iw.line("{"); iw.ident();

      //iw.sline("sline(\"<"); iw.print(getFullXMITagName(p_cls)); iw.print("."); iw.print(p_attr.getName()); iw.println(">\");");
      //iw.sline("printXMIStringValue(arg."); iw.print(getterUML(p_attr.getType(), p_attr.getName())); iw.println("());");
      //iw.sline("println(\"</"); iw.print(getFullXMITagName(p_cls)); iw.print("."); iw.print(p_attr.getName()); iw.println(">\");");

      iw.sline("dh.startElement(\""); iw.print(getFullXMITagName(p_cls));
        iw.print("."); iw.print(p_attr.getName()); iw.println("\", al);");
      iw.sline("characters(arg."); iw.print(getterUML(p_attr.getType(), p_attr.getName()));
        iw.println("());");
      iw.sline("dh.endElement(\""); iw.print(getFullXMITagName(p_cls));
        iw.print("."); iw.print(p_attr.getName()); iw.println("\");");

      iw.uline("}");
    }
    else if (p_attr.getType().getName().equals("Boolean"))
    {
      //iw.sline("sline(\"<"); iw.print(getFullXMITagName(p_cls)); iw.print("."); iw.print(p_attr.getName()); iw.print(" xmi.value=\"); ");
      //  iw.print("printXMIBooleanValue(arg."); iw.print(getterUML(p_attr.getType(), p_attr.getName())); iw.print("()); println(\"");
      //  iw.println("/>\");");

      iw.sline("al.addAttribute(\"xmi.value\", CDATA_TYPE, convertBooleanXMI(arg.");
        iw.print(getterUML(p_attr.getType(), p_attr.getName())); iw.print("()));");
      iw.sline("dh.startElement(\""); iw.print(getFullXMITagName(p_cls));
        iw.print("."); iw.print(p_attr.getName()); iw.println("\", al); al.clear();");
      iw.sline("dh.endElement(\""); iw.print(getFullXMITagName(p_cls));
        iw.print("."); iw.print(p_attr.getName()); iw.println("\");");

    }
    else if (p_attr.getType().getName().equals("LocationReference"))
    {
      iw.sline("if (null != arg."); iw.print(getterUML(p_attr.getType(), p_attr.getName())); iw.println("())");
      iw.line("{"); iw.ident();

      //iw.sline("sline(\"<"); iw.print(getFullXMITagName(p_cls)); iw.print("."); iw.print(p_attr.getName()); iw.println(">\");");
      //iw.sline("println(\"</"); iw.print(getFullXMITagName(p_cls)); iw.print("."); iw.print(p_attr.getName()); iw.println(">\");");

      iw.sline("dh.startElement(\""); iw.print(getFullXMITagName(p_cls));
        iw.print("."); iw.print(p_attr.getName()); iw.println("\", al);");
      iw.sline("characters(arg."); iw.print(getterUML(p_attr.getType(), p_attr.getName()));
        iw.println("());");
      iw.sline("dh.endElement(\""); iw.print(getFullXMITagName(p_cls));
        iw.print("."); iw.print(p_attr.getName()); iw.println("\");");

      iw.uline("}");
    }
    else if (p_attr.getType().getName().equals("Integer") || p_attr.getType().getName().equals("UnlimitedInteger"))
    {
      //iw.sline("sline(\"<"); iw.print(getFullXMITagName(p_cls)); iw.print("."); iw.print(p_attr.getName()); iw.println(">\");");
      //iw.sline("printXMIStringValue(String.valueOf(arg."); iw.print(getterUML(p_attr.getType(), p_attr.getName())); iw.println("()));");
      //iw.sline("println(\"</"); iw.print(getFullXMITagName(p_cls)); iw.print("."); iw.print(p_attr.getName()); iw.println(">\");");

      iw.sline("dh.startElement(\""); iw.print(getFullXMITagName(p_cls));
        iw.print("."); iw.print(p_attr.getName()); iw.println("\", al);");
      iw.sline("characters(String.valueOf(arg."); iw.print(getterUML(p_attr.getType(), p_attr.getName()));
        iw.println("()));");
      iw.sline("dh.endElement(\""); iw.print(getFullXMITagName(p_cls));
        iw.print("."); iw.print(p_attr.getName()); iw.println("\");");
    }
    else if (p_attr.getType() instanceof MEnum)
    {
      iw.sline("if (null != arg."); iw.print(getterUML(p_attr.getType(), p_attr.getName())); iw.println("())");
      iw.line("{"); iw.ident();

      //iw.sline("sline(\"<"); iw.print(getFullXMITagName(p_cls)); iw.print("."); iw.print(p_attr.getName()); iw.println(" xmi.value=\\\"\");");
      //iw.sline("printXMIStringValue(arg."); iw.print(getterUML(p_attr.getType(), p_attr.getName())); iw.println("().getName());");
      //iw.line("println(\"\\\"/>\");");

      iw.sline("al.addAttribute(\"xmi.value\", CDATA_TYPE, arg.");
        iw.print(getterUML(p_attr.getType(), p_attr.getName())); iw.print("().getName());");
      iw.sline("dh.startElement(\""); iw.print(getFullXMITagName(p_cls));
        iw.print("."); iw.print(p_attr.getName()); iw.println("\", al); al.clear();");
      iw.sline("dh.endElement(\""); iw.print(getFullXMITagName(p_cls));
        iw.print("."); iw.print(p_attr.getName()); iw.println("\");");

      iw.uline("}");
    }
    else if (p_attr.getType().getName().equals("Multiplicity"))
    {
      iw.sline("if (null != arg."); iw.print(getterUML(p_attr.getType(), p_attr.getName())); iw.println("())");
      iw.line("{"); iw.ident();

      //iw.sline("line(\"<"); iw.print(getFullXMITagName(p_cls)); iw.print("."); iw.print(p_attr.getName()); iw.println(">\"); ident();");
      //iw.sline("print(arg."); iw.print(getterUML(p_attr.getType(), p_attr.getName())); iw.println("(), false);");
      //iw.sline("unident(); line(\"</"); iw.print(getFullXMITagName(p_cls)); iw.print("."); iw.print(p_attr.getName()); iw.println(">\");");

      iw.sline("dh.startElement(\""); iw.print(getFullXMITagName(p_cls));
        iw.print("."); iw.print(p_attr.getName()); iw.println("\", al);");
      iw.sline("print(arg."); iw.print(getterUML(p_attr.getType(), p_attr.getName())); iw.print("(), false, \"");
        iw.print(getFullXMITagName(p_attr.getType())); iw.println("\");");
      iw.sline("dh.endElement(\""); iw.print(getFullXMITagName(p_cls));
        iw.print("."); iw.print(p_attr.getName()); iw.println("\");");

      iw.uline("}");
    }
    else if (p_attr.getType() instanceof MDataType)
    {
      iw.sline("if (null != arg."); iw.print(getterUML(p_attr.getType(), p_attr.getName())); iw.println("())");
      iw.line("{"); iw.ident();

      //iw.sline("line(\"<"); iw.print(getFullXMITagName(p_cls)); iw.print("."); iw.print(p_attr.getName()); iw.println(">\");");
      //iw.line("ident();");
      //iw.sline("print(arg."); iw.print(getterUML(p_attr.getType(), p_attr.getName())); iw.println("(), false);");
      //iw.line("unident();");
      //iw.sline("line(\"</"); iw.print(getFullXMITagName(p_cls)); iw.print("."); iw.print(p_attr.getName()); iw.println(">\");");

      iw.sline("dh.startElement(\""); iw.print(getFullXMITagName(p_cls));
        iw.print("."); iw.print(p_attr.getName()); iw.println("\", al);");
      iw.sline("print(arg."); iw.print(getterUML(p_attr.getType(), p_attr.getName())); iw.print("(), false, \"");
        iw.print(getFullXMITagName(p_attr.getType())); iw.println("\");");
      iw.sline("dh.endElement(\""); iw.print(getFullXMITagName(p_cls));
        iw.print("."); iw.print(p_attr.getName()); iw.println("\");");

      iw.uline("}");
    }
    else
    {
      System.out.println("Unknown primitive type: " + p_attr.getType().getName());
    }

    return sw.toString();
  }

  protected void genClassRoles(MClass p_cls, HashMap p_hmClass)
  {
    Iterator i = p_cls.getSuperClasses().iterator();
    while(i.hasNext())
    {
      MClass scls = (MClass)i.next();
      genClassRoles(scls, p_hmClass);
    }

    i = p_cls.getRoles().iterator();
    while(i.hasNext())
    {
      MRole role = (MRole)i.next();
      p_hmClass.put(
        getFullXMITagName(p_cls)+"."+getXMIRoleName(oppositeRole(role)),
        genClassRole(p_cls, oppositeRole(role), p_hmClass)
      );
    }

    if (!(p_cls instanceof MDataType))
    {
      StringWriter sw = new StringWriter();
      IdentWriter iw = new IdentWriter(sw);
  
      iw.ident(); iw.ident();
      iw.println();
      iw.line("printXMIExtension(arg);");
  
      p_hmClass.put(
        "XMI.extension",
        sw.toString()
      );
    }
  }

  protected String genClassRole(MClass p_cls, MRole p_role, HashMap p_hmClass)
  {
    StringWriter sw = new StringWriter();
    IdentWriter iw = new IdentWriter(sw);

    iw.ident(); iw.ident();

    if (!p_role.getName().equals(""))
    {
      MRole roleOp = oppositeRole(p_role);
      if (!p_role.getName().substring(0, 1).equals("/") && !roleOp.getName().substring(0, 1).equals("/") && p_role.isNavigable())
      {
        if (p_role.getKind().equals("bag") || p_role.getKind().equals("list"))
        {
          MClass rt = (MClass)p_role.getType();

          iw.line("{"); iw.ident();
          iw.sline("Iterator i = arg.get"); iw.print(getJavaName(getPlural(p_role.getName()))); iw.println("().iterator();");
          iw.line("if (i.hasNext())");
          iw.line("{"); iw.ident();

          iw.sline("dh.startElement(\""); iw.print(getFullXMITagName(p_cls)); 
            iw.print("."); iw.print(getXMIRoleName(p_role)); iw.println("\", al);");

          iw.line("while(i.hasNext())");
          iw.line("{"); iw.ident();
          iw.sline(); iw.print(getUMLMName(rt)); iw.print(" el = ("); iw.print(getUMLMName(rt)); iw.println(")i.next();");

          //iw.sline("line(\"<"); iw.print(getFullXMITagName(p_cls)); iw.print("."); iw.print(getXMIRoleName(p_role)); iw.println(">\"); ident();");

          if (roleOp.isComposite())
          {
            iw.sline("print(el, false, \"");
          }
          else
          {
            iw.sline("print(el, true, \"");
          }
          iw.print(getFullXMITagName(rt)); iw.println("\");");

          //iw.sline("unident(); line(\"</"); iw.print(getFullXMITagName(p_cls)); iw.print("."); iw.print(getXMIRoleName(p_role)); iw.println(">\");");

          iw.uline("}");

          iw.sline("dh.endElement(\""); iw.print(getFullXMITagName(p_cls)); 
            iw.print("."); iw.print(getXMIRoleName(p_role)); iw.println("\");");

          iw.uline("}");
          iw.uline("}");
        }
        else
        {
          iw.sline("if (null != arg.get"); iw.print(getJavaName(p_role.getName())); iw.println("())");
          iw.line("{"); iw.ident();

          //iw.sline("line(\"<"); iw.print(getFullXMITagName(p_cls)); iw.print("."); iw.print(getXMIRoleName(p_role)); iw.println(">\"); ident();");

          iw.sline("dh.startElement(\""); iw.print(getFullXMITagName(p_cls)); 
            iw.print("."); iw.print(getXMIRoleName(p_role)); iw.println("\", al);");

          if (roleOp.isComposite())
          {
            iw.sline("print(arg.get"); iw.print(getJavaName(p_role.getName())); iw.print("(), false, \"");
          }
          else
          {
            iw.sline("print(arg.get"); iw.print(getJavaName(p_role.getName())); iw.print("(), true, \"");
          }
          iw.print(getFullXMITagName(p_role.getType())); iw.println("\");");

          //iw.sline("unident(); line(\"</"); iw.print(getFullXMITagName(p_cls)); iw.print("."); iw.print(getXMIRoleName(p_role)); iw.println(">\");");

          iw.sline("dh.endElement(\""); iw.print(getFullXMITagName(p_cls)); 
            iw.print("."); iw.print(getXMIRoleName(p_role)); iw.println("\");");

          iw.uline("}");
        }
      }
    }

    return sw.toString();
  }

  protected static HashMap cardinal2string = new HashMap();
  static
  {
    cardinal2string.put("NONE", "");
    cardinal2string.put("OPTIONAL", "?");
    cardinal2string.put("ZEROMANY", "*");
    cardinal2string.put("ONEOMANY", "+");
  }

  protected String elementDeclarationToString(DTDItem p_node, HashMap p_hm, List p_li)
  {
    String ret = "";

    if (p_node instanceof DTDSequence)
    {
      DTDSequence seq = (DTDSequence)p_node;
      Enumeration i = seq.getItemsVec().elements();

      ret += "(";

      boolean bFirst = true;
      while (i.hasMoreElements())
      {
        DTDItem item = (DTDItem)i.nextElement();

        if (bFirst)
        {
          bFirst = false;
        }
        else
        { 
          ret += ",";
        }

        ret += elementDeclarationToString(item, p_hm, p_li);
      }

      return (ret + ")" + (String)cardinal2string.get(p_node.cardinal.name));
    }
    else if (p_node instanceof DTDChoice)
    {
      DTDChoice seq = (DTDChoice)p_node;
      Enumeration i = seq.getItemsVec().elements();

      ret += "(";

      boolean bFirst = true;
      while (i.hasMoreElements())
      {
        DTDItem item = (DTDItem)i.nextElement();

        if (bFirst)
        {
          bFirst = false;
        }
        else
        { 
          ret += " | ";
        }

        ret += elementDeclarationToString(item, p_hm, p_li);
      }

      return (ret + ")" + (String)cardinal2string.get(p_node.cardinal.name));
    }
    else if (p_node instanceof DTDName)
    {
      DTDName dtdname = (DTDName)p_node;

      p_hm.put(dtdname.value, null);
      p_li.add(dtdname.value);

      return (dtdname.value + (String)cardinal2string.get(dtdname.cardinal.name));
    }

    throw new RuntimeException("DTD: Not supported element type '" + p_node.getClass().getName() + "'");
  }

  protected String getFullXMITagName(MClass p_cls)
  {
    MPackage pkg = p_cls.getPackage();
    String s = "";

    while (pkg != root)
    {
      s = pkg.getName() + "." + s;
      pkg = pkg.getPackage();
    }

    return s + p_cls.getName().replace(' ', '_');
  }

  public void printPrintMainName(MClass p_cls)
  {
    print("print"); print(p_cls.getName()); print("Main");
  }

  public void printPrintAttributesName(MClass p_cls)
  {
    print("print"); print(p_cls.getName()); print("Attributes");
  }

  public void printPrintRolesName(MClass p_cls)
  {
    print("print"); print(p_cls.getName()); print("Roles");
  }

  public String getUMLMName(MClass p_cls)
  {
    return "M"+p_cls.getName();
  }

  public String getJavaName(String p_name)
  {
    return p_name.substring(0, 1).toUpperCase() + p_name.substring(1);
  }

  public String getterUML(MClass p_cls, String p_name)
  {
    if (p_cls.getName().equals("Boolean"))
    {
      return p_name;
    }

    return "get" + getJavaName(p_name);
  }

  public String setterUML(MClass p_cls, String p_name)
  {
    if (p_cls.getName().equals("Boolean"))
    {
      return "set" + getJavaName(p_name.substring(2));
    }

    return "set" + getJavaName(p_name);
  }

  protected String getXMIRoleName(MRole p_role)
  {
    String xminame = p_role.getXMIName();
    if (null == xminame || xminame.equals(""))
    {
      xminame = p_role.getName();
    }

    return xminame;
  }
}
