package ru.novosoft.uml.gen;
import java.util.*;
import java.io.*;
import ru.novosoft.uml.gen.mmm.*;

public class GenMMClass extends GenMMWriter
{
  GenMMClass(GenMM g, MClass c) throws IOException
  {
    super(g, getPackage(c), cname(c)+".java");
    try
    {
      prolog();
  
      line("package "+getPackage(c)+";");
      println();

      imports(c);
      println();

      sline("public interface "+cname(c));
      Iterator i = c.getSuperClasses().iterator();
      boolean first = true;
      while (i.hasNext())
      {
        MClass sc = (MClass)i.next();
        if (first)
        {
          print(" extends ");
          first = false;
        }
        else
        {
          print(", ");
        }
        print(cname(sc));
      }
      println();
      sblock();
      line("// generating attributes");
      i = c.getAttributes().iterator();
      while (i.hasNext())
      {
        MAttribute at = (MAttribute)i.next();
        line("// attribute: "+at.getName());
        generateAttribute(at);
      }
      line("// generating associations");
      i = c.getRoles().iterator();
      while (i.hasNext())
      {
        MRole tr = (MRole)i.next();
        MRole or = oppositeRole(tr);
        line("// opposite role: "+or.getName()+" this role: "+tr.getName());
        if (or.getKind().equals("ref"))
        {
          generateRefRole(tr,or);
        }
        else if (or.getKind().equals("bag"))
        {
          generateBagRole(tr,or);
        }
        else if (or.getKind().equals("list"))
        {
          generateListRole(tr,or);
        }
      }

      appendResource(getPackage(c), cname(c) + ".user");

      eblock();
    }
    finally
    {
      close();
    }
  }

  void generateAttribute(MAttribute at)
  {
    String type = cname(at.getType());
    line(type+" "+agetter(at)+";");
    line("void "+asetter(at, type+" __arg")+";");
  }

  void generateRefRole(MRole tr, MRole or)
  {
    String otype = cname(or.getType());
    line(otype+" "+rgetter(or)+";");
    line("void "+rsetter(or,otype+" __arg")+";");
    line("void "+ref(or,otype+" __arg")+";");
    line("void "+unref(or,otype+" __arg")+";");
  }

  void generateBagRole(MRole tr, MRole or)
  {
    String otype = cname(or.getType());
    line(bag+" "+bgetter(or)+";");
    line("void "+bsetter(or,bag+" __arg")+";");
    line("void "+badder(or,otype+" __arg")+";");
    line("void "+bremover(or,otype+" __arg")+";");
    line("void "+ref(or,otype+" __arg")+";");
    line("void "+unref(or,otype+" __arg")+";");
  }

  void generateListRole(MRole tr, MRole or)
  {
    String type = cname(or.getType());
    line(list+" "+bgetter(or)+";");
    line("void "+bsetter(or,list+" __arg")+";");
    line("void "+badder(or,type+" __arg")+";");
    line("void "+bremover(or,type+" __arg")+";");
    line("void "+ladder(or,"int __pos",type+" __arg")+";");
    line("void "+lremover(or,"int __pos")+";");
    line("void "+lsetter(or,"int __pos",type+" __arg")+";");
    line(type+" "+lgetter(or,"int __pos")+";");
  }
}
