/*
 *  NachoCalendar
 *
 * Project Info:  http://nachocalendar.sf.net
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc. 
 * in the United States and other countries.]
 *
 * Changes
 * -------
 *
 * CalendarDemo.java
 *
 * Created on August 14, 2004, 6:57 AM
 */

package net.sf.nachocalendar.demo;

import java.awt.BorderLayout;
import java.awt.Container;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import net.sf.nachocalendar.components.CalendarPanel;
import net.sf.nachocalendar.components.DateField;
import net.sf.nachocalendar.components.DatePanel;
import net.sf.nachocalendar.tasks.DefaultTask;
import net.sf.nachocalendar.tasks.Task;
import net.sf.nachocalendar.tasks.TaskCalendarFactory;
import net.sf.nachocalendar.tasks.TaskDataModel;
import net.sf.nachocalendar.tasks.TaskQuantityRenderer;

/**
 * Demo app used to show the package features
 * @author Ignacio Merani
 */
public class TaskCalendarDemo extends JDialog {
    private TaskDataModel model;
    private CalendarPanel cp;
    //private Collection holidays;
    private DateField datefield;
    private DatePanel setter;
    private DefaultListModel listmodel;
    private boolean[] workingdays = {false, true, true, true, true, true, true};
    private String[] days;
    private DefaultListModel listamodel;
    
    /** Creates new form HolidayCalendarDemo */
    public TaskCalendarDemo(JFrame parent, boolean modal) {
        super(parent, modal);
        listamodel = new DefaultListModel();
        DateFormatSymbols symbols = new DateFormatSymbols();
        days = symbols.getShortWeekdays();
        for (int i=1; i < days.length; i++) {
            days[i] = days[i].substring(0,1).toUpperCase() + days[i].substring(1).toLowerCase();
        }
        cp = TaskCalendarFactory.createCalendarPanel();
        cp.setRenderer(new TaskQuantityRenderer());
        datefield = TaskCalendarFactory.createDateField();
        setter = TaskCalendarFactory.createDatePanel();
        setter.setModel(cp.getModel());
        listmodel = new DefaultListModel();
        initComponents();
        dlista.setModel(listamodel);
        cSelection.setSelectedIndex(2);
        lista.setModel(listmodel);
        model = (TaskDataModel) cp.getModel();
        getContentPane().add(cp, BorderLayout.WEST);
        updateWorking();
        createListeners();
        pack();
        setLocationRelativeTo(parent);
    }
    
    private void createListeners() {
        setter.addChangeListener(new ChangeListener() {
            public void stateChanged(ChangeEvent e) {
                Date d = (Date) setter.getValue();
                cp.setDate(d);
            }
        });
        cp.addChangeListener(new ChangeListener() {
            public void stateChanged(ChangeEvent e) {
                /*MonthPanel dp = (MonthPanel) e.getSource();
                datefield.setValue(dp.getDay());
                listmodel.clear();
                Collection col = model.getTasks(dp.getDay());
                if (col == null) return;
                Iterator it = col.iterator();
                while (it.hasNext()) {
                    listmodel.addElement(it.next());
                }*/
            }
        });
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;
        javax.swing.JLabel jLabel1;
        javax.swing.JLabel jLabel2;
        javax.swing.JPanel jPanel1;
        javax.swing.JPanel jPanel2;
        javax.swing.JPanel jPanel3;
        javax.swing.JPanel jPanel5;
        javax.swing.JScrollPane jScrollPane3;

        orientationGroup = new javax.swing.ButtonGroup();
        scrollGroup = new javax.swing.ButtonGroup();
        yearGroup = new javax.swing.ButtonGroup();
        firstDayGroup = new javax.swing.ButtonGroup();
        jScrollPane2 = new javax.swing.JScrollPane();
        jPanel1 = new javax.swing.JPanel();
        jSeparator2 = new javax.swing.JSeparator();
        jLabel1 = new javax.swing.JLabel();
        tName = new javax.swing.JTextField();
        jScrollPane3 = new javax.swing.JScrollPane();
        lista = new javax.swing.JList();
        jLabel2 = new javax.swing.JLabel();
        jPanel3 = datefield;
        bAdd = new javax.swing.JButton();
        bRemove = new javax.swing.JButton();
        bLoad = new javax.swing.JButton();
        bSave = new javax.swing.JButton();
        jSeparator1 = new javax.swing.JSeparator();
        jPanel4 = new javax.swing.JPanel();
        cSun = new javax.swing.JCheckBox();
        cMon = new javax.swing.JCheckBox();
        cTue = new javax.swing.JCheckBox();
        cWed = new javax.swing.JCheckBox();
        cThu = new javax.swing.JCheckBox();
        cFri = new javax.swing.JCheckBox();
        cSat = new javax.swing.JCheckBox();
        bUpdate = new javax.swing.JButton();
        jPanel7 = new javax.swing.JPanel();
        jLabel5 = new javax.swing.JLabel();
        cVertical = new javax.swing.JRadioButton();
        cHorizontal = new javax.swing.JRadioButton();
        jLabel6 = new javax.swing.JLabel();
        cScrollUp = new javax.swing.JRadioButton();
        cScrollDown = new javax.swing.JRadioButton();
        jLabel7 = new javax.swing.JLabel();
        cYearUp = new javax.swing.JRadioButton();
        cYearDown = new javax.swing.JRadioButton();
        jLabel8 = new javax.swing.JLabel();
        cSunday = new javax.swing.JRadioButton();
        cMonday = new javax.swing.JRadioButton();
        jLabel9 = new javax.swing.JLabel();
        cSelection = new javax.swing.JComboBox();
        cAntiAliased = new javax.swing.JCheckBox();
        cEnabled = new javax.swing.JCheckBox();
        cEternal = new javax.swing.JCheckBox();
        cShowToday = new javax.swing.JCheckBox();
        cShowMoon = new javax.swing.JCheckBox();
        jPanel8 = new javax.swing.JPanel();
        bRefresh = new javax.swing.JButton();
        sPanels = new JSpinner(new SpinnerNumberModel(3,1,12,1));
        jLabel3 = new javax.swing.JLabel();
        jPanel2 = new javax.swing.JPanel();
        bExit = new javax.swing.JButton();
        jPanel6 = new javax.swing.JPanel();
        jLabel4 = new javax.swing.JLabel();
        jPanel5 = setter;
        jPanel9 = new javax.swing.JPanel();
        bGetValue = new javax.swing.JButton();
        bGetValues = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        dlista = new javax.swing.JList();

        FormListener formListener = new FormListener();

        setTitle("NachoCalendar Demo");
        addWindowListener(formListener);

        jPanel1.setLayout(new java.awt.GridBagLayout());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanel1.add(jSeparator2, gridBagConstraints);

        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        jLabel1.setText("Name");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel1.add(jLabel1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel1.add(tName, gridBagConstraints);

        lista.addListSelectionListener(formListener);

        jScrollPane3.setViewportView(lista);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel1.add(jScrollPane3, gridBagConstraints);

        jLabel2.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        jLabel2.setText("Date");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel1.add(jLabel2, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel1.add(jPanel3, gridBagConstraints);

        bAdd.setText("Add");
        bAdd.addActionListener(formListener);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel1.add(bAdd, gridBagConstraints);

        bRemove.setText("Remove");
        bRemove.setEnabled(false);
        bRemove.addActionListener(formListener);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel1.add(bRemove, gridBagConstraints);

        bLoad.setText("Load");
        bLoad.addActionListener(formListener);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel1.add(bLoad, gridBagConstraints);

        bSave.setText("Save");
        bSave.addActionListener(formListener);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel1.add(bSave, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        jPanel1.add(jSeparator1, gridBagConstraints);

        jPanel4.setLayout(new java.awt.GridBagLayout());

        jPanel4.setBorder(new javax.swing.border.TitledBorder("Working Days"));
        cSun.setText(days[1]);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel4.add(cSun, gridBagConstraints);

        cMon.setSelected(true);
        cMon.setText(days[2]);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel4.add(cMon, gridBagConstraints);

        cTue.setSelected(true);
        cTue.setText(days[3]);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel4.add(cTue, gridBagConstraints);

        cWed.setSelected(true);
        cWed.setText(days[4]);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel4.add(cWed, gridBagConstraints);

        cThu.setSelected(true);
        cThu.setText(days[5]);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel4.add(cThu, gridBagConstraints);

        cFri.setSelected(true);
        cFri.setText(days[6]);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel4.add(cFri, gridBagConstraints);

        cSat.setSelected(true);
        cSat.setText(days[7]);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel4.add(cSat, gridBagConstraints);

        bUpdate.setText("Update");
        bUpdate.addActionListener(formListener);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel4.add(bUpdate, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        jPanel1.add(jPanel4, gridBagConstraints);

        jPanel7.setLayout(new java.awt.GridBagLayout());

        jPanel7.setBorder(new javax.swing.border.TitledBorder("Properties"));
        jLabel5.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        jLabel5.setText("Orientation");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel7.add(jLabel5, gridBagConstraints);

        cVertical.setSelected(true);
        cVertical.setText("Vertical");
        orientationGroup.add(cVertical);
        cVertical.addActionListener(formListener);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel7.add(cVertical, gridBagConstraints);

        cHorizontal.setText("Horizontal");
        orientationGroup.add(cHorizontal);
        cHorizontal.addActionListener(formListener);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel7.add(cHorizontal, gridBagConstraints);

        jLabel6.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        jLabel6.setText("Scroll Position");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel7.add(jLabel6, gridBagConstraints);

        cScrollUp.setSelected(true);
        cScrollUp.setText("Up/Left");
        scrollGroup.add(cScrollUp);
        cScrollUp.addActionListener(formListener);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel7.add(cScrollUp, gridBagConstraints);

        cScrollDown.setText("Down/Rigth");
        scrollGroup.add(cScrollDown);
        cScrollDown.addActionListener(formListener);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel7.add(cScrollDown, gridBagConstraints);

        jLabel7.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        jLabel7.setText("Year Position");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel7.add(jLabel7, gridBagConstraints);

        cYearUp.setSelected(true);
        cYearUp.setText("Up/Left");
        yearGroup.add(cYearUp);
        cYearUp.addActionListener(formListener);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel7.add(cYearUp, gridBagConstraints);

        cYearDown.setText("Down/Rigth");
        yearGroup.add(cYearDown);
        cYearDown.addActionListener(formListener);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel7.add(cYearDown, gridBagConstraints);

        jLabel8.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        jLabel8.setText("FirstDay");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel7.add(jLabel8, gridBagConstraints);

        cSunday.setSelected(true);
        cSunday.setText("Sunday");
        firstDayGroup.add(cSunday);
        cSunday.addItemListener(formListener);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel7.add(cSunday, gridBagConstraints);

        cMonday.setText("Monday");
        firstDayGroup.add(cMonday);
        cMonday.addItemListener(formListener);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel7.add(cMonday, gridBagConstraints);

        jLabel9.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        jLabel9.setText("SelectionMode");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel7.add(jLabel9, gridBagConstraints);

        cSelection.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "SingleSelection", "SingleInterval", "MultipleInterval" }));
        cSelection.addItemListener(formListener);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel7.add(cSelection, gridBagConstraints);

        cAntiAliased.setText("AntiAliased");
        cAntiAliased.addItemListener(formListener);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanel7.add(cAntiAliased, gridBagConstraints);

        cEnabled.setSelected(true);
        cEnabled.setText("Enabled");
        cEnabled.addItemListener(formListener);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel7.add(cEnabled, gridBagConstraints);

        cEternal.setSelected(true);
        cEternal.setText("Eternal Scroll");
        cEternal.addItemListener(formListener);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanel7.add(cEternal, gridBagConstraints);

        cShowToday.setText("Show Today");
        cShowToday.addItemListener(formListener);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanel7.add(cShowToday, gridBagConstraints);

        cShowMoon.setText("Show Moon");
        cShowMoon.addItemListener(formListener);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanel7.add(cShowMoon, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanel7.add(jPanel8, gridBagConstraints);

        bRefresh.setText("Update");
        bRefresh.addActionListener(formListener);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel7.add(bRefresh, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel7.add(sPanels, gridBagConstraints);

        jLabel3.setText("Panels");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel7.add(jLabel3, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanel1.add(jPanel7, gridBagConstraints);

        jScrollPane2.setViewportView(jPanel1);

        getContentPane().add(jScrollPane2, java.awt.BorderLayout.CENTER);

        bExit.setText("Exit");
        bExit.addActionListener(formListener);

        jPanel2.add(bExit);

        getContentPane().add(jPanel2, java.awt.BorderLayout.SOUTH);

        jPanel6.setLayout(new java.awt.GridBagLayout());

        jLabel4.setText("Set Date");
        jPanel6.add(jLabel4, new java.awt.GridBagConstraints());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        jPanel6.add(jPanel5, gridBagConstraints);

        jPanel9.setLayout(new java.awt.GridBagLayout());

        bGetValue.setText("getValue");
        bGetValue.addActionListener(formListener);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel9.add(bGetValue, gridBagConstraints);

        bGetValues.setText("getValues");
        bGetValues.addActionListener(formListener);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 2);
        jPanel9.add(bGetValues, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.insets = new java.awt.Insets(6, 0, 0, 0);
        jPanel6.add(jPanel9, gridBagConstraints);

        jScrollPane1.setViewportView(dlista);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(6, 0, 0, 0);
        jPanel6.add(jScrollPane1, gridBagConstraints);

        getContentPane().add(jPanel6, java.awt.BorderLayout.EAST);

        pack();
    }

    // Code for dispatching events from components to event handlers.

    private class FormListener implements java.awt.event.ActionListener, java.awt.event.ItemListener, java.awt.event.WindowListener, javax.swing.event.ListSelectionListener {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            if (evt.getSource() == bAdd) {
                TaskCalendarDemo.this.bAddActionPerformed(evt);
            }
            else if (evt.getSource() == bRemove) {
                TaskCalendarDemo.this.bRemoveActionPerformed(evt);
            }
            else if (evt.getSource() == bLoad) {
                TaskCalendarDemo.this.bLoadActionPerformed(evt);
            }
            else if (evt.getSource() == bSave) {
                TaskCalendarDemo.this.bSaveActionPerformed(evt);
            }
            else if (evt.getSource() == bUpdate) {
                TaskCalendarDemo.this.bUpdateActionPerformed(evt);
            }
            else if (evt.getSource() == cVertical) {
                TaskCalendarDemo.this.cVerticalActionPerformed(evt);
            }
            else if (evt.getSource() == cHorizontal) {
                TaskCalendarDemo.this.cHorizontalActionPerformed(evt);
            }
            else if (evt.getSource() == cScrollUp) {
                TaskCalendarDemo.this.cScrollUpActionPerformed(evt);
            }
            else if (evt.getSource() == cScrollDown) {
                TaskCalendarDemo.this.cScrollDownActionPerformed(evt);
            }
            else if (evt.getSource() == cYearUp) {
                TaskCalendarDemo.this.cYearUpActionPerformed(evt);
            }
            else if (evt.getSource() == cYearDown) {
                TaskCalendarDemo.this.cYearDownActionPerformed(evt);
            }
            else if (evt.getSource() == bRefresh) {
                TaskCalendarDemo.this.bRefreshActionPerformed(evt);
            }
            else if (evt.getSource() == bExit) {
                TaskCalendarDemo.this.bExitActionPerformed(evt);
            }
            else if (evt.getSource() == bGetValue) {
                TaskCalendarDemo.this.bGetValueActionPerformed(evt);
            }
            else if (evt.getSource() == bGetValues) {
                TaskCalendarDemo.this.bGetValuesActionPerformed(evt);
            }
        }

        public void itemStateChanged(java.awt.event.ItemEvent evt) {
            if (evt.getSource() == cSunday) {
                TaskCalendarDemo.this.cSundayItemStateChanged(evt);
            }
            else if (evt.getSource() == cMonday) {
                TaskCalendarDemo.this.cMondayItemStateChanged(evt);
            }
            else if (evt.getSource() == cSelection) {
                TaskCalendarDemo.this.cSelectionItemStateChanged(evt);
            }
            else if (evt.getSource() == cAntiAliased) {
                TaskCalendarDemo.this.cAntiAliasedItemStateChanged(evt);
            }
            else if (evt.getSource() == cEnabled) {
                TaskCalendarDemo.this.cEnabledItemStateChanged(evt);
            }
            else if (evt.getSource() == cEternal) {
                TaskCalendarDemo.this.cEternalItemStateChanged(evt);
            }
            else if (evt.getSource() == cShowToday) {
                TaskCalendarDemo.this.cShowTodayItemStateChanged(evt);
            }
            else if (evt.getSource() == cShowMoon) {
                TaskCalendarDemo.this.cShowMoonItemStateChanged(evt);
            }
        }

        public void windowActivated(java.awt.event.WindowEvent evt) {
        }

        public void windowClosed(java.awt.event.WindowEvent evt) {
        }

        public void windowClosing(java.awt.event.WindowEvent evt) {
            if (evt.getSource() == TaskCalendarDemo.this) {
                TaskCalendarDemo.this.exitForm(evt);
            }
        }

        public void windowDeactivated(java.awt.event.WindowEvent evt) {
        }

        public void windowDeiconified(java.awt.event.WindowEvent evt) {
        }

        public void windowIconified(java.awt.event.WindowEvent evt) {
        }

        public void windowOpened(java.awt.event.WindowEvent evt) {
        }

        public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
            if (evt.getSource() == lista) {
                TaskCalendarDemo.this.listaValueChanged(evt);
            }
        }
    }//GEN-END:initComponents

    private void cShowMoonItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_cShowMoonItemStateChanged
        cp.setPrintMoon(cShowMoon.isSelected());
        datefield.setPrintMoon(cShowMoon.isSelected());
        setter.setPrintMoon(cShowMoon.isSelected());
    }//GEN-LAST:event_cShowMoonItemStateChanged

    private void cShowTodayItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_cShowTodayItemStateChanged
        cp.setShowToday(cShowToday.isSelected());
        setter.setShowToday(cShowToday.isSelected());
        datefield.setShowToday(cShowToday.isSelected());
    }//GEN-LAST:event_cShowTodayItemStateChanged

    private void cEternalItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_cEternalItemStateChanged
        cp.setEternalScroll(cEternal.isSelected());
    }//GEN-LAST:event_cEternalItemStateChanged

    private void bGetValuesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bGetValuesActionPerformed
        listamodel.clear();
        Object[] datos = setter.getValues();
        if ((datos == null) || (datos.length < 1)) return;
        for (int i=0; i < datos.length; i++) {
            listamodel.addElement(datos[i]);
        }
    }//GEN-LAST:event_bGetValuesActionPerformed

    private void bGetValueActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bGetValueActionPerformed
        listamodel.clear();
        Object dato = setter.getValue();
        if (dato == null) return;
        listamodel.addElement(dato);
        
    }//GEN-LAST:event_bGetValueActionPerformed

    private void cSelectionItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_cSelectionItemStateChanged
        cp.setSelectionMode(cSelection.getSelectedIndex());
        setter.setSelectionMode(cSelection.getSelectedIndex());
    }//GEN-LAST:event_cSelectionItemStateChanged

    private void cAntiAliasedItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_cAntiAliasedItemStateChanged
        setter.setAntiAliased(cAntiAliased.isSelected());
        cp.setAntiAliased(cAntiAliased.isSelected());
        datefield.setAntiAliased(cAntiAliased.isSelected());
    }//GEN-LAST:event_cAntiAliasedItemStateChanged

    private void cEnabledItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_cEnabledItemStateChanged
        setter.setEnabled(cEnabled.isSelected());
        cp.setEnabled(cEnabled.isSelected());
        datefield.setEnabled(cEnabled.isSelected());
    }//GEN-LAST:event_cEnabledItemStateChanged

    private void cMondayItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_cMondayItemStateChanged
        setter.setFirstDayOfWeek(Calendar.MONDAY);
        cp.setFirstDayOfWeek(Calendar.MONDAY);
        datefield.setFirstDayOfWeek(Calendar.MONDAY);
    }//GEN-LAST:event_cMondayItemStateChanged

    private void cSundayItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_cSundayItemStateChanged
        setter.setFirstDayOfWeek(Calendar.SUNDAY);
        cp.setFirstDayOfWeek(Calendar.SUNDAY);
        datefield.setFirstDayOfWeek(Calendar.SUNDAY);
    }//GEN-LAST:event_cSundayItemStateChanged
    
    private void bRefreshActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bRefreshActionPerformed
        int q = ((Number) sPanels.getValue()).intValue();
        cp.setQuantity(q);
        pack();
    }//GEN-LAST:event_bRefreshActionPerformed
    
    private void cYearDownActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cYearDownActionPerformed
        cp.setYearPosition(CalendarPanel.DOWN);
        pack();
    }//GEN-LAST:event_cYearDownActionPerformed
    
    private void cYearUpActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cYearUpActionPerformed
        cp.setYearPosition(CalendarPanel.UP);
        pack();
    }//GEN-LAST:event_cYearUpActionPerformed
    
    private void cScrollDownActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cScrollDownActionPerformed
        cp.setScrollPosition(CalendarPanel.DOWN);
        pack();
    }//GEN-LAST:event_cScrollDownActionPerformed
    
    private void cScrollUpActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cScrollUpActionPerformed
        cp.setScrollPosition(CalendarPanel.UP);
        pack();
    }//GEN-LAST:event_cScrollUpActionPerformed
    
    private void cHorizontalActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cHorizontalActionPerformed
        Container con = getContentPane();
        con.remove(cp);
        cp.setOrientation(CalendarPanel.HORIZONTAL);
        con.add(cp, BorderLayout.NORTH);
        pack();
    }//GEN-LAST:event_cHorizontalActionPerformed
    
    private void cVerticalActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cVerticalActionPerformed
        Container con = getContentPane();
        con.remove(cp);
        cp.setOrientation(CalendarPanel.VERTICAL);
        con.add(cp, BorderLayout.WEST);
        pack();
    }//GEN-LAST:event_cVerticalActionPerformed
    
    private void bUpdateActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bUpdateActionPerformed
        updateWorking();
    }//GEN-LAST:event_bUpdateActionPerformed
    
    private void bLoadActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bLoadActionPerformed
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        int resp = chooser.showOpenDialog(this);
        if (resp != JFileChooser.APPROVE_OPTION) return;
        listmodel.clear();
        model.clear();
        File f = chooser.getSelectedFile();
        try {
            FileInputStream fis = new FileInputStream(f);
            ObjectInputStream is = new ObjectInputStream(fis);
            while (true) {
                Object o = is.readObject();
                if (o == null) break;
                Task t = (Task) o;
                model.addTask(t);
            }
            is.close();
            fis.close();
        } catch (EOFException e) {
            
        } catch (Exception e) {
            e.printStackTrace();
        }
    }//GEN-LAST:event_bLoadActionPerformed
    
    private void bSaveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bSaveActionPerformed
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        int resp = chooser.showSaveDialog(this);
        if (resp != JFileChooser.APPROVE_OPTION) return;
        File f = chooser.getSelectedFile();
        try {
            FileOutputStream fos = new FileOutputStream(f);
            ObjectOutputStream os = new ObjectOutputStream(fos);
            Map map = model.getAll();
            Iterator it = map.keySet().iterator();
            while (it.hasNext()){
                Object oj = map.get(it.next());
                if (oj instanceof Collection) {
                    Collection col = (Collection) oj;
                    Iterator it2 = col.iterator();
                    while (it2.hasNext()) {
                        os.writeObject(it2.next());
                    }
                }
            }
            os.flush();
            os.close();
            fos.close();
            
        } catch (IOException e) {
            e.printStackTrace();
        }
    }//GEN-LAST:event_bSaveActionPerformed
    
    private void bRemoveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bRemoveActionPerformed
        Task t = (Task) listmodel.remove(lista.getSelectedIndex());
        model.removeTask(t);
        cp.refresh();
        setter.refresh();
    }//GEN-LAST:event_bRemoveActionPerformed
    
    private void bAddActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bAddActionPerformed
        Task t = new DefaultTask();
        t.setName(tName.getText());
        t.setDate((Date) datefield.getValue());
        listmodel.addElement(t);
        model.addTask(t);
        cp.refresh();
        setter.refresh();
    }//GEN-LAST:event_bAddActionPerformed
    
    private void listaValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_listaValueChanged
        bRemove.setEnabled(lista.getSelectedIndex() > -1);
    }//GEN-LAST:event_listaValueChanged
    
    private void bExitActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bExitActionPerformed
        setVisible(false);
    }//GEN-LAST:event_bExitActionPerformed
    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        setVisible(false);
    }//GEN-LAST:event_exitForm
    
    private void updateWorking() {
        workingdays[0] = cSun.isSelected();
        workingdays[1] = cMon.isSelected();
        workingdays[2] = cTue.isSelected();
        workingdays[3] = cWed.isSelected();
        workingdays[4] = cThu.isSelected();
        workingdays[5] = cFri.isSelected();
        workingdays[6] = cSat.isSelected();
        cp.setWorkingdays(workingdays);
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton bAdd;
    private javax.swing.JButton bExit;
    private javax.swing.JButton bGetValue;
    private javax.swing.JButton bGetValues;
    private javax.swing.JButton bLoad;
    private javax.swing.JButton bRefresh;
    private javax.swing.JButton bRemove;
    private javax.swing.JButton bSave;
    private javax.swing.JButton bUpdate;
    private javax.swing.JCheckBox cAntiAliased;
    private javax.swing.JCheckBox cEnabled;
    private javax.swing.JCheckBox cEternal;
    private javax.swing.JCheckBox cFri;
    private javax.swing.JRadioButton cHorizontal;
    private javax.swing.JCheckBox cMon;
    private javax.swing.JRadioButton cMonday;
    private javax.swing.JCheckBox cSat;
    private javax.swing.JRadioButton cScrollDown;
    private javax.swing.JRadioButton cScrollUp;
    private javax.swing.JComboBox cSelection;
    private javax.swing.JCheckBox cShowMoon;
    private javax.swing.JCheckBox cShowToday;
    private javax.swing.JCheckBox cSun;
    private javax.swing.JRadioButton cSunday;
    private javax.swing.JCheckBox cThu;
    private javax.swing.JCheckBox cTue;
    private javax.swing.JRadioButton cVertical;
    private javax.swing.JCheckBox cWed;
    private javax.swing.JRadioButton cYearDown;
    private javax.swing.JRadioButton cYearUp;
    private javax.swing.JList dlista;
    private javax.swing.ButtonGroup firstDayGroup;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JPanel jPanel7;
    private javax.swing.JPanel jPanel8;
    private javax.swing.JPanel jPanel9;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JSeparator jSeparator2;
    private javax.swing.JList lista;
    private javax.swing.ButtonGroup orientationGroup;
    private javax.swing.JSpinner sPanels;
    private javax.swing.ButtonGroup scrollGroup;
    private javax.swing.JTextField tName;
    private javax.swing.ButtonGroup yearGroup;
    // End of variables declaration//GEN-END:variables
    
}
