/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.tools.remote.soap.axis.ser;

import javax.management.relation.MBeanServerNotificationFilter;
import javax.management.ObjectName;

import org.xml.sax.SAXException;

/**
 * @author <a href="mailto:biorn_steedom@users.sourceforge.net">Simone Bordet</a>
 * @version $Revision: 1.1 $
 */
public class MBeanServerNotificationFilterDeser extends AxisDeserializer
{
   private MBeanServerNotificationFilter filter = new MBeanServerNotificationFilter();

   protected void onSetChildValue(Object value, Object hint) throws SAXException
   {
      if (NotificationFilterSupportSer.NOTIFICATION_TYPE.equals(hint)) filter.enableType((String)value);
      else if (MBeanServerNotificationFilterSer.ALL_DISABLED.equals(hint) && ((Boolean)value).booleanValue()) filter.disableAllObjectNames();
      else if (MBeanServerNotificationFilterSer.ALL_ENABLED.equals(hint) && ((Boolean)value).booleanValue()) filter.enableAllObjectNames();
      else if (MBeanServerNotificationFilterSer.ENABLED_OBJECT_NAME.equals(hint)) filter.enableObjectName((ObjectName)value);
      else if (MBeanServerNotificationFilterSer.DISABLED_OBJECT_NAME.equals(hint)) filter.disableObjectName((ObjectName)value);
   }

   protected Object createObject() throws SAXException
   {
      return filter;
   }
}
