/* (PD) 2001 The Bitzi Corporation
 * Please see file COPYING or http://bitzi.com/publicdomain 
 * for more info.
 *
 * $Id: browser.c,v 1.1 2002/10/02 01:39:21 robert Exp $
 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/stat.h>

#include "bitcollider.h"

b_bool launch(const char *url, const char *command);
b_bool launch_using_envvar(const char *url);
b_bool is_netscape_running(void);

b_bool launch_browser(const char* url, BrowserEnum browser)
{
    char         command[1024];
    char        *browser_env;

    browser_env = getenv("BROWSER");
    if (browser_env && strlen(browser_env) > 0)
        return launch_using_envvar(url);

    switch(browser)
    {
        case eBrowserNetscape:
           if (is_netscape_running())
                strcpy(command, "netscape -raise -remote "
                                "\"openURL(file://%s,new-window)\""); 
           else
                strcpy(command, "netscape \"file://%s\" &");

           break;
        case eBrowserMozilla:
           strcpy(command, "mozilla '%s' &");
           break;
        case eBrowserKonqueror:
           strcpy(command, "konqueror '%s' &");
           break;
        case eBrowserOpera:
           strcpy(command, "opera '%s' &");
           break;
        case eBrowserLynx:
           strcpy(command, "lynx '%s'");
           break;
    }

    return launch(url, command);
}

int launch_using_envvar(const char *url)
{
    char *browser, *token;
    int   ret = 0;

    browser = strdup(getenv("BROWSER"));
    token = strtok(browser, ":");
    while(*token)
    {
        ret = launch(url, token);
        if (ret)
           break;

        token = strtok(NULL, ":");
    }
    free(browser);

    return ret;
}

int launch(const char *url, const char *browser)
{
    char *command, *ptr, newBrowser[1024];
    int   ret;

    ptr = strchr(browser, '%');
    if (ptr && ptr > browser && *(ptr-1) != '"' && *(ptr-1) != '\'')
    {
        *ptr = 0;
        sprintf(newBrowser, "%s\"%%s\"", browser, ptr + 2);  
        browser = newBrowser;
    }

    command = malloc(strlen(browser) + strlen(url) + 10);
    sprintf(command, browser, url);

    ret = system(command) >> 8;
    if (ret == 127)
       ret = 0;
    else
       ret = 1;

    free(command);
    return ret;
}

b_bool is_netscape_running(void)
{
    struct stat  sb;
    char        *home, lockfile[1024];

    home = getenv("HOME");
    if (!home) 
        return false;

    sprintf(lockfile,"%.200s/.netscape/lock",home);
    return (lstat(lockfile, &sb) != -1);
}
