/*
 * Decompiled with CFR 0.152.
 */
package org.boehn.kmlframework.todo;

import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.boehn.kmlframework.coordinates.CartesianCoordinate;
import org.boehn.kmlframework.coordinates.EarthCoordinate;
import org.boehn.kmlframework.coordinates.TimeAndPlace;
import org.boehn.kmlframework.kml.Kml;
import org.boehn.kmlframework.kml.KmlException;
import org.boehn.kmlframework.todo.GraphicalModel;
import org.boehn.kmlframework.todo.MapObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapObjectClass {
    private String className;
    private List<GraphicalModel> models;
    private boolean showTail = true;
    private boolean showModels = true;
    private Integer visibleFrom;
    private Integer visibleTo;
    private Integer tailHistoryLimit;
    private Integer tailVisibleFrom;
    private Integer tailVisibleTo;
    private String styleUrl;

    public MapObjectClass(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public List<GraphicalModel> getModels() {
        return this.models;
    }

    public void setModels(List<GraphicalModel> models) {
        this.models = models;
    }

    public void addModel(GraphicalModel model) {
        if (this.models == null) {
            this.models = new ArrayList<GraphicalModel>();
        }
        this.models.add(model);
    }

    public void addModels(List<GraphicalModel> models) {
        if (this.models == null) {
            this.models = models;
        } else {
            this.models.addAll(models);
        }
    }

    public Integer getVisibleFrom() {
        return this.visibleFrom;
    }

    public void setVisibleFrom(Integer visibleFrom) {
        this.visibleFrom = visibleFrom;
    }

    public Integer getVisibleTo() {
        return this.visibleTo;
    }

    public void setVisibleTo(Integer visibleTo) {
        this.visibleTo = visibleTo;
    }

    public String getStyleUrl() {
        return this.styleUrl;
    }

    public boolean getShowModels() {
        return this.showModels;
    }

    public void setShowModels(boolean showModel) {
        this.showModels = showModel;
    }

    public boolean getShowTail() {
        return this.showTail;
    }

    public void setShowTail(boolean showTail) {
        this.showTail = showTail;
    }

    public Integer getTailVisibleFrom() {
        return this.tailVisibleFrom;
    }

    public void setTailVisibleFrom(Integer tailVisibleFrom) {
        this.tailVisibleFrom = tailVisibleFrom;
    }

    public Integer getTailVisibleTo() {
        return this.tailVisibleTo;
    }

    public void setTailVisibleTo(Integer tailVisibleTo) {
        this.tailVisibleTo = tailVisibleTo;
    }

    public Integer getTailHistoryLimit() {
        return this.tailHistoryLimit;
    }

    public void setTailHistoryLimit(Integer tailHistoryLimit) {
        this.tailHistoryLimit = tailHistoryLimit;
    }

    public void addKml(MapObject mapObject, Element parentElement, Kml model, Document xmlDocument, EarthCoordinate location, Double rotation, CartesianCoordinate localReferenceCoordinate, CartesianCoordinate scale, String name) throws KmlException {
        if (this.models != null || mapObject.getMovements() != null && this.showTail) {
            boolean objectHasGraphicalElementToDraw = false;
            Element multiGeometryElement = xmlDocument.createElement("MultiGeometry");
            if (mapObject.getMovements() == null || !this.showTail) {
                List<GraphicalModel> graphicalModelsTemp = this.models;
            } else {
                Date timeHistoryLimitAbsolute;
                ArrayList<GraphicalModel> graphicalModelsTemp = new ArrayList<GraphicalModel>(this.models);
                GraphicalModel graphicalModel = new GraphicalModel();
                if (this.tailHistoryLimit != null) {
                    GregorianCalendar calendar = new GregorianCalendar();
                    calendar.add(13, -this.tailHistoryLimit.intValue());
                    timeHistoryLimitAbsolute = calendar.getTime();
                } else {
                    timeHistoryLimitAbsolute = null;
                }
                for (TimeAndPlace timeAndPlace : mapObject.getMovements()) {
                    if (timeHistoryLimitAbsolute != null && timeHistoryLimitAbsolute.after(timeAndPlace.getTime())) break;
                }
                graphicalModel.setVisibleFrom(this.tailVisibleFrom);
                graphicalModel.setVisibleTo(this.tailVisibleTo);
                graphicalModelsTemp.add(graphicalModel);
            }
            if (objectHasGraphicalElementToDraw) {
                Element placemarkElement = xmlDocument.createElement("Placemark");
                Element nameElement = xmlDocument.createElement("name");
                nameElement.appendChild(xmlDocument.createTextNode(name != null ? String.valueOf(name) + " model" : "model"));
                placemarkElement.appendChild(nameElement);
                placemarkElement.appendChild(multiGeometryElement);
                parentElement.appendChild(placemarkElement);
            }
        }
    }

    public String toString() {
        StringBuffer text = new StringBuffer("MapObjectClass:\n");
        text.append("   className: '" + this.className + "'\n");
        text.append("   styleUrl: '" + this.styleUrl + "'\n");
        text.append("   models: " + this.models + "\n");
        text.append("   showModels: " + this.showModels + "\n");
        text.append("   showTail: " + this.showTail + "\n");
        text.append("   tailVisibleFrom: " + this.tailVisibleFrom + "\n");
        text.append("   tailVisibleTo: " + this.tailVisibleTo + "\n");
        text.append("   timeHistoryLimit: " + this.tailHistoryLimit + "\n");
        return text.toString();
    }
}

