/**
 * Copyright 2013 JogAmp Community. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification, are
 * permitted provided that the following conditions are met:
 *
 *    1. Redistributions of source code must retain the above copyright notice, this list of
 *       conditions and the following disclaimer.
 *
 *    2. Redistributions in binary form must reproduce the above copyright notice, this list
 *       of conditions and the following disclaimer in the documentation and/or other materials
 *       provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY JogAmp Community ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL JogAmp Community OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are those of the
 * authors and should not be interpreted as representing official policies, either expressed
 * or implied, of JogAmp Community.
 */
package com.jogamp.opengl.test.junit.util;

import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;

public class GLEventListenerCounter implements GLEventListener {
    public int initCount = 0;
    public int displayCount = 0;
    public int reshapeCount = 0;
    public int disposeCount = 0;

    public void reset() {
        initCount = 0;
        displayCount = 0;
        reshapeCount = 0;
        disposeCount = 0;
    }

    @Override
    public void init(final GLAutoDrawable drawable) {
        initCount++;
    }

    @Override
    public void dispose(final GLAutoDrawable drawable) {
        disposeCount++;
    }

    @Override
    public void display(final GLAutoDrawable drawable) {
        displayCount++;
    }

    @Override
    public void reshape(final GLAutoDrawable d, final int x, final int y, final int width, final int height) {
        reshapeCount++;
    }

    public String toString() {
        return "GLEventListenerCounter[init "+initCount+", dispose "+disposeCount+", reshape "+reshapeCount+", display "+displayCount+"]";
    }
}