/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import gnu.jpdf.BoundingBox;
import gnu.jpdf.HelpFrame;
import gnu.jpdf.PDFJob;
import gnu.jpdf.StringTooLongException;
import gnu.jpdf.TestMenuBar;
import gnu.jpdf.TestPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.JobAttributes;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PDFTest
extends JFrame
implements ActionListener {
    private static String outputPdfFile;
    private static String sampleImageFile;
    private static boolean noWindow;
    private final JPanel pane = new JPanel();
    private final Dimension documentDimension;
    private int currentPage;
    private final PDFJob job;
    private boolean pdfDocumentAlreadyDone;
    private final TestPanel drawingArea;
    private final TestMenuBar menuBar;

    public PDFTest(String string, String string2, boolean bl) {
        Dimension dimension;
        FileOutputStream fileOutputStream = null;
        try {
            File file = new File(string);
            fileOutputStream = new FileOutputStream(file);
        }
        catch (Exception exception) {
            System.err.println("Error!! - Invalid output file path: " + string);
            PDFTest.usage();
            System.exit(1);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        Container container = this.getContentPane();
        this.pane.setLayout(new BorderLayout());
        this.menuBar = new TestMenuBar(this);
        this.setJMenuBar(this.menuBar);
        this.job = new PDFJob(fileOutputStream);
        Graphics graphics = this.job.getGraphics();
        this.documentDimension = dimension = this.job.getPageDimension();
        int n = (int)dimension.getWidth();
        int n2 = (int)dimension.getHeight();
        this.drawingArea = new TestPanel();
        JScrollPane jScrollPane = new JScrollPane(this.drawingArea, 22, 32);
        this.drawingArea.setPreferredSize(new Dimension(1000, 1000));
        this.pane.add((Component)jScrollPane, "Center");
        container.add(this.pane);
        this.setTitle("PDF Test Application");
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension2 = toolkit.getScreenSize();
        this.setLocation(50, 50);
        this.setSize(n, n2 / 2);
        this.setVisible(true);
        this.toFront();
        this.doFirstPage(graphics);
        this.currentPage = 1;
        if (fileOutputStream != null) {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.drawingArea.repaint();
        this.pane.revalidate();
    }

    private void doFirstPage(Graphics graphics) {
        Dimension dimension = this.documentDimension;
        Image image = this.drawingArea.createImage((int)dimension.getWidth(), (int)dimension.getHeight());
        if (image == null) {
            System.out.println("Error!! - drawing image is null");
            System.exit(1);
        }
        this.drawingArea.setImage(image);
        Graphics graphics2 = image.getGraphics();
        this.doTest(graphics2, dimension);
        graphics2.dispose();
        if (!this.pdfDocumentAlreadyDone && graphics != null) {
            this.doTest(graphics, dimension);
            graphics.dispose();
            graphics = this.job.getGraphics();
            this.doSecondPageTest(graphics);
            graphics.dispose();
            this.job.end();
        }
        this.currentPage = 1;
        this.drawingArea.repaint();
        this.drawingArea.revalidate();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.menuBar.close) {
            System.exit(0);
        }
        if (object == this.menuBar.printer) {
            this.printPdf();
            return;
        }
        if (object == this.menuBar.helpTopics) {
            System.out.println("Help..");
            this.showHelp();
            return;
        }
        if (object == this.menuBar.aboutApp) {
            System.out.println("About...");
            this.showAboutBox();
            return;
        }
        if (object == this.menuBar.viewFirstPage && this.currentPage != 1) {
            this.doFirstPage(null);
            return;
        }
        if (object == this.menuBar.viewSecondPage && this.currentPage != 2) {
            this.doSecondPage();
            return;
        }
    }

    private void showAboutBox() {
        JOptionPane.showMessageDialog(this, "gnujpdf test application, by Eric Z. Beard.  http://gnujpdf.sourceforge.net");
    }

    private void showHelp() {
        HelpFrame helpFrame = new HelpFrame();
    }

    private void printPdf() {
        System.out.println("Printing..");
        JobAttributes jobAttributes = new JobAttributes();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        PrintJob printJob = toolkit.getPrintJob(this, "PDF Test Print", jobAttributes, null);
        if (printJob != null) {
            Graphics graphics = printJob.getGraphics();
            if (this.currentPage == 1) {
                this.doTest(graphics, this.documentDimension);
                graphics.dispose();
                printJob.end();
            } else {
                this.doSecondPageTest(graphics);
                graphics.dispose();
                printJob.end();
            }
        } else {
            System.err.println("Can't print: printjob null");
        }
    }

    private void doTest(Graphics graphics, Dimension dimension) {
        BoundingBox boundingBox;
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(Color.black);
        Point point = new Point(60, 60);
        Dimension dimension2 = new Dimension(200, 200);
        Font font = new Font("TimesRoman", 0, 14);
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        BoundingBox boundingBox2 = new BoundingBox(point, dimension2);
        String string = "Hello World! this is a really long string";
        int n = 10;
        try {
            boundingBox = boundingBox2.getStringBounds(string, 3, 2, fontMetrics, n);
        }
        catch (StringTooLongException stringTooLongException) {
            stringTooLongException.printStackTrace();
            return;
        }
        graphics.drawRect(60, 60, 200, 200);
        graphics.drawRect((int)boundingBox.getLocation().getX() + 60, (int)boundingBox.getLocation().getY() + 60, (int)boundingBox.getSize().getWidth(), (int)boundingBox.getSize().getHeight());
        Point point2 = boundingBox.getDrawingPoint();
        int n2 = (int)point2.getX();
        int n3 = (int)point2.getY();
        graphics.drawLine(n2, n3, n2 + ((int)boundingBox.getSize().getWidth() - n * 2), n3);
        try {
            boundingBox.drawWrappedString(graphics, fontMetrics, n, 3);
        }
        catch (StringTooLongException stringTooLongException) {
            stringTooLongException.printStackTrace();
            return;
        }
        BoundingBox boundingBox3 = new BoundingBox(new Point(300, 60), new Dimension(200, 200));
        graphics.drawRect((int)boundingBox3.getAbsoluteLocation().getX(), (int)boundingBox3.getAbsoluteLocation().getY(), (int)boundingBox3.getSize().getWidth(), (int)boundingBox3.getSize().getHeight());
        BoundingBox boundingBox4 = new BoundingBox(new Point(10, 10), new Dimension(100, 100));
        boundingBox3.add(boundingBox4);
        graphics.drawRect((int)boundingBox4.getAbsoluteLocation().getX(), (int)boundingBox4.getAbsoluteLocation().getY(), (int)boundingBox4.getSize().getWidth(), (int)boundingBox4.getSize().getHeight());
        try {
            BoundingBox boundingBox5 = boundingBox4.getStringBounds(string, 3, 2, fontMetrics, n);
            graphics.drawRect((int)boundingBox5.getAbsoluteLocation().getX(), (int)boundingBox5.getAbsoluteLocation().getY(), (int)boundingBox5.getSize().getWidth(), (int)boundingBox5.getSize().getHeight());
            Point point3 = boundingBox5.getDrawingPoint();
            int n4 = (int)point3.getX();
            int n5 = (int)point3.getY();
            boundingBox5.drawWrappedString(graphics, fontMetrics, n, 3);
        }
        catch (StringTooLongException stringTooLongException) {
            stringTooLongException.printStackTrace();
        }
        this.drawStringsInBox(graphics);
        this.drawSampleImage(graphics, dimension);
    }

    private void drawStringsInBox(Graphics graphics) {
        BoundingBox boundingBox;
        graphics.setColor(Color.black);
        BoundingBox boundingBox2 = new BoundingBox(new Point(20, 300), new Dimension(250, 250));
        graphics.drawRect((int)boundingBox2.getAbsoluteLocation().getX(), (int)boundingBox2.getAbsoluteLocation().getY(), (int)boundingBox2.getSize().getWidth(), (int)boundingBox2.getSize().getHeight());
        Font font = new Font("Helvetica", 0, 12);
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        String string = "Line 1";
        String string2 = "Line 2";
        String string3 = "Line 3 realllllly loooooong   .h gkjhg kjh gkjh gkjhg kjhg kjhg kjh gk jbhg";
        int n = 5;
        try {
            boundingBox = boundingBox2.getStringBounds(string, 4, 1, fontMetrics, n);
            boundingBox.drawWrappedString(graphics, fontMetrics, n, 4);
        }
        catch (StringTooLongException stringTooLongException) {
            stringTooLongException.printStackTrace();
            return;
        }
        boundingBox2.subtract(boundingBox, 7);
        try {
            boundingBox = boundingBox2.getStringBounds(string2, 4, 1, fontMetrics, n);
            boundingBox.drawWrappedString(graphics, fontMetrics, n, 4);
        }
        catch (StringTooLongException stringTooLongException) {
            stringTooLongException.printStackTrace();
            return;
        }
        boundingBox2.subtract(boundingBox, 7);
        try {
            boundingBox = boundingBox2.getStringBounds(string3, 4, 1, fontMetrics, n);
            boundingBox.drawWrappedString(graphics, fontMetrics, n, 4);
        }
        catch (StringTooLongException stringTooLongException) {
            stringTooLongException.printStackTrace();
            return;
        }
        boundingBox2.subtract(boundingBox, 7);
        try {
            boundingBox = boundingBox2.getStringBounds(string, 5, 2, fontMetrics, n);
            boundingBox.drawWrappedString(graphics, fontMetrics, n, 5);
            boundingBox2.subtract(boundingBox, 6);
            boundingBox = boundingBox2.getStringBounds(string2, 5, 2, fontMetrics, n);
            boundingBox.drawWrappedString(graphics, fontMetrics, n, 5);
            boundingBox2.subtract(boundingBox, 6);
            boundingBox = boundingBox2.getStringBounds(string3, 5, 2, fontMetrics, n);
            boundingBox.drawWrappedString(graphics, fontMetrics, n, 5);
            boundingBox2.subtract(boundingBox, 6);
        }
        catch (StringTooLongException stringTooLongException) {
            stringTooLongException.printStackTrace();
            return;
        }
    }

    private void drawSampleImage(Graphics graphics, Dimension dimension) {
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Image image = toolkit.createImage(sampleImageFile);
            MediaTracker mediaTracker = new MediaTracker(this.drawingArea);
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForID(0);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            graphics.drawImage(image, 10, 10, image.getWidth(this.drawingArea), image.getHeight(this.drawingArea), Color.green, this.drawingArea);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void doSecondPage() {
        Dimension dimension = this.documentDimension;
        Image image = this.drawingArea.createImage((int)dimension.getWidth(), (int)dimension.getHeight());
        if (image == null) {
            System.out.println("Error!! - drawing image is null");
            System.exit(1);
        }
        this.drawingArea.setImage(image);
        Graphics graphics = image.getGraphics();
        this.doSecondPageTest(graphics);
        graphics.dispose();
        this.currentPage = 2;
        this.drawingArea.repaint();
        this.drawingArea.revalidate();
    }

    private void doSecondPageTest(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.documentDimension.width, this.documentDimension.height);
        graphics.setColor(Color.black);
        graphics.drawLine(10, 10, 50, 50);
        graphics.drawRect(30, 10, 10, 10);
        graphics.fillRect(30, 90, 10, 10);
        int[] nArray = new int[]{10, 10, 20, 15, 20};
        int[] nArray2 = new int[]{50, 60, 60, 55, 50};
        int n = nArray.length;
        graphics.drawPolygon(nArray, nArray2, n);
        nArray = new int[]{60, 60, 70, 65, 70};
        nArray2 = new int[]{80, 90, 90, 85, 80};
        n = nArray.length;
        graphics.drawPolyline(nArray, nArray2, n);
        nArray = new int[]{60, 60, 70, 65, 70};
        nArray2 = new int[]{50, 60, 60, 55, 50};
        n = nArray.length;
        graphics.fillPolygon(nArray, nArray2, n);
        graphics.setFont(new Font("SansSerif", 0, 12));
        graphics.drawString("This is a simple string", 10, 120);
        graphics.drawString("This is a (complex) string", 10, 130);
        graphics.drawString("(complex) string (with ( (multiple brackets ))", 10, 140);
        graphics.drawRect(200, 60, 50, 50);
        graphics.drawLine(200, 60, 250, 110);
        graphics.drawLine(200, 110, 250, 60);
        graphics.drawLine(200, 85, 225, 60);
        graphics.drawArc(200, 60, 50, 50, 45, 180);
        graphics.drawArc(100, 400, 100, 200, 0, 360);
        graphics.drawOval(200, 400, 100, 200);
        graphics.fillOval(300, 400, 100, 200);
        graphics.drawRect(300, 50, 80, 40);
        graphics.drawLine(300, 50, 380, 90);
        graphics.drawLine(300, 90, 380, 50);
        graphics.drawArc(300, 50, 80, 40, 135, 180);
        graphics.drawRect(400, 50, 40, 80);
        graphics.drawLine(400, 50, 440, 130);
        graphics.drawLine(400, 130, 440, 50);
        graphics.setColor(Color.blue);
        graphics.fillArc(400, 50, 40, 80, 135, 180);
        graphics.setColor(Color.black);
        graphics.drawRect(400, 150, 40, 80);
        graphics.drawLine(400, 150, 440, 230);
        graphics.drawLine(400, 230, 440, 150);
        graphics.setColor(Color.blue);
        graphics.fillArc(400, 150, 40, 80, 135, 225);
        graphics.setColor(Color.black);
        String[] stringArray = new String[]{"SansSerif", "Monospaced", "TimesRoman", "Helvetica", "Courier", "Dialog", "DialogInput"};
        String[] stringArray2 = new String[]{"Plain", "Bold", "Italic", "Bold+Italic"};
        int[] nArray3 = new int[]{0, 1, 2, 3};
        int n2 = 170;
        for (int i = 0; i < stringArray2.length; ++i) {
            graphics.drawString(stringArray2[i], 100 + 50 * i, n2 - 14);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        for (int i = 0; i < stringArray.length; ++i) {
            graphics.drawString(stringArray[i], 98 - fontMetrics.stringWidth(stringArray[i]), n2 + 12 * i);
        }
        Font font = graphics.getFont();
        for (String string : stringArray) {
            for (int i = 0; i < stringArray2.length; ++i) {
                graphics.setFont(new Font(string, nArray3[i], 10));
                graphics.drawString(stringArray2[i], 100 + 50 * i, n2);
            }
            n2 += 12;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (stringArray[i].equals("-nw")) {
                    noWindow = true;
                }
                if (stringArray[i].equals("-pdf") && n > i + 1) {
                    outputPdfFile = stringArray[i + 1];
                }
                if (!stringArray[i].equals("-img") || n <= i + 1) continue;
                sampleImageFile = stringArray[i + 1];
            }
        } else {
            PDFTest.usage();
            System.exit(1);
        }
        if (outputPdfFile == null) {
            System.err.println("No output file specified");
            PDFTest.usage();
            System.exit(1);
        }
        if (sampleImageFile == null) {
            System.err.println("No sample image file specified");
            PDFTest.usage();
            System.exit(1);
        }
        PDFTest pDFTest = new PDFTest(outputPdfFile, sampleImageFile, noWindow);
    }

    private static void usage() {
        System.out.println("PDFTest Usage:");
        System.out.println();
        System.out.print("java -classpath <$CLASSPATH> gnu.jpdf.PDFTest -pdf ");
        System.out.print("<output-file-path> -img <path-to-image>");
        System.out.println();
        System.out.println();
        System.out.println("This will produce the pdf file generated at ");
        System.out.println("<output-file-path> (which should end in '.pdf') and ");
        System.out.println("use the image at <path-to-image>.  Use a small jpg ");
        System.out.println("preferably since the compression is not so good ");
        System.out.println("and a pdf file will typically be 10 times as big as ");
        System.out.println("the image used as a sample.");
        System.out.println();
    }
}

