/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.Edge;
import org.jgraph.graph.GraphModel;

public class GraphConstants {
    public static Font DEFAULTFONT = null;
    public static int DEFAULTDECORATIONSIZE;
    public static int DEFAULTINSET;
    public static final int PERMILLE = 1000;
    protected static float[] dash;
    public static Stroke SELECTION_STROKE;
    public static final int ARROW_NONE = 0;
    public static final int ARROW_CLASSIC = 1;
    public static final int ARROW_TECHNICAL = 2;
    public static final int ARROW_SIMPLE = 4;
    public static final int ARROW_CIRCLE = 5;
    public static final int ARROW_LINE = 7;
    public static final int ARROW_DOUBLELINE = 8;
    public static final int ARROW_DIAMOND = 9;
    public static final int STYLE_ORTHOGONAL = 11;
    public static final int STYLE_BEZIER = 12;
    public static final int STYLE_SPLINE = 13;
    public static final int X_AXIS = 1;
    public static final int Y_AXIS = 2;
    public static Edge.Routing ROUTING_DEFAULT;
    public static final Edge.Routing ROUTING_SIMPLE;
    public static final String SIZEABLEAXIS = "sizeableAxis";
    public static final String MOVEABLEAXIS = "moveableAxis";
    public static final String REPLACEATTRIBUTES = "replaceAttributes";
    public static final String REMOVEATTRIBUTES = "removeAttributes";
    public static final String REMOVEALL = "removeAll";
    public static final String ICON = "icon";
    public static final String FONT = "font";
    public static final String OPAQUE = "opaque";
    public static final String GROUPOPAQUE = "groupOpaque";
    public static final String BORDER = "border";
    public static final String LINECOLOR = "linecolor";
    public static final String BORDERCOLOR = "bordercolor";
    public static final String LINEWIDTH = "linewidth";
    public static final String FOREGROUND = "foregroundColor";
    public static final String BACKGROUND = "backgroundColor";
    public static final String GRADIENTCOLOR = "gradientColor";
    public static final String VERTICAL_ALIGNMENT = "verticalAlignment";
    public static final String HORIZONTAL_ALIGNMENT = "horizontalAlignment";
    public static final String VERTICAL_TEXT_POSITION = "verticalTextPosition";
    public static final String HORIZONTAL_TEXT_POSITION = "horizontalTextPosition";
    public static final String DASHPATTERN = "dashPattern";
    public static final String DASHOFFSET = "dashOffset";
    public static final String LINESTYLE = "lineStyle";
    public static final String LINEBEGIN = "lineBegin";
    public static final String LINEEND = "lineEnd";
    public static final String BEGINSIZE = "beginSize";
    public static final String ENDSIZE = "endSize";
    public static final String BEGINFILL = "beginFill";
    public static final String ENDFILL = "endFill";
    public static final String VALUE = "value";
    public static final String EDITABLE = "editable";
    public static final String MOVEABLE = "moveable";
    public static final String SIZEABLE = "sizeable";
    public static final String AUTOSIZE = "autosize";
    public static final String RESIZE = "resize";
    public static final String INSET = "inset";
    public static final String CONSTRAINED = "constrained";
    public static final String SELECTABLE = "selectable";
    public static final String CHILDRENSELECTABLE = "childrenSelectable";
    public static final String MOVEHIDDENCHILDREN = "childrenSelectable";
    public static final String BENDABLE = "bendable";
    public static final String CONNECTABLE = "connectable";
    public static final String DISCONNECTABLE = "disconnectable";
    public static final String BOUNDS = "bounds";
    public static final String POINTS = "points";
    public static final String ROUTING = "routing";
    public static final String LABELPOSITION = "labelposition";
    public static final String EXTRALABELS = "extraLabels";
    public static final String EXTRALABELPOSITIONS = "extraLabelPositions";
    public static final String LABELALONGEDGE = "labelAlongEdge";
    public static final String ABSOLUTEX = "absoluteX";
    public static final String ABSOLUTEY = "absoluteY";
    public static final String OFFSET = "offset";
    public static final String SIZE = "size";
    public static final String LINK = "link";

    public static Map createAttributes(Object object, Object object2, Object object3) {
        return GraphConstants.createAttributes(new Object[]{object}, new Object[]{object2}, new Object[]{object3});
    }

    public static Map createAttributes(Object[] objectArray, Object object, Object object2) {
        return GraphConstants.createAttributes(objectArray, new Object[]{object}, new Object[]{object2});
    }

    public static Map createAttributes(Object[] objectArray, Object[] objectArray2, Object[] objectArray3) {
        if (objectArray2 != null && objectArray3 != null && objectArray2.length != objectArray3.length) {
            throw new IllegalArgumentException("Keys and values must have same length");
        }
        Hashtable hashtable = new Hashtable();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            Hashtable<Object, Object> hashtable2 = new Hashtable<Object, Object>();
            for (int j = 0; j < objectArray2.length; ++j) {
                if (objectArray2[j] == null || objectArray3[j] == null) continue;
                hashtable2.put(objectArray2[j], objectArray3[j]);
            }
            hashtable.put(objectArray[i], hashtable2);
        }
        return hashtable;
    }

    public static Map createAttributes(Object[] objectArray, CellMapper cellMapper) {
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            CellView cellView = null;
            Object object = objectArray[i];
            if (object instanceof CellView) {
                cellView = (CellView)object;
                object = cellView.getCell();
            } else if (cellMapper != null) {
                cellView = cellMapper.getMapping(object, false);
            }
            if (cellView == null) continue;
            hashtable.put(object, cellView.getAllAttributes().clone());
        }
        return hashtable;
    }

    public static Map createAttributesFromModel(Object[] objectArray, GraphModel graphModel) {
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            AttributeMap attributeMap = graphModel.getAttributes(objectArray[i]);
            if (attributeMap == null || attributeMap.size() <= 0) continue;
            hashtable.put(objectArray[i], attributeMap.clone());
        }
        return hashtable;
    }

    public static Map replaceKeys(Map map, Map map2) {
        Hashtable hashtable = new Hashtable();
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Object v;
            Map.Entry entry = iterator.next();
            if (!(entry.getValue() instanceof Map) || (v = map.get(entry.getKey())) == null) continue;
            AttributeMap attributeMap = (AttributeMap)((AttributeMap)entry.getValue()).clone();
            hashtable.put(v, attributeMap);
        }
        return hashtable;
    }

    public static Map merge(Map hashtable, Map map) {
        if (hashtable != null && map != null) {
            hashtable = new Hashtable(hashtable);
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Map map2 = (Map)entry.getValue();
                Map map3 = (Map)hashtable.remove(entry.getKey());
                if (map3 == null) continue;
                map2.putAll(map3);
            }
            map.putAll(hashtable);
        }
        return map;
    }

    public static void setFont(Map map, Font font) {
        map.put(FONT, font);
    }

    public static Font getFont(Map map) {
        Font font = (Font)map.get(FONT);
        if (font == null) {
            font = DEFAULTFONT;
        }
        return font;
    }

    public static final void setRemoveAttributes(Map map, Object[] objectArray) {
        map.put(REMOVEATTRIBUTES, objectArray);
    }

    public static final Object[] getRemoveAttributes(Map map) {
        return (Object[])map.get(REMOVEATTRIBUTES);
    }

    public static final void setMoveableAxis(Map map, int n) {
        map.put(MOVEABLEAXIS, new Integer(n));
    }

    public static final int getMoveableAxis(Map map) {
        Integer n = (Integer)map.get(MOVEABLEAXIS);
        if (n != null) {
            return n;
        }
        return 0;
    }

    public static final void setSizeableAxis(Map map, int n) {
        map.put(SIZEABLEAXIS, new Integer(n));
    }

    public static final int getSizeableAxis(Map map) {
        Integer n = (Integer)map.get(SIZEABLEAXIS);
        if (n != null) {
            return n;
        }
        return 0;
    }

    public static final void setIcon(Map map, Icon icon) {
        map.put(ICON, icon);
    }

    public static final Icon getIcon(Map map) {
        return (Icon)map.get(ICON);
    }

    public static final void setOpaque(Map map, boolean bl) {
        map.put(OPAQUE, new Boolean(bl));
    }

    public static final boolean isOpaque(Map map) {
        Boolean bl = (Boolean)map.get(OPAQUE);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static final void setGroupOpaque(Map map, boolean bl) {
        map.put(GROUPOPAQUE, new Boolean(bl));
    }

    public static final boolean isGroupOpaque(Map map) {
        Boolean bl = (Boolean)map.get(GROUPOPAQUE);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static final void setBorder(Map map, Border border) {
        map.put(BORDER, border);
    }

    public static final Border getBorder(Map map) {
        return (Border)map.get(BORDER);
    }

    public static final void setLineColor(Map map, Color color) {
        map.put(LINECOLOR, color);
    }

    public static final Color getLineColor(Map map) {
        return (Color)map.get(LINECOLOR);
    }

    public static final void setBorderColor(Map map, Color color) {
        map.put(BORDERCOLOR, color);
    }

    public static final Color getBorderColor(Map map) {
        return (Color)map.get(BORDERCOLOR);
    }

    public static final void setLineWidth(Map map, float f) {
        map.put(LINEWIDTH, new Float(f));
    }

    public static final float getLineWidth(Map map) {
        Float f = (Float)map.get(LINEWIDTH);
        if (f != null) {
            return f.floatValue();
        }
        return 1.0f;
    }

    public static final void setForeground(Map map, Color color) {
        map.put(FOREGROUND, color);
    }

    public static final Color getForeground(Map map) {
        return (Color)map.get(FOREGROUND);
    }

    public static final void setBackground(Map map, Color color) {
        map.put(BACKGROUND, color);
    }

    public static final Color getBackground(Map map) {
        return (Color)map.get(BACKGROUND);
    }

    public static final void setGradientColor(Map map, Color color) {
        map.put(GRADIENTCOLOR, color);
    }

    public static final Color getGradientColor(Map map) {
        return (Color)map.get(GRADIENTCOLOR);
    }

    public static final void setVerticalAlignment(Map map, int n) {
        map.put(VERTICAL_ALIGNMENT, new Integer(n));
    }

    public static final int getVerticalAlignment(Map map) {
        Integer n = (Integer)map.get(VERTICAL_ALIGNMENT);
        if (n != null) {
            return n;
        }
        return 0;
    }

    public static final void setHorizontalAlignment(Map map, int n) {
        map.put(HORIZONTAL_ALIGNMENT, new Integer(n));
    }

    public static final int getHorizontalAlignment(Map map) {
        Integer n = (Integer)map.get(HORIZONTAL_ALIGNMENT);
        if (n != null) {
            return n;
        }
        return 0;
    }

    public static final void setVerticalTextPosition(Map map, int n) {
        map.put(VERTICAL_TEXT_POSITION, new Integer(n));
    }

    public static final int getVerticalTextPosition(Map map) {
        Integer n = (Integer)map.get(VERTICAL_TEXT_POSITION);
        if (n != null) {
            return n;
        }
        return 3;
    }

    public static final void setHorizontalTextPosition(Map map, int n) {
        map.put(HORIZONTAL_TEXT_POSITION, new Integer(n));
    }

    public static final int getHorizontalTextPosition(Map map) {
        Integer n = (Integer)map.get(HORIZONTAL_TEXT_POSITION);
        if (n != null) {
            return n;
        }
        return 0;
    }

    public static final void setDashPattern(Map map, float[] fArray) {
        map.put(DASHPATTERN, fArray);
    }

    public static final float[] getDashPattern(Map map) {
        return (float[])map.get(DASHPATTERN);
    }

    public static final void setDashOffset(Map map, float f) {
        map.put(DASHOFFSET, new Float(f));
    }

    public static final float getDashOffset(Map map) {
        Float f = (Float)map.get(DASHOFFSET);
        if (f != null) {
            return f.floatValue();
        }
        return 1.0f;
    }

    public static final void setLineStyle(Map map, int n) {
        map.put(LINESTYLE, new Integer(n));
    }

    public static final int getLineStyle(Map map) {
        Integer n = (Integer)map.get(LINESTYLE);
        if (n != null) {
            return n;
        }
        return 11;
    }

    public static final void setBeginSize(Map map, int n) {
        map.put(BEGINSIZE, new Integer(n));
    }

    public static final int getBeginSize(Map map) {
        Integer n = (Integer)map.get(BEGINSIZE);
        if (n != null) {
            return n;
        }
        return DEFAULTDECORATIONSIZE;
    }

    public static final void setEndSize(Map map, int n) {
        map.put(ENDSIZE, new Integer(n));
    }

    public static final int getEndSize(Map map) {
        Integer n = (Integer)map.get(ENDSIZE);
        if (n != null) {
            return n;
        }
        return DEFAULTDECORATIONSIZE;
    }

    public static final void setLineBegin(Map map, int n) {
        map.put(LINEBEGIN, new Integer(n));
    }

    public static final int getLineBegin(Map map) {
        Integer n = (Integer)map.get(LINEBEGIN);
        if (n != null) {
            return n;
        }
        return 0;
    }

    public static final void setLineEnd(Map map, int n) {
        map.put(LINEEND, new Integer(n));
    }

    public static final int getLineEnd(Map map) {
        Integer n = (Integer)map.get(LINEEND);
        if (n != null) {
            return n;
        }
        return 0;
    }

    public static final void setValue(Map map, Object object) {
        map.put(VALUE, object);
    }

    public static final Object getValue(Map map) {
        return map.get(VALUE);
    }

    public static final void setLabelPosition(Map map, Point2D point2D) {
        map.put(LABELPOSITION, point2D);
    }

    public static final Point2D getLabelPosition(Map map) {
        return (Point2D)map.get(LABELPOSITION);
    }

    public static final void setExtraLabels(Map map, Object[] objectArray) {
        map.put(EXTRALABELS, objectArray);
    }

    public static final Object[] getExtraLabels(Map map) {
        return (Object[])map.get(EXTRALABELS);
    }

    public static final void setExtraLabelPositions(Map map, Point2D[] point2DArray) {
        map.put(EXTRALABELPOSITIONS, point2DArray);
    }

    public static final Point2D[] getExtraLabelPositions(Map map) {
        return (Point2D[])map.get(EXTRALABELPOSITIONS);
    }

    public static final void setLabelAlongEdge(Map map, boolean bl) {
        map.put(LABELALONGEDGE, new Boolean(bl));
    }

    public static final boolean isLabelAlongEdge(Map map) {
        Boolean bl = (Boolean)map.get(LABELALONGEDGE);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static final void setEditable(Map map, boolean bl) {
        map.put(EDITABLE, new Boolean(bl));
    }

    public static final boolean isEditable(Map map) {
        Boolean bl = (Boolean)map.get(EDITABLE);
        if (bl != null) {
            return bl;
        }
        return true;
    }

    public static final void setMoveable(Map map, boolean bl) {
        map.put(MOVEABLE, new Boolean(bl));
    }

    public static final boolean isMoveable(Map map) {
        Boolean bl = (Boolean)map.get(MOVEABLE);
        if (bl != null) {
            return bl;
        }
        return true;
    }

    public static final void setSizeable(Map map, boolean bl) {
        map.put(SIZEABLE, new Boolean(bl));
    }

    public static final boolean isSizeable(Map map) {
        Boolean bl = (Boolean)map.get(SIZEABLE);
        if (bl != null) {
            return bl;
        }
        return true;
    }

    public static final void setAutoSize(Map map, boolean bl) {
        map.put(AUTOSIZE, new Boolean(bl));
    }

    public static final boolean isAutoSize(Map map) {
        Boolean bl = (Boolean)map.get(AUTOSIZE);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static final void setResize(Map map, boolean bl) {
        map.put(RESIZE, new Boolean(bl));
    }

    public static final boolean isResize(Map map) {
        Boolean bl = (Boolean)map.get(RESIZE);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static final void setConstrained(Map map, boolean bl) {
        map.put(CONSTRAINED, new Boolean(bl));
    }

    public static final boolean isConstrained(Map map) {
        Boolean bl = (Boolean)map.get(CONSTRAINED);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static final void setSelectable(Map map, boolean bl) {
        map.put(SELECTABLE, new Boolean(bl));
    }

    public static final boolean isSelectable(Map map) {
        Boolean bl = (Boolean)map.get(SELECTABLE);
        if (bl != null) {
            return bl;
        }
        return true;
    }

    public static final void setChildrenSelectable(Map map, boolean bl) {
        map.put("childrenSelectable", new Boolean(bl));
    }

    public static final boolean isChildrenSelectable(Map map) {
        Boolean bl = (Boolean)map.get("childrenSelectable");
        if (bl != null) {
            return bl;
        }
        return true;
    }

    public static final void setBendable(Map map, boolean bl) {
        map.put(BENDABLE, new Boolean(bl));
    }

    public static final boolean isBendable(Map map) {
        Boolean bl = (Boolean)map.get(BENDABLE);
        if (bl != null) {
            return bl;
        }
        return true;
    }

    public static final void setConnectable(Map map, boolean bl) {
        map.put(CONNECTABLE, new Boolean(bl));
    }

    public static final boolean isConnectable(Map map) {
        Boolean bl = (Boolean)map.get(CONNECTABLE);
        if (bl != null) {
            return bl;
        }
        return true;
    }

    public static final void setDisconnectable(Map map, boolean bl) {
        map.put(DISCONNECTABLE, new Boolean(bl));
    }

    public static final boolean isDisconnectable(Map map) {
        Boolean bl = (Boolean)map.get(DISCONNECTABLE);
        if (bl != null) {
            return bl;
        }
        return true;
    }

    public static final void setPoints(Map map, List list) {
        map.put(POINTS, list);
    }

    public static final List getPoints(Map map) {
        return (List)map.get(POINTS);
    }

    public static final void setRouting(Map map, Edge.Routing routing) {
        map.put(ROUTING, routing);
    }

    public static final Edge.Routing getRouting(Map map) {
        Edge.Routing routing = (Edge.Routing)map.get(ROUTING);
        if (routing == null) {
            routing = ROUTING_DEFAULT;
        }
        return routing;
    }

    public static final void setBounds(Map map, Rectangle2D rectangle2D) {
        map.put(BOUNDS, rectangle2D);
    }

    public static final Rectangle2D getBounds(Map map) {
        return (Rectangle2D)map.get(BOUNDS);
    }

    public static final void setInset(Map map, int n) {
        map.put(INSET, new Integer(n));
    }

    public static final int getInset(Map map) {
        Integer n = (Integer)map.get(INSET);
        if (n != null) {
            return n;
        }
        return DEFAULTINSET;
    }

    public static final void setSize(Map map, Dimension dimension) {
        map.put(SIZE, dimension);
    }

    public static final Dimension getSize(Map map) {
        return (Dimension)map.get(SIZE);
    }

    public static final void setOffset(Map map, Point2D point2D) {
        map.put(OFFSET, point2D);
    }

    public static final Point2D getOffset(Map map) {
        return (Point2D)map.get(OFFSET);
    }

    public static final void setBeginFill(Map map, boolean bl) {
        map.put(BEGINFILL, new Boolean(bl));
    }

    public static final boolean isBeginFill(Map map) {
        Boolean bl = (Boolean)map.get(BEGINFILL);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static final void setEndFill(Map map, boolean bl) {
        map.put(ENDFILL, new Boolean(bl));
    }

    public static final boolean isEndFill(Map map) {
        Boolean bl = (Boolean)map.get(ENDFILL);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static final void setAbsolute(Map map, boolean bl) {
        GraphConstants.setAbsoluteX(map, bl);
        GraphConstants.setAbsoluteY(map, bl);
    }

    public static final void setAbsoluteY(Map map, boolean bl) {
        map.put(ABSOLUTEY, new Boolean(bl));
    }

    public static final boolean isAbsoluteY(Map map) {
        Boolean bl = (Boolean)map.get(ABSOLUTEY);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static final void setAbsoluteX(Map map, boolean bl) {
        map.put(ABSOLUTEX, new Boolean(bl));
    }

    public static final boolean isAbsoluteX(Map map) {
        Boolean bl = (Boolean)map.get(ABSOLUTEX);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static final void setRemoveAll(Map map, boolean bl) {
        map.put(REMOVEALL, new Boolean(bl));
    }

    public static final boolean isRemoveAll(Map map) {
        Boolean bl = (Boolean)map.get(REMOVEALL);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public static Edge.Routing getROUTING_SIMPLE() {
        return ROUTING_SIMPLE;
    }

    public static Edge.Routing getROUTING_DEFAULT() {
        return ROUTING_DEFAULT;
    }

    public static void setLink(Map map, String string) {
        map.put(LINK, string);
    }

    public static String getLink(Map map) {
        String string = (String)map.get(LINK);
        return string;
    }

    static {
        try {
            DEFAULTFONT = UIManager.getDefaults().getFont("Label.font");
        }
        catch (InternalError internalError) {
            // empty catch block
        }
        DEFAULTDECORATIONSIZE = 10;
        DEFAULTINSET = 0;
        dash = new float[]{5.0f, 5.0f};
        SELECTION_STROKE = new BasicStroke(1.0f, 0, 0, 10.0f, dash, 0.0f);
        ROUTING_DEFAULT = new DefaultEdge.LoopRouting();
        ROUTING_SIMPLE = new DefaultEdge.DefaultRouting();
    }
}

