/*
 * Copyright (c) 2001-2012 JGoodies Karsten Lentzsch. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  o Neither the name of JGoodies Karsten Lentzsch nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.jgoodies.looks.plastic.theme;

import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;

import com.jgoodies.looks.plastic.PlasticScrollBarUI;

/**
 * A theme with low saturated blue primary colors and a light gray/blueish
 * window background. It has been optimized to work with Windows XP
 * using the "Royale" desktop theme.
 *
 * @author Karsten Lentzsch
 * @version $Revision: 1.8 $
 *
 * @since 2.0.3
 */
public class ExperienceRoyale extends DesertBluer {

    @Override
    public String getName() {
        return "Experience Royale";
    }

    protected static final ColorUIResource ROYALE_BACKGROUND =
        new ColorUIResource(235, 233, 237);

    protected static final ColorUIResource ROYALE_BACKGROUND_DARKER =
        new ColorUIResource(167, 166, 170);

    protected static final ColorUIResource ROYALE_SELECTION =
        new ColorUIResource(51, 94, 168);

    private static final ColorUIResource SECONDARY1 =
        Colors.GRAY_MEDIUM;

    private static final ColorUIResource SECONDARY2 =
        ROYALE_BACKGROUND_DARKER;

    private static final ColorUIResource SECONDARY3 =
        ROYALE_BACKGROUND;

    @Override
    protected ColorUIResource getPrimary1() {
        return ROYALE_SELECTION;
    }

    @Override
    protected ColorUIResource getPrimary2() {
        return Colors.BLUE_LOW_MEDIUM;
    }

    @Override
    protected ColorUIResource getPrimary3() {
        return Colors.BLUE_LOW_LIGHTEST;
    }

    @Override
    protected ColorUIResource getSecondary1() {
        return SECONDARY1;
    }

    @Override
    protected ColorUIResource getSecondary2() {
        return SECONDARY2;
    }

    @Override
    protected ColorUIResource getSecondary3() {
        return SECONDARY3;
    }

    @Override
    public ColorUIResource getFocusColor() {
        return Colors.ORANGE_FOCUS;
    }

    @Override
    public ColorUIResource getPrimaryControlShadow() {
        return getPrimary3();
    }

    @Override
    public ColorUIResource getMenuSelectedBackground() {
        return getPrimary1();
    }
    @Override
    public ColorUIResource getMenuSelectedForeground() {
        return WHITE;
    }

    @Override
    public ColorUIResource getMenuItemBackground() {
        return WHITE;
    }

    @Override
    public ColorUIResource getToggleButtonCheckColor() {
        return Colors.GREEN_CHECK;
    }

    @Override
    public void addCustomEntriesToTable(UIDefaults table) {
        super.addCustomEntriesToTable(table);
        Object[] uiDefaults =
            {
                "ScrollBar.thumbHighlight",
                getPrimaryControlHighlight(),
                PlasticScrollBarUI.MAX_BUMPS_WIDTH_KEY,
                new Integer(22),
                };
        table.putDefaults(uiDefaults);
    }

}