#!/bin/sh

BUILDDIR=`pwd`
GCJDIR=`dirname $0`

if test "$BUILDDIR" -ef "$GCJDIR"; then
  echo "You cannot build this library in this directory."
  echo "Make a separate directory and run this script from there."
  exit 1
fi

mkdir -p com/jcraft/jzlib
mkdir -p org/metastatic/jessie/https
mkdir -p org/metastatic/jessie/pki/der
mkdir -p org/metastatic/jessie/pki/ext
mkdir -p org/metastatic/jessie/pki/io
mkdir -p org/metastatic/jessie/pki/provider
mkdir -p org/metastatic/jessie/provider
mkdir -p org/metastatic/callbacks
mkdir -p javax/net/ssl
mkdir -p javax/security/cert

(cd $GCJDIR
 cp -ruf ../com/jcraft/jzlib/*.java                   $BUILDDIR/com/jcraft/jzlib
 cp -ruf ../javax/net/*.java                          $BUILDDIR/javax/net/
 cp -ruf ../javax/net/ssl/*.java                      $BUILDDIR/javax/net/ssl/
 cp -ruf ../javax/security/cert/*.java                $BUILDDIR/javax/security/cert/
 cp -ruf ../org/metastatic/callbacks/*.java           $BUILDDIR/org/metastatic/callbacks/
 cp -ruf ../org/metastatic/callbacks/*.properties     $BUILDDIR/org/metastatic/callbacks/
 cp -ruf ../org/metastatic/jessie/*.java              $BUILDDIR/org/metastatic/jessie/
 cp -ruf ../org/metastatic/jessie/https/*.java        $BUILDDIR/org/metastatic/jessie/https/
 cp -ruf ../org/metastatic/jessie/pki/*.java          $BUILDDIR/org/metastatic/jessie/pki/
 cp -ruf ../org/metastatic/jessie/pki/der/*.java      $BUILDDIR/org/metastatic/jessie/pki/der/
 cp -ruf ../org/metastatic/jessie/pki/ext/*.java      $BUILDDIR/org/metastatic/jessie/pki/ext/
 cp -ruf ../org/metastatic/jessie/pki/io/*.java       $BUILDDIR/org/metastatic/jessie/pki/io/
 cp -ruf ../org/metastatic/jessie/pki/provider/*.java $BUILDDIR/org/metastatic/jessie/pki/provider/
 cp -ruf ../org/metastatic/jessie/provider/*.java     $BUILDDIR/org/metastatic/jessie/provider/
 cp -uf ../gcj/acinclude.m4 Makefile.am Makefile.in aclocal.m4 config.guess config.sub \
     configure.ac configure depcomp install-sh libtool ltmain.sh missing mkinstalldirs \
     $BUILDDIR
)

echo "Files copied; use \`./configure' then \`make' to build Jessie"
