

#include <math.h>
       #include <sys/types.h>
       #include <sys/stat.h>
       #include <fcntl.h>
      #include <sys/time.h>
       #include <unistd.h>

#define SINETEST
//#define FIFOTEST

#include <stdio.h>
#include <sys/soundcard.h>

#ifdef SINETEST
#include "libjackoss.h"
#endif





short sig[8192];

int sine(int size) {
  int i;

  for (i=0;i<size;i++) {
    sig[2*i] = 0.1*32766.*sin(M_PI*(float)i/128.);
    sig[2*i+1] = sig[2*i];     
  }

}



#ifdef SINETEST
int main(char** argv, int arc)
{

  int fd;
  int param;  
  fd_set rfds;
  fd_set wfds;
  struct timeval tv;
  int retval;

           /* Watch stdin (fd 0) to see when it has input. */
           /* Wait up to five seconds. */
  
  

  fd = open("/dev/dsp",O_WRONLY);
  if (fd < 0) fprintf(stderr,"unable to open\n");
  
  sine(4096);

  param = 48000;
  ioctl(fd,SNDCTL_DSP_SPEED,&param);
  param = 2;
  ioctl(fd,SNDCTL_DSP_CHANNELS,&param);
  param = AFMT_S16_NE;
  ioctl(fd,SNDCTL_DSP_SETFMT,&param);

  
  
  while (1) {
#if SELECT_TEST
    tv.tv_sec = 5;
    tv.tv_usec = 0;
    FD_ZERO(&wfds);
    FD_ZERO(&rfds);
    FD_SET(fd, &wfds);
    FD_SET(0, &rfds);
    
    retval = select(fd+1, &rfds, &wfds, NULL, &tv);
    
    //    fprintf(stderr,"reval %d\n",retval);
    if (!FD_ISSET(fd, &wfds))
      fprintf(stderr,"is not set\n");
    
    if (FD_ISSET(fd, &rfds))
      fprintf(stderr,"input received\n");
#endif

    write(fd,sig,4096);
  }

  close(fd);


}
#endif

#ifdef PIPETEST
int main() {

  int fdesc[2];
  char c;
  int ret;
  fd_set wfds;
  struct timeval tv;

  tv.tv_sec =  5;
  tv.tv_usec = 0;

  pipe(fdesc);


  while (1) {
  FD_ZERO(&wfds);
  FD_SET(fdesc[1],&wfds);
    fprintf(stderr,"****************************** \nwriting\n");
    fprintf(stderr,"calling select\n");
    ret = select(fdesc[1]+1,NULL,&wfds,NULL,&tv);
    fprintf(stderr,"select returned %d\n",ret);
    ret = read(fdesc[1],&c,1); 
    if (ret != 1) fprintf(stderr,"writing failed\n");
  }


  exit (0);
}
#endif

#ifdef FIFOTEST
int main() {

  int fd;
  char c;
  int ret;
  int count = 0;
  fd_set wfds;
  fd_set rfds;
  struct timeval tv;


  ret = mkfifo("/tmp/test",S_IRWXU|S_IRUSR|S_IWUSR);
  if (ret) fprintf(stderr,"FIFO creation failed\n");

  fd = open ("/tmp/test",O_RDWR);

  while (1) {
    tv.tv_sec =  1;
    tv.tv_usec = 0;
    count++;
    FD_ZERO(&wfds);
    FD_SET(fd,&wfds);
    FD_ZERO(&rfds);
    FD_SET(fd,&rfds);

    fprintf(stderr,"calling select\n");
    ret = select(fd+1,&rfds,&wfds,NULL,&tv);
    if (FD_ISSET(fd,&wfds)) {
      fprintf(stderr,"****************************** \nwriting %d\n",count);
      fprintf(stderr,"write select returned %d\n",ret);
      ret = write(fd,&c,1); 
      if (ret != 1) fprintf(stderr,"writing failed\n");
    }
    if (FD_ISSET(fd,&rfds))
      fprintf(stderr,"read select returned %d\n",ret);
  }

  
  exit (0);
}
#endif
